/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmd.sdk.base.commands;

import com.ibm.cognos.fmd.sdk.base.JSONUtils;
import com.ibm.cognos.fmd.sdk.base.commands.ResourceCommand;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPhysicalDefinition;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemMapping;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.SQLObject;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import com.ibm.json.java.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryItemMappingCommand
extends ResourceCommand {
    protected static final String PROP_QUERY_ITEM = "queryItem";
    protected static final String PROP_COLUMN_NAME = "columnName";
    protected static final String PROP_TABLE = "table";
    protected static final String PROP_SQL_OBJECT = "sqlObject";

    @Override
    protected Class<?> expectedObjectType() {
        return QueryItemMapping.class;
    }

    @Override
    protected Object create(Object parentObject, JSONObject modelObj, JSONObject dataOut) {
        FmRelationalObject parent = this.getTypedParent(parentObject, FmRelationalObject.class, dataOut);
        if (parent == null) {
            return null;
        }
        QueryItemBase queryItem = this.getRefProperty(PROP_QUERY_ITEM, modelObj, true, QueryItemBase.class, dataOut);
        if (queryItem == null) {
            return null;
        }
        String columnName = this.getStringProperty(PROP_COLUMN_NAME, modelObj, true, dataOut);
        if (columnName == null) {
            return null;
        }
        Table table = this.getRefProperty(PROP_TABLE, modelObj, true, Table.class, dataOut);
        SQLObject sql = this.getRefProperty(PROP_SQL_OBJECT, modelObj, false, SQLObject.class, dataOut);
        FmPhysicalDefinition physicalDefinition = parent.getPhysicalDefinition();
        if (table != null) {
            return physicalDefinition.createQueryItemMapping(queryItem, columnName, table);
        }
        if (sql != null) {
            return physicalDefinition.createQueryItemMapping(queryItem, columnName, sql);
        }
        JSONUtils.addError(dataOut, "No mapped item was found");
        return null;
    }

    @Override
    protected void jsonToObject(Object object, JSONObject modelObj, String version, JSONObject dataOut) {
        super.jsonToObject(object, modelObj, version, dataOut);
        QueryItemMapping queryItemMapping = (QueryItemMapping)object;
        Object property = modelObj.remove((Object)PROP_COLUMN_NAME);
        if (property != null && property instanceof String) {
            queryItemMapping.setColumnName((String)property);
        }
    }

    @Override
    protected void objectToJson(JSONObject result, Object object, String version, JSONObject dataOut) {
        super.objectToJson(result, object, version, dataOut);
        QueryItemMapping queryItemMapping = (QueryItemMapping)object;
        this.addObjectToJson(result, PROP_COLUMN_NAME, queryItemMapping.getColumnName());
        this.addRefToJson(result, PROP_QUERY_ITEM, queryItemMapping.getQueryItem());
        this.addRefToJson(result, PROP_TABLE, queryItemMapping.getTable());
        this.addRefToJson(result, PROP_SQL_OBJECT, queryItemMapping.getSQLObject());
    }

    @Override
    protected boolean delete(Object object, JSONObject dataOut) {
        QueryItemMapping table = (QueryItemMapping)object;
        RelationalObject parent = table.getRelationalParent();
        if (parent == null) {
            return false;
        }
        parent.removeQueryItemMapping(table);
        return true;
    }
}

