/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmd.sdk.base.commands;

import com.ibm.cognos.fmd.sdk.base.commands.ResourceCommand;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRole;
import com.ibm.cognos.fmeng.fmmd.model.LocalizedValue;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.Role;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryItemRoleCommand
extends ResourceCommand {
    protected static final String PROP_IS_INTRISTIC = "isIntristic";

    @Override
    protected Class<?> expectedObjectType() {
        return Role.class;
    }

    @Override
    protected Object create(Object parentObject, JSONObject modelObj, JSONObject dataOut) {
        Iterator iterator;
        QueryItem parent = this.getTypedParent(parentObject, QueryItem.class, dataOut);
        if (parent == null) {
            return null;
        }
        Object name = modelObj.get((Object)"name");
        String defaultName = this.getDefaultName(name, parent.getSession());
        if (FmRole.isDefaultRole((String)defaultName)) {
            return parent.addDefaultRole(FmRole.getDefaultRoleIndex((String)defaultName));
        }
        if (name instanceof JSONArray && (iterator = ((JSONArray)name).iterator()).hasNext()) {
            Object locName = iterator.next();
            String text = (String)((JSONObject)locName).get((Object)"text");
            String locale = (String)((JSONObject)locName).get((Object)"locale");
            return parent.addCustomRole(text, locale);
        }
        return null;
    }

    @Override
    protected void jsonToObject(Object object, JSONObject modelObj, String version, JSONObject dataOut) {
        Object property;
        super.jsonToObject(object, modelObj, version, dataOut);
        Role role = (Role)object;
        Boolean intristic = this.getBooleanProperty(PROP_IS_INTRISTIC, modelObj, null, false, dataOut);
        if (intristic != null) {
            role.setIntrinsic(intristic.booleanValue());
        }
        if ((property = modelObj.remove((Object)"name")) instanceof String) {
            FMMDSession session = role.getQueryItem().getSession();
            String defaultLocale = session.getDefaultLocale();
            role.setName(defaultLocale, (String)property);
        } else if (property instanceof JSONObject) {
            String text = (String)((JSONObject)property).get((Object)"text");
            String locale = (String)((JSONObject)property).get((Object)"locale");
            role.setName(locale, text);
        } else if (property instanceof JSONArray) {
            for (Object locText : (JSONArray)property) {
                String text = (String)((JSONObject)locText).get((Object)"text");
                String locale = (String)((JSONObject)locText).get((Object)"locale");
                role.setName(locale, text);
            }
        }
    }

    @Override
    protected void objectToJson(JSONObject result, Object object, String version, JSONObject dataOut) {
        super.objectToJson(result, object, version, dataOut);
        Role role = (Role)object;
        this.addObjectToJson(result, PROP_IS_INTRISTIC, role.getIntrinsic());
        List localizedNames = role.getNames();
        JSONArray names = new JSONArray();
        for (LocalizedValue localizedName : localizedNames) {
            this.addTextToJson(names, localizedName.getValue(), localizedName.getLocale());
        }
        result.put((Object)"name", (Object)names);
    }

    @Override
    protected boolean delete(Object object, JSONObject dataOut) {
        if (!(object instanceof FmRole)) {
            return false;
        }
        FmRole role = (FmRole)object;
        ((FmQueryItemBase)role.getQueryItem()).removeRole(role);
        return true;
    }
}

