/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmd.sdk.base.commands;

import com.ibm.cognos.fmd.sdk.base.JSONUtils;
import com.ibm.cognos.fmd.sdk.base.commands.ReportObjectCommand;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSection;
import com.ibm.cognos.fmeng.fmmd.impl.model.RelationalDimensionParentInternal;
import com.ibm.cognos.fmeng.fmmd.model.DimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.MeasureDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationalDimensionCommand
extends ReportObjectCommand {
    protected static final String PROP_DIMENSION_STYLE = "dimensionStyle";
    protected static final String PROP_MULTILINGUAL_SUPPORT = "multilingualSupport";
    protected static final String PROP_DEFAULT_HIERARCHY = "defaultHierarchy";
    protected static final String PROP_LEVELS = "levels";
    protected static final String PROP_RELATIONAL_HIERARCHY = "relationalHierarchies";
    protected static final String PROP_CREATE_RELATIONSHIP = "createRelationship";
    protected static final String PROP_FILTERS = "filters";

    @Override
    protected Class<?> expectedObjectType() {
        return RelationalDimension.class;
    }

    @Override
    protected Object create(Object parentObject, JSONObject modelObj, JSONObject dataOut) {
        MeasureDimension measureDimension;
        FmSection sectionParent = null;
        FmCube cubeParent = null;
        FMMDSession session = null;
        if (parentObject instanceof FmSection) {
            sectionParent = (FmSection)parentObject;
            session = sectionParent.getSession();
        } else if (parentObject instanceof FmCube) {
            cubeParent = (FmCube)parentObject;
            session = cubeParent.getSession();
        } else {
            JSONUtils.addError(dataOut, "Expected parent object, expecting either cube, or namespace, or folder.");
            return null;
        }
        Object sName = modelObj.get((Object)"name");
        String defaultName = this.getDefaultName(sName, session);
        DimensionBase.DimensionStyle styleValue = this.getEnumProperty(PROP_DIMENSION_STYLE, modelObj, DimensionBase.DimensionStyle.class, false, dataOut);
        if (styleValue == null) {
            styleValue = DimensionBase.DimensionStyle.regular;
        }
        boolean createRelationship = this.getBooleanProperty(PROP_CREATE_RELATIONSHIP, modelObj, Boolean.FALSE, false, dataOut);
        if (sectionParent != null) {
            return FmRelationalDimension.createRelationalDimension((FMMDSession)session, (RelationalDimensionParentInternal)sectionParent, (String)defaultName, (DimensionBase.DimensionStyle)styleValue);
        }
        FmRelationalDimension dimension = FmRelationalDimension.createRelationalDimension((FMMDSession)session, (RelationalDimensionParentInternal)cubeParent, (String)defaultName, (DimensionBase.DimensionStyle)styleValue);
        if (createRelationship && (measureDimension = cubeParent.getMeasureDimension()) != null) {
            String suggestedName = String.valueOf(defaultName) + "-" + measureDimension.getName();
            cubeParent.createRelationship(suggestedName, null, (RelationalDimension)dimension, measureDimension);
        }
        return dimension;
    }

    @Override
    protected void objectToJson(JSONObject result, Object object, String version, JSONObject dataOut) {
        super.objectToJson(result, object, version, dataOut);
        RelationalDimension relationalDimension = (RelationalDimension)object;
        this.addObjectToJson(result, PROP_DIMENSION_STYLE, relationalDimension.getDimensionStyle());
        this.addObjectToJson(result, PROP_MULTILINGUAL_SUPPORT, relationalDimension.getMultilingualSupport());
        this.addRefToJson(result, PROP_DEFAULT_HIERARCHY, relationalDimension.getDefaultHierarchy());
        List allLevels = relationalDimension.getAllLevels();
        if (allLevels != null) {
            ArrayList<Level> levels = new ArrayList<Level>(allLevels.size());
            for (Level level : allLevels) {
                if (level.isAllLevel()) continue;
                levels.add(level);
            }
            this.addRefListToJson(result, PROP_LEVELS, levels);
        }
        this.addRefListToJson(result, PROP_RELATIONAL_HIERARCHY, relationalDimension.getAllHierarchies());
        this.addRefListToJson(result, PROP_FILTERS, relationalDimension.getAllFilters());
    }
}

