/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmd.sdk.base.commands;

import com.ibm.cognos.fmd.sdk.base.commands.ReportObjectCommand;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.LevelReference;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationalHierarchyCommand
extends ReportObjectCommand {
    protected static final String PROP_MULTI_ROOT = "multiRoot";
    protected static final String PROP_ROOT_MEMBER = "rootMember";
    protected static final String PROP_ROOT_CAPTION = "rootCaption";
    protected static final String PROP_PARENT_CHILD = "isParentChild";
    protected static final String PROP_DEFAULT_HIERARCHY = "defaultHierarchy";
    protected static final String PROP_BALANCED = "balanced";
    protected static final String PROP_RAGGED = "ragged";
    protected static final String PROP_LEVELS = "levels";
    protected static final String PROP_LEVEL_REFERENCES = "levelReferences";
    protected static final String PROP_ACCESS_RULES = "accessRules";
    protected static final String PROP_HAS_RELATIVE_TIME_MEMBERS = "hasRelativeTimeMembers";
    protected static final String PROP_CAPTION_FOR_MEMBERS = "captionForMembers";
    protected static final String PROP_CLACULATED_MEMBERS = "calculatedMembers";
    protected static final String PROP_RELATIVE_TIME_MEMBERS = "relativeTimeMembers";
    protected static final String PROP_GENERATE_NEXT_PERIODS = "generateNextPeriodsMembers";
    protected static final String PROP_GENERATE_PRIOR_PERIODS = "generatePriorPeriodsMembers";
    protected static final String PROP_INCLUDE_RELATIVE_TIME_SUBTREE = "includeRelativeTimeSubtree";

    @Override
    protected Class<?> expectedObjectType() {
        return RelationalHierarchy.class;
    }

    @Override
    protected Object create(Object parentObject, JSONObject modelObj, JSONObject dataOut) {
        FmRelationalDimension parent = this.getTypedParent(parentObject, FmRelationalDimension.class, dataOut);
        if (parent == null) {
            return null;
        }
        FMMDSession session = parent.getSession();
        Object sName = modelObj.get((Object)"name");
        String defaultName = this.getDefaultName(sName, session);
        Boolean isParentChild = this.getBooleanProperty(PROP_PARENT_CHILD, modelObj, null, false, dataOut);
        if (isParentChild != null && isParentChild.booleanValue()) {
            return parent.createParentChildHierarchy(defaultName);
        }
        return parent.createHierarchy(defaultName);
    }

    @Override
    protected void jsonToObject(Object object, JSONObject modelObj, String version, JSONObject dataOut) {
        Boolean showSubtree;
        Boolean generatePrior;
        Boolean generateNext;
        List<Level> levels;
        BaseObject parent;
        Boolean isDefault;
        RelationalHierarchy.CaptionForMembers memberCaption;
        Boolean hasTimeMembers;
        Boolean isMultiRoot;
        Object property;
        String rootMember;
        Boolean ragged;
        super.jsonToObject(object, modelObj, version, dataOut);
        FmRelationalHierarchy hierarchy = (FmRelationalHierarchy)object;
        Boolean balanced = this.getBooleanProperty(PROP_BALANCED, modelObj, null, false, dataOut);
        if (balanced != null) {
            hierarchy.setBalanced(balanced.booleanValue());
        }
        if ((ragged = this.getBooleanProperty(PROP_RAGGED, modelObj, null, false, dataOut)) != null) {
            hierarchy.setRagged(ragged.booleanValue());
        }
        if ((rootMember = this.getStringProperty(PROP_ROOT_MEMBER, modelObj, false, dataOut)) != null) {
            hierarchy.setRootMember(rootMember);
        }
        if ((property = modelObj.remove((Object)PROP_ROOT_CAPTION)) != null && property instanceof JSONObject) {
            if (property instanceof JSONObject) {
                String text = (String)((JSONObject)property).get((Object)"text");
                String locale = (String)((JSONObject)property).get((Object)"locale");
                hierarchy.setRootCaption(locale, text);
            } else if (property instanceof String) {
                String defaultLocale = hierarchy.getSession().getDefaultLocale();
                hierarchy.setRootCaption(defaultLocale, (String)property);
            }
        }
        if ((isMultiRoot = this.getBooleanProperty(PROP_MULTI_ROOT, modelObj, null, false, dataOut)) != null) {
            hierarchy.setMultiRoot(isMultiRoot.booleanValue());
        }
        if ((hasTimeMembers = this.getBooleanProperty(PROP_HAS_RELATIVE_TIME_MEMBERS, modelObj, null, false, dataOut)) != null) {
            hierarchy.setHasRelativeTimeMembers(hasTimeMembers.booleanValue());
        }
        if ((memberCaption = this.getEnumProperty(PROP_CAPTION_FOR_MEMBERS, modelObj, RelationalHierarchy.CaptionForMembers.class, false, dataOut)) != null) {
            hierarchy.setCaptionForMembers(memberCaption);
        }
        if ((isDefault = this.getBooleanProperty(PROP_DEFAULT_HIERARCHY, modelObj, null, false, dataOut)) != null && isDefault.booleanValue() && (parent = hierarchy.getParent()) instanceof FmRelationalDimension) {
            ((FmRelationalDimension)parent).setDefaultHierarchy((RelationalHierarchy)hierarchy);
        }
        if ((levels = this.jsonToList(PROP_LEVELS, modelObj, Level.class, dataOut)) != null) {
            FMMDSession session = hierarchy.getSession();
            List existingRefs = hierarchy.getLevelReferences();
            if (existingRefs != null) {
                session.delete(existingRefs);
            }
            for (Level level : levels) {
                hierarchy.addLevel(level);
            }
        }
        if ((generateNext = this.getBooleanProperty(PROP_GENERATE_NEXT_PERIODS, modelObj, null, false, dataOut)) != null) {
            hierarchy.setShowRelativeTimeNextPeriodMembers(generateNext.booleanValue());
        }
        if ((generatePrior = this.getBooleanProperty(PROP_GENERATE_PRIOR_PERIODS, modelObj, null, false, dataOut)) != null) {
            hierarchy.setShowRelativeTimePriorPeriodMembers(generatePrior.booleanValue());
        }
        if ((showSubtree = this.getBooleanProperty(PROP_INCLUDE_RELATIVE_TIME_SUBTREE, modelObj, null, false, dataOut)) != null) {
            hierarchy.setShowRelativeTimeSubtreeMembers(showSubtree.booleanValue());
        }
    }

    @Override
    protected void objectToJson(JSONObject result, Object object, String version, JSONObject dataOut) {
        List levelRefs;
        super.objectToJson(result, object, version, dataOut);
        FmRelationalHierarchy hierarchy = (FmRelationalHierarchy)object;
        this.addObjectToJson(result, PROP_BALANCED, hierarchy.getBalanced());
        this.addObjectToJson(result, PROP_RAGGED, hierarchy.getRagged());
        this.addObjectToJson(result, PROP_ROOT_MEMBER, hierarchy.getRootMember());
        this.addObjectToJson(result, PROP_PARENT_CHILD, hierarchy.getParentChild());
        this.addObjectToJson(result, PROP_ROOT_CAPTION, hierarchy.getRootCaption());
        this.addObjectToJson(result, PROP_MULTI_ROOT, hierarchy.isMultiRoot());
        this.addObjectToJson(result, PROP_HAS_RELATIVE_TIME_MEMBERS, hierarchy.getHasRelativeTimeMembers());
        this.addObjectToJson(result, PROP_CAPTION_FOR_MEMBERS, hierarchy.getCaptionForMembers());
        this.addObjectToJson(result, PROP_GENERATE_NEXT_PERIODS, hierarchy.getShowRelativeTimeNextPeriodMembers());
        this.addObjectToJson(result, PROP_GENERATE_PRIOR_PERIODS, hierarchy.getShowRelativeTimePriorPeriodMembers());
        this.addObjectToJson(result, PROP_INCLUDE_RELATIVE_TIME_SUBTREE, hierarchy.getShowRelativeTimeSubtreeMembers());
        BaseObject parent = hierarchy.getParent();
        if (parent instanceof FmRelationalDimension) {
            RelationalHierarchy defaultHierarchy = ((FmRelationalDimension)parent).getDefaultHierarchy();
            boolean isDefaultHierarchy = hierarchy.equals((Object)defaultHierarchy);
            result.put((Object)PROP_DEFAULT_HIERARCHY, (Object)isDefaultHierarchy);
        }
        if ((levelRefs = hierarchy.getLevelReferences()) != null) {
            JSONArray jsonLevels = new JSONArray();
            JSONArray jsonLevelRefs = new JSONArray();
            for (LevelReference levelRef : levelRefs) {
                jsonLevelRefs.add((Object)this.getId(levelRef));
                jsonLevels.add((Object)this.getId(levelRef.getLevel()));
            }
            result.put((Object)PROP_LEVELS, (Object)jsonLevels);
            result.put((Object)PROP_LEVEL_REFERENCES, (Object)jsonLevelRefs);
        }
        this.addRefListToJson(result, PROP_ACCESS_RULES, hierarchy.getAccessRules());
        this.addRefListToJson(result, PROP_CLACULATED_MEMBERS, hierarchy.getCalculatedMembers());
        this.addRefListToJson(result, PROP_RELATIVE_TIME_MEMBERS, hierarchy.getRelativeTimeMembers());
    }
}

