/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmd.sdk.base.commands;

import com.ibm.cognos.fmd.sdk.base.commands.BaseObjectCommand;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmNamespace;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmProject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalParameterMap;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.json.java.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationalParameterMapCommand
extends BaseObjectCommand {
    protected static final String PROP_DEFAULT_VALUE = "defaultValue";
    protected static final String PROP_QUERY_ITEMS = "queryItems";
    protected static final String PROP_FILTERS = "filters";

    @Override
    protected Class<?> expectedObjectType() {
        return FmRelationalParameterMap.class;
    }

    @Override
    protected Object create(Object parentObject, JSONObject modelObj, JSONObject dataOut) {
        FmNamespace parent = this.getTypedParent(parentObject, FmNamespace.class, dataOut);
        if (parent == null) {
            return null;
        }
        FMMDSession session = parent.getSession();
        FmProject project = (FmProject)session.getProject();
        String sName = this.getStringProperty("name", modelObj, dataOut);
        return project.createRelationalParameterMap(sName);
    }

    @Override
    protected void jsonToObject(Object object, JSONObject modelObj, String version, JSONObject dataOut) {
        String defaultValue;
        super.jsonToObject(object, modelObj, version, dataOut);
        FmRelationalParameterMap parameterMap = (FmRelationalParameterMap)object;
        String name = this.getStringProperty("name", modelObj, false, dataOut);
        if (name != null) {
            parameterMap.setName(name, parameterMap.getSession().getDefaultLocale());
        }
        if ((defaultValue = this.getStringProperty(PROP_DEFAULT_VALUE, modelObj, false, dataOut)) != null) {
            parameterMap.setDefaultValue(defaultValue);
        }
    }

    @Override
    protected void objectToJson(JSONObject result, Object object, String version, JSONObject dataOut) {
        super.objectToJson(result, object, version, dataOut);
        FmRelationalParameterMap parameterMap = (FmRelationalParameterMap)object;
        this.addObjectToJson(result, "name", parameterMap.getName());
        this.addObjectToJson(result, PROP_DEFAULT_VALUE, parameterMap.getDefaultValue());
        this.addRefListToJson(result, PROP_QUERY_ITEMS, parameterMap.getAllQueryItems());
        this.addRefListToJson(result, PROP_FILTERS, parameterMap.getFilters());
    }
}

