/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmd.sdk.base.commands;

import com.ibm.cognos.fmd.sdk.base.commands.ResourceCommand;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationship;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.BuilderFactory;
import com.ibm.cognos.fmeng.fmmd.model.Cardinality;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipEnd;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipParent;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipCommand
extends ResourceCommand {
    protected static final String PROP_LEFT_OBJECT = "leftObjectRef";
    protected static final String PROP_RIGHT_OBJECT = "rightObjectRef";
    protected static final String PROP_LEFT_MIN_CARD = "leftMinCardinality";
    protected static final String PROP_LEFT_MAX_CARD = "leftMaxCardinality";
    protected static final String PROP_RIGHT_MIN_CARD = "rightMinCardinality";
    protected static final String PROP_RIGHT_MAX_CARD = "rightMaxCardinality";
    protected static final String PROP_EXPRESSION = "expression";

    @Override
    protected Class<?> expectedObjectType() {
        return FmRelationship.class;
    }

    @Override
    protected Object create(Object parentObject, JSONObject modelObj, JSONObject dataOut) {
        RelationshipParent parent = this.getTypedParent(parentObject, RelationshipParent.class, dataOut);
        if (parent == null) {
            return null;
        }
        BaseObject parentBase = this.getTypedParent(parentObject, BaseObject.class, dataOut);
        if (parentBase == null) {
            return null;
        }
        FMMDSession session = parentBase.getSession();
        Object sName = modelObj.remove((Object)"name");
        String defaultName = this.getDefaultName(sName, session);
        RelationshipEnd left = this.getRefProperty(PROP_LEFT_OBJECT, modelObj, false, RelationshipEnd.class, dataOut);
        RelationshipEnd right = this.getRefProperty(PROP_RIGHT_OBJECT, modelObj, false, RelationshipEnd.class, dataOut);
        ExpressionBuilder expression = this.jsonToExpression(session, PROP_EXPRESSION, modelObj, dataOut);
        return parent.createRelationship(defaultName, expression, left, right);
    }

    @Override
    protected void jsonToObject(Object object, JSONObject modelObj, String version, JSONObject dataOut) {
        ExpressionBuilder expression;
        RelationshipEnd right;
        RelationshipEnd left;
        Cardinality.ECardinality rightMaxCard;
        Cardinality.ECardinality rightMinCard;
        Cardinality.ECardinality leftMaxCard;
        super.jsonToObject(object, modelObj, version, dataOut);
        FmRelationship relationship = (FmRelationship)object;
        Cardinality.ECardinality leftMinCard = this.getEnumProperty(PROP_LEFT_MIN_CARD, modelObj, Cardinality.ECardinality.class, false, dataOut);
        if (leftMinCard != null) {
            relationship.setLeftMincard(leftMinCard);
        }
        if ((leftMaxCard = this.getEnumProperty(PROP_LEFT_MAX_CARD, modelObj, Cardinality.ECardinality.class, false, dataOut)) != null) {
            relationship.setLeftMaxcard(leftMaxCard);
        }
        if ((rightMinCard = this.getEnumProperty(PROP_RIGHT_MIN_CARD, modelObj, Cardinality.ECardinality.class, false, dataOut)) != null) {
            relationship.setRightMincard(rightMinCard);
        }
        if ((rightMaxCard = this.getEnumProperty(PROP_RIGHT_MAX_CARD, modelObj, Cardinality.ECardinality.class, false, dataOut)) != null) {
            relationship.setRightMaxcard(rightMaxCard);
        }
        if ((left = this.getRefProperty(PROP_LEFT_OBJECT, modelObj, false, RelationshipEnd.class, dataOut)) instanceof RelationshipEnd) {
            relationship.setLeftEnd(left);
        }
        if ((right = this.getRefProperty(PROP_RIGHT_OBJECT, modelObj, false, RelationshipEnd.class, dataOut)) instanceof RelationshipEnd) {
            relationship.setRightEnd(right);
        }
        if ((expression = this.jsonToExpression(relationship.getSession(), PROP_EXPRESSION, modelObj, dataOut)) != null) {
            relationship.setExpression(expression);
        }
    }

    @Override
    protected void objectToJson(JSONObject result, Object object, String version, JSONObject dataOut) {
        super.objectToJson(result, object, version, dataOut);
        FmRelationship relationship = (FmRelationship)object;
        this.addObjectToJson(result, "name", relationship.getName());
        this.addRefToJson(result, PROP_LEFT_OBJECT, relationship.getLeftEnd());
        this.addRefToJson(result, PROP_RIGHT_OBJECT, relationship.getRightEnd());
        this.addObjectToJson(result, PROP_LEFT_MIN_CARD, relationship.getLeftMincard());
        this.addObjectToJson(result, PROP_LEFT_MAX_CARD, relationship.getLeftMaxcard());
        this.addObjectToJson(result, PROP_RIGHT_MIN_CARD, relationship.getRightMincard());
        this.addObjectToJson(result, PROP_RIGHT_MAX_CARD, relationship.getRightMaxcard());
        Expression exp = relationship.getExpression();
        if (exp != null) {
            JSONArray jsonExpresson = this.expressionToJson(BuilderFactory.createExpressionBuilder((Expression)exp), dataOut);
            result.put((Object)PROP_EXPRESSION, (Object)jsonExpresson);
        }
    }

    @Override
    protected boolean delete(Object object, JSONObject dataOut) {
        return false;
    }
}

