/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmd.sdk.base.commands;

import com.ibm.cognos.fmd.sdk.base.JSONUtils;
import com.ibm.cognos.fmd.sdk.base.commands.ReportObjectCommand;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevelReference;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelativeTimeMember;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.LevelReference;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.RelativeTimeMember;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.json.java.JSONObject;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelativeTimeMemberCommand
extends ReportObjectCommand {
    protected static final String PROP_STYLE = "style";
    protected static final String PROP_TARGET_PERIOD = "targetPeriod";
    protected static final String PROP_PERIOD_OFFSET = "targetPeriodOffset";
    protected static final String PROP_CONTEXT_PERIOD = "contextPeriod";
    protected static final String PROP_CONTEXT_PERIOD_OFFSET = "contextPeriodOffset";
    protected static final String PROP_IS_LIFE_TO_DATE_PERIOD = "isLifeToDatePeriod";
    protected static final String PROP_TO_DATE_PERIOD = "toDatePeriod";
    protected static final String PROP_NUMBER_OF_PERIODS = "numberOfPeriods";

    @Override
    protected Class<?> expectedObjectType() {
        return FmRelativeTimeMember.class;
    }

    @Override
    protected Object create(Object parentObject, JSONObject modelObj, JSONObject dataOut) {
        FmRelationalHierarchy parent = this.getTypedParent(parentObject, FmRelationalHierarchy.class, dataOut);
        if (parent == null) {
            return null;
        }
        RelativeTimeMember.RelativeTimeMemberStyle style = this.getEnumProperty(PROP_STYLE, modelObj, RelativeTimeMember.RelativeTimeMemberStyle.class, true, dataOut);
        if (style == null) {
            return null;
        }
        String sName = this.getStringProperty("name", modelObj, false, dataOut);
        return parent.createRelativeTimeMember(sName, style);
    }

    @Override
    protected void jsonToObject(Object object, JSONObject modelObj, String version, JSONObject dataOut) {
        Boolean lifeToDate;
        BigInteger numberOfPeriods;
        BigInteger contextPeriodOffset;
        BigInteger targetPeriodOffset;
        LevelReference toDatePeriod;
        LevelReference contextPeriod;
        super.jsonToObject(object, modelObj, version, dataOut);
        FmRelativeTimeMember member = (FmRelativeTimeMember)object;
        BaseObject parent = member.getParent();
        while (!(parent instanceof RelationalHierarchy)) {
            if (parent == null) break;
            parent = parent.getParent();
        }
        if (parent == null) {
            JSONUtils.addError(dataOut, "Unable to find containing hierarchy for relative time member: " + this.getId(member));
            return;
        }
        LevelReference targetPeriod = this.getLevelReference(PROP_TARGET_PERIOD, (FmRelationalHierarchy)parent, modelObj, dataOut);
        if (targetPeriod != null) {
            member.setTargetPeriod(targetPeriod);
        }
        if ((contextPeriod = this.getLevelReference(PROP_CONTEXT_PERIOD, (FmRelationalHierarchy)parent, modelObj, dataOut)) != null) {
            member.setContextPeriod(contextPeriod);
        }
        if ((toDatePeriod = this.getLevelReference(PROP_TO_DATE_PERIOD, (FmRelationalHierarchy)parent, modelObj, dataOut)) != null) {
            member.setToDatePeriod(toDatePeriod);
        }
        if ((targetPeriodOffset = this.getBigIntegerProperty(PROP_PERIOD_OFFSET, modelObj, false, dataOut)) != null) {
            member.setTargetPeriodOffset(targetPeriodOffset);
        }
        if ((contextPeriodOffset = this.getBigIntegerProperty(PROP_CONTEXT_PERIOD_OFFSET, modelObj, false, dataOut)) != null) {
            member.setContextPeriodOffset(contextPeriodOffset);
        }
        if ((numberOfPeriods = this.getBigIntegerProperty(PROP_NUMBER_OF_PERIODS, modelObj, false, dataOut)) != null) {
            member.setNumberOfPeriods(numberOfPeriods);
        }
        if ((lifeToDate = this.getBooleanProperty(PROP_IS_LIFE_TO_DATE_PERIOD, modelObj, null, false, dataOut)) != null) {
            member.setLifeToDate(lifeToDate.booleanValue());
        }
    }

    @Override
    protected void objectToJson(JSONObject result, Object object, String version, JSONObject dataOut) {
        super.objectToJson(result, object, version, dataOut);
        FmRelativeTimeMember member = (FmRelativeTimeMember)object;
        this.addObjectToJson(result, PROP_STYLE, member.getRelativeTimeMemberStyle());
        LevelReference targetPeriod = member.getTargetPeriod();
        if (targetPeriod != null) {
            this.addRefToJson(result, PROP_TARGET_PERIOD, targetPeriod.getLevel());
        }
        this.addObjectToJson(result, PROP_PERIOD_OFFSET, member.getTargetPeriodOffset());
        LevelReference contextPeriod = member.getContextPeriod();
        if (contextPeriod != null) {
            this.addRefToJson(result, PROP_CONTEXT_PERIOD, contextPeriod.getLevel());
        }
        this.addObjectToJson(result, PROP_CONTEXT_PERIOD_OFFSET, member.getContextPeriodOffset());
        this.addObjectToJson(result, PROP_IS_LIFE_TO_DATE_PERIOD, member.isLifeToDate());
        LevelReference toDatePeriod = member.getToDatePeriod();
        if (toDatePeriod != null) {
            this.addRefToJson(result, PROP_TO_DATE_PERIOD, toDatePeriod.getLevel());
        }
        this.addObjectToJson(result, PROP_NUMBER_OF_PERIODS, member.getNumberOfPeriods());
    }

    private LevelReference getLevelReference(String propertyName, FmRelationalHierarchy parent, JSONObject modelObj, JSONObject dataOut) {
        String id = this.getStringProperty(propertyName, modelObj, false, dataOut);
        if (id == null) {
            return null;
        }
        Object object = this.getObject(id);
        if (object instanceof LevelReference) {
            return (LevelReference)object;
        }
        if (object instanceof Level) {
            return FmLevelReference.createLevelReference((FMMDSession)parent.getSession(), (FmRelationalHierarchy)parent, (Level)((Level)object));
        }
        JSONUtils.addError(dataOut, "Object \"" + id + "\" is expected to be of type Level or LevelReference.");
        return null;
    }
}

