/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmd.sdk.base.commands;

import com.ibm.cognos.fmd.sdk.base.IResponder;
import com.ibm.cognos.fmd.sdk.base.JSONUtils;
import com.ibm.cognos.fmd.sdk.base.commands.SDKCommand;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMemberUniqueName;
import com.ibm.cognos.fmeng.fmmd.model.BuilderFactory;
import com.ibm.cognos.fmeng.fmmd.model.CalculatedMember;
import com.ibm.cognos.fmeng.fmmd.model.Calculation;
import com.ibm.cognos.fmeng.fmmd.model.ColumnReference;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.Filter;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.LevelReference;
import com.ibm.cognos.fmeng.fmmd.model.MDXExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.Measure;
import com.ibm.cognos.fmeng.fmmd.model.MemberUniqueNameBuilder;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.fmmd.model.VirtualDimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.VirtualHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.VirtualLevel;
import com.ibm.cognos.fmeng.fmmd.model.VirtualMeasure;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceCommand
extends SDKCommand
implements IResponder {
    protected static final String PROP_COLUMNREF_COLUMN_NAME = "columnName";
    protected static final String PROP_COLUMNREF_TABLE_NAME = "tableName";
    protected static final String PROP_COLUMNREF_DATASOURCE = "dataSourceRef";
    protected static final String PROP_COLUMNREF_OBJECTREF = "objectRef";
    protected static final String PROP_MEMBER_REF = "member";
    protected static final String PROP_CAPTION = "caption";
    protected static final String PROP_PATH = "path";

    protected abstract Object create(Object var1, JSONObject var2, JSONObject var3);

    protected abstract boolean delete(Object var1, JSONObject var2);

    @Override
    public int processPost(String objectId, JSONObject dataIn, JSONObject dataOut, int version) {
        Object candidateObj = null;
        String sParent = (String)dataIn.remove((Object)"parent");
        Object parentObj = this.getObject(sParent);
        candidateObj = this.create(parentObj, dataIn, dataOut);
        if (candidateObj == null) {
            return 0;
        }
        this.jsonToObject(candidateObj, dataIn, null, dataOut);
        JSONUtils.setId(dataOut, this.getId(candidateObj));
        this.warnOnUnusedData(dataIn, dataOut);
        return 201;
    }

    @Override
    public int processGet(String objectId, JSONObject dataIn, JSONObject dataOut, int version) {
        Object modelObj = this.getObjectFromPath(objectId, this.expectedObjectType(), dataOut);
        if (modelObj == null) {
            return 0;
        }
        this.objectToJson(dataOut, modelObj, null, dataOut);
        return 200;
    }

    protected Object getObjectFromId(String objectId, Class<?> expectedType, JSONObject dataOut) {
        if (objectId == null) {
            JSONUtils.addError(dataOut, "Unable to find object's Id");
            return null;
        }
        Object modelObj = this.getObject(objectId);
        if (modelObj == null) {
            JSONUtils.addError(dataOut, "Unable to find model object for ID: " + objectId);
            return null;
        }
        if (expectedType != null && !expectedType.isInstance(modelObj)) {
            JSONUtils.addError(dataOut, "Incorrect object type, expected: " + expectedType);
            return null;
        }
        return modelObj;
    }

    @Override
    public int processPut(String objectId, JSONObject dataIn, JSONObject dataOut, int version) {
        Object modelObject = this.getObjectFromPath(objectId, this.expectedObjectType(), dataOut);
        if (modelObject == null) {
            return 0;
        }
        this.jsonToObject(modelObject, dataIn, null, dataOut);
        this.warnOnUnusedData(dataIn, dataOut);
        return 200;
    }

    @Override
    public int processDelete(String objectId, JSONObject dataIn, JSONObject dataOut, int version) {
        Object modelObject = this.getObjectFromPath(objectId, this.expectedObjectType(), dataOut);
        if (modelObject == null) {
            return 0;
        }
        boolean result = this.delete(modelObject, dataOut);
        if (result) {
            this.removeId(this.getId(modelObject));
        } else {
            JSONUtils.addError(dataOut, "Unable to delete item: " + this.getId(modelObject));
        }
        return 200;
    }

    protected Class<?> expectedObjectType() {
        return null;
    }

    protected <T> T getTypedParent(Object parentObject, Class<T> type, JSONObject dataOut) {
        try {
            return type.cast(parentObject);
        }
        catch (ClassCastException classCastException) {
            JSONUtils.addError(dataOut, "Expected parent object: " + type.getName());
            return null;
        }
    }

    protected String getDefaultName(Object modelObj, FMMDSession fmSession) {
        if (modelObj instanceof String) {
            return (String)modelObj;
        }
        if (modelObj instanceof JSONObject) {
            return (String)((JSONObject)modelObj).get((Object)"text");
        }
        if (modelObj instanceof JSONArray) {
            String localeKey = fmSession.getProject().getDefaultLocale().toString();
            String bestFit = null;
            for (Object object : (JSONArray)modelObj) {
                String text = (String)((JSONObject)object).get((Object)"text");
                if (text == null) continue;
                String locale = (String)((JSONObject)object).get((Object)"locale");
                if (locale != null && locale.equalsIgnoreCase(localeKey)) {
                    ((JSONArray)modelObj).remove(object);
                    return text;
                }
                if (bestFit != null) continue;
                bestFit = text;
            }
            return bestFit;
        }
        return null;
    }

    protected void jsonToObject(Object object, JSONObject modelObj, String version, JSONObject dataOut) {
    }

    protected void objectToJson(JSONObject result, Object object, String version, JSONObject dataOut) {
    }

    protected ExpressionBuilder jsonToExpression(FMMDSession session, String expressionPropertyName, JSONObject jsonModel, JSONObject dataOut) {
        Object expressionObject = jsonModel.remove((Object)expressionPropertyName);
        if (expressionObject instanceof String) {
            return BuilderFactory.createExpressionBuilder((FMMDSession)session, (String)((String)expressionObject));
        }
        if (expressionObject instanceof JSONArray) {
            ExpressionBuilder expressionBuilder = BuilderFactory.createExpressionBuilder();
            for (Object expressionPartObject : (JSONArray)expressionObject) {
                if (expressionPartObject instanceof String) {
                    expressionBuilder.addExpressionPart((String)expressionPartObject, null);
                    continue;
                }
                if (expressionPartObject instanceof JSONObject) {
                    JSONObject jsonPart = (JSONObject)expressionPartObject;
                    Object id = jsonPart.get((Object)"id");
                    if (id != null) {
                        if (!(id instanceof String)) {
                            JSONUtils.addError(dataOut, "Unexpected expression part ID: " + id);
                            return null;
                        }
                        Object refObject = this.getObject((String)id);
                        if (refObject instanceof Calculation) {
                            expressionBuilder.addExpressionPart((Calculation)refObject, null);
                            continue;
                        }
                        if (refObject instanceof Filter) {
                            expressionBuilder.addExpressionPart((Filter)refObject, null);
                            continue;
                        }
                        if (refObject instanceof QueryItemBase) {
                            expressionBuilder.addExpressionPart((QueryItemBase)refObject, null, null);
                            continue;
                        }
                        JSONUtils.addError(dataOut, "Unexpected object references in the expression part: " + refObject);
                        continue;
                    }
                    if (jsonPart.containsKey((Object)PROP_CAPTION) || jsonPart.containsKey((Object)PROP_MEMBER_REF)) {
                        MemberUniqueNameBuilder mun = this.getMUNfromJSON(jsonPart, dataOut);
                        if (mun == null) continue;
                        expressionBuilder.addExpressionPart(mun, null);
                        continue;
                    }
                    Object property = jsonPart.get((Object)PROP_COLUMNREF_COLUMN_NAME);
                    if (!(property instanceof String)) {
                        JSONUtils.addError(dataOut, "columnName property should be a string: " + property);
                        return null;
                    }
                    String columnName = (String)property;
                    property = jsonPart.get((Object)PROP_COLUMNREF_TABLE_NAME);
                    if (!(property instanceof String)) {
                        JSONUtils.addError(dataOut, "tableName property should be a string: " + property);
                        return null;
                    }
                    String tableName = (String)property;
                    property = jsonPart.get((Object)PROP_COLUMNREF_DATASOURCE);
                    if (!(property instanceof String)) {
                        JSONUtils.addError(dataOut, "dataSourceRef property should be a string: " + property);
                        return null;
                    }
                    Object dataSourceObject = this.getObject((String)property);
                    if (!(dataSourceObject instanceof DataSource)) {
                        JSONUtils.addError(dataOut, "Unexpected data source type: " + dataSourceObject);
                        return null;
                    }
                    property = jsonPart.get((Object)PROP_COLUMNREF_OBJECTREF);
                    if (!(property instanceof String)) {
                        JSONUtils.addError(dataOut, "objectRef property should be a string: " + property);
                        return null;
                    }
                    Object relationalObject = this.getObject((String)property);
                    if (!(relationalObject instanceof RelationalObject)) {
                        JSONUtils.addError(dataOut, "Unexpected reference object type: " + relationalObject);
                        return null;
                    }
                    expressionBuilder.addExpressionPart((DataSource)dataSourceObject, columnName, tableName, (RelationalObject)relationalObject, null);
                    continue;
                }
                JSONUtils.addError(dataOut, "Unrecognized expression part: " + expressionPartObject);
                return null;
            }
            return expressionBuilder;
        }
        if (expressionObject != null) {
            JSONUtils.addError(dataOut, "Unsupported expression: " + expressionObject);
        }
        return null;
    }

    protected JSONArray expressionToJson(ExpressionBuilder expression, JSONObject dataOut) {
        JSONArray result = new JSONArray();
        List parts = expression.getParts();
        for (Object part : parts) {
            JSONObject jsonPart;
            if (part instanceof String) {
                result.add(part);
                continue;
            }
            if (part instanceof ColumnReference) {
                ColumnReference columnReference = (ColumnReference)part;
                jsonPart = new JSONObject();
                jsonPart.put((Object)PROP_COLUMNREF_COLUMN_NAME, (Object)columnReference.getColumnName());
                jsonPart.put((Object)PROP_COLUMNREF_TABLE_NAME, (Object)columnReference.getTableName());
                jsonPart.put((Object)PROP_COLUMNREF_DATASOURCE, (Object)this.getId(columnReference.getDataSource()));
                jsonPart.put((Object)PROP_COLUMNREF_OBJECTREF, (Object)this.getId(columnReference.getRelationalObject()));
                result.add((Object)jsonPart);
                continue;
            }
            if (part instanceof Calculation || part instanceof Filter || part instanceof QueryItemBase) {
                JSONObject jsonPart2 = new JSONObject();
                jsonPart2.put((Object)"id", (Object)this.getId(part));
                result.add((Object)jsonPart2);
                continue;
            }
            if (!(part instanceof FmMemberUniqueName)) continue;
            FMMDSession session = ((FmMemberUniqueName)part).getSession();
            jsonPart = this.getJSONfromMUN(session, (FmMemberUniqueName)part, dataOut);
            result.add((Object)jsonPart);
        }
        return result;
    }

    protected MDXExpressionBuilder jsonToMDXExpression(FMMDSession session, String expressionPropertyName, JSONObject jsonModel, JSONObject dataOut) {
        Object expressionObject = jsonModel.remove((Object)expressionPropertyName);
        if (!(expressionObject instanceof JSONArray)) {
            JSONUtils.addError(dataOut, "Unexpected expression representation: " + expressionObject);
            return null;
        }
        MDXExpressionBuilder expressionBuilder = BuilderFactory.createMDXExpressionBuilder();
        for (Object expressionPartObject : (JSONArray)expressionObject) {
            if (expressionPartObject instanceof String) {
                expressionBuilder.addPart((String)expressionPartObject, null);
                continue;
            }
            if (!(expressionPartObject instanceof JSONObject)) continue;
            JSONObject jsonPart = (JSONObject)expressionPartObject;
            Object property = jsonPart.get((Object)"id");
            if (property == null) {
                MemberUniqueNameBuilder member = this.getMUNfromJSON(jsonPart, dataOut);
                expressionBuilder.addPart(member, null);
                continue;
            }
            if (!(property instanceof String)) {
                JSONUtils.addError(dataOut, "Unexpected expression part ID: " + property);
                return null;
            }
            Object refObject = this.getObject((String)property);
            if (refObject instanceof RelationalHierarchy) {
                expressionBuilder.addPart((RelationalHierarchy)refObject, null);
                continue;
            }
            if (refObject instanceof LevelReference) {
                expressionBuilder.addPart((LevelReference)refObject, null);
                continue;
            }
            if (refObject instanceof RelationalDimensionBase) {
                expressionBuilder.addPart((RelationalDimensionBase)refObject, null);
                continue;
            }
            if (refObject instanceof QueryItem) {
                expressionBuilder.addPart((QueryItem)refObject, null);
                continue;
            }
            if (refObject instanceof Measure) {
                expressionBuilder.addPart((Measure)refObject, null);
                continue;
            }
            if (refObject instanceof VirtualDimensionBase) {
                expressionBuilder.addPart((VirtualDimensionBase)refObject, null);
                continue;
            }
            if (refObject instanceof VirtualHierarchy) {
                expressionBuilder.addPart((VirtualHierarchy)refObject, null);
                continue;
            }
            if (refObject instanceof VirtualLevel) {
                expressionBuilder.addPart((VirtualLevel)refObject, null);
                continue;
            }
            if (refObject instanceof VirtualMeasure) {
                expressionBuilder.addPart((VirtualMeasure)refObject, null);
                continue;
            }
            if (refObject instanceof TopLevelObject) {
                expressionBuilder.addPart((TopLevelObject)refObject, null);
                continue;
            }
            if (refObject instanceof CalculatedMember) {
                expressionBuilder.addPart((CalculatedMember)refObject, null);
                continue;
            }
            JSONUtils.addError(dataOut, "Unexpected object references in the expression part: " + refObject);
        }
        return expressionBuilder;
    }

    protected JSONArray mdxExpressionToJson(FMMDSession session, Expression expression, JSONObject dataOut) {
        JSONArray result = new JSONArray();
        List parts = expression.getComponents();
        for (Object part : parts) {
            JSONObject jsonPart;
            if (part instanceof String) {
                result.add(part);
                continue;
            }
            if (part instanceof FmMemberUniqueName) {
                jsonPart = this.getJSONfromMUN(session, (FmMemberUniqueName)part, dataOut);
                result.add((Object)jsonPart);
                continue;
            }
            jsonPart = new JSONObject();
            jsonPart.put((Object)"id", (Object)this.getId(part));
            result.add((Object)jsonPart);
        }
        return result;
    }

    protected MemberUniqueNameBuilder getMUNfromJSON(JSONObject modelObj, JSONObject dataOut) {
        MemberUniqueNameBuilder member = BuilderFactory.createMemberUniqueNameBuilder();
        String sCaption = this.getStringProperty(PROP_CAPTION, modelObj, false, dataOut);
        String sPath = this.getStringProperty(PROP_PATH, modelObj, false, dataOut);
        Object refObject = this.getRefProperty(PROP_MEMBER_REF, modelObj, false, Object.class, dataOut);
        if (refObject instanceof LevelReference) {
            member.setMember((LevelReference)refObject, sPath, sCaption);
        } else if (refObject instanceof Level) {
            member.setMember((Level)refObject, sPath, sCaption);
        } else if (refObject instanceof RelationalHierarchy) {
            member.setMember((RelationalHierarchy)refObject, sPath, sCaption);
        } else if (refObject instanceof VirtualLevel) {
            member.setMember((VirtualLevel)refObject, sPath, sCaption);
        } else if (refObject instanceof VirtualHierarchy) {
            member.setMember((VirtualHierarchy)refObject, sPath, sCaption);
        } else if (sCaption != null) {
            member.setCaption(sCaption);
        }
        return member;
    }

    protected JSONObject getJSONfromMUN(FMMDSession session, FmMemberUniqueName mun, JSONObject dataOut) {
        JSONObject result = new JSONObject();
        this.addObjectToJson(result, PROP_CAPTION, mun.getMemberCaption());
        this.addObjectToJson(result, PROP_PATH, mun.getPath());
        List refObjects = mun.getRawRefObjs();
        if (refObjects != null && refObjects.size() > 0) {
            this.addRefToJson(result, PROP_MEMBER_REF, refObjects.get(0));
        }
        return result;
    }
}

