/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmd.sdk.base.commands;

import com.ibm.cognos.fmd.sdk.base.JSONUtils;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SDKCommand {
    protected static final String pathPrefix = "/FmCommand/";
    protected static final String PROP_ID = "id";
    protected static final String PROP_TEXT = "text";
    protected static final String PROP_LOCALE = "locale";
    protected static final String PROP_NAME = "name";
    protected static final String PROP_NAMESPACE = "namespace";
    protected static final String TEXT_REQUEST = "com.ibm.cognos.fmd.sdk.request.text";
    public static final String TEXT_RETURN = "com.ibm.cognos.fmd.sdk.result.text";
    private static Map<String, Object> idMap = new HashMap<String, Object>();
    private static Map<Object, String> idReverseMap = new HashMap<Object, String>();

    protected Object getObjectFromPath(String urlPath, Class<?> expectedType, JSONObject dataOut) {
        String[] urlSegments = urlPath.split("/");
        if (urlSegments.length < 2) {
            return null;
        }
        Object modelObj = null;
        String id = urlSegments[1];
        modelObj = this.getObject(id);
        if (modelObj == null) {
            JSONUtils.addError(dataOut, "Unable to find model object for ID: " + id);
            return null;
        }
        if (expectedType != null && !expectedType.isInstance(modelObj)) {
            JSONUtils.addError(dataOut, "Incorrect object type, expected: " + expectedType);
            return null;
        }
        return modelObj;
    }

    protected synchronized String getId(Object object) {
        String id = idReverseMap.get(object);
        if (id != null) {
            return id;
        }
        if (object instanceof ReportObject) {
            id = ((ReportObject)object).getGuid();
        }
        if (id == null) {
            UUID uuid = UUID.randomUUID();
            id = uuid.toString();
            id = id.replaceAll("-", "");
        }
        idReverseMap.put(object, id);
        idMap.put(id, object);
        return id;
    }

    protected synchronized Object getObject(String id) {
        return idMap.get(id);
    }

    protected synchronized void removeId(String id) {
        idReverseMap.remove(id);
        idMap.remove(id);
    }

    protected void addTextToJson(JSONArray jsonArray, String value, String locale) {
        if (value == null) {
            return;
        }
        JSONObject desc = new JSONObject();
        desc.put((Object)PROP_TEXT, (Object)value);
        desc.put((Object)PROP_LOCALE, (Object)locale);
        jsonArray.add((Object)desc);
    }

    protected void addObjectToJson(JSONObject result, String property, Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof String) {
            result.put((Object)property, object);
        } else {
            result.put((Object)property, (Object)object.toString());
        }
    }

    protected void addRefToJson(JSONObject result, String property, Object object) {
        if (object == null) {
            return;
        }
        result.put((Object)property, (Object)this.getId(object));
    }

    protected void addRefListToJson(JSONObject result, String property, List<?> list) {
        if (list == null) {
            return;
        }
        if (list.isEmpty()) {
            return;
        }
        JSONArray jsonArray = new JSONArray(list.size());
        for (Object object : list) {
            jsonArray.add((Object)this.getId(object));
        }
        result.put((Object)property, (Object)jsonArray);
    }

    protected <T> T getJsonProperty(String propertyName, JSONObject modelObj, boolean required, Class<T> type, JSONObject dataOut) {
        if (modelObj == null) {
            JSONUtils.addError(dataOut, "Request has no JSON data");
            return null;
        }
        Object property = modelObj.remove((Object)propertyName);
        if (property == null) {
            if (required) {
                JSONUtils.addError(dataOut, "Missing required property: " + propertyName);
            }
            return null;
        }
        try {
            return type.cast(property);
        }
        catch (ClassCastException classCastException) {
            JSONUtils.addError(dataOut, "Property \"" + propertyName + "\" is expected to be of type \"" + type + "\"");
            return null;
        }
    }

    protected <T> T getRefProperty(String propertyName, JSONObject modelObj, boolean required, Class<T> type, JSONObject dataOut) {
        String id = this.getStringProperty(propertyName, modelObj, required, dataOut);
        if (id == null) {
            return null;
        }
        Object ref = this.getObject(id);
        try {
            return type.cast(ref);
        }
        catch (ClassCastException classCastException) {
            JSONUtils.addError(dataOut, "Object \"" + id + "\" is expected to be of type \"" + type + "\"");
            return null;
        }
    }

    protected String getStringProperty(String propertyName, JSONObject modelObj, boolean required, JSONObject dataOut) {
        return this.getJsonProperty(propertyName, modelObj, required, String.class, dataOut);
    }

    protected String getStringProperty(String propertyName, JSONObject modelObj, JSONObject dataOut) {
        return this.getJsonProperty(propertyName, modelObj, true, String.class, dataOut);
    }

    protected <T extends Enum<T>> T getEnumProperty(String propertyName, JSONObject modelObj, Class<T> type, boolean required, JSONObject dataOut) {
        String tmp = this.getJsonProperty(propertyName, modelObj, required, String.class, dataOut);
        if (tmp == null) {
            return null;
        }
        try {
            return Enum.valueOf(type, tmp);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JSONUtils.addError(dataOut, "Property \"" + propertyName + "\" has unsupported value \"" + tmp + "\"");
            return null;
        }
    }

    protected Boolean getBooleanProperty(String propertyName, JSONObject modelObj, Boolean defaultValue, boolean requied, JSONObject dataOut) {
        String tmp = this.getJsonProperty(propertyName, modelObj, requied, String.class, dataOut);
        if (tmp == null) {
            return defaultValue;
        }
        return Boolean.valueOf(tmp);
    }

    protected Integer getIntegerProperty(String propertyName, JSONObject modelObj, boolean required, JSONObject dataOut) {
        String tmp = this.getJsonProperty(propertyName, modelObj, required, String.class, dataOut);
        if (tmp == null) {
            return null;
        }
        try {
            return Integer.valueOf(tmp);
        }
        catch (NumberFormatException numberFormatException) {
            JSONUtils.addError(dataOut, "Invalid argument for property: " + propertyName);
            return null;
        }
    }

    protected BigInteger getBigIntegerProperty(String propertyName, JSONObject modelObj, boolean required, JSONObject dataOut) {
        String tmp = this.getJsonProperty(propertyName, modelObj, required, String.class, dataOut);
        if (tmp == null) {
            return null;
        }
        try {
            return new BigInteger(tmp);
        }
        catch (NumberFormatException numberFormatException) {
            JSONUtils.addError(dataOut, "Invalid argument for property: " + propertyName);
            return null;
        }
    }

    private <T> T textToObject(String text, Class<T> type, JSONObject dataOut) {
        if (text == null) {
            return null;
        }
        Object elementObject = this.getObject(text);
        if (elementObject == null) {
            return null;
        }
        if (type.isAssignableFrom(elementObject.getClass())) {
            return type.cast(elementObject);
        }
        JSONUtils.addError(dataOut, "Object \"" + text + "\" is expected to be of type \"" + type + "\"");
        return null;
    }

    protected <T> List<T> jsonToList(String propertyName, JSONObject modelObj, Class<T> type, JSONObject dataOut) {
        Object property = modelObj.remove((Object)propertyName);
        if (property == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        if (property instanceof String) {
            T object = this.textToObject((String)property, type, dataOut);
            if (object != null) {
                result.add(object);
            }
            return result;
        }
        if (!(property instanceof JSONArray)) {
            JSONUtils.addError(dataOut, "Expected array for the value of the property " + propertyName);
            return result;
        }
        for (Object element : (JSONArray)property) {
            if (!(element instanceof String)) {
                JSONUtils.addError(dataOut, "Expected array of strings for the value of the property " + propertyName);
                continue;
            }
            T object = this.textToObject((String)element, type, dataOut);
            if (object == null) continue;
            result.add(object);
        }
        return result;
    }

    protected List<String> jsonToList(String propertyName, JSONObject modelObj, JSONObject dataOut) {
        Object property = modelObj.remove((Object)propertyName);
        if (property == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        if (property instanceof String) {
            result.add((String)property);
            return result;
        }
        if (!(property instanceof JSONArray)) {
            JSONUtils.addError(dataOut, "Expected array for the value of the property " + propertyName);
            return result;
        }
        for (Object element : (JSONArray)property) {
            if (!(element instanceof String)) {
                JSONUtils.addError(dataOut, "Expected array of strings for the value of the property " + propertyName);
                continue;
            }
            result.add((String)element);
        }
        return result;
    }

    protected void warnOnUnusedData(JSONObject dataIn, JSONObject dataOut) {
        String tmp;
        if (dataIn.isEmpty()) {
            return;
        }
        try {
            tmp = dataIn.serialize();
        }
        catch (IOException e) {
            tmp = e.getMessage();
        }
        JSONUtils.addWarning(dataOut, "Unused parameters: " + tmp);
    }
}

