/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmd.sdk.base.commands;

import com.ibm.cognos.fmd.sdk.base.commands.ResourceCommand;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSQLObject;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.SQLObject;
import com.ibm.json.java.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLObjectCommand
extends ResourceCommand {
    protected static final String PROP_DATASOURCE = "datasource";
    protected static final String PROP_SQL_STATEMENT = "sqlStatement";

    @Override
    protected Class<?> expectedObjectType() {
        return FmSQLObject.class;
    }

    @Override
    protected Object create(Object parentObject, JSONObject modelObj, JSONObject dataOut) {
        FmRelationalObject parent = this.getTypedParent(parentObject, FmRelationalObject.class, dataOut);
        DataSource dsObject = this.getRefProperty(PROP_DATASOURCE, modelObj, true, DataSource.class, dataOut);
        String sName = this.getStringProperty("name", modelObj, dataOut);
        String sqlStatement = this.getStringProperty(PROP_SQL_STATEMENT, modelObj, dataOut);
        if (dsObject == null || sName == null || parent == null || sqlStatement == null) {
            return null;
        }
        return parent.getPhysicalDefinition().createSQLObject(dsObject, sName, sqlStatement);
    }

    @Override
    protected void jsonToObject(Object object, JSONObject modelObj, String version, JSONObject dataOut) {
        super.jsonToObject(object, modelObj, version, dataOut);
        FmSQLObject sqlObject = (FmSQLObject)object;
        String sqlStatement = this.getStringProperty(PROP_SQL_STATEMENT, modelObj, false, dataOut);
        if (sqlStatement != null) {
            sqlObject.setSQLStatement(sqlStatement);
        }
    }

    @Override
    protected void objectToJson(JSONObject result, Object object, String version, JSONObject dataOut) {
        super.objectToJson(result, object, version, dataOut);
        FmSQLObject sqlObject = (FmSQLObject)object;
        this.addObjectToJson(result, "name", sqlObject.getName());
        this.addObjectToJson(result, PROP_SQL_STATEMENT, sqlObject.getSQLStatement());
        this.addRefToJson(result, PROP_DATASOURCE, sqlObject.getDataSource());
    }

    @Override
    protected boolean delete(Object object, JSONObject dataOut) {
        FmSQLObject sqlObject = (FmSQLObject)object;
        RelationalObject parent = sqlObject.getRelationalParent();
        if (parent == null) {
            return false;
        }
        parent.removeSQLObject((SQLObject)sqlObject);
        return true;
    }
}

