/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmd.sdk.base.commands;

import com.ibm.cognos.fmd.sdk.base.JSONUtils;
import com.ibm.cognos.fmd.sdk.base.commands.BaseObjectCommand;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmAccessRule;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasureDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.AccessRule;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.BuilderFactory;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.MDXExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.MeasureBase;
import com.ibm.cognos.fmeng.fmmd.model.Permission;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityFilterCommand
extends BaseObjectCommand {
    protected static final String PROP_IS_ALL_ACCESS = "isAllAccess";
    protected static final String PROP_PERMISSSION = "permission";
    protected static final String PROP_MEMBER_ACCESS = "memberAccess";
    protected static final String PROP_EXPRESSION = "expression";
    protected static final String PROP_REF = "objectReference";
    protected static final String PROP_RULE_STYLE = "ruleStyle";

    @Override
    protected Class<?> expectedObjectType() {
        return FmAccessRule.class;
    }

    @Override
    protected Object create(Object parentObject, JSONObject modelObj, JSONObject dataOut) {
        BaseObject parent = this.getTypedParent(parentObject, BaseObject.class, dataOut);
        if (parent == null) {
            return null;
        }
        FMMDSession session = parent.getSession();
        boolean isAllAccess = this.getBooleanProperty(PROP_IS_ALL_ACCESS, modelObj, Boolean.FALSE, false, dataOut);
        if (isAllAccess) {
            if (parentObject instanceof FmRelationalHierarchy) {
                return FmAccessRule.createAllAccessRule((FMMDSession)session, (FmRelationalHierarchy)((FmRelationalHierarchy)parentObject));
            }
            JSONUtils.addError(dataOut, "Expected parent object to be a relational hierarchy");
            return null;
        }
        Permission access = this.getEnumProperty(PROP_PERMISSSION, modelObj, Permission.class, true, dataOut);
        if (access == null) {
            return null;
        }
        String sName = this.getStringProperty("name", modelObj, dataOut);
        BaseObject accessObject = this.getRefProperty(PROP_REF, modelObj, false, BaseObject.class, dataOut);
        if (accessObject instanceof RelationalDimension) {
            if (parentObject instanceof FmCube) {
                return FmAccessRule.createAccessRule((FMMDSession)session, (FmCube)((FmCube)parentObject), (String)sName, (RelationalDimension)((RelationalDimension)accessObject), (Permission)access);
            }
            JSONUtils.addError(dataOut, "Expected parent type: Cube; actual parent type: " + parentObject.getClass().getName());
            return null;
        }
        if (accessObject instanceof QueryItem) {
            if (parentObject instanceof FmCube) {
                return FmAccessRule.createAccessRule((FMMDSession)session, (FmCube)((FmCube)parentObject), (String)sName, (QueryItem)((QueryItem)accessObject), (Permission)access);
            }
            JSONUtils.addError(dataOut, "Expected parent type: Cube; actual parent type: " + parentObject.getClass().getName());
            return null;
        }
        if (accessObject instanceof MeasureBase) {
            if (parentObject instanceof FmMeasureDimension) {
                return ((FmMeasureDimension)parentObject).createAccessRule(sName, (MeasureBase)accessObject, access);
            }
            JSONUtils.addError(dataOut, "Expected parent type: measure dimension; actual parent type: " + parentObject.getClass().getName());
            return null;
        }
        if (parentObject instanceof FmRelationalHierarchy) {
            AccessRule rule = ((FmRelationalHierarchy)parentObject).createAccessRule(sName);
            rule.setPermission(access);
            return rule;
        }
        JSONUtils.addError(dataOut, "Reffered object should be a relation dimension, query item or measure.");
        return null;
    }

    @Override
    protected void jsonToObject(Object object, JSONObject modelObj, String version, JSONObject dataOut) {
        AccessRule.MemberAccess memberAccess;
        super.jsonToObject(object, modelObj, version, dataOut);
        FmAccessRule accessRule = (FmAccessRule)object;
        String sName = this.getStringProperty("name", modelObj, false, dataOut);
        if (sName != null) {
            accessRule.setName(sName);
        }
        if ((memberAccess = this.getEnumProperty(PROP_MEMBER_ACCESS, modelObj, AccessRule.MemberAccess.class, false, dataOut)) != null) {
            accessRule.setMemberAccess(memberAccess);
        }
        if (accessRule.getRuleStyle() == AccessRule.RuleStyle.roleBased) {
            MDXExpressionBuilder expr = this.jsonToMDXExpression(accessRule.getSession(), PROP_EXPRESSION, modelObj, dataOut);
            if (expr != null) {
                accessRule.setExpression(expr);
            }
        } else if (accessRule.getRuleStyle() == AccessRule.RuleStyle.lookupTableBased) {
            ExpressionBuilder expr = this.jsonToExpression(accessRule.getSession(), PROP_EXPRESSION, modelObj, dataOut);
            if (expr != null) {
                accessRule.setFilterExpression(expr);
            }
        } else {
            JSONUtils.addError(dataOut, "Invalid rule style for security filter.");
        }
    }

    @Override
    protected void objectToJson(JSONObject result, Object object, String version, JSONObject dataOut) {
        super.objectToJson(result, object, version, dataOut);
        FmAccessRule accessRule = (FmAccessRule)object;
        this.addObjectToJson(result, "name", accessRule.getName());
        this.addObjectToJson(result, PROP_IS_ALL_ACCESS, accessRule.getAllAccess());
        this.addObjectToJson(result, PROP_PERMISSSION, accessRule.getPermission());
        this.addObjectToJson(result, PROP_MEMBER_ACCESS, accessRule.getMemberAccess());
        this.addObjectToJson(result, PROP_RULE_STYLE, accessRule.getRuleStyle());
        QueryItem refObject = accessRule.getQueryItem();
        if (refObject == null) {
            refObject = accessRule.getDimension();
        }
        if (refObject == null) {
            refObject = accessRule.getMeasure();
        }
        this.addRefToJson(result, PROP_REF, refObject);
        Expression expression = accessRule.getExpression();
        if (expression != null) {
            if (accessRule.getRuleStyle() == AccessRule.RuleStyle.roleBased) {
                JSONArray jsonExpression = this.mdxExpressionToJson(accessRule.getSession(), expression, dataOut);
                result.put((Object)PROP_EXPRESSION, (Object)jsonExpression);
            } else if (accessRule.getRuleStyle() == AccessRule.RuleStyle.lookupTableBased) {
                ExpressionBuilder builder = BuilderFactory.createExpressionBuilder((Expression)expression);
                JSONArray jsonExpresson = this.expressionToJson(builder, dataOut);
                result.put((Object)PROP_EXPRESSION, (Object)jsonExpresson);
            }
        }
    }
}

