/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmd.sdk.base.commands;

import com.ibm.cognos.fmd.sdk.base.commands.BaseObjectCommand;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmAccessView;
import com.ibm.cognos.fmeng.fmmd.model.AccessRule;
import com.ibm.cognos.fmeng.fmmd.model.AccessView;
import com.ibm.cognos.fmeng.fmmd.model.Cube;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityViewCommand
extends BaseObjectCommand {
    protected static final String PROP_FILTERS = "filters";

    @Override
    protected Class<?> expectedObjectType() {
        return FmAccessView.class;
    }

    @Override
    protected Object create(Object parentObject, JSONObject modelObj, JSONObject dataOut) {
        Cube parentCube = this.getTypedParent(parentObject, Cube.class, dataOut);
        if (parentCube == null) {
            return null;
        }
        String sName = this.getStringProperty("name", modelObj, dataOut);
        if (sName == null) {
            return null;
        }
        return parentCube.createAccessView(sName);
    }

    @Override
    protected void jsonToObject(Object object, JSONObject modelObj, String version, JSONObject dataOut) {
        List<AccessRule> newRules;
        super.jsonToObject(object, modelObj, version, dataOut);
        AccessView accessView = (AccessView)object;
        String sName = this.getStringProperty("name", modelObj, false, dataOut);
        if (sName != null) {
            accessView.setName(sName);
        }
        if ((newRules = this.jsonToList(PROP_FILTERS, modelObj, AccessRule.class, dataOut)) != null) {
            List oldRules = accessView.getAccessRules();
            ArrayList tmp = new ArrayList(oldRules);
            oldRules.removeAll(newRules);
            newRules.removeAll(tmp);
            for (AccessRule accessRule : oldRules) {
                accessView.removeAccessRule(accessRule);
            }
            for (AccessRule accessRule : newRules) {
                accessView.addAccessRule(accessRule);
            }
        }
    }

    @Override
    protected void objectToJson(JSONObject result, Object object, String version, JSONObject dataOut) {
        super.objectToJson(result, object, version, dataOut);
        AccessView accessView = (AccessView)object;
        this.addObjectToJson(result, "name", accessView.getName());
        this.addRefListToJson(result, PROP_FILTERS, accessView.getAccessRules());
    }
}

