/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmd.sdk.base.commands;

import com.ibm.cognos.fmd.sdk.base.commands.VirtualObjectCommand;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualHierarchy;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.json.java.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualHierarchyCommand
extends VirtualObjectCommand {
    protected static final String PROP_PARENT_CHILD = "parentChild";
    protected static final String PROP_RELATIVE_TIME_MEMBERS = "addRelativeTimeMembers";
    protected static final String PROP_LEVELS = "virtualLevels";
    protected static final String PROP_CLACULATED_MEMBERS = "calculatedMembers";

    @Override
    protected Class<?> expectedObjectType() {
        return FmVirtualHierarchy.class;
    }

    @Override
    protected Object create(Object parentObject, JSONObject modelObj, JSONObject dataOut) {
        FmVirtualDimension parent = this.getTypedParent(parentObject, FmVirtualDimension.class, dataOut);
        if (parent == null) {
            return null;
        }
        FMMDSession session = parent.getSession();
        Object sName = modelObj.get((Object)"name");
        String defaultName = this.getDefaultName(sName, session);
        return parent.createHierarchy(defaultName);
    }

    @Override
    protected void jsonToObject(Object object, JSONObject modelObj, String version, JSONObject dataOut) {
        Boolean hasRelativeTimeMembers;
        super.jsonToObject(object, modelObj, version, dataOut);
        FmVirtualHierarchy hierarchy = (FmVirtualHierarchy)object;
        Boolean isParentChild = this.getBooleanProperty(PROP_PARENT_CHILD, modelObj, null, false, dataOut);
        if (isParentChild != null) {
            hierarchy.setParentChild(isParentChild.booleanValue());
        }
        if ((hasRelativeTimeMembers = this.getBooleanProperty(PROP_RELATIVE_TIME_MEMBERS, modelObj, null, false, dataOut)) != null) {
            hierarchy.setHasRelativeTimeMembers(hasRelativeTimeMembers.booleanValue());
        }
    }

    @Override
    protected void objectToJson(JSONObject result, Object object, String version, JSONObject dataOut) {
        super.objectToJson(result, object, version, dataOut);
        FmVirtualHierarchy hierarchy = (FmVirtualHierarchy)object;
        this.addObjectToJson(result, PROP_PARENT_CHILD, hierarchy.getParentChild());
        this.addObjectToJson(result, PROP_RELATIVE_TIME_MEMBERS, hierarchy.getHasRelativeTimeMembers());
        this.addRefListToJson(result, PROP_LEVELS, hierarchy.getLevels());
        this.addRefListToJson(result, PROP_CLACULATED_MEMBERS, hierarchy.getCalculatedMembers());
    }
}

