/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmd.sdk.base.commands;

import com.ibm.cognos.fmd.sdk.base.JSONUtils;
import com.ibm.cognos.fmd.sdk.base.commands.VirtualObjectCommand;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualMeasure;
import com.ibm.cognos.fmeng.fmmd.impl.model.VirtualMeasureParentInternal;
import com.ibm.cognos.fmeng.fmmd.model.VirtualObject;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.json.java.JSONObject;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualMeasureCommand
extends VirtualObjectCommand {
    protected static final String PROP_VISIBLE = "visible";
    protected static final String PROP_MERGE_OPERATOR = "mergeOperator";
    protected static final String PROP_PRECEDENCE = "precedence";
    protected static final String PROP_DATA_FORMAT = "dataFormat";

    @Override
    protected Class<?> expectedObjectType() {
        return FmVirtualMeasure.class;
    }

    @Override
    protected Object create(Object parentObject, JSONObject modelObj, JSONObject dataOut) {
        VirtualMeasureParentInternal parent = this.getTypedParent(parentObject, VirtualMeasureParentInternal.class, dataOut);
        if (parent == null) {
            return null;
        }
        FMMDSession session = ((FmBaseObject)parent).getSession();
        Object sName = modelObj.get((Object)"name");
        String defaultName = this.getDefaultName(sName, session);
        return parent.createMeasure(defaultName);
    }

    @Override
    protected void jsonToObject(Object object, JSONObject modelObj, String version, JSONObject dataOut) {
        String dataFormat;
        String sPrecedence;
        VirtualObject.MergeOperator operator;
        super.jsonToObject(object, modelObj, version, dataOut);
        FmVirtualMeasure measure = (FmVirtualMeasure)object;
        Boolean isVisible = this.getBooleanProperty(PROP_VISIBLE, modelObj, null, false, dataOut);
        if (isVisible != null) {
            measure.setHidden(isVisible == false);
        }
        if ((operator = this.getEnumProperty(PROP_MERGE_OPERATOR, modelObj, VirtualObject.MergeOperator.class, false, dataOut)) != null) {
            measure.setMergeOperator(operator);
        }
        if ((sPrecedence = this.getStringProperty(PROP_PRECEDENCE, modelObj, false, dataOut)) != null) {
            try {
                BigInteger precedence = BigInteger.valueOf(Long.valueOf(sPrecedence));
                measure.setPrecedence(precedence);
            }
            catch (NumberFormatException e) {
                JSONUtils.addError(dataOut, e.getMessage());
            }
        }
        if ((dataFormat = this.getStringProperty(PROP_DATA_FORMAT, modelObj, false, dataOut)) != null) {
            measure.setFormat(dataFormat);
        }
    }

    @Override
    protected void objectToJson(JSONObject result, Object object, String version, JSONObject dataOut) {
        super.objectToJson(result, object, version, dataOut);
        FmVirtualMeasure measure = (FmVirtualMeasure)object;
        this.addObjectToJson(result, PROP_VISIBLE, !measure.getHidden());
        this.addObjectToJson(result, PROP_MERGE_OPERATOR, measure.getMergeOperator());
        this.addObjectToJson(result, PROP_PRECEDENCE, measure.getPrecedence());
        this.addObjectToJson(result, PROP_DATA_FORMAT, measure.getFormat());
    }
}

