/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmd.sdk.base.commands;

import com.ibm.cognos.fmd.sdk.base.JSONUtils;
import com.ibm.cognos.fmd.sdk.base.commands.BaseObjectCommand;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSourceObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualObject;
import com.ibm.cognos.fmeng.fmmd.model.LocalizedValue;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.model.SourceObject;
import com.ibm.cognos.fmeng.metadata.MdCube;
import com.ibm.cognos.fmeng.metadata.MdDimension;
import com.ibm.cognos.fmeng.metadata.MdMeasureDimension;
import com.ibm.cognos.fmeng.metadata.MdOLAPBase;
import com.ibm.json.java.JSONObject;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualSourceCommand
extends BaseObjectCommand {
    protected static final String PROP_SOURCE_PARENT = "sourceParent";
    protected static final String PROP_SOURCE_OBJECT = "sourceObject";
    protected static final String PROP_SOURCE_NAME = "sourceName";
    protected static final String PROP_SOURCE_PATH = "sourcePath";

    @Override
    protected Class<?> expectedObjectType() {
        return FmSourceObject.class;
    }

    @Override
    protected Object create(Object parentObject, JSONObject modelObj, JSONObject dataOut) {
        String sourcePath;
        FmVirtualObject parent = this.getTypedParent(parentObject, FmVirtualObject.class, dataOut);
        if (parent == null) {
            return null;
        }
        ReportObject sourceObject = this.getRefProperty(PROP_SOURCE_OBJECT, modelObj, false, ReportObject.class, dataOut);
        final String sourceName = this.getStringProperty(PROP_SOURCE_NAME, modelObj, false, dataOut);
        if (sourceObject == null && sourceName == null) {
            JSONUtils.addError(dataOut, "Either source object or the source name have to be specified.");
            return null;
        }
        SourceObject parentSource = this.getRefProperty(PROP_SOURCE_PARENT, modelObj, false, SourceObject.class, dataOut);
        if (sourceObject != null) {
            return parent.createSourceObject(parentSource, sourceObject);
        }
        if (parent instanceof FmVirtualCube && (sourcePath = this.getStringProperty(PROP_SOURCE_PATH, modelObj, false, dataOut)) != null) {
            MdCube pseudoObject = new MdCube(){

                public List<MdOLAPBase> getChildObjects() {
                    return null;
                }

                public String getName() {
                    return sourceName;
                }

                public String getName(String arg0) {
                    return null;
                }

                public List<LocalizedValue> getNames() {
                    return null;
                }

                public String getCMPath() {
                    return sourcePath;
                }

                public String getDefaultLocale() {
                    return null;
                }

                public List<MdDimension> getDimensions() {
                    return null;
                }

                public MdMeasureDimension getMeasureDimension() {
                    return null;
                }
            };
            return ((FmVirtualCube)parent).createSourceCube(pseudoObject);
        }
        MdOLAPBase pseudoObject = new MdOLAPBase(){

            public List<MdOLAPBase> getChildObjects() {
                return null;
            }

            public String getName() {
                return sourceName;
            }

            public String getName(String arg0) {
                return null;
            }

            public List<LocalizedValue> getNames() {
                return null;
            }
        };
        return parent.createSourceObject(parentSource, pseudoObject);
    }

    @Override
    protected void jsonToObject(Object object, JSONObject modelObj, String version, JSONObject dataOut) {
        super.jsonToObject(object, modelObj, version, dataOut);
        FmSourceObject sourceObject = (FmSourceObject)object;
        String sName = this.getStringProperty("name", modelObj, false, dataOut);
        if (sName != null) {
            sourceObject.setName(sName);
        }
    }

    @Override
    protected void objectToJson(JSONObject result, Object object, String version, JSONObject dataOut) {
        super.objectToJson(result, object, version, dataOut);
        FmSourceObject sourceObject = (FmSourceObject)object;
        this.addObjectToJson(result, "name", sourceObject.getName());
        this.addRefToJson(result, PROP_SOURCE_PARENT, sourceObject.getSourceParent());
        this.addRefToJson(result, PROP_SOURCE_OBJECT, sourceObject.getModelSource());
        this.addObjectToJson(result, PROP_SOURCE_NAME, sourceObject.getSourceName());
        this.addObjectToJson(result, PROP_SOURCE_PATH, sourceObject.getSourcePath());
    }
}

