/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmd.sdk.commands.rest;

import com.cognos.ccs.service.command.ACommand;
import com.cognos.ccs.transports.XMLTransport;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.fmd.sdk.base.CommandProcessor;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.http.HttpServletRequestWrapper;
import org.dom4j.Element;

public class RESTCommand
extends ACommand {
    protected static final String TEXT_REQUEST = "com.ibm.cognos.fmd.sdk.request.text";
    protected static final String TEXT_RETURN = "com.ibm.cognos.fmd.sdk.result.text";

    public void performRestAction(BIBusEnvelope bi, MessageContext context, String sourceId) {
        int result = 0;
        JSONObject dataOut = new JSONObject();
        Exception exception = null;
        try {
            try {
                String requestPath = (String)context.getProperty("path_info");
                String requestMethod = this.getHTTPMethod(context);
                JSONObject modelObj = this.getJsonRequest(context);
                result = CommandProcessor.process((String)requestPath, (String)requestMethod, (JSONObject)modelObj, (JSONObject)dataOut);
            }
            catch (Exception e) {
                String tmp;
                exception = e;
                if (result != 0) {
                    context.setProperty("response.status_code", (Object)Integer.toString(result));
                }
                if (exception != null) {
                    JSONArray jsonErrors = (JSONArray)dataOut.get((Object)"errors");
                    if (jsonErrors == null) {
                        jsonErrors = new JSONArray(1);
                        dataOut.put((Object)"errors", (Object)jsonErrors);
                    }
                    jsonErrors.add((Object)exception.getMessage());
                }
                XMLTransport trans = (XMLTransport)this.m_session.getTransport();
                String textResult = (String)dataOut.get((Object)TEXT_RETURN);
                if (textResult == null) {
                    try {
                        tmp = dataOut.serialize();
                    }
                    catch (IOException e2) {
                        tmp = e2.getMessage();
                    }
                    trans.setContentType("application/json; charset=utf-8");
                } else {
                    trans.setContentType("text/xml; charset=utf-8");
                    tmp = textResult;
                }
                this.m_session.setResponseAsString(tmp);
            }
        }
        finally {
            String tmp;
            if (result != 0) {
                context.setProperty("response.status_code", (Object)Integer.toString(result));
            }
            if (exception != null) {
                JSONArray jsonErrors = (JSONArray)dataOut.get((Object)"errors");
                if (jsonErrors == null) {
                    jsonErrors = new JSONArray(1);
                    dataOut.put((Object)"errors", (Object)jsonErrors);
                }
                jsonErrors.add((Object)exception.getMessage());
            }
            XMLTransport trans = (XMLTransport)this.m_session.getTransport();
            String textResult = (String)dataOut.get((Object)TEXT_RETURN);
            if (textResult == null) {
                try {
                    tmp = dataOut.serialize();
                }
                catch (IOException e) {
                    tmp = e.getMessage();
                }
                trans.setContentType("application/json; charset=utf-8");
            } else {
                trans.setContentType("text/xml; charset=utf-8");
                tmp = textResult;
            }
            this.m_session.setResponseAsString(tmp);
        }
    }

    protected String getHTTPMethod(MessageContext context) {
        HttpServletRequestWrapper request;
        String methodOverride;
        String requestMethod = (String)context.getProperty("request.method");
        if ("POST".equalsIgnoreCase(requestMethod) && (methodOverride = (request = (HttpServletRequestWrapper)context.getProperty("http_servlet_request")).getHeader("X-HTTP-Method-Override")) != null) {
            return methodOverride;
        }
        return requestMethod;
    }

    protected JSONObject getJsonRequest(MessageContext context) throws IOException {
        String inputStr;
        InputStream in = (InputStream)context.getProperty("request.body");
        if (in == null) {
            return null;
        }
        BufferedReader streamReader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        StringBuilder responseStrBuilder = new StringBuilder();
        while ((inputStr = streamReader.readLine()) != null) {
            responseStrBuilder.append(inputStr);
        }
        String args = responseStrBuilder.toString();
        if (args.isEmpty()) {
            return null;
        }
        try {
            return JSONObject.parse((String)args);
        }
        catch (IOException iOException) {
            JSONObject input = new JSONObject();
            input.put((Object)TEXT_REQUEST, (Object)args);
            return input;
        }
    }

    public void performSoapAction(Element arg0, MessageContext arg1) {
    }
}

