/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmd.sdk.util;

import com.cognos.ccl4j.resource.CCLResourceManager;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class FmSdkMessage {
    public static final String FMSDK_BUNDLE_NAME = "fmdsdk";
    private String mBundleName = "fmdsdk";
    private String mMsgKey;
    private Object[] mMsgParams = null;

    public FmSdkMessage(String msgKey) {
        this.mMsgKey = msgKey;
        this.mMsgParams = null;
    }

    public FmSdkMessage(String msgKey, String ... msgParams) {
        this.mMsgKey = msgKey;
        this.mMsgParams = msgParams;
    }

    public FmSdkMessage(String msgKey, Object[] msgParams) {
        this.mMsgKey = msgKey;
        this.mMsgParams = msgParams;
    }

    public String getBundleName() {
        return this.mBundleName;
    }

    public static String render(String key, Locale locale) {
        FmSdkMessage msg = new FmSdkMessage(key);
        return msg.render(locale);
    }

    public static String render(String key, String locale) {
        FmSdkMessage msg = new FmSdkMessage(key);
        return msg.render(locale);
    }

    public static String render(String key, String locale, String ... args) {
        FmSdkMessage msg = new FmSdkMessage(key, args);
        return msg.render(locale);
    }

    public static String render(String key, Locale locale, String ... args) {
        FmSdkMessage msg = new FmSdkMessage(key, args);
        return msg.render(locale);
    }

    public String render(String crnLocale) {
        Locale aLocale = CCLResourceManager.getLocale((String)crnLocale);
        ResourceBundle resBundle = ResourceBundle.getBundle(this.mBundleName, aLocale);
        return this.render(resBundle, aLocale);
    }

    public String render(Locale locale) {
        ResourceBundle resBundle = ResourceBundle.getBundle(this.mBundleName, locale);
        return this.render(resBundle, locale);
    }

    String render(ResourceBundle resBundle, Locale aLocale) {
        String localizedMessage = null;
        try {
            localizedMessage = resBundle.getString(this.mMsgKey);
        }
        catch (MissingResourceException mre) {
            return mre.getMessage();
        }
        if (this.mMsgParams != null && this.mMsgParams.length > 0) {
            MessageFormat aFormatter = new MessageFormat(localizedMessage, aLocale);
            localizedMessage = aFormatter.format(this.mMsgParams, new StringBuffer(), (FieldPosition)null).toString();
        }
        return localizedMessage;
    }

    public boolean verifyKey(String key) {
        return this.mMsgKey.equals(key);
    }

    public String getKey() {
        return this.mMsgKey;
    }
}

