/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.action.helpers;

import com.ibm.cognos.fmeng.action.helpers.FMUpdateRequestParamValue;
import com.ibm.cognos.fmeng.action.helpers.FMUpdateRequestTaskHelper;
import com.ibm.cognos.fmeng.fmmd.helpers.HelperBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public class FMUpdateResponseTaskHelper
extends HelperBase {
    public static final int kStatUnknown = 0;
    public static final int kStatSuccess = 1;
    public static final int kStatFailure = 2;
    public static final int kParamUnknown = 0;
    public static final int kParamProperty = 1;
    public static final int kParamObject = 2;
    public static final String sUnknown = "Unknown";
    public static final String sSuccess = "success";
    public static final String sFailure = "failure";
    public static final String sStatus = "status";
    public static final String sCode = "code";
    int m_eTask;
    int m_eStatus;
    Element m_elmResponse;
    Element m_elmFeedback;
    private Map<Integer, List<FMUpdateRequestParamValue>> m_parameters;
    ErrorInfo m_ErrorInfo;

    public static String statusToString(int eStatus) {
        switch (eStatus) {
            case 1: {
                return sSuccess;
            }
            case 2: {
                return sFailure;
            }
        }
        return sUnknown;
    }

    public static int ToStatus(String sStatusName) {
        int eStatus = 0;
        if (sStatusName.equals(sSuccess)) {
            eStatus = 1;
        } else if (sStatusName.equals(sFailure)) {
            eStatus = 2;
        }
        return eStatus;
    }

    public static String paramToString(int eParam) {
        switch (eParam) {
            case 1: {
                return "property";
            }
            case 2: {
                return "object";
            }
        }
        return "object";
    }

    public static int ToParameter(String sParamName) {
        int eParam = 0;
        if (sParamName.equals("property")) {
            eParam = 1;
        } else if (sParamName.equals("object")) {
            eParam = 2;
        }
        return eParam;
    }

    public FMUpdateResponseTaskHelper(int eTask, int eStatus) {
        this.m_eTask = eTask;
        this.m_eStatus = eStatus;
        this.m_ErrorInfo = null;
        this.m_parameters = new HashMap<Integer, List<FMUpdateRequestParamValue>>();
    }

    public int GetTask() {
        return this.m_eTask;
    }

    public int GetStatus() {
        return this.m_eStatus;
    }

    public void SetStatus(int eStatus) {
        this.m_eStatus = eStatus;
    }

    public void AddParameter(int eParam, String paramValue) {
        List<FMUpdateRequestParamValue> paramValues = this.m_parameters.get(new Integer(eParam));
        if (paramValues == null) {
            paramValues = new ArrayList<FMUpdateRequestParamValue>();
            this.m_parameters.put(new Integer(eParam), paramValues);
        }
        paramValues.add(new FMUpdateRequestParamValue(paramValue, null));
    }

    public ErrorInfo GetError() {
        List listErrors;
        if (!this.m_elmResponse.equals(null) && this.m_ErrorInfo.equals(null) && (listErrors = this.m_elmResponse.selectNodes(".//error")).size() > 0) {
            Element elmTemp = (Element)listErrors.get(0);
            String errorMsg = elmTemp.getText();
            this.SetError(elmTemp.attributeValue(sCode), errorMsg);
        }
        return this.m_ErrorInfo;
    }

    public void SetError(String sErrorCode, String sErrorMsg) {
        if (!this.m_ErrorInfo.equals(null)) {
            this.m_ErrorInfo.s_code = sErrorCode;
            this.m_ErrorInfo.s_msg = sErrorMsg;
        } else {
            this.m_ErrorInfo = new ErrorInfo(sErrorCode, sErrorMsg);
        }
    }

    public Element GetFeedback() {
        return this.m_elmFeedback;
    }

    public void doMake(Element tasksElm) {
        Element elmTask = tasksElm.addElement("task");
        elmTask.addAttribute("name", FMUpdateRequestTaskHelper.taskToString(this.m_eTask));
        elmTask.addAttribute(sStatus, FMUpdateResponseTaskHelper.statusToString(this.m_eStatus));
        for (Integer key : this.m_parameters.keySet()) {
            List<FMUpdateRequestParamValue> lValues = this.m_parameters.get(key);
            Iterator<FMUpdateRequestParamValue> listValuesItr = lValues.iterator();
            while (listValuesItr.hasNext()) {
                Element elmParam = elmTask.addElement("param");
                elmParam.addAttribute("name", FMUpdateResponseTaskHelper.paramToString(key));
                elmParam.addAttribute("value", listValuesItr.next().s_sValue);
            }
        }
        if (this.m_ErrorInfo != null) {
            Element elmError = elmTask.addElement("error");
            elmError.addAttribute(sCode, this.m_ErrorInfo.s_code);
            elmError.addText(this.m_ErrorInfo.s_msg);
        }
        if (this.m_elmFeedback != null) {
            Element nodeTemp = (Element)this.m_elmFeedback.clone();
            elmTask.add(nodeTemp);
        }
    }

    public void doTake(Element elmResponse) {
        this.m_elmResponse = elmResponse;
        List listFeedbacks = this.m_elmResponse.selectNodes(".//feedback");
        if (listFeedbacks.size() > 0) {
            this.m_elmFeedback = (Element)listFeedbacks.get(0);
        }
    }

    public class ErrorInfo {
        String s_code;
        String s_msg;

        ErrorInfo(String sCode, String sMsg) {
            this.s_code = sCode;
            this.s_msg = sMsg;
        }
    }
}

