/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.action.objmodifier.impl;

import com.ibm.cognos.fmeng.action.helpers.FMUpdateRequestParamValue;
import com.ibm.cognos.fmeng.action.helpers.FMUpdateRequestTaskHelper;
import com.ibm.cognos.fmeng.action.objmodifier.impl.ObjectModifier;
import com.ibm.cognos.fmeng.action.objmodifier.impl.ReportObjectModifier;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmEMDObjectNaming;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSection;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmShortcut;
import com.ibm.cognos.fmeng.fmmd.impl.task.FmDimensionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.BasedOn;
import com.ibm.cognos.fmeng.fmmd.model.QuerySetOperation;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubjectRef;
import com.ibm.cognos.fmeng.fmmd.util.LocaleBasedValue;
import com.ibm.cognos.fmeng.fmmd.util.ObjectHelper;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SectionModifier
extends ReportObjectModifier {
    protected SectionModifier(FMMDSession session, FmBaseObject FMObject) {
        super(session, FMObject);
    }

    private FmSection getFmSection() {
        return (FmSection)this.m_FMObject;
    }

    @Override
    public boolean setImmediateProperty(String propertyName, Object propertyValue) {
        super.setImmediateProperty(propertyName, propertyValue);
        return false;
    }

    @Override
    protected FmBaseObject doAddObject(String objectType, List<FMUpdateRequestParamValue> vBasedOns, List<LocaleBasedValue> vLocalizedNames, FmEMDObjectNaming eMakeUnique, FmBaseObject objInsertBefore) {
        FmBaseObject hNewObj = null;
        Object_Type type = Object_Type.valueOf(objectType);
        switch (type) {
            case dimension: {
                hNewObj = this.addDimension(vBasedOns, vLocalizedNames, eMakeUnique, objInsertBefore);
                break;
            }
            case querySubject: {
                hNewObj = this.addQuerySubject(vBasedOns, vLocalizedNames, eMakeUnique, objInsertBefore);
                break;
            }
            default: {
                Object[] msgParams = new Object[]{FMUpdateRequestTaskHelper.taskToString(5), FMUpdateRequestTaskHelper.paramToString(8)};
                throw new FmMDException("BMT_MD_UPDATE_ACTION_MISSING_PARAM", msgParams);
            }
        }
        return hNewObj;
    }

    protected FmBaseObject addDimension(List<FMUpdateRequestParamValue> vBasedOns, List<LocaleBasedValue> vLocalisedNames, FmEMDObjectNaming makeUnique, FmBaseObject objInsertBefore) {
        FmBaseObject hNewDimension = null;
        FMUpdateRequestParamValue pSubType = this.getCurrentRequestTask().getParameterValue(17);
        FmMDException.ASSERT(pSubType != null, "Non null parameter expected");
        boolean isMeasure = pSubType.s_sValue.equals("measure");
        String name = null;
        if (vLocalisedNames != null && vLocalisedNames.size() > 0) {
            name = vLocalisedNames.get((int)0).s_Value;
        }
        List<BasedOn> FmBasedOns = null;
        if (vBasedOns != null && !vBasedOns.isEmpty()) {
            FmBasedOns = this.convertToBasedOnTypes(vBasedOns);
        }
        if (vBasedOns != null && !vBasedOns.isEmpty()) {
            FmDimensionBuilder builder = new FmDimensionBuilder(this.m_session);
            hNewDimension = isMeasure ? (FmBaseObject)((Object)builder.populateMeasureDimensionFrom(this.getFmSection(), FmBasedOns, name)) : (FmBaseObject)((Object)builder.populateRegularDimensionFrom(this.getFmSection(), FmBasedOns, name));
        } else {
            hNewDimension = isMeasure ? (FmBaseObject)((Object)this.getFmSection().createMeasureDimension(name)) : (FmBaseObject)((Object)this.getFmSection().createRegularDimension(name));
        }
        if (hNewDimension != null && objInsertBefore != null) {
            this.getFmSection().reorderBefore(hNewDimension, (BaseObject)objInsertBefore);
        }
        return hNewDimension;
    }

    protected FmBaseObject addQuerySubject(List<FMUpdateRequestParamValue> vBasedOns, List<LocaleBasedValue> vLocalizedNames, FmEMDObjectNaming eMakeUnique, FmBaseObject objInsertBefore) {
        FMUpdateRequestParamValue pDefinitionType = this.getCurrentRequestTask().getParameterValue(16);
        QuerySubjectBase.EDefinitionType eDefType = QuerySubjectBase.EDefinitionType.kTypeUnknown;
        if (pDefinitionType != null) {
            eDefType = SectionModifier.ToDefinitionType(pDefinitionType.s_sValue);
        }
        FmQuerySubject hNewQS = null;
        FmBaseObject eBasedOnItem = null;
        ArrayList<QuerySubjectRef> basedOns = new ArrayList<QuerySubjectRef>();
        if (vBasedOns != null) {
            for (FMUpdateRequestParamValue parm : vBasedOns) {
                FmBaseObject fmBaseObject = eBasedOnItem = parm == null || parm.s_elmValue == null ? null : ObjectModifier.GetBasedOnItem(this.m_session, parm.s_elmValue);
                if (eBasedOnItem instanceof FmQuerySubject) {
                    basedOns.add(new QuerySubjectRef((FmQuerySubject)eBasedOnItem));
                    continue;
                }
                if (eBasedOnItem instanceof FmShortcut) {
                    basedOns.add(new QuerySubjectRef((FmShortcut)eBasedOnItem));
                    continue;
                }
                throw new FmMDException("BMT_MD_SOURCE_QS_FOR_QSET_INCOMPATIBLE_ERROR");
            }
        }
        ArrayList<LocaleBasedValue> vBasedOnNames = null;
        if (eBasedOnItem != null && vLocalizedNames.isEmpty()) {
            vBasedOnNames = ObjectHelper.getBasedOnNames(this.m_session, eBasedOnItem);
        }
        if (eDefType == QuerySubjectBase.EDefinitionType.kTypeModelSetQuery) {
            FMUpdateRequestParamValue setOp = this.getCurrentRequestTask().getParameterValue(25);
            FMUpdateRequestParamValue dup = this.getCurrentRequestTask().getParameterValue(26);
            hNewQS = (FmQuerySubject)this.getFmSection().createModelSetQuery(vLocalizedNames.isEmpty() ? vBasedOnNames.get((int)0).s_Value : vLocalizedNames.get((int)0).s_Value, (QuerySubjectRef)basedOns.get(0), (QuerySubjectRef)basedOns.get(1), QuerySetOperation.ESetOperation.valueOf(setOp.s_sValue), QuerySetOperation.EDuplicates.valueOf(dup.s_sValue));
        } else if (eDefType == QuerySubjectBase.EDefinitionType.kTypeModelQuery) {
            FmMDException.ASSERT(basedOns == null || basedOns.size() == 0, "Did not expect any based on");
            hNewQS = (FmQuerySubject)this.getFmSection().createModelQuerySubject(vLocalizedNames.isEmpty() ? vBasedOnNames.get((int)0).s_Value : vLocalizedNames.get((int)0).s_Value);
        }
        this.getFmSection().reorderBefore(hNewQS, (BaseObject)objInsertBefore);
        return hNewQS;
    }

    private static QuerySubjectBase.EDefinitionType ToDefinitionType(String sDefinitionType) {
        QuerySubjectBase.EDefinitionType eType = QuerySubjectBase.EDefinitionType.kTypeUnknown;
        if (sDefinitionType.equals("dbQuery")) {
            eType = QuerySubjectBase.EDefinitionType.kTypeDatabaseQuery;
        } else if (sDefinitionType.equals("modelQuery")) {
            eType = QuerySubjectBase.EDefinitionType.kTypeModelQuery;
        } else if (sDefinitionType.equals("mdQuery")) {
            eType = QuerySubjectBase.EDefinitionType.kTypeMultiDimensionalQuery;
        } else if (sDefinitionType.equals("storedProcedure")) {
            eType = QuerySubjectBase.EDefinitionType.kTypeStoredProcedureQuery;
        } else if (sDefinitionType.equals("queryOperation")) {
            eType = QuerySubjectBase.EDefinitionType.kTypeModelSetQuery;
        }
        return eType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Object_Type {
        querySubject,
        dimension;

    }
}

