/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.action.objmodifier.impl;

import com.ibm.cognos.fmeng.action.helpers.FMUpdateObjectRequestHelper;
import com.ibm.cognos.fmeng.action.helpers.FMUpdateObjectResponseHelper;
import com.ibm.cognos.fmeng.action.helpers.FMUpdateRequestParamValue;
import com.ibm.cognos.fmeng.action.helpers.FMUpdateRequestTaskHelper;
import com.ibm.cognos.fmeng.action.helpers.FMUpdateResponseTaskHelper;
import com.ibm.cognos.fmeng.action.objmodifier.impl.ObjectModifier;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmComplexProperty;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmEMDObjectNaming;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmExpression;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRefobjViaShortcut;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.task.FmDeleteManager;
import com.ibm.cognos.fmeng.fmmd.impl.task.PreviewRemoveListener;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.BasedOn;
import com.ibm.cognos.fmeng.fmmd.model.BuilderFactory;
import com.ibm.cognos.fmeng.fmmd.model.NamedObject;
import com.ibm.cognos.fmeng.fmmd.util.FmExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.util.LocaleBasedValue;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UpdateObjectMixin {
    private FMUpdateObjectRequestHelper m_hlprRequest = new FMUpdateObjectRequestHelper();
    private FMUpdateObjectResponseHelper m_hlprResponse = new FMUpdateObjectResponseHelper();
    protected FMUpdateRequestTaskHelper m_pCurrRequestTask;
    private FMUpdateResponseTaskHelper m_pCurrResponseTask;
    private String m_actionContext;
    boolean m_isVerify = false;
    protected FMMDSession m_session;
    protected FmBaseObject m_FMObject;

    public final Element doUpdate(Element elmRequest, boolean isVerify) {
        this.m_isVerify = isVerify;
        return this.doUpdateImpl(elmRequest);
    }

    private Element doUpdateImpl(Element elmRequest) {
        Element elmResponse = null;
        this.m_hlprRequest.take(elmRequest);
        List<FMUpdateRequestTaskHelper> vTasks = this.m_hlprRequest.GetTasks();
        Iterator<FMUpdateRequestTaskHelper> iterator = vTasks.iterator();
        while (iterator.hasNext()) {
            FMUpdateRequestTaskHelper task;
            this.m_pCurrRequestTask = task = iterator.next();
            this.m_pCurrResponseTask = this.m_hlprResponse.AddTask(this.m_pCurrRequestTask.GetTask());
            this.handleUpdateTask();
            this.m_pCurrResponseTask.SetStatus(1);
            elmResponse = this.m_hlprResponse.make();
        }
        return elmResponse;
    }

    protected boolean doUpdateProperty(String sPropType, FMUpdateRequestParamValue propValue) {
        Object[] msgParams = new Object[]{"Update Object", ((FmReportObject)this.m_FMObject).getName(this.m_session.getActiveLocale().getCountry())};
        throw new FmMDException("BMT_MD_ERROR_ACTION_NOT_SUPPORTED", msgParams);
    }

    protected String doAddProperty(String propType, FMUpdateRequestParamValue propValue, FMUpdateRequestParamValue propInsertBefore) {
        Object[] msgParams = new Object[]{"Update Object", ((NamedObject)((Object)this.m_FMObject)).getName()};
        throw new FmMDException("BMT_MD_ERROR_ACTION_NOT_SUPPORTED", msgParams);
    }

    protected abstract boolean doRemoveProperty(String var1, FMUpdateRequestParamValue var2);

    protected abstract boolean doReorderProperty(String var1, FMUpdateRequestParamValue var2, FMUpdateRequestParamValue var3);

    protected FmBaseObject doAddObject(String objectType, List<FMUpdateRequestParamValue> vBasedOns, List<LocaleBasedValue> vLocalizedNames, FmEMDObjectNaming eMakeUnique, FmBaseObject addBefore) {
        Object[] msgParams = new Object[]{"Update Object", ((FmReportObject)this.m_FMObject).getLocalizedType()};
        throw new FmMDException("BMT_MD_ERROR_ACTION_NOT_SUPPORTED", msgParams);
    }

    protected void doRemoveObject(String objectType, List<FmBaseObject> hRemoveObjects) {
        FmDeleteManager del = new FmDeleteManager(this.m_session, hRemoveObjects);
        if (this.isVerify()) {
            PreviewRemoveListener rl = new PreviewRemoveListener(this.m_session);
            del.removeObjects(rl);
            rl.throwIfMessagesPresent();
        } else {
            del.removeObjects();
        }
    }

    protected FmComplexProperty mapUpdateProperty(String propType, FMUpdateRequestParamValue pIndex) {
        Object[] msgParams = new Object[]{FMUpdateRequestTaskHelper.taskToString(this.m_pCurrRequestTask.GetTask()), FMUpdateRequestTaskHelper.paramToString(1)};
        throw new FmMDException("BMT_MD_INVALID_PARAMETER", msgParams);
    }

    protected void UpdateObjectStatus() {
    }

    protected FMUpdateRequestTaskHelper getCurrentRequestTask() {
        return this.m_pCurrRequestTask;
    }

    protected FMUpdateResponseTaskHelper getCurrentResponseTask() {
        return this.m_pCurrResponseTask;
    }

    protected boolean isVerify() {
        return this.m_isVerify;
    }

    public String getActionContext() {
        return this.m_actionContext;
    }

    public void setActionContext(String elmContext) {
        this.m_actionContext = elmContext;
    }

    private void handleUpdateTask() {
        switch (this.m_pCurrRequestTask.GetTask()) {
            case 3: {
                this.handleUpdateProperty();
                break;
            }
            case 1: {
                this.handleAddProperty();
                break;
            }
            case 2: {
                this.handleRemoveProperty();
                break;
            }
            case 4: {
                this.handleReorderProperty();
                break;
            }
            case 5: {
                this.handleAddObject();
                break;
            }
            case 6: {
                this.handleRemoveObject();
                break;
            }
            default: {
                Object[] msgParams = new Object[2];
                msgParams[0] = FMUpdateRequestTaskHelper.taskToString(this.m_pCurrRequestTask.GetTask());
                String localeKey = FmModelFactory.getInstance().getProject(this.m_session).getDefaultLocale();
                msgParams[1] = ((FmReportObject)this.m_FMObject).getName(localeKey);
                throw new FmMDException("BMT_MD_UPDATE_ACTION_INVALID_TASK", msgParams);
            }
        }
        this.UpdateObjectStatus();
    }

    private void handleUpdateProperty() {
        FMUpdateRequestParamValue pPropType = this.m_pCurrRequestTask.getParameterValue(1);
        if (pPropType == null) {
            Object[] msgParams = new Object[]{FMUpdateRequestTaskHelper.taskToString(3), FMUpdateRequestTaskHelper.paramToString(1)};
            throw new FmMDException("BMT_MD_UPDATE_ACTION_MISSING_PARAM", msgParams);
        }
        FmMDException.ASSERT(!pPropType.s_sValue.equals(""), "Expects a string value in the parameter value");
        FMUpdateRequestParamValue pPropValue = this.m_pCurrRequestTask.getParameterValue(2);
        boolean sucesss = this.doUpdateProperty(pPropType.s_sValue, pPropValue);
        if (!sucesss) {
            return;
        }
        String idProperty = String.valueOf(this.m_FMObject.getID()) + "/" + pPropType.s_sValue;
        this.m_pCurrResponseTask.AddParameter(1, idProperty);
    }

    private void handleAddProperty() {
        FMUpdateRequestParamValue pPropType = this.m_pCurrRequestTask.getParameterValue(1);
        if (pPropType == null) {
            Object[] msgParams = new Object[]{FMUpdateRequestTaskHelper.taskToString(1), FMUpdateRequestTaskHelper.paramToString(1)};
            throw new FmMDException("BMT_MD_UPDATE_ACTION_MISSING_PARAM", msgParams);
        }
        FmMDException.ASSERT(!pPropType.s_sValue.equals(""), "Expects a string value in the parameter value");
        FMUpdateRequestParamValue pPropValue = this.m_pCurrRequestTask.getParameterValue(2);
        FMUpdateRequestParamValue pPropBefore = this.m_pCurrRequestTask.getParameterValue(6);
        String idProperty = this.doAddProperty(pPropType.s_sValue, pPropValue, pPropBefore);
        if (idProperty.equals("")) {
            idProperty = String.valueOf(this.m_FMObject.getID()) + "/" + pPropType.s_sValue;
        } else if (idProperty == null) {
            Object[] msgParams = new Object[]{FMUpdateRequestTaskHelper.taskToString(1), FMUpdateRequestTaskHelper.paramToString(1)};
            throw new FmMDException("BMT_MD_UPDATE_ACTION_MISSING_PARAM", msgParams);
        }
        this.m_pCurrResponseTask.AddParameter(1, idProperty);
    }

    private void handleRemoveProperty() {
        FMUpdateRequestParamValue pPropType = this.m_pCurrRequestTask.getParameterValue(1);
        if (pPropType == null) {
            Object[] msgParams = new Object[]{FMUpdateRequestTaskHelper.taskToString(2), FMUpdateRequestTaskHelper.paramToString(1)};
            throw new FmMDException("BMT_MD_UPDATE_ACTION_MISSING_PARAM", msgParams);
        }
        FmMDException.ASSERT(!pPropType.s_sValue.equals(""), "Expects a string value in the parameter value");
        List<FMUpdateRequestParamValue> vPropIndxs = this.m_pCurrRequestTask.getParameter(5);
        boolean removed = false;
        if (vPropIndxs != null && vPropIndxs.size() > 0) {
            for (FMUpdateRequestParamValue param : vPropIndxs) {
                if (!this.doRemoveProperty(pPropType.s_sValue, param)) continue;
                removed = true;
            }
        } else if (this.doRemoveProperty(pPropType.s_sValue, null)) {
            removed = true;
        }
        if (removed) {
            this.m_pCurrResponseTask.AddParameter(2, this.m_FMObject.getID());
        }
    }

    private void handleReorderProperty() {
        FMUpdateRequestParamValue pPropType = this.m_pCurrRequestTask.getParameterValue(1);
        if (pPropType == null) {
            Object[] msgParams = new Object[]{FMUpdateRequestTaskHelper.taskToString(4), FMUpdateRequestTaskHelper.paramToString(1)};
            throw new FmMDException("BMT_MD_UPDATE_ACTION_MISSING_PARAM", msgParams);
        }
        FmMDException.ASSERT(!pPropType.s_sValue.equals(""), "Expects a string value in the parameter value");
        List<FMUpdateRequestParamValue> vPropIndxs = this.m_pCurrRequestTask.getParameter(5);
        FMUpdateRequestParamValue pPropBeforeIndx = this.m_pCurrRequestTask.getParameterValue(6);
        for (FMUpdateRequestParamValue param : vPropIndxs) {
            this.doReorderProperty(pPropType.s_sValue, param, pPropBeforeIndx);
        }
        String idProperty = String.valueOf(this.m_FMObject.getID()) + pPropType.s_sValue;
        this.m_pCurrResponseTask.AddParameter(2, idProperty);
    }

    private void handleAddObject() {
        FmBaseObject newObj;
        FMUpdateRequestParamValue pObjType = this.m_pCurrRequestTask.getParameterValue(8);
        if (pObjType == null) {
            Object[] msgParams = new Object[]{FMUpdateRequestTaskHelper.taskToString(5), FMUpdateRequestTaskHelper.paramToString(1)};
            throw new FmMDException("BMT_MD_UPDATE_ACTION_MISSING_PARAM", msgParams);
        }
        FmMDException.ASSERT(!pObjType.s_sValue.equals(""), "Expects a string value in the parameter value");
        List<FMUpdateRequestParamValue> vBasedOns = this.m_pCurrRequestTask.getParameter(12);
        ArrayList vNames = (ArrayList)this.m_pCurrRequestTask.getParameter(7);
        if (vNames != null && vNames.size() > 1) {
            FmMDException.ASSERT(false, "Did not expect localized names for action");
        }
        if (vNames == null && vBasedOns.isEmpty()) {
            Object[] msgParams = new Object[]{FMUpdateRequestTaskHelper.taskToString(5), FMUpdateRequestTaskHelper.paramToString(1)};
            throw new FmMDException("BMT_MD_UPDATE_ACTION_MISSING_PARAM", msgParams);
        }
        ArrayList<LocaleBasedValue> localizedNames = new ArrayList<LocaleBasedValue>();
        if (vNames != null) {
            for (FMUpdateRequestParamValue pValue : vNames) {
                if (pValue.s_sValue == null || pValue.s_sValue.equals("")) continue;
                String sLocale = pValue.s_locale;
                if (sLocale != null && sLocale.equals("")) {
                    sLocale = this.m_session.getActiveLocale().getCountry();
                }
                localizedNames.add(new LocaleBasedValue(sLocale, pValue.s_sValue));
            }
        }
        FmEMDObjectNaming eMakeUnique = FmEMDObjectNaming.kMakeUnique;
        FMUpdateRequestParamValue pTmpValue = this.m_pCurrRequestTask.getParameterValue(9);
        if (pTmpValue == null || pTmpValue.s_sValue.equals("false")) {
            // empty if block
        }
        eMakeUnique = FmEMDObjectNaming.kDoNotMakeUnique;
        FMUpdateRequestParamValue pBeforeID = this.m_pCurrRequestTask.getParameterValue(11);
        FmBaseObject eAddBefore = null;
        if (pBeforeID != null) {
            FmMDException.ASSERT(!pBeforeID.s_sValue.equals(""), "Expects a string value in the parameter value");
            eAddBefore = (FmBaseObject)((Object)FmModelFactory.getInstance().get(this.m_session, ((EMFSession)this.m_session).getObjectById(pBeforeID.s_sValue)));
        }
        if ((newObj = this.doAddObject(pObjType.s_sValue, vBasedOns, localizedNames, eMakeUnique, eAddBefore)) == null) {
            return;
        }
        this.m_pCurrResponseTask.AddParameter(2, newObj.getID());
    }

    private void handleRemoveObject() {
        FMUpdateRequestParamValue pvObjType = this.m_pCurrRequestTask.getParameterValue(8);
        if (pvObjType == null) {
            Object[] msgParams = new Object[]{FMUpdateRequestTaskHelper.taskToString(6), FMUpdateRequestTaskHelper.paramToString(1)};
            throw new FmMDException("BMT_MD_UPDATE_ACTION_MISSING_PARAM", msgParams);
        }
        FmMDException.ASSERT(!pvObjType.s_sValue.equals(""), "Expects a string value in the parameter value");
        List<FMUpdateRequestParamValue> vObjectIDs = this.m_pCurrRequestTask.getParameter(10);
        ArrayList<FmBaseObject> vObjects = new ArrayList<FmBaseObject>();
        for (FMUpdateRequestParamValue paramValue : vObjectIDs) {
            FmBaseObject object = null;
            if (paramValue.s_elmValue != null) {
                FmMDException.ASSERT(paramValue.s_elmValue.equals("refobj"), "Only \"refobj\" expected in the parameter value");
                object = ObjectModifier.GetBasedOnItem(this.m_session, paramValue.s_elmValue);
            } else {
                Object obj = ((EMFSession)this.m_session).getObjectById(paramValue.s_sValue);
                object = (FmBaseObject)((Object)FmModelFactory.getInstance().get(this.m_session, obj));
            }
            if (object == null) continue;
            vObjects.add(object);
        }
        if (!vObjects.isEmpty()) {
            this.doRemoveObject(pvObjType.s_sValue, vObjects);
            this.m_pCurrResponseTask.AddParameter(2, this.m_FMObject.getID());
        }
    }

    public List<BasedOn> convertToBasedOnTypes(List<FMUpdateRequestParamValue> vBasedOns) {
        ArrayList<BasedOn> res = new ArrayList<BasedOn>(vBasedOns.size());
        for (FMUpdateRequestParamValue parm : vBasedOns) {
            String expression = parm.extractExpressionFromBasedOn();
            FmExpressionBuilder builder = (FmExpressionBuilder)BuilderFactory.createExpressionBuilder();
            builder.parse(this.m_session, expression);
            FmExpression fmExp = FmExpression.create(this.m_session, builder);
            if (fmExp.isSimpleRefObjViaShortcut()) {
                FmRefobjViaShortcut rvs = fmExp.getRefobjViaShortcut().get(0);
                if (rvs.getShortcut().equals(rvs.getRawRefobj())) {
                    res.add(rvs.getShortcut());
                    continue;
                }
                res.add(rvs);
                continue;
            }
            if (fmExp.isSimpleObjectRef()) {
                BaseObject obj = fmExp.getRefObjs(false).get(0);
                res.add((BasedOn)((Object)obj));
                continue;
            }
            res.add(fmExp);
        }
        return res;
    }
}

