/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.helpers;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.DOMWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DomHelper {
    public static String domToString(Node doc) {
        if (doc == null) {
            return "";
        }
        StringWriter domText = new StringWriter();
        StreamResult sr = new StreamResult(domText);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer t = null;
        try {
            t = tf.newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.transform(new DOMSource(doc), sr);
        }
        catch (TransformerConfigurationException tfc) {
            throw new RuntimeException(tfc.getMessage(), tfc);
        }
        catch (TransformerException tfe) {
            throw new RuntimeException(tfe.getMessage(), tfe);
        }
        return domText.toString();
    }

    public static Element stringToDom(String xmlSource) {
        if (xmlSource == null || "".equals(xmlSource)) {
            return null;
        }
        Element elm = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlSource)));
            elm = doc.getDocumentElement();
        }
        catch (SAXException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IOException io) {
            throw new RuntimeException(io.getMessage(), io);
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce.getMessage(), pce);
        }
        return elm;
    }

    public static org.dom4j.Element stringToDom4j(String xmlSource) {
        if (xmlSource == null || "".equals(xmlSource)) {
            return null;
        }
        try {
            return DocumentHelper.parseText((String)xmlSource).getRootElement();
        }
        catch (DocumentException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Element createElement(Element elmParent, String tagName) {
        Element newChild = elmParent.getOwnerDocument().createElement(tagName);
        elmParent.appendChild(newChild);
        return newChild;
    }

    public static Element createElementWithText(Element elmParent, String tagName, String text) {
        Element newChild = DomHelper.createElement(elmParent, tagName);
        newChild.setTextContent(text);
        return newChild;
    }

    public static Element createElementWithAttribute(Element elmParent, String tagName, String attributeName, String value) {
        Element newChild = DomHelper.createElement(elmParent, tagName);
        newChild.setAttribute(attributeName, value);
        return newChild;
    }

    public static Element findOrCreateElement(Element elmParent, String tagName) {
        Element element = DomHelper.findFirstElement(elmParent, tagName);
        if (element == null) {
            element = DomHelper.createElement(elmParent, tagName);
        }
        return element;
    }

    public static Element findOrCreateElementWithText(Element elmParent, String tagName, String text) {
        Element element = DomHelper.findOrCreateElement(elmParent, tagName);
        element.setTextContent(text);
        return element;
    }

    public static Element findFirstElement(Element elmParent, String tagName) {
        Element element = null;
        NodeList nodeList = elmParent.getElementsByTagName(tagName);
        int iInd = 0;
        while (iInd < nodeList.getLength()) {
            Node childNode = nodeList.item(iInd);
            if (childNode.getNodeType() == 1) {
                element = (Element)childNode;
                break;
            }
            ++iInd;
        }
        return element;
    }

    public static Element findElementWithAttribute(Element elmParent, String tagName, String attributeName, String value) {
        Element element = null;
        NodeList nodeList = elmParent.getElementsByTagName(tagName);
        int iInd = 0;
        while (iInd < nodeList.getLength()) {
            Node childNode = nodeList.item(iInd);
            if (childNode.getNodeType() == 1 && value.equals(((Element)childNode).getAttribute(attributeName))) {
                element = (Element)childNode;
                break;
            }
            ++iInd;
        }
        return element;
    }

    public static Element dom4j2w3c(org.dom4j.Element element) {
        DOMWriter writer = new DOMWriter();
        Document doc2 = null;
        try {
            doc2 = writer.write(element.getDocument());
        }
        catch (DocumentException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return doc2.getDocumentElement();
    }

    public static org.dom4j.Element w3c2dom4j(Element element) {
        String elmStr = DomHelper.domToString(element);
        org.dom4j.Element dom4jElement = DomHelper.stringToDom4j(elmStr);
        return dom4jElement;
    }
}

