/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.helpers;

import com.ibm.cognos.fmeng.fmmd.helpers.HelperBase;
import com.ibm.cognos.fmeng.fmmd.impl.task.planner.XConnectionManager;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Branch;
import org.dom4j.Element;

public abstract class XCommandHelper
extends HelperBase {
    public static final String fmmd_resources_FMRequest_str = "FMRequest";
    public static final String fmmd_resources_FMCommand_str = "FMCommand";
    public static final String fmmd_resources_requestID_str = "requestID";
    public static final String fmmd_resources_commandID_str = "commandID";
    public static final String fmmd_resources_connection_str = "connection";
    public static final String fmmd_resources_value_str = "value";
    public static final String fmmd_resources_default_str = "default";
    public static final String fmmd_resources_reportName_str = "reportName";
    private Map<String, String> m_properties = new HashMap<String, String>();
    private Element m_elmConnection;
    protected FMMDSession m_session;

    public static Element addConnection(Element elmCommand, Element elmConnection) {
        Element metadataElement;
        Element executeElement;
        Element elmTemp = (Element)elmConnection.clone();
        Element elmConnect = (Element)elmCommand.selectSingleNode("//*[local-name()='connection']");
        if (elmConnect == null) {
            elmCommand.content().add(0, elmTemp);
        } else {
            List testConnectionElm = elmCommand.elements("testConnection");
            if (testConnectionElm.size() > 0) {
                Element elmConnectModel = (Element)elmTemp.selectSingleNode(".//*[local-name()='connection']");
                Element elmConnectDB = (Element)elmConnect.selectSingleNode(".//*[local-name()='connection']");
                Element parent = elmConnectModel.getParent();
                parent.remove(elmConnectModel);
                parent.content().add(0, elmConnectDB);
            }
            elmCommand.remove(elmConnect);
            elmCommand.content().add(0, elmTemp);
        }
        boolean bIsMetadataRequest = false;
        if (elmCommand != null && (executeElement = (Element)elmCommand.selectSingleNode("//*[local-name()='execute']")) != null && (metadataElement = (Element)executeElement.selectSingleNode("//*[local-name()='Metadata']")) != null) {
            bIsMetadataRequest = true;
        }
        if (bIsMetadataRequest) {
            Element dataSourceTypeElement;
            Element elmConnectModel;
            String strModelPath = "";
            Element elmSecondConnect = (Element)elmTemp.selectSingleNode("//*[local-name()='connection']");
            if (elmSecondConnect != null && (elmConnectModel = (Element)elmSecondConnect.selectSingleNode("//*[local-name()='name']")) != null) {
                strModelPath = elmConnectModel.attributeValue(fmmd_resources_value_str);
            }
            if ((dataSourceTypeElement = (Element)elmTemp.selectSingleNode("//*[local-name()='dataSourceType']")) != null) {
                dataSourceTypeElement.addAttribute(fmmd_resources_value_str, "MQP");
                Element modelPathElement = (Element)elmTemp.selectSingleNode("//*[local-name()='dataSource']");
                if (modelPathElement != null) {
                    modelPathElement.addAttribute(fmmd_resources_value_str, strModelPath);
                }
            }
        }
        return elmCommand;
    }

    public static String getDefaultFMCommandID() {
        return fmmd_resources_FMCommand_str;
    }

    public static String getDefaultFMRequestID() {
        return fmmd_resources_FMRequest_str;
    }

    public void setConnection(Element elmConnection) {
        this.m_elmConnection = elmConnection;
    }

    public void setProperty(EProperty eProp, String propValue) {
        switch (eProp) {
            case kPropCommandID: {
                this.m_properties.put(fmmd_resources_commandID_str, propValue);
                break;
            }
            case kPropRequestID: {
                this.m_properties.put(fmmd_resources_requestID_str, propValue);
            }
        }
    }

    protected XCommandHelper() {
        this.m_properties.put(fmmd_resources_commandID_str, fmmd_resources_FMCommand_str);
        this.m_properties.put(fmmd_resources_requestID_str, fmmd_resources_FMRequest_str);
    }

    protected XCommandHelper(FMMDSession session) {
        this.m_session = session;
        this.m_properties.put(fmmd_resources_commandID_str, fmmd_resources_FMCommand_str);
        this.m_properties.put(fmmd_resources_requestID_str, fmmd_resources_FMRequest_str);
    }

    protected abstract void insertCommand(Element var1);

    protected final Element doMake(Branch root) {
        Element elmRequest = root.addElement("command");
        elmRequest.addAttribute("xmlns", "http://developer.cognos.com/schemas/qsapi/2/");
        elmRequest.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.makeReportName(elmRequest, fmmd_resources_default_str);
        if (this.m_elmConnection != null) {
            Element nodeTemp = (Element)this.m_elmConnection.clone();
            elmRequest.add(nodeTemp);
        } else {
            elmRequest.addElement(fmmd_resources_connection_str);
        }
        this.insertCommand(elmRequest);
        for (Map.Entry<String, String> entry : this.m_properties.entrySet()) {
            Element elmProp = elmRequest.addElement(entry.getKey());
            elmProp.addAttribute(fmmd_resources_value_str, entry.getValue());
        }
        return elmRequest;
    }

    protected String getModelPath() {
        return XConnectionManager.getInstance().getModelPath(this.m_session);
    }

    protected void makeModelPath(Element elmCommand) {
        Element modelPath = elmCommand.addElement("modelPath");
        modelPath.setText(this.getModelPath());
    }

    protected void makeModelPath(Element elmCommand, String packageName) {
        Element modelPath = elmCommand.element("modelPath");
        if (modelPath != null) {
            String path = "/content/package[@name='";
            path = String.valueOf(path) + packageName;
            path = String.valueOf(path) + "']/model";
            modelPath.setText(path);
        }
    }

    protected void makeReportName(Element elmCommand, String reportName) {
        if (reportName.equals(fmmd_resources_default_str)) {
            elmCommand.addAttribute(fmmd_resources_reportName_str, fmmd_resources_FMRequest_str);
        } else {
            elmCommand.addAttribute(fmmd_resources_reportName_str, reportName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum EProperty {
        kPropUnknown,
        kPropCommandID,
        kPropRequestID;

    }
}

