/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.helpers;

import com.ibm.cognos.fmeng.fmmd.helpers.XCommandHelper;
import com.ibm.cognos.fmeng.fmmd.helpers.XJoinQueryHelper;
import com.ibm.cognos.fmeng.fmmd.helpers.XModelSetQueryHelper;
import com.ibm.cognos.fmeng.fmmd.helpers.XQueryDataItem;
import com.ibm.cognos.fmeng.fmmd.helpers.XQueryHelper;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.dom4j.Branch;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XExecuteCommandHelper
extends XCommandHelper {
    private Locale m_pQueryLocale;
    private List<XQueryHelper> m_queries = new ArrayList<XQueryHelper>();
    private Map<ERequestHint, String> m_requestHints = new HashMap<ERequestHint, String>();
    private List<EQueryFeedback> m_queryFeedbacks = new ArrayList<EQueryFeedback>();
    private Map<String, String> m_properties = new HashMap<String, String>();
    private EQOSSeverity m_eQOSSeverity;

    public XExecuteCommandHelper(FMMDSession session) {
        super(session);
        this.m_pQueryLocale = session.getActiveLocale();
        this.m_eQOSSeverity = EQOSSeverity.unknown;
    }

    public XQueryHelper addQuery(String queryName) {
        XQueryHelper p = new XQueryHelper(queryName);
        this.m_queries.add(p);
        return p;
    }

    public XQueryHelper addJoinQuery(String queryName, String leftEnd, String leftCard, String rightEnd, String rightCard, String joinExpr) {
        XJoinQueryHelper p = new XJoinQueryHelper(queryName, leftEnd, leftCard, rightEnd, rightCard, joinExpr);
        this.m_queries.add(p);
        return p;
    }

    public XQueryHelper addModelSetQuery(String queryName, List<String> svAliases, String operation, String duplicates) {
        XModelSetQueryHelper p = new XModelSetQueryHelper(queryName, svAliases, operation, duplicates);
        this.m_queries.add(p);
        return p;
    }

    public void addRequestHint(ERequestHint eReqHint, String reqHintValue) {
        this.m_requestHints.put(eReqHint, reqHintValue);
    }

    public void addExecuteProperty(String nameProp, String valueProp) {
        this.m_properties.put(nameProp, valueProp);
    }

    public void addQueryFeedback(EQueryFeedback eQueryFeedback) {
        this.m_queryFeedbacks.add(eQueryFeedback);
    }

    public void setQOSSeverityLevel(EQOSSeverity eQOSLevel) {
        this.m_eQOSSeverity = eQOSLevel;
    }

    public static EQOSSeverity convertNagLevel2SeverityLevel(int nagLevel) {
        EQOSSeverity eSeverity = EQOSSeverity.unknown;
        switch (nagLevel) {
            case 0: 
            case 1: {
                eSeverity = EQOSSeverity.error;
                break;
            }
            case 2: {
                eSeverity = EQOSSeverity.warning;
                break;
            }
            case 3: {
                eSeverity = EQOSSeverity.keyTransformation;
                break;
            }
            case 4: {
                eSeverity = EQOSSeverity.information;
                break;
            }
            default: {
                eSeverity = EQOSSeverity.information;
            }
        }
        return eSeverity;
    }

    public void insertQuerySet(Element command, Element querySetElement) {
        Element elmExCmd = command.addElement("execute");
        this.makeModelPath(querySetElement);
        elmExCmd.add(querySetElement);
    }

    public void insertQuerySetWithModelPath(Element command, Element querySetElement, String modelPath) {
        Element elmExCmd = command.addElement("execute");
        this.makeModelPath(querySetElement, modelPath);
        elmExCmd.add(querySetElement);
    }

    public void insertProperties(Element elmExCmd, HashMap<String, String> properties) {
        Element execute = elmExCmd.element("execute");
        Element anElement = execute.addElement("property");
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            anElement.addAttribute("name", entry.getKey());
            anElement.addAttribute("value", entry.getValue());
        }
    }

    @Override
    protected void insertCommand(Element command) {
        Element elmExCmd = command.addElement("execute");
        Element elmQSet = elmExCmd.addElement("querySet");
        if (this.m_pQueryLocale != null) {
            elmQSet.addAttribute("expressionLocale", this.m_pQueryLocale.getLanguage());
        }
        this.makeModelPath(elmQSet);
        Element elmQueries = elmQSet.addElement("queries");
        for (XQueryHelper xQueryHelper : this.m_queries) {
            Element elmQuery = xQueryHelper.doMake((Branch)elmQueries);
            elmQuery.detach();
            elmQueries.add(elmQuery);
        }
        this.makeResultDefinitions(elmQSet);
        this.makeRequestHints(elmQSet);
        for (Map.Entry entry : this.m_properties.entrySet()) {
            Element anElement = elmExCmd.addElement("property");
            anElement.addAttribute("name", (String)entry.getKey());
            anElement.addAttribute("value", (String)entry.getValue());
        }
        this.makeQueryFeedbacks(elmExCmd);
    }

    private void makeRequestHints(Element elmQuerySet) {
        if (this.m_requestHints.isEmpty()) {
            return;
        }
        Element elmReqHints = elmQuerySet.addElement("requestHints");
        Element elmHint = null;
        for (Map.Entry<ERequestHint, String> e : this.m_requestHints.entrySet()) {
            switch (e.getKey()) {
                case noDataMode: {
                    elmHint = elmReqHints.addElement("noDataMode");
                    elmHint.addAttribute("enabled", e.getValue());
                    break;
                }
                case designMode: {
                    elmHint = elmReqHints.addElement("designMode");
                    elmHint.addAttribute("enabled", e.getValue());
                    break;
                }
                case executionOptimization: {
                    elmHint = elmReqHints.addElement("executionOptimization");
                    elmHint.addAttribute("value", e.getValue());
                    break;
                }
                case queryProcessing: {
                    elmHint = elmReqHints.addElement("queryProcessing");
                    elmHint.addAttribute("value", e.getValue());
                }
            }
        }
    }

    private void makeResultDefinitions(Element elmQuerySet) {
        Element elmResDefs = elmQuerySet.addElement("queryResultDefinitions");
        XQueryHelper qh = this.m_queries.get(0);
        boolean bFirstQuery = "SingleCount".equals(qh.getName()) || "querySet".equals(qh.getName());
        for (XQueryHelper qItr : this.m_queries) {
            Element elmResDef = elmResDefs.addElement("queryResultDefinition");
            String tmp = "rsd";
            tmp = String.valueOf(tmp) + qItr.getName();
            elmResDef.addAttribute("name", tmp);
            elmResDef.addAttribute("refQuery", qItr.getName());
            Element elmEdges = elmResDef.addElement("edges");
            Element elmEdge = elmEdges.addElement("edge");
            elmEdge.addAttribute("name", "columns");
            Element elmEdgeGrps = elmEdge.addElement("edgeGroups");
            Element elmEdgeGrp = elmEdgeGrps.addElement("edgeGroup");
            Element elmValSets = elmEdgeGrp.addElement("valueSets");
            Element elmValSet = elmValSets.addElement("valueSet");
            elmValSet.addAttribute("name", "valueSet1");
            Element elmGrpBody = elmValSet.addElement("groupBody");
            elmGrpBody.addAttribute("name", "groupBody1");
            List<XQueryDataItem> dataItems = qItr.getDataItems();
            for (XQueryDataItem diItr : dataItems) {
                Element elmDItemRef = elmGrpBody.addElement("dataItemRef");
                elmDItemRef.addAttribute("refDataItem", diItr.getName());
            }
            if (bFirstQuery) break;
        }
    }

    public void makeQueryFeedbacks(Element elmExecute) {
        if (this.m_queryFeedbacks.isEmpty() && this.m_eQOSSeverity == EQOSSeverity.unknown) {
            return;
        }
        Element elmFeedback = elmExecute.addElement("queryFeedback");
        if (this.m_eQOSSeverity != EQOSSeverity.unknown) {
            elmFeedback.addAttribute("severityLevel", this.m_eQOSSeverity.toString());
        }
        for (EQueryFeedback e : this.m_queryFeedbacks) {
            Element elmProp = elmFeedback.addElement("property");
            elmProp.addAttribute("name", e.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EQOSSeverity {
        unknown,
        error,
        warning,
        keyTransformation,
        information;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EQueryFeedback {
        unknown,
        nativeCommandText,
        CognosCommandText,
        connections,
        columnList,
        executionPlan,
        nativeCommandType,
        tableType;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EQueryOptimization {
        unknown,
        firstRow,
        allRows,
        incremental;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ERequestHint {
        unknown,
        noDataMode,
        designMode,
        executionOptimization,
        queryProcessing;

    }
}

