/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.helpers;

import com.ibm.cognos.fmeng.fmmd.helpers.HelperBase;
import com.ibm.cognos.fmeng.fmmd.helpers.XQueryDataItem;
import com.ibm.cognos.fmeng.fmmd.helpers.XQueryDetailFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Branch;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XQueryHelper
extends HelperBase {
    private String m_name;
    private boolean m_bAutoSummary = false;
    private List<XQueryDataItem> m_dataItems = new ArrayList<XQueryDataItem>();
    private List<XQueryDetailFilter> m_detailFilters = new ArrayList<XQueryDetailFilter>();
    private Map<EQueryHint, String> m_simpleHints = new HashMap<EQueryHint, String>();
    private String m_queryRef;

    XQueryHelper(String name) {
        this.m_name = name;
        this.addHint(EQueryHint.avoidZeroDiv, "true");
    }

    String getName() {
        return this.m_name;
    }

    public void setAutoSummary(boolean autoSummary) {
        this.m_bAutoSummary = autoSummary;
    }

    public XQueryDataItem addDataItem(String name, String expression) {
        String uniqueName = this.makeUnique(this.m_dataItems, name);
        XQueryDataItem item = new XQueryDataItem(uniqueName, expression);
        this.m_dataItems.add(item);
        return item;
    }

    XQueryDetailFilter addDetailFilter(String expression, XQueryDetailFilter.EUse eUse) {
        XQueryDetailFilter p = new XQueryDetailFilter(expression, eUse);
        this.m_detailFilters.add(p);
        return p;
    }

    public void setQueryRef(String name) {
        this.m_queryRef = name;
    }

    public void addHint(EQueryHint eHint, String hintValue) {
        this.m_simpleHints.put(eHint, hintValue);
    }

    public List<XQueryDataItem> getDataItems() {
        return this.m_dataItems;
    }

    List<XQueryDetailFilter> getDetailFilters() {
        return this.m_detailFilters;
    }

    protected Element setSource(Element elmRequest) {
        Element elmSource = elmRequest.addElement("source");
        if (this.m_queryRef == null || this.m_queryRef.equals("")) {
            elmSource.addElement("model");
        } else {
            Element elmQueryRef = elmSource.addElement("queryRef");
            elmQueryRef.addAttribute("refQuery", this.m_queryRef);
        }
        return elmRequest;
    }

    @Override
    protected Element doMake(Branch root) {
        Element elmRequest = root.addElement("query");
        elmRequest.addAttribute("name", this.m_name);
        elmRequest = this.setSource(elmRequest);
        Element elmSelection = elmRequest.addElement("selection");
        elmSelection.addAttribute("autoSummary", this.m_bAutoSummary ? "true" : "false");
        for (XQueryDataItem item : this.m_dataItems) {
            Element elmDItem = elmSelection.addElement("dataItem");
            elmDItem.addAttribute("name", item.getName());
            if (item.getSort() != XQueryDataItem.ESort.unknown) {
                elmDItem.addAttribute("sort", item.getSort().toString());
            }
            if (item.getAggregate() != XQueryDataItem.EAggregate.unknown) {
                elmDItem.addAttribute("aggregate", item.getAggregate().toString());
            }
            if (item.getRollupAggregate() != XQueryDataItem.EAggregate.unknown) {
                elmDItem.addAttribute("rollupAggregate", item.getRollupAggregate().toString());
            }
            Element expression = elmDItem.addElement("expression");
            expression.setText(item.getExpression());
            if (item.getTagName() == "") continue;
            Element tag = elmDItem.addElement("tag");
            tag.setText(item.getTagName());
        }
        if (!this.m_detailFilters.isEmpty()) {
            Element elmDetailFilter = elmRequest.addElement("detailFilter");
            for (XQueryDetailFilter fItr : this.m_detailFilters) {
                Element elmFilter = elmDetailFilter.addElement("filter");
                elmFilter.addAttribute("use", fItr.getUse().toString());
                Element filterExpression = elmFilter.addElement("filterExpression");
                filterExpression.setText(fItr.getExpression());
            }
        }
        if (!this.m_simpleHints.isEmpty()) {
            this.makeHints(elmRequest);
        }
        return elmRequest;
    }

    private void makeHints(Element elmQuery) {
        Element elmQHints = elmQuery.addElement("queryHints");
        for (Map.Entry<EQueryHint, String> e : this.m_simpleHints.entrySet()) {
            Element elmHint = elmQHints.addElement(e.getKey().toString());
            elmHint.addAttribute("value", e.getValue());
        }
    }

    private boolean contains(List<XQueryDataItem> inDataItems, String candidateName) {
        for (XQueryDataItem item : inDataItems) {
            if (!item.getName().equals(candidateName)) continue;
            return true;
        }
        return false;
    }

    private String makeUnique(List<XQueryDataItem> inDataItems, String candidateName) {
        String tempName = candidateName;
        int seqNo = 0;
        while (seqNo < inDataItems.size() && this.contains(inDataItems, tempName)) {
            tempName = String.valueOf(candidateName) + Integer.toString(++seqNo);
        }
        return tempName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EQueryHint {
        unknown,
        avoidZeroDiv,
        autoSort,
        measureRefiner,
        maxRowsRetrieved;

    }
}

