/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.helpers;

import com.ibm.cognos.fmeng.fmmd.helpers.XCommandHelper;
import com.ibm.cognos.fmeng.fmmd.helpers.XSqlDescribeHelper;
import com.ibm.cognos.fmeng.fmmd.util.CmHelper;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.soap.MetadataServiceRequest;
import java.util.List;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSqlHelper
extends XCommandHelper {
    protected static volatile int nQueryNameCount = 0;
    protected String msDummyModelPath;
    protected String msSql;
    protected String msCmDataSourceName;
    protected Element mElmSqlText;
    protected List<String> mListSqlColumnNames;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSqlHelper(FMMDSession session, String sModelPath, String sCmDataSourceName, String sSql, List<String> listSqlColumnNames) {
        super(session);
        Class<XSqlHelper> clazz = XSqlHelper.class;
        synchronized (XSqlHelper.class) {
            ++nQueryNameCount;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            this.msDummyModelPath = sModelPath;
            this.msSql = sSql;
            this.msCmDataSourceName = sCmDataSourceName;
            this.mListSqlColumnNames = listSqlColumnNames;
            return;
        }
    }

    public Element doSqlDescribeRequest() {
        XSqlDescribeHelper qsHelper = new XSqlDescribeHelper(this.m_session, this.msDummyModelPath, this.msCmDataSourceName, this.msSql);
        Element domRequest = qsHelper.make();
        String dispatcherGuid = CmHelper.get(this.m_session, this.m_session.getPassport()).getDispatcherGuid();
        MetadataServiceRequest request = new MetadataServiceRequest(this.m_session.getPassport(), null, dispatcherGuid);
        Element elmResponse = request.sendQueryServicesRequest(domRequest.asXML(), new MetadataServiceRequest.RequestOptions(){
            {
                this.mMaxRows = 0;
                this.mValidateOnly = false;
                this.mUseBmeGateway = false;
            }
        });
        return elmResponse;
    }

    @Override
    protected void insertCommand(Element command) {
        Element execute = command.addElement("execute");
        Element querySet = execute.addElement("querySet");
        Element retrieveDataset = execute.addElement("retrieveDataset");
        Element modelPath = querySet.addElement("modelPath");
        Element queries = querySet.addElement("queries");
        Element query = queries.addElement("query");
        Element source = query.addElement("source");
        Element sqlQuery = source.addElement("sqlQuery");
        this.mElmSqlText = sqlQuery.addElement("sqlText");
        Element mdProjectedItems = sqlQuery.addElement("mdProjectedItems");
        Element selection = query.addElement("selection");
        Element queryResultDefinitions = querySet.addElement("queryResultDefinitions");
        Element queryResultDefinition = queryResultDefinitions.addElement("queryResultDefinition");
        Element edges = queryResultDefinition.addElement("edges");
        Element edge = edges.addElement("edge");
        Element edgeGroups = edge.addElement("edgeGroups");
        Element edgeGroup = edgeGroups.addElement("edgeGroup");
        Element valueSets = edgeGroup.addElement("valueSets");
        Element valueSet = valueSets.addElement("valueSet");
        Element groupBody = valueSet.addElement("groupBody");
        execute.addAttribute("returnParameterValues", "false");
        querySet.addAttribute("expressionLocale", this.m_session.getProject().getDefaultLocale());
        modelPath.setText(this.msDummyModelPath == null ? this.getModelPath() : this.msDummyModelPath);
        String sQueryName = "FMEngSQLQuery" + nQueryNameCount;
        query.addAttribute("name", sQueryName);
        sqlQuery.addAttribute("dataSource", this.msCmDataSourceName);
        int sqlQueryElementCount = 1;
        String sqlQueryName = "SQL" + sqlQueryElementCount;
        sqlQuery.addAttribute("name", sqlQueryName);
        this.mElmSqlText.addText(this.msSql);
        String queryResultDefinitionName = String.valueOf(sQueryName) + "." + (sqlQueryElementCount - 1);
        queryResultDefinition.addAttribute("name ", queryResultDefinitionName);
        queryResultDefinition.addAttribute("refQuery ", sQueryName);
        String sEdgeName = String.valueOf(3 + 6 * (sqlQueryElementCount - 1));
        edge.addAttribute("name", sEdgeName);
        String sValueSetName = String.valueOf(7 + 6 * (sqlQueryElementCount - 1));
        valueSet.addAttribute("name", sValueSetName);
        groupBody.addAttribute("name", String.valueOf(sValueSetName) + "_groupBody");
        retrieveDataset.addAttribute("value", queryResultDefinitionName);
        for (String sColumnName : this.mListSqlColumnNames) {
            Element mdProjectedItem = mdProjectedItems.addElement("mdProjectedItem");
            mdProjectedItem.addAttribute("name", sColumnName);
            Element dataItem = selection.addElement("dataItem");
            dataItem.addAttribute("name", sColumnName);
            Element expression = dataItem.addElement("expression");
            expression.addText(String.format("[%s].[%s]", sqlQueryName, sColumnName));
            Element dataItemRef = groupBody.addElement("dataItemRef");
            dataItemRef.addAttribute("refDataItem", sColumnName);
        }
    }
}

