/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCalculatedMember;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmExpression;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasure;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasureDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationship;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveListener;
import com.ibm.cognos.fmeng.fmmd.impl.model.V5ExpressionHandler;
import com.ibm.cognos.fmeng.fmmd.model.AccessRule;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.BuilderFactory;
import com.ibm.cognos.fmeng.fmmd.model.Cube;
import com.ibm.cognos.fmeng.fmmd.model.CubeBase;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.MDXExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.Measure;
import com.ibm.cognos.fmeng.fmmd.model.MeasureBase;
import com.ibm.cognos.fmeng.fmmd.model.MeasureDimension;
import com.ibm.cognos.fmeng.fmmd.model.Permission;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.RelationalQuerySubject;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.fmmd.model.V5Query;
import com.ibm.cognos.fmeng.genmodel.AccessRuleType;
import com.ibm.cognos.fmeng.genmodel.AccessScopeType;
import com.ibm.cognos.fmeng.genmodel.CubeType;
import com.ibm.cognos.fmeng.genmodel.ExpressionType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.MeasureDimensionType;
import com.ibm.cognos.fmeng.genmodel.PermissionType;
import com.ibm.cognos.fmeng.genmodel.QueryItemType;
import com.ibm.cognos.fmeng.genmodel.RelationalHierarchyType;
import com.ibm.cognos.fmeng.genmodel.RuleStyleType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import com.ibm.cognos.fmeng.utility.V5DataItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmAccessRule
extends FmModelObject
implements AccessRule,
V5Query {
    private FmAccessRule(FMMDSession session, Object emfObject) {
        super(session, emfObject);
    }

    public static FmAccessRule get(FMMDSession session, Object object) {
        return new FmAccessRule(session, (AccessRuleType)object);
    }

    protected static AccessRule createAccessRule(FMMDSession session, FmRelationalHierarchy parent, String objectName, AccessRule.RuleStyle style) {
        FmAccessRule accessRule = FmAccessRule.createAccessRuleInternal(session, parent, objectName);
        parent.addAccessRule(accessRule);
        String uniqueName = accessRule.makeUniqueName(objectName);
        accessRule.setName(uniqueName);
        accessRule.getAccessRuleType().setAllAccess(false);
        accessRule.getAccessRuleType().setPermission(PermissionType.GRANT);
        accessRule.getAccessRuleType().setAccessScope(AccessScopeType.MEMBERS);
        RuleStyleType rs = RuleStyleType.ROLE;
        switch (style) {
            case roleBased: {
                rs = RuleStyleType.ROLE;
                break;
            }
            case lookupTableBased: {
                rs = RuleStyleType.LOOKUP_TABLE;
            }
        }
        accessRule.getAccessRuleType().setRuleStyle(rs);
        return accessRule;
    }

    public static AccessRule createAllAccessRule(FMMDSession session, FmRelationalHierarchy parent) {
        String objectName = FmMessage.render("BMT_MDN_ALL_ACCESS_RULE", session.getActiveLocale());
        FmAccessRule accessRule = FmAccessRule.createAccessRuleInternal(session, parent, objectName);
        accessRule.getAccessRuleType().setAllAccess(true);
        accessRule.getAccessRuleType().setPermission(PermissionType.GRANT);
        accessRule.getAccessRuleType().setAccessScope(AccessScopeType.ALL);
        accessRule.getAccessRuleType().setRuleStyle(RuleStyleType.ROLE);
        parent.addAccessRule(accessRule);
        String uniqueName = accessRule.makeUniqueName(objectName);
        accessRule.setName(uniqueName);
        return accessRule;
    }

    protected static AccessRule createAccessRule(FMMDSession session, FmMeasureDimension parent, String objectName, MeasureBase measure, Permission access) {
        FmAccessRule accessRule = FmAccessRule.createAccessRuleInternal(session, parent, objectName);
        parent.addAccessRule(accessRule);
        String uniqueName = accessRule.makeUniqueName(objectName);
        accessRule.setName(uniqueName);
        accessRule.setAccessProperties(access);
        MDXExpressionBuilder builder = BuilderFactory.createMDXExpressionBuilder();
        builder.addPart(measure, null);
        FmExpression fmExp = FmExpression.create(session, builder);
        accessRule.getAccessRuleType().setExpression(fmExp.getExpressionType());
        return accessRule;
    }

    public static AccessRule createAccessRule(FMMDSession session, FmCube parent, String objectName, RelationalDimension dimension, Permission access) {
        FmAccessRule accessRule = FmAccessRule.createAccessRuleInternal(session, parent, objectName);
        parent.addAccessRule(accessRule);
        String uniqueName = accessRule.makeUniqueName(objectName);
        accessRule.setName(uniqueName);
        accessRule.setAccessProperties(access);
        MDXExpressionBuilder builder = BuilderFactory.createMDXExpressionBuilder();
        builder.addPart(dimension, null);
        FmExpression fmExp = FmExpression.create(session, builder);
        accessRule.getAccessRuleType().setExpression(fmExp.getExpressionType());
        accessRule.getAccessRuleType().setRuleStyle(RuleStyleType.ROLE);
        return accessRule;
    }

    public static AccessRule createAccessRule(FMMDSession session, FmCube parent, String objectName, QueryItem queryItem, Permission access) {
        FmAccessRule accessRule = FmAccessRule.createAccessRuleInternal(session, parent, objectName);
        parent.addAccessRule(accessRule);
        String uniqueName = accessRule.makeUniqueName(objectName);
        accessRule.setName(uniqueName);
        accessRule.setAccessProperties(access);
        MDXExpressionBuilder builder = BuilderFactory.createMDXExpressionBuilder();
        builder.addPart(queryItem, null);
        FmExpression fmExp = FmExpression.create(session, builder);
        accessRule.getAccessRuleType().setExpression(fmExp.getExpressionType());
        accessRule.getAccessRuleType().setRuleStyle(RuleStyleType.ROLE);
        return accessRule;
    }

    private static FmAccessRule createAccessRuleInternal(FMMDSession session, FmReportObject parent, String objectName) {
        if (parent.isInAggregateCube()) {
            throw new FmMDException("BMT_MD_AGGREGATE_CUBES_MAY_NOT_HAVE_ACCESS_RULES");
        }
        if (objectName == null || objectName.length() == 0) {
            objectName = FmAccessRule.getDefaultName(session.getActiveLocale());
        }
        AccessRuleType emfObj = GenmodelFactory.eINSTANCE.createAccessRuleType();
        return new FmAccessRule(session, emfObj);
    }

    public static String getDefaultName(Locale locale) {
        return FmMessage.render("BMT_MDN_OBJECT_NAME_ACCESS_RULE", locale);
    }

    @Override
    public FmObjectType getFmObjectType() {
        return FmObjectType.accessRule;
    }

    protected AccessRuleType getAccessRuleType() {
        return (AccessRuleType)this.m_emfObject;
    }

    @Override
    void prepareForObjectDeletion(RemoveInfo info, FmBaseObject object, RemoveListener listener) {
        MeasureBase myMeasure;
        super.prepareForObjectDeletion(info, object, listener);
        if (this.getAllAccess()) {
            return;
        }
        if (object instanceof MeasureBase && this.isMeasureAccess() && (myMeasure = this.getMeasure()).equals(object)) {
            this.m_session.delete(this);
        }
        if (object instanceof FmRelationalDimension) {
            this.cleanupDimension((RelationalDimension)((Object)object));
        }
        if (object instanceof FmRelationship) {
            boolean isDetailCube = true;
            BaseObject parent = object.getParent();
            if (parent instanceof Cube && ((Cube)parent).isAggregateCube()) {
                isDetailCube = false;
            }
            if (isDetailCube) {
                RelationalDimension dim = null;
                FmRelationship rel = (FmRelationship)object;
                dim = rel.getLeftEnd() instanceof MeasureDimension ? (RelationalDimension)rel.getRightEnd() : (RelationalDimension)rel.getLeftEnd();
                this.cleanupDimension(dim);
            }
        }
        if (object instanceof FmQueryItem) {
            switch (this.getRestrictObjectType()) {
                case member: {
                    if (!this.getRuleStyle().equals((Object)AccessRule.RuleStyle.lookupTableBased)) break;
                    EObject keyToDelete = null;
                    for (EObject key : this.getAccessRuleType().getQueryItemKeyValueMap().keySet()) {
                        EObject value = (EObject)this.getAccessRuleType().getQueryItemKeyValueMap().get((Object)key);
                        if (!value.equals(object.getInternal())) continue;
                        keyToDelete = key;
                        break;
                    }
                    if (keyToDelete != null) {
                        this.getAccessRuleType().getQueryItemKeyValueMap().remove(keyToDelete);
                        break;
                    }
                    this.getAccessRuleType().getQueryItemKeyValueMap().remove(object.getInternal());
                    break;
                }
                case attribute: {
                    if (!this.getQueryItem().equals(object)) break;
                    this.m_session.delete(this);
                }
            }
        }
    }

    private void cleanupDimension(RelationalDimension dim) {
        if (dim != null && dim.isRollupDimension()) {
            return;
        }
        switch (this.getRestrictObjectType()) {
            case dimension: {
                if (!this.getDimension().equals(dim)) break;
                this.m_session.delete(this);
                break;
            }
            case attribute: {
                if (!this.getQueryItem().getRelationalParent().equals(dim)) break;
                this.m_session.delete(this);
            }
        }
    }

    private void setMemberAccessProperties(AccessRule.MemberAccess access) {
        switch (access) {
            case grantAll: {
                this.getAccessRuleType().setPermission(PermissionType.GRANT);
                this.getAccessRuleType().setAccessScope(AccessScopeType.ALL);
                break;
            }
            case grantMembers: {
                this.getAccessRuleType().setPermission(PermissionType.GRANT);
                this.getAccessRuleType().setAccessScope(AccessScopeType.MEMBERS);
                break;
            }
            case grantMembersAndDescendants: {
                this.getAccessRuleType().setPermission(PermissionType.GRANT);
                this.getAccessRuleType().setAccessScope(AccessScopeType.MEMBERS_AND_DESCENDANTS);
                break;
            }
            case grantMembersAndAncestors: {
                this.getAccessRuleType().setPermission(PermissionType.GRANT);
                this.getAccessRuleType().setAccessScope(AccessScopeType.MEMBERS_AND_ANCESTORS);
                break;
            }
            case grantMembersDescendantsAndAncestors: {
                this.getAccessRuleType().setPermission(PermissionType.GRANT);
                this.getAccessRuleType().setAccessScope(AccessScopeType.MEMBERS_DESCENDANTS_AND_ANCESTORS);
                break;
            }
            case denyMembersAndDescendants: {
                this.getAccessRuleType().setPermission(PermissionType.DENY);
                this.getAccessRuleType().setAccessScope(AccessScopeType.MEMBERS_AND_DESCENDANTS);
                break;
            }
            default: {
                FmMDException.ASSERT(false, "Invalid security access rules: " + access.toString());
            }
        }
    }

    private void setAccessProperties(Permission access) {
        switch (access) {
            case grant: {
                this.getAccessRuleType().setPermission(PermissionType.GRANT);
                break;
            }
            case deny: {
                this.getAccessRuleType().setPermission(PermissionType.DENY);
                break;
            }
            default: {
                FmMDException.ASSERT(false, "Invalid security access rules: " + access.toString());
            }
        }
    }

    @Override
    public Expression getExpression() {
        if (this.isMeasureAccess()) {
            return null;
        }
        ExpressionType expression = this.getAccessRuleType().getExpression();
        if (expression == null) {
            return null;
        }
        return FmExpression.get((FMMDSession)this.m_session, expression);
    }

    @Override
    public Expression setExpression(MDXExpressionBuilder builder) {
        if (this.getRestrictObjectType() != AccessRule.RestrictObjectType.member) {
            FmMDException.ASSERT(false, "You can only setExpression for access rule in a hierarchy.");
        }
        FmMDException.ASSERT(this.getRuleStyle().equals((Object)AccessRule.RuleStyle.roleBased), "You can only setExpression for access rule of role-based type .");
        FmExpression fmExp = FmExpression.create((FMMDSession)this.m_session, builder);
        this.getAccessRuleType().setExpression(fmExp.getExpressionType());
        return fmExp;
    }

    @Override
    public Permission getPermission() {
        switch (this.getAccessRuleType().getPermission()) {
            case GRANT: {
                return Permission.grant;
            }
            case DENY: {
                return Permission.deny;
            }
        }
        FmMDException.ASSERT(false, "Bad default member access.");
        return Permission.grant;
    }

    @Override
    public AccessRule.MemberAccess getMemberAccess() {
        switch (this.getAccessRuleType().getPermission()) {
            case GRANT: {
                switch (this.getAccessRuleType().getAccessScope()) {
                    case MEMBERS: {
                        return AccessRule.MemberAccess.grantMembers;
                    }
                    case MEMBERS_AND_DESCENDANTS: {
                        return AccessRule.MemberAccess.grantMembersAndDescendants;
                    }
                    case MEMBERS_AND_ANCESTORS: {
                        return AccessRule.MemberAccess.grantMembersAndAncestors;
                    }
                    case MEMBERS_DESCENDANTS_AND_ANCESTORS: {
                        return AccessRule.MemberAccess.grantMembersDescendantsAndAncestors;
                    }
                }
                return AccessRule.MemberAccess.grantAll;
            }
            case DENY: {
                switch (this.getAccessRuleType().getAccessScope()) {
                    default: 
                }
                return AccessRule.MemberAccess.denyMembersAndDescendants;
            }
        }
        FmMDException.ASSERT(false, "Bad default member access.");
        return AccessRule.MemberAccess.grantAll;
    }

    @Override
    public void setPermission(Permission access) {
        switch (this.getRestrictObjectType()) {
            case measure: 
            case attribute: 
            case dimension: {
                this.setAccessProperties(access);
                break;
            }
            default: {
                FmMDException.ASSERT(true, "Invalid object type for Permission.");
            }
        }
    }

    @Override
    public void setMemberAccess(AccessRule.MemberAccess access) {
        FmMDException.ASSERT(this.getRestrictObjectType().equals((Object)AccessRule.RestrictObjectType.member), "You must specify a MemberAccess for member rules.");
        this.setMemberAccessProperties(access);
    }

    @Override
    public boolean isMeasureAccess() {
        return this.getRestrictObjectType().equals((Object)AccessRule.RestrictObjectType.measure);
    }

    @Override
    public boolean isDimensionAccess() {
        return this.getRestrictObjectType().equals((Object)AccessRule.RestrictObjectType.dimension);
    }

    @Override
    public boolean isQueryItemAccess() {
        return this.getRestrictObjectType().equals((Object)AccessRule.RestrictObjectType.attribute);
    }

    @Override
    public MeasureBase getMeasure() {
        if (!this.getRestrictObjectType().equals((Object)AccessRule.RestrictObjectType.measure)) {
            return null;
        }
        FmExpression expr = FmExpression.get((FMMDSession)this.m_session, this.getAccessRuleType().getExpression());
        for (Object obj : expr.getComponents()) {
            if (obj instanceof FmMeasure) {
                return (FmMeasure)obj;
            }
            if (!(obj instanceof FmCalculatedMember)) continue;
            return (FmCalculatedMember)obj;
        }
        return null;
    }

    @Override
    public RelationalDimension getDimension() {
        if (!this.getRestrictObjectType().equals((Object)AccessRule.RestrictObjectType.dimension)) {
            return null;
        }
        FmExpression expr = FmExpression.get((FMMDSession)this.m_session, this.getAccessRuleType().getExpression());
        for (Object obj : expr.getComponents()) {
            if (!(obj instanceof FmRelationalDimension)) continue;
            return (FmRelationalDimension)obj;
        }
        return null;
    }

    @Override
    public QueryItem getQueryItem() {
        if (!this.getRestrictObjectType().equals((Object)AccessRule.RestrictObjectType.attribute)) {
            return null;
        }
        FmExpression expr = FmExpression.get((FMMDSession)this.m_session, this.getAccessRuleType().getExpression());
        if (expr != null) {
            for (Object obj : expr.getComponents()) {
                if (!(obj instanceof FmQueryItem)) continue;
                return (FmQueryItem)obj;
            }
        }
        return null;
    }

    @Override
    public boolean getAllAccess() {
        return this.getAccessRuleType().isAllAccess();
    }

    public boolean isGrant() {
        return this.getAccessRuleType().getPermission() == PermissionType.GRANT;
    }

    @Override
    public String getV5Expression(CubeBase cube) {
        if (this.getAccessRuleType().getExpression() != null) {
            FmExpression expr = FmExpression.get((FMMDSession)this.m_session, this.getAccessRuleType().getExpression());
            V5ExpressionHandler handler = new V5ExpressionHandler(cube, this);
            expr.evaluateComponents(handler);
            return handler.getV5Expression();
        }
        return null;
    }

    @Override
    public String getV5Expression(CubeBase cube, RelationalHierarchy hier) {
        if (this.getAccessRuleType().getExpression() != null) {
            FmExpression expr = FmExpression.get((FMMDSession)this.m_session, this.getAccessRuleType().getExpression());
            V5ExpressionHandler handler = new V5ExpressionHandler(cube, hier, this);
            expr.evaluateComponents(handler);
            return handler.getV5Expression();
        }
        return null;
    }

    @Override
    public List<QueryItem> getLevelKeys() {
        if (!this.getRestrictObjectType().equals((Object)AccessRule.RestrictObjectType.member)) {
            FmMDException.ASSERT(this.isMeasureAccess(), "You may not call getLevelKeys for access rule that do not belong to a hierarchy.");
        }
        FmMDException.ASSERT(this.getRuleStyle().equals((Object)AccessRule.RuleStyle.lookupTableBased), "Don't ask for getLevelKeys for access rule of role based type.");
        FmMDException.ASSERT(this.getAccessRuleType().eContainer().eContainer() instanceof RelationalHierarchyType, "Bad ancestor for the rule");
        List<QueryItem> levelKeys = FmRelationalHierarchy.get(this.m_session, this.getAccessRuleType().eContainer().eContainer()).getLevelKeys();
        Set mappedKeys = this.getAccessRuleType().getQueryItemKeyValueMap().keySet();
        ArrayList<EObject> toDelete = new ArrayList<EObject>();
        for (EObject mappedKey : mappedKeys) {
            boolean bFound = false;
            for (QueryItem levelKey : levelKeys) {
                if (!mappedKey.equals(levelKey.getInternal())) continue;
                bFound = true;
                break;
            }
            if (bFound) continue;
            toDelete.add(mappedKey);
        }
        for (EObject mappedKey : toDelete) {
            this.getAccessRuleType().getQueryItemKeyValueMap().remove((Object)mappedKey);
        }
        return levelKeys;
    }

    @Override
    public QueryItem getLevelKeyToQueryItem(QueryItem levelKey) {
        FmMDException.ASSERT(this.getRuleStyle().equals((Object)AccessRule.RuleStyle.lookupTableBased), "Don't ask for getLevelKeytoQueryItem for access rule of role based type.");
        if (levelKey == null) {
            return null;
        }
        QueryItemType qi = (QueryItemType)this.getAccessRuleType().getQueryItemKeyValueMap().get(levelKey.getInternal());
        if (qi == null) {
            return null;
        }
        return FmQueryItem.get(this.m_session, qi);
    }

    @Override
    public void setLevelKeyToQueryItem(QueryItem levelKey, QueryItem item) {
        if (!this.getRestrictObjectType().equals((Object)AccessRule.RestrictObjectType.member)) {
            FmMDException.ASSERT(false, "You can only setLevelKeysToQueryItems for access rule in a hierarchy.");
        }
        FmMDException.ASSERT(this.getRuleStyle().equals((Object)AccessRule.RuleStyle.lookupTableBased), "You cannot setLevelKeysToQueryItems for access rule of role based type.");
        FmMDException.ASSERT(this.getAccessRuleType().eContainer().eContainer() instanceof RelationalHierarchyType, "Bad ancestor for the rule");
        boolean bFound = false;
        for (QueryItem existingLevelKey : FmRelationalHierarchy.get(this.m_session, this.getAccessRuleType().eContainer().eContainer()).getLevelKeys()) {
            if (!existingLevelKey.equals(levelKey)) continue;
            bFound = true;
            break;
        }
        if (!bFound) {
            throw new FmMDException("BMT_MD_INVALID_LEVEL_KEY", levelKey.getName());
        }
        if (item == null) {
            this.getAccessRuleType().getQueryItemKeyValueMap().remove(levelKey.getInternal());
        } else {
            this.getAccessRuleType().getQueryItemKeyValueMap().put((Object)((EObject)levelKey.getInternal()), (Object)((EObject)item.getInternal()));
        }
    }

    public List<QueryItem> getMappedLevelKeys() {
        ArrayList<QueryItem> levelKeys = new ArrayList<QueryItem>();
        for (EObject obj : this.getAccessRuleType().getQueryItemKeyValueMap().keySet()) {
            levelKeys.add(FmQueryItem.get(this.m_session, obj));
        }
        return levelKeys;
    }

    @Override
    public RelationalQuerySubject getFilterQuerySubject() {
        for (EObject value : this.getAccessRuleType().getQueryItemKeyValueMap().values()) {
            if (value == null) continue;
            FmQueryItem qi = FmQueryItem.get(this.m_session, value);
            RelationalObject ro = qi.getRelationalParent();
            FmMDException.ASSERT(ro instanceof RelationalQuerySubject, "Unexpected filter item mapping.");
            return (RelationalQuerySubject)ro;
        }
        return null;
    }

    @Override
    public AccessRule.RuleStyle getRuleStyle() {
        switch (this.getAccessRuleType().getRuleStyle()) {
            case ROLE: {
                return AccessRule.RuleStyle.roleBased;
            }
            case LOOKUP_TABLE: {
                return AccessRule.RuleStyle.lookupTableBased;
            }
        }
        return AccessRule.RuleStyle.roleBased;
    }

    @Override
    public TopLevelObject getTopLevelObject() {
        if (this.isTopLevelObjectAccess()) {
            FmExpression expr = FmExpression.get((FMMDSession)this.m_session, this.getAccessRuleType().getExpression());
            for (Object obj : expr.getComponents()) {
                if (obj instanceof FmMeasure) {
                    return (FmMeasure)obj;
                }
                if (obj instanceof FmCalculatedMember) {
                    return (FmCalculatedMember)obj;
                }
                if (!(obj instanceof FmRelationalDimension)) continue;
                return (FmRelationalDimension)obj;
            }
        }
        return null;
    }

    @Override
    public V5DataItem getV5DataItem(CubeBase cube) {
        V5ExpressionHandler handler = new V5ExpressionHandler(cube, this);
        this.getExpression().evaluateComponents(handler);
        String hierId = null;
        if (this.getParent().getParent() instanceof RelationalHierarchy) {
            hierId = ((RelationalHierarchy)this.getParent().getParent()).getID();
        }
        return V5DataItem.createV5DataItem(V5DataItem.dataItemType.eAccessRole, cube, hierId, this.getName(), handler.getV5Expression());
    }

    @Override
    public boolean isTopLevelObjectAccess() {
        EObject obj = (EObject)this.m_emfObject;
        while (obj != null) {
            if (obj instanceof MeasureDimensionType || obj instanceof Measure) {
                return true;
            }
            if (obj instanceof CubeType) {
                return true;
            }
            obj = obj.eContainer();
        }
        return false;
    }

    @Override
    public Expression getFilterExpression() {
        if (this.getRuleStyle().equals((Object)AccessRule.RuleStyle.roleBased)) {
            return null;
        }
        ExpressionType expression = this.getAccessRuleType().getExpression();
        if (expression == null) {
            return null;
        }
        return FmExpression.get((FMMDSession)this.m_session, expression);
    }

    @Override
    public void setFilterExpression(ExpressionBuilder expr) {
        FmMDException.ASSERT(this.getRuleStyle().equals((Object)AccessRule.RuleStyle.lookupTableBased), "Filter expressions are only applicable for lookup-table based rules.");
        FmExpression fmExp = FmExpression.create((FMMDSession)this.m_session, expr);
        this.getAccessRuleType().setExpression(fmExp.getExpressionType());
    }

    @Override
    public AccessRule.RestrictObjectType getRestrictObjectType() {
        if (this.getRuleStyle().equals((Object)AccessRule.RuleStyle.lookupTableBased)) {
            return AccessRule.RestrictObjectType.member;
        }
        EObject obj = (EObject)this.m_emfObject;
        while (obj != null) {
            if (obj instanceof MeasureDimensionType) {
                return AccessRule.RestrictObjectType.measure;
            }
            if (obj instanceof RelationalHierarchyType) {
                return AccessRule.RestrictObjectType.member;
            }
            if (obj instanceof CubeType) {
                FmExpression expr = FmExpression.get((FMMDSession)this.m_session, this.getAccessRuleType().getExpression());
                for (Object obj2 : expr.getComponents()) {
                    if (obj2 instanceof FmQueryItem) {
                        return AccessRule.RestrictObjectType.attribute;
                    }
                    if (!(obj2 instanceof FmRelationalDimension)) continue;
                    return AccessRule.RestrictObjectType.dimension;
                }
            }
            obj = obj.eContainer();
        }
        FmMDException.ASSERT(false, "Unknown object type for security rule.");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean isEmpty() {
        ExpressionType expr = this.getAccessRuleType().getExpression();
        switch (this.getRestrictObjectType()) {
            case measure: 
            case attribute: 
            case dimension: {
                if (expr == null) {
                    return true;
                }
                EList<EObject> refobjs = expr.getRefobj();
                if (refobjs == null) {
                    return true;
                }
                if (refobjs.size() != 0) return false;
                return true;
            }
            case member: {
                if (this.getAllAccess()) return false;
                if (expr == null) {
                    return true;
                }
                switch (this.getRuleStyle()) {
                    case lookupTableBased: {
                        Collection values = this.getAccessRuleType().getQueryItemKeyValueMap().values();
                        if (values == null) {
                            return true;
                        }
                        if (values.size() == 0) {
                            return true;
                        }
                        boolean hasValues = false;
                        for (EObject value : values) {
                            if (value == null) continue;
                            hasValues = true;
                            break;
                        }
                        if (!hasValues) {
                            return true;
                        }
                    }
                    case roleBased: {
                        FeatureMap fm = expr.getMixed();
                        if (fm == null) {
                            return true;
                        }
                        if (!fm.isEmpty()) return false;
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public String getFilterExpressionText(HashMap<Object, String> idMap) {
        FmMDException.ASSERT(this.getRuleStyle() == AccessRule.RuleStyle.lookupTableBased, "Role-based rules don't have filter expressions.");
        String ruleText = "";
        for (Object obj : this.getExpression().getComponents()) {
            if (obj instanceof FmQueryItem) {
                FmQueryItem qi = (FmQueryItem)obj;
                if (idMap == null) {
                    ruleText = String.valueOf(ruleText) + qi.getID();
                    continue;
                }
                ruleText = String.valueOf(ruleText) + idMap.get(qi.getInternal());
                continue;
            }
            if (obj instanceof String) {
                ruleText = String.valueOf(ruleText) + (String)obj;
                continue;
            }
            FmMDException.ASSERT(false, "Unexpected object in filter expression: " + obj.getClass().toString());
        }
        return ruleText;
    }
}

