/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmAccessRule;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveListener;
import com.ibm.cognos.fmeng.fmmd.model.AccessRule;
import com.ibm.cognos.fmeng.fmmd.model.AccessView;
import com.ibm.cognos.fmeng.genmodel.AccessViewType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.RuleStyleType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmAccessView
extends FmModelObject
implements AccessView {
    FmAccessView(FMMDSession session, Object emfObject) {
        super(session, emfObject);
    }

    public static FmAccessView get(FMMDSession session, Object object) {
        return new FmAccessView(session, (AccessViewType)object);
    }

    protected static AccessView createAccessView(FMMDSession session, FmCube parent, String objectName, AccessRule.RuleStyle style) {
        if (parent.isAggregateCube()) {
            throw new FmMDException("BMT_MD_AGGREGATE_CUBES_MAY_NOT_HAVE_ACCESS_VIEWS");
        }
        if (objectName == null || objectName.length() == 0) {
            objectName = FmAccessView.getDefaultName(session.getActiveLocale());
        }
        AccessViewType emfObj = GenmodelFactory.eINSTANCE.createAccessViewType();
        FmAccessView fav = new FmAccessView(session, emfObj);
        parent.addAccessView(fav);
        String uniqueName = fav.makeUniqueName(objectName);
        fav.setName(uniqueName);
        switch (style) {
            case roleBased: {
                fav.getAccessViewType().setRuleStyle(RuleStyleType.ROLE);
                break;
            }
            case lookupTableBased: {
                fav.getAccessViewType().setRuleStyle(RuleStyleType.LOOKUP_TABLE);
            }
        }
        return fav;
    }

    public static String getDefaultName(Locale locale) {
        return FmMessage.render("BMT_MDN_OBJECT_NAME_ACCESS_VIEW", locale);
    }

    @Override
    public FmObjectType getFmObjectType() {
        return FmObjectType.accessView;
    }

    AccessViewType getAccessViewType() {
        return (AccessViewType)this.m_emfObject;
    }

    @Override
    void addChild(Object eObj) {
        switch (this.m_session.getGateway().getClassifierType(eObj)) {
            case 5: {
                this.getAccessViewType().getRefobj().add((Object)((AccessViewType)eObj));
                return;
            }
        }
        super.addChild(eObj);
    }

    @Override
    void prepareForObjectDeletion(RemoveInfo info, FmBaseObject object, RemoveListener listener) {
        if (object instanceof FmAccessRule) {
            this.getAccessViewType().getRefobj().remove(object.getInternal());
        }
        if (this.equals(object) && this.getSession().getClientType().equals((Object)FMMDSession.ClientType.CubeDesigner)) {
            ArrayList<AccessRule> rulesToDelete = new ArrayList<AccessRule>();
            for (AccessRule rule : this.getAccessRules()) {
                switch (rule.getRestrictObjectType()) {
                    case measure: 
                    case attribute: 
                    case dimension: {
                        rulesToDelete.add(rule);
                    }
                }
            }
            this.getSession().delete(rulesToDelete);
        }
    }

    @Override
    public void addAccessRule(AccessRule ar) {
        this.getAccessViewType().getRefobj().add((Object)((EObject)((FmAccessRule)ar).getInternal()));
    }

    @Override
    public List<AccessRule> getAccessRules() {
        ArrayList<AccessRule> results = new ArrayList<AccessRule>();
        for (EObject refObj : this.getAccessViewType().getRefobj()) {
            results.add(FmAccessRule.get(this.m_session, refObj));
        }
        return results;
    }

    @Override
    public void removeAccessRule(AccessRule accessRule) {
        this.getAccessViewType().getRefobj().remove(accessRule.getInternal());
    }

    @Override
    public boolean getGrantAllMeasures() {
        return this.getAccessViewType().isGrantAllMeasures();
    }

    @Override
    public void setGrantAllMeasures(boolean grantAllMeasures) {
        this.getAccessViewType().setGrantAllMeasures(grantAllMeasures);
    }

    @Override
    public AccessRule.RuleStyle getRuleStyle() {
        switch (this.getAccessViewType().getRuleStyle()) {
            case ROLE: {
                return AccessRule.RuleStyle.roleBased;
            }
            case LOOKUP_TABLE: {
                return AccessRule.RuleStyle.lookupTableBased;
            }
        }
        return AccessRule.RuleStyle.roleBased;
    }
}

