/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.AggregateRuleParentInternal;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmComplexProperty;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasure;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasureDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.model.AggregateRule;
import com.ibm.cognos.fmeng.fmmd.model.Dimension;
import com.ibm.cognos.fmeng.fmmd.model.DimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.SemiAggregate;
import com.ibm.cognos.fmeng.genmodel.AggregateRuleType;
import com.ibm.cognos.fmeng.genmodel.ApplyAggregateType;
import com.ibm.cognos.fmeng.genmodel.CubeType;
import com.ibm.cognos.fmeng.genmodel.DimensionType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.MeasureDimensionType;
import com.ibm.cognos.fmeng.genmodel.MeasureType;
import com.ibm.cognos.fmeng.genmodel.NamespaceType;
import com.ibm.cognos.fmeng.genmodel.RelationalDimensionType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmAggregateRule
extends FmComplexProperty
implements AggregateRule {
    private FmAggregateRule(FMMDSession session, Object emfObject) {
        super(session, emfObject);
    }

    public static FmAggregateRule create(EMFSession session, AggregateRuleParentInternal measure, SemiAggregate value) {
        return FmAggregateRule.create(session, measure, null, value);
    }

    public static FmAggregateRule create(EMFSession session, AggregateRuleParentInternal measure, Dimension objDimRef, SemiAggregate value) {
        FmAggregateRule.removeOldDimensionRef(measure, objDimRef);
        FmAggregateRule.validateDimensionRef(measure, objDimRef);
        return FmAggregateRule.create(session, measure, (EObject)objDimRef.getInternal(), value);
    }

    public static FmAggregateRule create(EMFSession session, AggregateRuleParentInternal measure, RelationalDimension objDimRef, SemiAggregate value) {
        EObject parent;
        boolean bFound = false;
        FmMeasureDimension measDim = null;
        if (measure instanceof FmMeasure) {
            parent = (EObject)((FmReportObject)((Object)measure)).getInternal();
            while (parent != null) {
                if (parent instanceof MeasureDimensionType) {
                    measDim = FmMeasureDimension.get(session, parent);
                    for (RelationalDimensionBase relationalDimensionBase : measDim.getRelatedDimensions()) {
                        if (!relationalDimensionBase.equals(objDimRef)) continue;
                        bFound = true;
                        break;
                    }
                    if (bFound) break;
                }
                parent = parent.eContainer();
            }
        }
        FmMDException.ASSERT(measDim != null, "Unsupported container for measures");
        if (!bFound) {
            parent = (EObject)((FmReportObject)((Object)measure)).getInternal();
            while (parent != null) {
                if (parent instanceof NamespaceType) {
                    throw new FmMDException("BMT_MD_DIMENSION_NOT_IN_DMR_FOR_APPLY_AGGREGATE", objDimRef.getName(), measDim.getName());
                }
                if (parent instanceof CubeType) {
                    FmCube fmCube = FmCube.get(session, parent);
                    throw new FmMDException("BMT_MD_DIMENSION_NOT_IN_CUBE_FOR_APPLY_AGGREGATE", objDimRef.getName(), fmCube.getName());
                }
                parent = parent.eContainer();
            }
        }
        FmAggregateRule.removeOldDimensionRef(measure, objDimRef);
        FmAggregateRule.validateDimensionRef(measure, objDimRef);
        return FmAggregateRule.create(session, measure, (EObject)objDimRef.getInternal(), value);
    }

    private static void removeOldDimensionRef(AggregateRuleParentInternal measure, DimensionBase objDimRef) {
        AggregateRule oldRule = measure.findAggregateRule(objDimRef);
        if (oldRule != null) {
            oldRule.removeDimensionRef(objDimRef);
            if (oldRule.getDimensionRefs().size() == 0) {
                measure.removeAggregateRule(oldRule);
            }
        }
    }

    private static void validateDimensionRef(AggregateRuleParentInternal measure, DimensionBase dim) {
        if (measure.findAggregateRule(dim) != null) {
            throw new FmMDException("BMT_MD_DIMENSION_ALREADY_REFERENCED", dim.getName());
        }
        if (dim.getDimensionStyle() == DimensionBase.DimensionStyle.measure) {
            throw new FmMDException("BMT_MD_INVALID_DIMENSION_REFERENCE");
        }
    }

    private static FmAggregateRule create(EMFSession session, AggregateRuleParentInternal measure, EObject dim, SemiAggregate value) {
        AggregateRuleType emfObj = GenmodelFactory.eINSTANCE.createAggregateRuleType();
        emfObj.setApplyAggregate(ApplyAggregateType.get(value.toString()));
        if (dim != null) {
            emfObj.getDimensionRef().add((Object)dim);
        }
        FmAggregateRule rule = new FmAggregateRule(session, emfObj);
        measure.addAggregateRule(rule);
        return rule;
    }

    static FmAggregateRule get(EMFSession session, Object ar) {
        FmMDException.ASSERT(ar != null && ar instanceof AggregateRuleType, "Expected aggregate rule type");
        return new FmAggregateRule(session, ar);
    }

    AggregateRuleType getAggregateRuleType() {
        return (AggregateRuleType)this.m_emfObject;
    }

    @Override
    public DimensionBase getDimensionBaseRef() {
        EList<EObject> dims = this.getAggregateRuleType().getDimensionRef();
        if (dims.size() == 0) {
            return null;
        }
        if (dims.get(0) instanceof DimensionType) {
            return FmDimension.get(this.m_session, dims.get(0));
        }
        if (dims.get(0) instanceof RelationalDimensionType) {
            return FmRelationalDimension.get(this.m_session, dims.get(0));
        }
        FmMDException.ASSERT(false, "Unexpected type for aggregate rule.");
        return null;
    }

    @Override
    public SemiAggregate getApplyAggregate() {
        return SemiAggregate.valueOf(this.getAggregateRuleType().getApplyAggregate().toString());
    }

    @Override
    public void addDimensionRef(DimensionBase dim) {
        FmMeasure measure = null;
        AggregateRuleType obj = this.getAggregateRuleType();
        while (obj != null) {
            if (obj instanceof MeasureType) {
                measure = FmMeasure.get(this.m_session, obj);
                break;
            }
            obj = obj.eContainer();
        }
        FmAggregateRule.removeOldDimensionRef(measure, dim);
        FmAggregateRule.validateDimensionRef(measure, dim);
        this.getAggregateRuleType().getDimensionRef().add((Object)((EObject)dim.getInternal()));
    }

    @Override
    public List<DimensionBase> getDimensionRefs() {
        ArrayList<DimensionBase> dims = new ArrayList<DimensionBase>();
        for (EObject obj : this.getAggregateRuleType().getDimensionRef()) {
            if (obj instanceof DimensionType) {
                dims.add(FmDimension.get(this.m_session, obj));
            }
            if (!(obj instanceof RelationalDimensionType)) continue;
            dims.add(FmRelationalDimension.get(this.m_session, obj));
        }
        return dims;
    }

    @Override
    public void removeDimensionRef(DimensionBase dim) {
        this.getAggregateRuleType().getDimensionRef().remove(dim.getInternal());
    }
}

