/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmComplexProperty;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmJoin;
import com.ibm.cognos.fmeng.fmmd.model.Association;
import com.ibm.cognos.fmeng.genmodel.AssociationType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.OperatorType;
import com.ibm.cognos.fmeng.platform.FMMDSession;

public class FmAssociation
extends FmComplexProperty
implements Association {
    FmAssociation(FMMDSession session, AssociationType emfObject) {
        super(session, emfObject);
    }

    public static Association get(FMMDSession session, AssociationType emfObject) {
        return new FmAssociation(session, emfObject);
    }

    public static FmAssociation createAssociation(FMMDSession session, FmJoin parent, String leftColumn, String rightColumn, Association.EOperator operator) {
        AssociationType associationType = GenmodelFactory.eINSTANCE.createAssociationType();
        associationType.setLeftColumnName(leftColumn);
        associationType.setRightColumnName(rightColumn);
        FmAssociation association = new FmAssociation(session, associationType);
        association.setOperator(operator);
        parent.addAssociation(association);
        return association;
    }

    protected AssociationType getAssociationType() {
        return (AssociationType)this.m_emfObject;
    }

    public String getLeftColumn() {
        return this.getAssociationType().getLeftColumnName();
    }

    public String getRightColumn() {
        return this.getAssociationType().getRightColumnName();
    }

    public Association.EOperator getOperator() {
        switch (this.getAssociationType().getOperator()) {
            case NONE: {
                return Association.EOperator.none;
            }
            case NOT_EQUALS: {
                return Association.EOperator.notEquals;
            }
            case GREATER_THAN: {
                return Association.EOperator.greaterThan;
            }
            case LESS_THAN: {
                return Association.EOperator.lessThan;
            }
            case GREATER_THAN_OR_EQUALS: {
                return Association.EOperator.greaterThanOrEquals;
            }
            case LESS_THAN_OR_EQUALS: {
                return Association.EOperator.lessThanOrEquals;
            }
        }
        return Association.EOperator.equals;
    }

    public String getOperatorAsString() {
        return FmAssociation.getOperatorAsString(this.getOperator());
    }

    public void setOperator(Association.EOperator operator) {
        switch (operator) {
            case none: {
                this.getAssociationType().setOperator(OperatorType.NONE);
                break;
            }
            case notEquals: {
                this.getAssociationType().setOperator(OperatorType.NOT_EQUALS);
                break;
            }
            case greaterThan: {
                this.getAssociationType().setOperator(OperatorType.GREATER_THAN);
                break;
            }
            case lessThan: {
                this.getAssociationType().setOperator(OperatorType.LESS_THAN);
                break;
            }
            case greaterThanOrEquals: {
                this.getAssociationType().setOperator(OperatorType.GREATER_THAN_OR_EQUALS);
                break;
            }
            case lessThanOrEquals: {
                this.getAssociationType().setOperator(OperatorType.LESS_THAN_OR_EQUALS);
                break;
            }
            default: {
                this.getAssociationType().setOperator(OperatorType.EQUALS);
            }
        }
    }

    public static String getOperatorAsString(Association.EOperator operator) {
        switch (operator) {
            case none: {
                return "";
            }
            case notEquals: {
                return "!=";
            }
            case greaterThan: {
                return ">";
            }
            case lessThan: {
                return "<";
            }
            case greaterThanOrEquals: {
                return ">=";
            }
            case lessThanOrEquals: {
                return "<=";
            }
        }
        return "=";
    }

    public void remove() {
        this.m_session.getGateway().delete(this.getAssociationType());
    }
}

