/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmNamespace;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmProject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSection;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.MoveListener;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveListener;
import com.ibm.cognos.fmeng.fmmd.impl.task.FmCopyManager;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.Copyable;
import com.ibm.cognos.fmeng.fmmd.model.Cube;
import com.ibm.cognos.fmeng.fmmd.model.CubeBase;
import com.ibm.cognos.fmeng.fmmd.model.Project;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.genmodel.AggregateCubesType;
import com.ibm.cognos.fmeng.genmodel.CubeType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.GenmodelPackage;
import com.ibm.cognos.fmeng.genmodel.NamespaceType;
import com.ibm.cognos.fmeng.genmodel.SectionType;
import com.ibm.cognos.fmeng.genmodel.VirtualCubeType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FmBaseObject
implements BaseObject {
    protected EMFSession m_session = null;
    protected Object m_emfObject = null;
    protected static final Pattern m_nameMatcher = Pattern.compile("\\s+");

    FmBaseObject(FMMDSession session, Object emfObject) {
        this.m_session = (EMFSession)session;
        this.m_emfObject = emfObject;
    }

    @Override
    public FMMDSession getSession() {
        return this.m_session;
    }

    @Override
    public List<BaseObject> getChildObjects() {
        ArrayList<BaseObject> fmChildren = new ArrayList<BaseObject>();
        List<?> children = this.m_session.getGateway().getChildren(this.m_emfObject);
        for (Object child : children) {
            TopLevelObject fmChild = FmModelFactory.getInstance().get(this.m_session, child);
            if (fmChild == null) continue;
            fmChildren.add(fmChild);
        }
        return fmChildren;
    }

    @Override
    public List<BaseObject> getDescendantObjects() {
        ArrayList<BaseObject> fmChildren = new ArrayList<BaseObject>();
        TreeIterator allContents = ((EObject)this.m_emfObject).eAllContents();
        while (allContents.hasNext()) {
            EObject child = (EObject)allContents.next();
            TopLevelObject fmChild = FmModelFactory.getInstance().get(this.m_session, child);
            if (fmChild == null) continue;
            fmChildren.add(fmChild);
        }
        return fmChildren;
    }

    @Override
    public boolean hasChildren() {
        List<BaseObject> children = this.getChildObjects();
        int i = 0;
        while (i < children.size()) {
            boolean isSourceObject;
            BaseObject ro = children.get(i);
            boolean bl = isSourceObject = ro.getFmObjectType().equals((Object)FmObjectType.sourceObjects) || ro.getFmObjectType().equals((Object)FmObjectType.sourceObject);
            if (!isSourceObject) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public BaseObject getPreviousSibling() {
        BaseObject parent = this.getParent();
        List<BaseObject> children = parent.getChildObjects();
        int i = 0;
        while (i < children.size()) {
            if (children.get(i).equals(this)) {
                if (i == 0) {
                    return null;
                }
                return children.get(i - 1);
            }
            ++i;
        }
        return null;
    }

    @Override
    public BaseObject getNextSibling() {
        BaseObject parent = this.getParent();
        List<BaseObject> children = parent.getChildObjects();
        int i = 0;
        while (i < children.size()) {
            if (children.get(i).equals(this)) {
                if (i + 1 == children.size()) {
                    return null;
                }
                return children.get(i + 1);
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof FmBaseObject && this.m_emfObject == ((FmBaseObject)obj).m_emfObject;
    }

    @Override
    public int hashCode() {
        return this.m_emfObject.hashCode();
    }

    public void reorderBefore(List<? extends BaseObject> reorderObjs, BaseObject hReferenceObj) {
        this.verifyReorderBefore(reorderObjs, hReferenceObj);
        Object reference = null;
        if (hReferenceObj != null) {
            reference = ((FmBaseObject)hReferenceObj).getInternal();
        }
        for (BaseObject baseObject : reorderObjs) {
            this.m_session.getGateway().reorderBefore(this.getInternal(), ((FmBaseObject)baseObject).getInternal(), reference);
            this.m_session.getCubeSynchronizer().synchReorderObject((EObject)this.getInternal(), (EObject)baseObject.getInternal(), (EObject)reference);
        }
    }

    @Override
    public void reorderBefore(BaseObject reorderObj, BaseObject hReferenceObj) {
        this.verifyReorderBefore(reorderObj, hReferenceObj);
        Object reference = null;
        if (hReferenceObj != null) {
            reference = ((FmBaseObject)hReferenceObj).getInternal();
        }
        this.m_session.getGateway().reorderBefore(this.getInternal(), ((FmBaseObject)reorderObj).getInternal(), reference);
        this.m_session.getCubeSynchronizer().synchReorderObject((EObject)this.getInternal(), (EObject)reorderObj.getInternal(), (EObject)reference);
    }

    void verifyReorderBefore(List<? extends BaseObject> rReorderObjs, BaseObject hReferenceObj) {
        if (hReferenceObj != null && !this.equals(hReferenceObj.getParent())) {
            FmMDException exc = new FmMDException("BMT_MD_INVALID_PARAMETER");
            throw exc;
        }
    }

    void verifyReorderBefore(BaseObject hReorderObj, BaseObject hReferenceObj) {
        if (hReferenceObj != null && !this.equals(hReferenceObj.getParent()) && !this.equals(hReorderObj.getParent())) {
            FmMDException exc = new FmMDException("BMT_MD_INVALID_PARAMETER");
            throw exc;
        }
    }

    @Override
    public abstract FmObjectType getFmObjectType();

    @Override
    public String getLocalizedType() {
        return FmMessage.render("BMT_PRP_" + this.getFmObjectTypeName() + "ID", this.m_session.getActiveLocale());
    }

    @Override
    public boolean canDelete() {
        return true;
    }

    @Override
    public String makeChildUniqueName(String suggestedName, FmObjectType objectType, BaseObject.PrefixName uniqueNameSpec, BaseObject ignore) {
        String id;
        String localeKey = this.getProject().getDefaultLocale();
        Matcher m = m_nameMatcher.matcher(suggestedName);
        String value = m.replaceAll(" ");
        String uName = suggestedName = value.trim();
        int seqNo = 0;
        if (uniqueNameSpec == BaseObject.PrefixName.kShortcutCreatePrefixAlways) {
            uName = FmMessage.render("BMT_MDV_UNIQUE_OBJECT_NAME_SPEC_SHORTCUT", localeKey, suggestedName);
            seqNo = 1;
        }
        FmMDException.ASSERT((id = this.m_session.getGateway().generateIDUsingName(this.m_emfObject, objectType, uName)) != null, "ID generation not supported for objects of type: " + objectType.toString());
        Object foundObject = this.m_session.getObjectById(id, ignore == null ? null : ignore.getInternal());
        while (foundObject != null) {
            uName = uniqueNameSpec == BaseObject.PrefixName.kCopy ? (seqNo == 1 ? FmMessage.render("BMT_MDV_UNIQUE_OBJECT_NAME_SPEC_COPY", localeKey, suggestedName) : FmMessage.render("BMT_MDV_UNIQUE_OBJECT_NAME_SPEC_COPY_SEQUENCENUMBER", localeKey, suggestedName, Integer.toString(seqNo).toString())) : (uniqueNameSpec == BaseObject.PrefixName.kShortcutCreatePrefixAlways ? FmMessage.render("BMT_MDV_UNIQUE_OBJECT_NAME_SPEC_SHORTCUT_SEQUENCENUMBER", localeKey, suggestedName, Integer.toString(seqNo).toString()) : (uniqueNameSpec == BaseObject.PrefixName.kShortcutCreatePrefixAsNeeded ? (seqNo == 1 ? FmMessage.render("BMT_MDV_UNIQUE_OBJECT_NAME_SPEC_SHORTCUT", localeKey, suggestedName) : FmMessage.render("BMT_MDV_UNIQUE_OBJECT_NAME_SPEC_SHORTCUT_SEQUENCENUMBER", localeKey, suggestedName, Integer.toString(seqNo).toString())) : String.valueOf(suggestedName) + Integer.toString(++seqNo)));
            id = this.m_session.getGateway().generateIDUsingName(this.m_emfObject, objectType, uName);
            foundObject = this.m_session.getObjectById(id);
        }
        return uName;
    }

    @Override
    public abstract String getName();

    @Override
    public String getID() {
        return this.m_session.getGateway().getID(this.m_emfObject);
    }

    @Override
    public final Object getInternal() {
        return this.m_emfObject;
    }

    @Override
    public boolean isAncestor(BaseObject obj2) {
        return this.m_session.getGateway().isAncestor(this.m_emfObject, ((FmBaseObject)obj2).m_emfObject);
    }

    @Override
    public Project getProject() {
        return this.m_session.getProject(this);
    }

    public FmProject getFmProject() {
        return (FmProject)this.getProject();
    }

    public String generateUniqueName(String suggestedName, EObject obj) {
        FmObjectType objectType = FmObjectType.getType(obj);
        if (objectType == FmObjectType.unknown) {
            return suggestedName;
        }
        if (suggestedName == null || "".equals(suggestedName)) {
            suggestedName = objectType.getDefaultName(this.m_session.getActiveLocale());
        }
        return this.makeChildUniqueName(suggestedName, objectType, BaseObject.PrefixName.kStandard, null);
    }

    @Override
    public String makeUniqueName(String name) {
        return this.getParent().makeChildUniqueName(name, this.getFmObjectType(), BaseObject.PrefixName.kStandard, this);
    }

    protected String makeUniqueName(String name, BaseObject.PrefixName prefix) {
        return this.getParent().makeChildUniqueName(name, this.getFmObjectType(), prefix, this);
    }

    public void postCopyAdoption(FmBaseObject parentObject) {
        FmMDException.ASSERT(false, "Unsupported copy");
    }

    public void moveObject(FmBaseObject targetParent, MoveListener listener) {
        if (targetParent instanceof FmSection) {
            EObject targetEObject = (EObject)((FmSection)targetParent).m_emfObject;
            SectionType sectionType = (SectionType)this.m_session.getGateway().resolveProxy(targetEObject);
            FeatureMap group = sectionType.getGroup();
            if (group.isEmpty()) {
                SectionType tmp = GenmodelFactory.eINSTANCE.createSectionType();
                FeatureMap.Entry tmpEntry = FeatureMapUtil.createEntry((EStructuralFeature)GenmodelPackage.eINSTANCE.getSectionType_Folder(), (Object)tmp);
                group.add((Object)tmpEntry);
                targetParent.addChild(this.m_emfObject);
                group.remove((Object)tmpEntry);
                return;
            }
        }
        targetParent.addChild(this.m_emfObject);
    }

    @Override
    public BaseObject getCommonParent(BaseObject obj) {
        Object common = this.m_session.getGateway().getCommonAncestor(this.getInternal(), ((FmBaseObject)obj).getInternal());
        return FmModelFactory.getInstance().get(this.m_session, common);
    }

    @Override
    public BaseObject getParent() {
        Object parent = this.m_session.getGateway().getParent(this.m_emfObject);
        if (parent != null) {
            return FmModelFactory.getInstance().get(this.m_session, parent);
        }
        return null;
    }

    public Cube getAncestorCube() {
        Object parent = this.m_session.getGateway().getParent(this.m_emfObject);
        while (parent != null) {
            if (parent instanceof CubeType) {
                return FmCube.get(this.m_session, parent);
            }
            parent = this.m_session.getGateway().getParent(parent);
        }
        return null;
    }

    public CubeBase getAncestorCubeOrVirtual() {
        Object parent = this.m_session.getGateway().getParent(this.m_emfObject);
        while (parent != null) {
            if (parent instanceof CubeType) {
                return FmCube.get(this.m_session, parent);
            }
            if (parent instanceof VirtualCubeType) {
                return FmVirtualCube.get(this.m_session, parent);
            }
            parent = this.m_session.getGateway().getParent(parent);
        }
        return null;
    }

    void addChild(Object emfObject) {
        Object[] args = new Object[]{this.getLocalizedType()};
        FmMDException exc = new FmMDException("BMT_MD_COPY_INVALID_TARGET", args);
        throw exc;
    }

    @Override
    public FmNamespace getParentNamespace() {
        BaseObject parent = this.getParent();
        while (parent != null) {
            if (parent instanceof FmNamespace) {
                return (FmNamespace)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    protected String fixupName(String nameValue) {
        Matcher m = m_nameMatcher.matcher(nameValue);
        String value = m.replaceAll(" ");
        if ((value = value.trim()).isEmpty()) {
            throw new FmMDException("BMT_MD_EMPTY_ID_ENTRY");
        }
        return value;
    }

    void validateNameUnique(String name) {
        StringBuffer type = new StringBuffer();
        if (!this.isNameUnique(name, type)) {
            FmNamespace parentNamespace = this.getParentNamespace();
            if (parentNamespace == null || parentNamespace.equals(this)) {
                Object[] msgParams = new Object[]{type, name};
                throw new FmMDException("BMT_MD_DUPLICATE_NAMESPACE_NAME", msgParams);
            }
            ((FmBaseObject)this.getParent()).renderNameUniqueMessage(name, type.toString());
        }
    }

    void renderNameUniqueMessage(String name, String type) {
        String localeKey = FmModelFactory.getInstance().getProject(this.m_session).getDefaultLocale();
        FmReportObject parentObj = null;
        FmBaseObject potentialParent = this;
        while (potentialParent != null) {
            if (potentialParent instanceof FmReportObject) {
                parentObj = (FmReportObject)potentialParent;
                break;
            }
            potentialParent = (FmBaseObject)potentialParent.getParent();
        }
        FmMDException.ASSERT(parentObj != null, "Bad parent");
        Object[] msgNSParams = new Object[]{type, name, parentObj.getLocalizedType(), parentObj.getName(localeKey)};
        throw new FmMDException("BMT_MD_DUPLICATE_OBJECT_NAME_WITHIN_NAMESPACE", msgNSParams);
    }

    boolean isNameUnique(String name, StringBuffer type) {
        boolean isUnique;
        String id = this.m_session.getGateway().generateID(this.m_emfObject, name);
        Object foundObject = this.m_session.getObjectById(id);
        boolean bl = isUnique = foundObject == null || foundObject.equals(this.getInternal());
        if (!isUnique) {
            String foundObjectType = FmModelFactory.getInstance().get(this.m_session, foundObject).getLocalizedType();
            type.append(foundObjectType);
        }
        return isUnique;
    }

    void prepareForObjectDeletion(RemoveInfo info, FmBaseObject object, RemoveListener listener) {
        List<BaseObject> children = this.getChildObjects();
        for (BaseObject oChild : children) {
            FmBaseObject child = (FmBaseObject)oChild;
            if (info.isRemoved(child)) continue;
            child.prepareForObjectDeletion(info, object, listener);
        }
    }

    @Override
    public Set<BaseObject> getReferencedObjects() {
        HashSet<BaseObject> set = new HashSet<BaseObject>();
        this.getReferencedObjects(set);
        return set;
    }

    public void getReferencedObjects(Set<BaseObject> set) {
    }

    @Override
    public void getReferencingObjects(Collection<BaseObject> collection) {
        ((FmProject)this.getProject()).getReferencesTo(this, collection);
    }

    protected void getReferencesTo(FmBaseObject ref, Collection<FmBaseObject> collection) {
        if (this.hasReferenceTo(ref)) {
            collection.add(this);
        }
        List<BaseObject> children = this.getChildObjects();
        for (BaseObject child : children) {
            ((FmBaseObject)child).getReferencesTo(ref, collection);
        }
    }

    private boolean hasReferenceTo(BaseObject object) {
        HashSet<BaseObject> set = new HashSet<BaseObject>();
        this.getReferencedObjects(set);
        return set.contains(object);
    }

    public final void remove(RemoveListener listener) {
        RemoveInfo info = new RemoveInfo();
        this.remove(info, listener);
    }

    protected void remove(RemoveInfo info, RemoveListener listener) {
        if (!this.canDelete()) {
            FmMDException exc = new FmMDException();
            Object[] msgParams = new Object[]{this.getLocalizedType(), this.getID()};
            FmMessage msg = new FmMessage("BMT_MD_INVALID_DELETE_OBJECT", msgParams);
            exc.addMessage(msg);
            listener.reportError(exc);
        }
        ((FmProject)this.getProject()).prepareForObjectDeletion(info, this, listener);
        info.markAsDeletion(this);
        listener.explicitDeletion(this);
        List<BaseObject> children = this.getChildObjects();
        for (BaseObject child : children) {
            ((FmBaseObject)child).remove(info, listener);
        }
        this.m_session.getGateway().delete(this.getInternal());
    }

    @Override
    public final boolean isValid() {
        return this.m_session.getGateway().isValid(this.m_emfObject);
    }

    protected static void validateEMFBaseObject(Object emfobj, Class<?> expectedClass) {
        if (emfobj == null) {
            Object[] msgNSParams = new Object[4];
            msgNSParams[0] = "(null)";
            msgNSParams[1] = expectedClass.getName();
            throw new FmMDException("BMT_MD_INVALID_OBJECT_TYPE2", msgNSParams);
        }
        if (!expectedClass.isInstance(emfobj)) {
            Object[] msgNSParams = new Object[4];
            msgNSParams[0] = emfobj.toString();
            msgNSParams[1] = expectedClass.getName();
            throw new FmMDException("BMT_MD_INVALID_OBJECT_TYPE2", msgNSParams);
        }
    }

    @Override
    public String asXML() {
        return this.m_session.getGateway().asXML(this.m_emfObject, true);
    }

    public List<BaseObject> copy(List<Copyable> toCopy) {
        return FmCopyManager.copy((FMMDSession)this.m_session, (BaseObject)this, toCopy);
    }

    public boolean canContain(BaseObject potentialChild) {
        return this.m_session.getGateway().canContain(this.getInternal(), potentialChild.getInternal());
    }

    public String toString() {
        if (this.m_session.getGateway().isValid(this.m_emfObject)) {
            return this.getID();
        }
        return String.valueOf(super.toString()) + " " + this.m_emfObject.toString();
    }

    @Override
    public String getFmObjectTypeName() {
        return this.getFmObjectType().toString();
    }

    protected boolean isInAggregateCube() {
        EObject parentObj = (EObject)this.getInternal();
        while (parentObj != null) {
            if (parentObj instanceof CubeType) {
                CubeType cubeType = (CubeType)parentObj;
                return cubeType.eContainer() instanceof AggregateCubesType;
            }
            if (parentObj instanceof NamespaceType) {
                return false;
            }
            parentObj = parentObj.eContainer();
        }
        return false;
    }
}

