/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.CalculatedMemberParentInternal;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmExpression;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasureDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasureFolder;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMemberUniqueName;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalQuerySubject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualMeasureDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.MoveListener;
import com.ibm.cognos.fmeng.fmmd.impl.model.V5ExpressionHandler;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.BuilderFactory;
import com.ibm.cognos.fmeng.fmmd.model.CalculatedMember;
import com.ibm.cognos.fmeng.fmmd.model.CubeBase;
import com.ibm.cognos.fmeng.fmmd.model.DimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.FmRegularAggregate;
import com.ibm.cognos.fmeng.fmmd.model.Format;
import com.ibm.cognos.fmeng.fmmd.model.HierarchyBase;
import com.ibm.cognos.fmeng.fmmd.model.MDXExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.MemberUniqueName;
import com.ibm.cognos.fmeng.fmmd.model.MemberUniqueNameBuilder;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.fmmd.model.V5Query;
import com.ibm.cognos.fmeng.fmmd.util.FmFormatGroup;
import com.ibm.cognos.fmeng.fmmd.util.FmMemberUniqueNameBuilder;
import com.ibm.cognos.fmeng.genmodel.CalculatedMemberType;
import com.ibm.cognos.fmeng.genmodel.CalculatedMembersType;
import com.ibm.cognos.fmeng.genmodel.ExpressionType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.MeasureDimensionType;
import com.ibm.cognos.fmeng.genmodel.MunType;
import com.ibm.cognos.fmeng.genmodel.RegularAggregateType;
import com.ibm.cognos.fmeng.genmodel.RelationalDimensionType;
import com.ibm.cognos.fmeng.genmodel.RelationalHierarchyType;
import com.ibm.cognos.fmeng.genmodel.RelationalQuerySubjectType;
import com.ibm.cognos.fmeng.genmodel.VirtualHierarchyType;
import com.ibm.cognos.fmeng.genmodel.VirtualMeasureDimensionType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import com.ibm.cognos.fmeng.utility.V5DataItem;
import java.math.BigInteger;
import java.util.Locale;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class FmCalculatedMember
extends FmReportObject
implements CalculatedMember,
V5Query {
    public static FmCalculatedMember createCalculatedMember(FMMDSession session, CalculatedMemberParentInternal parent, String objectName) {
        if (objectName == null || objectName.length() == 0) {
            objectName = FmCalculatedMember.getDefaultName(session.getActiveLocale());
        }
        CalculatedMemberType emfObj = GenmodelFactory.eINSTANCE.createCalculatedMemberType();
        FmCalculatedMember calc = new FmCalculatedMember(session, emfObj);
        parent.addCalculatedMember(calc);
        String uniqueName = calc.makeUniqueName(objectName);
        calc.setName(FmModelFactory.getInstance().getProject(session).getDefaultLocale(), uniqueName);
        if (parent instanceof FmVirtualHierarchy) {
            calc.setParentMember(null);
        } else if (calc.isCalculatedMeasure()) {
            calc.setRegularAggregate(FmRegularAggregate.calculated);
        } else {
            MemberUniqueNameBuilder parentMunBuilder = BuilderFactory.createMemberUniqueNameBuilder();
            if (!((FmRelationalHierarchy)parent).isMultiRoot()) {
                parentMunBuilder.setMember(((FmRelationalHierarchy)parent).getAllLevel(), "[" + ((FmRelationalHierarchy)parent).getRootMember() + "]", ((FmRelationalHierarchy)parent).getRootCaption());
                calc.setParentMember(parentMunBuilder);
            } else {
                FmMemberUniqueName defaultMemUniqName = (FmMemberUniqueName)((FmRelationalHierarchy)parent).getDefaultMemberUniqueName();
                if (defaultMemUniqName != null) {
                    FmMemberUniqueName copyOfdefaultMemUniqName = ((FmMemberUniqueNameBuilder)parentMunBuilder).copyMemberUniqueName(defaultMemUniqName, session);
                    calc.getCalculatedMemberType().setParentMember(copyOfdefaultMemUniqName.getMemberUniqueNameType());
                } else {
                    calc.setParentMember(null);
                }
            }
        }
        return calc;
    }

    public static FmCalculatedMember get(FMMDSession session, Object object) {
        return new FmCalculatedMember(session, object);
    }

    public static String getDefaultName(Locale locale) {
        return FmMessage.render("BMT_MDN_OBJECT_NAME_CALCULATED_MEMBER", locale);
    }

    FmCalculatedMember(FMMDSession session, Object emfObject) {
        super(session, emfObject);
    }

    private CalculatedMemberType getCalculatedMemberType() {
        return (CalculatedMemberType)this.m_emfObject;
    }

    public int getSolveOrder() {
        BigInteger so = this.getCalculatedMemberType().getSolveOrder();
        if (so != null) {
            return this.getCalculatedMemberType().getSolveOrder().intValue();
        }
        return 0;
    }

    public void setSolveOrder(int solveOrder) {
        this.getCalculatedMemberType().setSolveOrder(BigInteger.valueOf(solveOrder));
    }

    public MemberUniqueName getParentMember() {
        MunType mun = this.getCalculatedMemberType().getParentMember();
        if (mun == null) {
            return null;
        }
        return FmMemberUniqueName.get(this.m_session, mun);
    }

    public MemberUniqueName setParentMember(MemberUniqueNameBuilder munBuilder) {
        if (munBuilder != null) {
            for (Object part : munBuilder.getParts()) {
                if (!(part instanceof FmRelationalHierarchy)) continue;
                FmRelationalHierarchy hier = (FmRelationalHierarchy)part;
                if (hier.equals(this.getHierarchy())) break;
                throw new FmMDException("BMT_MD_BAD_CALCULATED_MEMBER_PARENT");
            }
            FmMemberUniqueName newMun = FmMemberUniqueName.create(this.m_session, munBuilder);
            this.getCalculatedMemberType().setParentMember(newMun.getMemberUniqueNameType());
            return newMun;
        }
        this.getCalculatedMemberType().setParentMember(null);
        return null;
    }

    public Expression getExpression() {
        ExpressionType exp = this.getCalculatedMemberType().getExpression();
        return FmExpression.get((FMMDSession)this.m_session, exp);
    }

    public V5DataItem getV5DataItem(CubeBase cube) {
        V5ExpressionHandler handler = new V5ExpressionHandler(cube, this);
        this.getExpression().evaluateComponents(handler);
        V5DataItem dataItem = null;
        dataItem = this.isCalculatedMeasure() ? V5DataItem.createV5DataItem(V5DataItem.dataItemType.eCalculatedMember, cube, this.getMeasureDimension().getID(), this.getName(), handler.getV5Expression()) : V5DataItem.createV5DataItem(V5DataItem.dataItemType.eCalculatedMember, cube, this.getHierarchy().getID(), this.getName(), handler.getV5Expression());
        return dataItem;
    }

    public Expression setExpression(MDXExpressionBuilder exprBuilder) {
        FmExpression exp = FmExpression.create((FMMDSession)this.m_session, exprBuilder);
        this.getCalculatedMemberType().setExpression(exp.getExpressionType());
        return exp;
    }

    public String getV5Expression(CubeBase cube) {
        V5ExpressionHandler handler = new V5ExpressionHandler(cube, this);
        this.getExpression().evaluateComponents(handler);
        return handler.getV5Expression();
    }

    public HierarchyBase getHierarchy() {
        EObject obj = this.getCalculatedMemberType().eContainer();
        while (obj != null) {
            if (obj instanceof RelationalHierarchyType) {
                return FmRelationalHierarchy.get(this.getSession(), obj);
            }
            if (obj instanceof VirtualHierarchyType) {
                return FmVirtualHierarchy.get(this.getSession(), obj);
            }
            obj = obj.eContainer();
        }
        return null;
    }

    public DimensionBase getMeasureDimension() {
        EObject parent = this.getCalculatedMemberType().eContainer();
        while (parent != null) {
            if (parent instanceof MeasureDimensionType) {
                return FmMeasureDimension.get(this.getSession(), parent);
            }
            if (parent instanceof VirtualMeasureDimensionType) {
                return FmVirtualMeasureDimension.get(this.getSession(), parent);
            }
            parent = parent.eContainer();
        }
        return null;
    }

    public boolean isCalculatedMeasure() {
        EObject parent = this.getCalculatedMemberType().eContainer();
        while (parent != null) {
            if (parent instanceof MeasureDimensionType) {
                return true;
            }
            if (parent instanceof VirtualMeasureDimensionType) {
                return true;
            }
            parent = parent.eContainer();
        }
        return false;
    }

    public FmObjectType getFmObjectType() {
        return FmObjectType.calculatedMember;
    }

    public String getV5MemberParent(CubeBase cube, boolean b) {
        DimensionBase measDim = this.getMeasureDimension();
        if (measDim != null) {
            return measDim.getID();
        }
        MemberUniqueName parent = this.getParentMember();
        if (parent == null) {
            return "";
        }
        return parent.getV5MemberUniqueName(cube, b);
    }

    public void setFormat(Format format) {
        if (format == null) {
            this.getCalculatedMemberType().setFormat(null);
        } else {
            this.getCalculatedMemberType().setFormat(format.getFormatString());
        }
    }

    public String getFormat() {
        return this.getCalculatedMemberType().getFormat();
    }

    public Format getFormatAsFormat() {
        return FmFormatGroup.get(this.getCalculatedMemberType().getFormat()).getFormat();
    }

    public void setHidden(boolean hidden) {
        FmMeasureDimension measDim;
        BaseObject parent;
        if (hidden && (parent = this.getParent()) instanceof FmMeasureDimension && (measDim = (FmMeasureDimension)parent).getDefaultMeasure().equals(this)) {
            throw new FmMDException("BMT_MD_DEFAULT_MEASURE_CANT_BE_HIDDEN2", this.getName(), measDim.getName());
        }
        this.getCalculatedMemberType().setHidden(hidden);
    }

    public boolean getHidden() {
        return this.getCalculatedMemberType().isHidden();
    }

    public void setRegularAggregate(FmRegularAggregate value) {
        if (!this.isCalculatedMeasure()) {
            throw new FmMDException("BMT_MD_NO_AGGREGATION_FOR_CALCULATED_MEMBERS");
        }
        this.getCalculatedMemberType().setRegularAggregate(RegularAggregateType.get(value.toString()));
    }

    public FmRegularAggregate getRegularAggregate() {
        if (this.isCalculatedMeasure()) {
            return FmRegularAggregate.valueOf(this.getCalculatedMemberType().getRegularAggregate().toString());
        }
        return FmRegularAggregate.unsupported;
    }

    public RelationalObject getRelationalParent() {
        EObject eObj = (EObject)this.m_emfObject;
        while (eObj != null) {
            if (eObj instanceof RelationalDimensionType) {
                return FmRelationalDimension.get(this.m_session, eObj);
            }
            if (eObj instanceof MeasureDimensionType) {
                return FmMeasureDimension.get(this.m_session, eObj);
            }
            if (eObj instanceof RelationalQuerySubjectType) {
                return FmRelationalQuerySubject.get(this.m_session, eObj);
            }
            eObj = eObj.eContainer();
        }
        return null;
    }

    public TopLevelObject getContainer() {
        EObject eObj = (EObject)this.m_emfObject;
        while (eObj != null) {
            if (eObj instanceof CalculatedMembersType) {
                return FmModelFactory.getInstance().get(this.m_session, eObj.eContainer());
            }
            if (eObj instanceof VirtualMeasureDimensionType || eObj instanceof MeasureDimensionType) {
                return FmModelFactory.getInstance().get(this.m_session, eObj);
            }
            eObj = eObj.eContainer();
        }
        System.out.println(this.getID());
        return null;
    }

    public void moveObject(FmBaseObject targetParent, MoveListener listener) {
        EList<CalculatedMemberType> targetMeasures;
        if (targetParent instanceof FmMeasureFolder && (targetMeasures = ((FmMeasureFolder)targetParent).getMeasureFolderType().getCalculatedMeasure()).isEmpty()) {
            CalculatedMemberType tmp = GenmodelFactory.eINSTANCE.createCalculatedMemberType();
            targetMeasures.add((Object)tmp);
            targetMeasures.add((Object)((CalculatedMemberType)this.m_emfObject));
            targetMeasures.remove((Object)tmp);
            this.makeAllNamesUnique(BaseObject.PrefixName.kStandard, targetParent, listener);
            return;
        }
        super.moveObject(targetParent, listener);
    }
}

