/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.EObjectSourceType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDataSource;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmExpression;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemLike;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSection;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveListener;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.BasedOn;
import com.ibm.cognos.fmeng.fmmd.model.Calculation;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.fmmd.model.FmRegularAggregate;
import com.ibm.cognos.fmeng.fmmd.model.FmUsage;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemLike;
import com.ibm.cognos.fmeng.genmodel.CalcDataSourcesType;
import com.ibm.cognos.fmeng.genmodel.CalculationType;
import com.ibm.cognos.fmeng.genmodel.DatatypeType;
import com.ibm.cognos.fmeng.genmodel.DisplayTypeType;
import com.ibm.cognos.fmeng.genmodel.ExpressionType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.PromptInfoType;
import com.ibm.cognos.fmeng.genmodel.PromptTypeValues;
import com.ibm.cognos.fmeng.genmodel.RegularAggregateType;
import com.ibm.cognos.fmeng.genmodel.UsageType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmCalculation
extends FmReportObject
implements FmQueryItemLike,
BasedOn,
Calculation {
    public static FmCalculation get(FMMDSession session, Object emfobj) {
        return new FmCalculation(session, (CalculationType)emfobj);
    }

    public static String getDefaultName(Locale locale) {
        return FmMessage.render("BMT_MDN_OBJECT_NAME_CALCULATION", locale);
    }

    protected static FmCalculation createCalculation(FMMDSession session, FmSection parent, String objectName) {
        if (objectName == null || objectName.length() == 0) {
            objectName = FmCalculation.getDefaultName(session.getActiveLocale());
        }
        CalculationType emfObj = GenmodelFactory.eINSTANCE.createCalculationType();
        FmCalculation calculation = new FmCalculation(session, emfObj);
        parent.addCalculation(calculation);
        String uniqueName = calculation.makeUniqueName(objectName);
        String localeKey = FmModelFactory.getInstance().getProject(session).getDefaultLocale();
        calculation.setName(localeKey, uniqueName);
        ExpressionType expressionType = GenmodelFactory.eINSTANCE.createExpressionType();
        emfObj.setExpression(expressionType);
        return calculation;
    }

    private FmCalculation(FMMDSession session, CalculationType emfObject) {
        super(session, emfObject);
    }

    @Override
    public FmObjectType getFmObjectType() {
        return FmObjectType.calculation;
    }

    public FmExpression createDefaultExpression() {
        ExpressionType expressionType = GenmodelFactory.eINSTANCE.createExpressionType();
        this.getCalculationType().setExpression(expressionType);
        return new FmExpression((FMMDSession)this.m_session, expressionType);
    }

    @Override
    public Expression getExpression() {
        ExpressionType exp = this.getCalculationType().getExpression();
        return FmExpression.get((FMMDSession)this.m_session, exp);
    }

    @Override
    public Expression setExpression(ExpressionBuilder expression) {
        FmExpression exp = FmExpression.create((FMMDSession)this.m_session, expression);
        this.setExpression(exp);
        return exp;
    }

    public void setExpression(QueryItemBase qi) {
        FmExpression fmExp = FmExpression.create(this.m_session, qi, null);
        this.setExpression(fmExp);
    }

    private void setExpression(FmExpression exp) {
        BaseObject obj;
        this.getCalculationType().setExpression(exp.getExpressionType());
        List<BaseObject> objs = exp.getRawRefObjs(false);
        if (objs.size() == 1 && (obj = objs.get(0)) instanceof QueryItemBase) {
            this.copyReplicableProperties((FmQueryItemBase)obj);
        }
    }

    void setExpression(ExpressionType et) {
        this.getCalculationType().setExpression(et);
    }

    @Override
    public FmDatatype getDatatype() {
        return FmDatatype.getValueOf(this.getCalculationType().getDatatype().toString());
    }

    @Override
    public void setDatatype(FmDatatype type) {
        this.getCalculationType().setDatatype(DatatypeType.get(type.toString()));
    }

    @Override
    public void setUsage(FmUsage usageValue) {
        this.getCalculationType().setUsage(UsageType.get(usageValue.toString()));
    }

    @Override
    public FmUsage getUsage() {
        return FmUsage.valueOf(this.getCalculationType().getUsage().toString());
    }

    @Override
    public boolean getHidden() {
        return this.getCalculationType().isHidden();
    }

    @Override
    public void setHidden(boolean hidden) {
        this.getCalculationType().setHidden(hidden);
    }

    protected CalculationType getCalculationType() {
        return (CalculationType)this.m_emfObject;
    }

    public EObjectSourceType determineSourceType(HashSet<FmBaseObject> visitedObjs) {
        if (visitedObjs == null) {
            visitedObjs = new HashSet();
        }
        visitedObjs.add(this);
        EObjectSourceType eSourceType = ((FmExpression)this.getExpression()).determineSourceType(visitedObjs);
        return eSourceType;
    }

    @Override
    public void setRegularAggregate(FmRegularAggregate value) {
        this.getCalculationType().setRegularAggregate(RegularAggregateType.get(value.toString()));
    }

    @Override
    public FmRegularAggregate getRegularAggregate() {
        return FmRegularAggregate.valueOf(this.getCalculationType().getRegularAggregate().toString());
    }

    @Override
    public void setSemiAggregate(FmRegularAggregate value) {
        this.getCalculationType().setSemiAggregate(RegularAggregateType.get(value.toString()));
    }

    @Override
    public FmRegularAggregate getSemiAggregate() {
        return FmRegularAggregate.valueOf(this.getCalculationType().getSemiAggregate().toString());
    }

    @Override
    public void setFormat(String propertyValue) {
        this.getCalculationType().setFormat(propertyValue);
    }

    @Override
    public String getFormat() {
        return this.getCalculationType().getFormat();
    }

    public void setCurrency(String propertyValue) {
        this.getCalculationType().setCurrency(propertyValue);
    }

    public String getCurrency() {
        return this.getCalculationType().getCurrency();
    }

    public void setScale(int value) {
        BigInteger bigI = new BigInteger(String.valueOf(value));
        this.getCalculationType().setScale(bigI);
    }

    public int getScale() {
        if (this.getCalculationType().getScale() != null) {
            return this.getCalculationType().getScale().intValue();
        }
        return -1;
    }

    public void setSize(long propertyValue) {
        this.getCalculationType().setSize(propertyValue);
    }

    public long getSize() {
        return this.getCalculationType().getSize();
    }

    @Override
    public void setPrecision(int value) {
        BigInteger bigI = new BigInteger(String.valueOf(value));
        this.getCalculationType().setPrecision(bigI);
    }

    @Override
    public int getPrecision() {
        if (this.getCalculationType().getPrecision() != null) {
            return this.getCalculationType().getPrecision().intValue();
        }
        return -1;
    }

    @Override
    public void setNullable(boolean propertyValue) {
        this.getCalculationType().setNullable(propertyValue);
    }

    @Override
    public boolean getNullable() {
        return this.getCalculationType().isNullable();
    }

    @Override
    public void setDisplayType(QueryItemLike.DisplayType dt) {
        if (dt == QueryItemLike.DisplayType.link) {
            this.getCalculationType().setDisplayType(DisplayTypeType.LINK);
        } else if (dt == QueryItemLike.DisplayType.picture) {
            this.getCalculationType().setDisplayType(DisplayTypeType.PICTURE);
        } else {
            this.getCalculationType().setDisplayType(DisplayTypeType.VALUE);
        }
    }

    @Override
    public QueryItemLike.DisplayType getDisplayType() {
        DisplayTypeType dtt = this.getCalculationType().getDisplayType();
        if (dtt == DisplayTypeType.LINK) {
            return QueryItemLike.DisplayType.link;
        }
        if (dtt == DisplayTypeType.PICTURE) {
            return QueryItemLike.DisplayType.picture;
        }
        return QueryItemLike.DisplayType.value;
    }

    @Override
    public void setMIMEType(String value) {
        this.getCalculationType().setMIMEType(value);
    }

    @Override
    public String getMIMEType() {
        return this.getCalculationType().getMIMEType();
    }

    @Override
    public void setUnSortable(boolean unsortable) {
        this.getCalculationType().setUnSortable(unsortable);
    }

    @Override
    public boolean getUnSortable() {
        return this.getCalculationType().isUnSortable();
    }

    @Override
    public void getReferencedObjects(Set<BaseObject> objects) {
        CalcDataSourcesType cdt;
        FmExpression exp;
        PromptInfoType it = this.getCalculationType().getPromptInfo();
        if (it != null) {
            if (it.getPromptCascadeOnRef() != null) {
                objects.add(FmModelFactory.getInstance().get(this.m_session, it.getPromptCascadeOnRef()));
            }
            if (it.getPromptDisplayItemRef() != null) {
                objects.add(FmModelFactory.getInstance().get(this.m_session, it.getPromptDisplayItemRef()));
            }
            if (it.getPromptFilterItemRef() != null) {
                objects.add(FmModelFactory.getInstance().get(this.m_session, it.getPromptFilterItemRef()));
            }
            if (it.getPromptUseItemRef() != null) {
                objects.add(FmModelFactory.getInstance().get(this.m_session, it.getPromptUseItemRef()));
            }
        }
        if ((exp = (FmExpression)this.getExpression()) != null) {
            exp.getReferencedObjects(objects, true);
        }
        if ((cdt = this.getCalculationType().getDatasources()) != null) {
            for (Object ds : cdt.getDataSourceRef()) {
                objects.add(FmDataSource.get(this.m_session, ds));
            }
        }
    }

    @Override
    public void prepareForObjectDeletion(RemoveInfo info, FmBaseObject object, RemoveListener listener) {
        FmExpression exp;
        PromptInfoType it = this.getCalculationType().getPromptInfo();
        if (it != null) {
            if (it.getPromptCascadeOnRef() == object.getInternal()) {
                it.setPromptCascadeOnRef(null);
            }
            if (it.getPromptDisplayItemRef() == object.getInternal()) {
                it.setPromptDisplayItemRef(null);
            }
            if (it.getPromptFilterItemRef() == object.getInternal()) {
                it.setPromptFilterItemRef(null);
            }
            if (it.getPromptUseItemRef() == object.getInternal()) {
                it.setPromptUseItemRef(null);
            }
        }
        if ((exp = (FmExpression)this.getExpression()) != null && exp.breakReferencesTo(object)) {
            listener.invalidateObject(this);
        }
    }

    @Override
    public void copyReplicableProperties(FmQueryItemBase sourceItem) {
        FmDatatype datatype;
        RegularAggregateType aggregateRule;
        FmRegularAggregate semiAggregate;
        FmRegularAggregate regularAggregate;
        PromptInfoType promptInfo;
        DisplayTypeType displayType;
        UsageType usage;
        super.copyDescriptionAndScreentip(sourceItem);
        String valueStr = sourceItem.getFormat();
        if (valueStr != null) {
            this.setFormat(valueStr);
        }
        if ((valueStr = sourceItem.getCurrency()) != null) {
            this.setCurrency(valueStr);
        }
        if ((usage = sourceItem.getQueryItemBaseType().getUsage()) != null) {
            this.getCalculationType().setUsage(usage);
        }
        if ((displayType = sourceItem.getQueryItemBaseType().getDisplayType()) != null) {
            this.getCalculationType().setDisplayType(displayType);
        }
        if ((promptInfo = sourceItem.getQueryItemBaseType().getPromptInfo()) != null) {
            this.getCalculationType().setPromptInfo(promptInfo);
        }
        if ((regularAggregate = sourceItem.getRegularAggregate()) != null) {
            this.setRegularAggregate(regularAggregate);
        }
        if ((semiAggregate = sourceItem.getSemiAggregate()) != null) {
            this.setSemiAggregate(semiAggregate);
        }
        if ((aggregateRule = sourceItem.getQueryItemBaseType().getAggregationRule()) != null) {
            this.getCalculationType().setAggregationRule(aggregateRule);
        }
        if ((datatype = sourceItem.getDatatype()) != null) {
            this.setDatatype(datatype);
        }
        if (sourceItem.getScale() != null) {
            this.setScale(sourceItem.getScale());
        }
        if (sourceItem.getPrecision() != null) {
            this.setPrecision(sourceItem.getPrecision());
        }
        if (sourceItem.getSize() != null) {
            this.setSize(sourceItem.getSize());
        }
    }

    @Override
    public final FmQueryItem getPromptCascadeItem() {
        PromptInfoType it = this.getCalculationType().getPromptInfo();
        if (it != null && it.getPromptCascadeOnRef() != null) {
            return (FmQueryItem)FmModelFactory.getInstance().get(this.m_session, it.getPromptCascadeOnRef());
        }
        return null;
    }

    @Override
    public QueryItemLike.PromptType getPromptType() {
        PromptInfoType info = this.getCalculationType().getPromptInfo();
        if (info == null) {
            return QueryItemLike.PromptType.serverDetermined;
        }
        switch (info.getPromptType()) {
            case SERVER_DETERMINED: {
                return QueryItemLike.PromptType.serverDetermined;
            }
            case EDIT_BOX: {
                return QueryItemLike.PromptType.editBox;
            }
            case SELECT_DATE: {
                return QueryItemLike.PromptType.selectDate;
            }
            case SELECT_DATE_TIME: {
                return QueryItemLike.PromptType.selectDateTime;
            }
            case SELECT_INTERVAL: {
                return QueryItemLike.PromptType.selectInterval;
            }
            case SELECT_TIME: {
                return QueryItemLike.PromptType.selectTime;
            }
            case SELECT_VALUE: {
                return QueryItemLike.PromptType.selectValue;
            }
            case SELECT_WITH_SEARCH: {
                return QueryItemLike.PromptType.selectWithSearch;
            }
            case SELECT_WITH_TREE: {
                return QueryItemLike.PromptType.selectWithTree;
            }
        }
        return QueryItemLike.PromptType.serverDetermined;
    }

    private PromptInfoType getOrCreatePromptInfo() {
        PromptInfoType pit = this.getCalculationType().getPromptInfo();
        if (pit == null) {
            pit = GenmodelFactory.eINSTANCE.createPromptInfoType();
            this.getCalculationType().setPromptInfo(pit);
        }
        return pit;
    }

    @Override
    public void setPromptType(QueryItemLike.PromptType promptType) {
        PromptInfoType pit = this.getOrCreatePromptInfo();
        switch (promptType) {
            case serverDetermined: {
                pit.setPromptType(PromptTypeValues.SERVER_DETERMINED);
                break;
            }
            case editBox: {
                pit.setPromptType(PromptTypeValues.EDIT_BOX);
                break;
            }
            case selectDate: {
                pit.setPromptType(PromptTypeValues.SELECT_DATE);
                break;
            }
            case selectDateTime: {
                pit.setPromptType(PromptTypeValues.SELECT_DATE_TIME);
                break;
            }
            case selectInterval: {
                pit.setPromptType(PromptTypeValues.SELECT_INTERVAL);
                break;
            }
            case selectTime: {
                pit.setPromptType(PromptTypeValues.SELECT_TIME);
                break;
            }
            case selectValue: {
                pit.setPromptType(PromptTypeValues.SELECT_VALUE);
                break;
            }
            case selectWithSearch: {
                pit.setPromptType(PromptTypeValues.SELECT_WITH_SEARCH);
                break;
            }
            case selectWithTree: {
                pit.setPromptType(PromptTypeValues.SELECT_WITH_TREE);
            }
        }
    }

    @Override
    public final QueryItem getPromptDisplayItem() {
        PromptInfoType it = this.getCalculationType().getPromptInfo();
        if (it != null && it.getPromptDisplayItemRef() != null) {
            return (FmQueryItem)FmModelFactory.getInstance().get(this.m_session, it.getPromptDisplayItemRef());
        }
        return null;
    }

    @Override
    public final FmQueryItem getPromptFilterItem() {
        PromptInfoType it = this.getCalculationType().getPromptInfo();
        if (it != null && it.getPromptFilterItemRef() != null) {
            return (FmQueryItem)FmModelFactory.getInstance().get(this.m_session, it.getPromptFilterItemRef());
        }
        return null;
    }

    @Override
    public final FmQueryItem getPromptUseItem() {
        PromptInfoType it = this.getCalculationType().getPromptInfo();
        if (it != null && it.getPromptUseItemRef() != null) {
            return (FmQueryItem)FmModelFactory.getInstance().get(this.m_session, it.getPromptUseItemRef());
        }
        return null;
    }

    @Override
    public void setPromptCascadeItem(QueryItemBase qi) {
        PromptInfoType it = this.getOrCreatePromptInfo();
        if (qi != null) {
            it.setPromptCascadeOnRef((EObject)qi.getInternal());
        } else {
            it.setPromptCascadeOnRef(null);
        }
    }

    @Override
    public void setPromptDisplayItem(QueryItemBase qi) {
        PromptInfoType it = this.getOrCreatePromptInfo();
        if (qi != null) {
            it.setPromptDisplayItemRef((EObject)qi.getInternal());
        } else {
            it.setPromptDisplayItemRef(null);
        }
    }

    @Override
    public void setPromptFilterItem(QueryItemBase qi) {
        PromptInfoType it = this.getOrCreatePromptInfo();
        if (qi != null) {
            it.setPromptFilterItemRef((EObject)qi.getInternal());
        } else {
            it.setPromptFilterItemRef(null);
        }
    }

    @Override
    public void setPromptUseItem(QueryItemBase qi) {
        PromptInfoType it = this.getOrCreatePromptInfo();
        if (qi != null) {
            it.setPromptUseItemRef((EObject)qi.getInternal());
        } else {
            it.setPromptUseItemRef(null);
        }
    }
}

