/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.helpers.XTestConnectionHelper;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmEMDObjectNaming;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmParameterMap;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmProject;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveListener;
import com.ibm.cognos.fmeng.fmmd.impl.task.planner.DataSourceConnection;
import com.ibm.cognos.fmeng.fmmd.impl.task.planner.XAdaptor;
import com.ibm.cognos.fmeng.fmmd.impl.task.planner.XConnectionManager;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.Status;
import com.ibm.cognos.fmeng.fmmd.util.EmfHelper;
import com.ibm.cognos.fmeng.fmmd.util.ObjectHelper;
import com.ibm.cognos.fmeng.fmmd.util.StringHelper;
import com.ibm.cognos.fmeng.genmodel.DataSourceDetailType;
import com.ibm.cognos.fmeng.genmodel.DataSourceType;
import com.ibm.cognos.fmeng.genmodel.DbQueryType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.MacroType;
import com.ibm.cognos.fmeng.genmodel.ModelObjectType;
import com.ibm.cognos.fmeng.genmodel.ModelQueryType;
import com.ibm.cognos.fmeng.genmodel.ProjectType;
import com.ibm.cognos.fmeng.genmodel.QueryProcessingType;
import com.ibm.cognos.fmeng.genmodel.QueryTypeType;
import com.ibm.cognos.fmeng.genmodel.RollupProcessingType;
import com.ibm.cognos.fmeng.genmodel.SqlType;
import com.ibm.cognos.fmeng.metadata.MdCatalog;
import com.ibm.cognos.fmeng.metadata.MdDatabase;
import com.ibm.cognos.fmeng.metadata.MdSchema;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.impl.gateway.EMFModelGateway;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.dom4j.Element;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;

public class FmDataSource
extends FmModelObject
implements DataSource {
    protected static FmDataSource createDataSource(FMMDSession session, String objectName, FmEMDObjectNaming eMDObjectNaming) {
        if (objectName == null || objectName.length() == 0) {
            objectName = FmDataSource.getDefaultName(session.getActiveLocale());
        }
        DataSourceType emfObj = GenmodelFactory.eINSTANCE.createDataSourceType();
        ProjectType proj = (ProjectType)FmModelFactory.getInstance().getProject(session).getInternal();
        proj.getDataSources().getDataSource().add((Object)emfObj);
        FmDataSource datasource = new FmDataSource(session, emfObj);
        String uniqueName = datasource.makeUniqueName(objectName);
        emfObj.setName(uniqueName);
        return datasource;
    }

    public static FmDataSource get(FMMDSession session, Object emfobj) {
        return new FmDataSource(session, emfobj);
    }

    private FmDataSource(FMMDSession session, Object emfObject) {
        super(session, emfObject);
    }

    public FmObjectType getFmObjectType() {
        return FmObjectType.dataSource;
    }

    public static String getDefaultName(Locale locale) {
        return FmMessage.render("BMT_MDN_OBJECT_NAME_DATASOURCE", locale);
    }

    public String getCmDataSourceName() {
        MacroType cmDataSource = this.getAsDataSourceType().getCmDataSource();
        if (cmDataSource == null) {
            return "";
        }
        FeatureMap map = cmDataSource.getMixed();
        if (!map.isEmpty()) {
            return (String)map.getValue(0);
        }
        return "";
    }

    public FmParameterMap getAliasTableReference() {
        EObject obj = this.getAsDataSourceType().getAliasTableMapRef();
        return FmParameterMap.get(this.m_session, obj);
    }

    public void setCmDataSourceName(String dataSourceName) {
        if (dataSourceName == null) {
            dataSourceName = "";
        }
        this.getAsDataSourceType().setCmDataSource(EMFModelGateway.createMacroType(dataSourceName));
    }

    public String getCatalogName() {
        FeatureMap feature;
        String catalogName = "";
        MacroType catalog = this.getAsDataSourceType().getCatalog();
        if (catalog != null && (feature = catalog.getMixed()).size() > 0) {
            catalogName = (String)feature.getValue(0);
        }
        return catalogName;
    }

    public void setCatalogName(String catalogName) {
        if (catalogName == null) {
            catalogName = "";
        }
        this.getAsDataSourceType().setCatalog(EMFModelGateway.createMacroType(catalogName));
    }

    public String getSchemaName() {
        FeatureMap feature;
        String schemaName = "";
        MacroType schema = this.getAsDataSourceType().getSchema();
        if (schema != null && (feature = schema.getMixed()).size() > 0) {
            schemaName = (String)feature.getValue(0);
        }
        return schemaName;
    }

    public void setSchemaName(String schemaName) {
        if (schemaName == null) {
            schemaName = "";
        }
        this.getAsDataSourceType().setSchema(EMFModelGateway.createMacroType(schemaName));
    }

    public String getCube() {
        String cubeName = this.getAsDataSourceType().getCube();
        if (cubeName == null) {
            cubeName = "";
        }
        return cubeName;
    }

    public void setCube(String cubeName) {
        if (cubeName == null) {
            cubeName = "";
        }
        this.getAsDataSourceType().setCube(cubeName);
    }

    public DataSource.EQueryType getQueryType() {
        return DataSource.EQueryType.valueOf(this.getAsDataSourceType().getType().getQueryType().toString());
    }

    public void setQueryType(String queryTypeStr) {
        QueryTypeType queryType = QueryTypeType.get(queryTypeStr);
        DataSourceDetailType detailType = this.getAsDataSourceType().getType();
        if (detailType == null) {
            detailType = GenmodelFactory.eINSTANCE.createDataSourceDetailType();
            this.getAsDataSourceType().setType(detailType);
        }
        detailType.setQueryType(queryType);
    }

    public void setQueryType(DataSource.EQueryType queryType) {
        this.setQueryType(queryType.toString());
    }

    public String getInterface() {
        return this.getAsDataSourceType().getType().getInterface();
    }

    public void setInterface(String databaseTypeStr) {
        DataSourceDetailType detailType = this.getAsDataSourceType().getType();
        if (detailType == null) {
            detailType = GenmodelFactory.eINSTANCE.createDataSourceDetailType();
            this.getAsDataSourceType().setType(detailType);
        }
        detailType.setInterface(databaseTypeStr);
        if (databaseTypeStr != null) {
            if (databaseTypeStr.equalsIgnoreCase("SS")) {
                this.setFunctionSetID("V_SQLServer");
            } else if (databaseTypeStr.equalsIgnoreCase("D2")) {
                this.setFunctionSetID("V_DB2");
            } else if (databaseTypeStr.equalsIgnoreCase("IF")) {
                this.setFunctionSetID("V_Informix");
            } else if (databaseTypeStr.equalsIgnoreCase("NZ")) {
                this.setFunctionSetID("V_Netezza");
            } else if (databaseTypeStr.equalsIgnoreCase("OR")) {
                this.setFunctionSetID("V_Oracle");
            } else if (databaseTypeStr.equalsIgnoreCase("TD")) {
                this.setFunctionSetID("V_Teradata");
            }
        }
    }

    public String getFunctionSetID() {
        DataSourceDetailType detailType = this.getAsDataSourceType().getType();
        if (detailType != null) {
            return detailType.getFunctionSetID();
        }
        return null;
    }

    public void setFunctionSetID(String functionSetID) {
        DataSourceDetailType detailType = this.getAsDataSourceType().getType();
        if (detailType == null) {
            detailType = GenmodelFactory.eINSTANCE.createDataSourceDetailType();
            this.getAsDataSourceType().setType(detailType);
        }
        detailType.setFunctionSetID(functionSetID);
    }

    public DataSource.EQueryProcessing getQueryProcessing() {
        return DataSource.EQueryProcessing.valueOf(this.getAsDataSourceType().getQueryProcessing().toString());
    }

    public void setQueryProcessing(DataSource.EQueryProcessing queryProcessing) {
        QueryProcessingType queryProcessingType = QueryProcessingType.get(queryProcessing.toString());
        this.getAsDataSourceType().setQueryProcessing(queryProcessingType);
    }

    public DataSource.ERollupProcessing getRollupProcessing() {
        return DataSource.ERollupProcessing.valueOf(this.getAsDataSourceType().getRollupProcessing().toString());
    }

    public void setRollupProcessing(DataSource.ERollupProcessing rollupProcessing) {
        RollupProcessingType rollupProcessingType = RollupProcessingType.get(rollupProcessing.toString());
        this.getAsDataSourceType().setRollupProcessing(rollupProcessingType);
    }

    public boolean doesMatch(FmDataSource ds) {
        String dataSourceName = ds.getCmDataSourceName();
        String dataSourceCatalog = ds.getCatalogName();
        String dataSourceSchema = ds.getSchemaName();
        String dataSourceCube = ds.getCube();
        return this.doesMatch(dataSourceName, dataSourceCatalog, dataSourceSchema, dataSourceCube);
    }

    public boolean doesMatch(String cmDataSourceName, String catalogName, String schemaName, String cubeName) {
        if (cmDataSourceName == null) {
            cmDataSourceName = "";
        }
        if (catalogName == null) {
            catalogName = "";
        }
        if (schemaName == null) {
            schemaName = "";
        }
        if (cubeName == null) {
            cubeName = "";
        }
        String myCmDataSourceName = this.getCmDataSourceName();
        String myCatalogName = this.getCatalogName();
        String mySchemaName = this.getSchemaName();
        String myCubeName = this.getCube();
        return cmDataSourceName.equals(myCmDataSourceName) && catalogName.equals(myCatalogName) && schemaName.equals(mySchemaName) && cubeName.equals(myCubeName);
    }

    public boolean doesMatch(String catalogName, String schemaName, String cubeName) {
        if (catalogName == null) {
            catalogName = "";
        }
        if (schemaName == null) {
            schemaName = "";
        }
        if (cubeName == null) {
            cubeName = "";
        }
        String myCatalogName = this.getCatalogName();
        String mySchemaName = this.getSchemaName();
        String myCubeName = this.getCube();
        return catalogName.equals(myCatalogName) && schemaName.equals(mySchemaName) && cubeName.equals(myCubeName);
    }

    public String getDataSourceIndicator() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.getAsDataSourceType().getName());
        builder.append("].");
        return builder.toString();
    }

    void validateName(String propertyName, String newValue) {
    }

    public void setName(String nameValue) {
        this.validateNameUnique(nameValue);
        this.collectObjsForDataSourceRenaming(this.getAsDataSourceType().getName(), nameValue);
        ((ModelObjectType)this.m_emfObject).setName(nameValue);
    }

    public void collectObjsForDataSourceRenaming(String oldValue, String newValue) {
        if (oldValue == newValue) {
            return;
        }
        String strLeftBracket = "[";
        String strRightBracket = "]";
        oldValue = String.valueOf(strLeftBracket) + oldValue + strRightBracket;
        newValue = String.valueOf(strLeftBracket) + newValue + strRightBracket;
        HashSet<Integer> recurseInto = new HashSet<Integer>();
        HashMap<Integer, List<Object>> collect = new HashMap<Integer, List<Object>>();
        recurseInto.add(88);
        recurseInto.add(148);
        recurseInto.add(124);
        recurseInto.add(37);
        recurseInto.add(35);
        ArrayList sqlNodes = new ArrayList();
        collect.put(165, sqlNodes);
        EmfHelper.collect(this.getFmProject().getInternal(), recurseInto, collect);
        for (Object sqlNode : sqlNodes) {
            SqlType sql = (SqlType)sqlNode;
            EList<MacroType> tables = sql.getTable();
            for (MacroType table : tables) {
                String tableName = EMFModelGateway.getMacroTypeValue(table);
                String newSqlString = StringHelper.replaceAll(tableName, oldValue, newValue);
                EMFModelGateway.setMacroTypeValue(table, newSqlString);
            }
            Object container = this.m_session.getGateway().getParent(sql);
            if (container instanceof DbQueryType) {
                ((DbQueryType)container).setSql(sql);
                continue;
            }
            if (!(container instanceof ModelQueryType)) continue;
            ((ModelQueryType)container).setSql(sql);
        }
    }

    final DataSourceType getAsDataSourceType() {
        return (DataSourceType)this.m_emfObject;
    }

    public void remove(RemoveInfo info, RemoveListener listener) {
        HashSet<FmBaseObject> referencingObjects = new HashSet<FmBaseObject>();
        ((FmProject)this.getProject()).getReferencesTo(this, referencingObjects);
        if (referencingObjects.size() != 0) {
            Object[] msgParams = new Object[3];
            msgParams[0] = this.getLocalizedType();
            msgParams[1] = this.getID();
            String affectedObjectsMsg = "\r\n" + ObjectHelper.renderObjects(this.m_session, referencingObjects, 0, false);
            msgParams[2] = affectedObjectsMsg;
            FmMDException error = new FmMDException(0, "BMT_MD_VERIFY_DELETE_IMPACTED_OBJECTS_ERROR", msgParams);
            listener.reportError(error);
        } else {
            this.m_session.getGateway().delete(this.getInternal());
        }
    }

    public void prepareForObjectDeletion(RemoveInfo info, FmBaseObject object, RemoveListener listener) {
        if (object.equals(this.getAliasTableReference())) {
            this.getAsDataSourceType().setAliasTableMapRef(null);
        }
    }

    public void test() {
        String cmDataSourceName = this.getCmDataSourceName();
        if ("".equals(cmDataSourceName)) {
            throw new FmMDException("BMT_MD_UNABLE_TESTDATASOURCE");
        }
        DataSourceConnection conn = XConnectionManager.getInstance().getSelection(this.m_session, cmDataSourceName);
        XTestConnectionHelper testConnHelper = new XTestConnectionHelper(cmDataSourceName, conn != null ? conn.s_connectionName : "", conn != null ? conn.s_signonName : "", conn != null ? conn.s_logonUID : "", conn != null ? conn.s_logonPWD : "", "", "", "");
        Element domRequest = testConnHelper.make();
        XAdaptor myAdaptor = XAdaptor.create(this.m_session, true, true);
        myAdaptor.doQsApiRequest(domRequest, 0);
    }

    public String toString() {
        String dataSource = "Name: " + this.getName() + "\n\tCM data source: " + this.getCmDataSourceName() + "\n\tCatalog: " + this.getCatalogName() + "\n\tSchema: " + this.getSchemaName();
        return dataSource;
    }

    public Status.EStatus getStatus() {
        return this.getAssociatedDatabase() == null ? Status.EStatus.warning : Status.EStatus.valid;
    }

    public void setStatus(Status.EStatus status) {
    }

    public MdDatabase getAssociatedDatabase() {
        MdDatabase retDatabase = null;
        String cmDsName = this.getCmDataSourceName();
        String catName = this.getCatalogName();
        String schemaName = this.getSchemaName();
        boolean fnd = false;
        List<MdSchema> schemas = null;
        List<MdDatabase> mdDatabases = this.getSession().getMetadataSources();
        for (MdDatabase db : mdDatabases) {
            if (!cmDsName.equals(db.getName())) continue;
            List<MdCatalog> cats = db.getCatalogs();
            if (cats != null && cats.size() > 0) {
                for (MdCatalog mdcat : cats) {
                    if (!mdcat.getName().equals(catName)) continue;
                    schemas = mdcat.getSchemas();
                    break;
                }
            } else {
                schemas = db.getSchemas();
            }
            if (schemas != null && schemas.size() > 0) {
                for (MdSchema schema : schemas) {
                    if (!schema.getName().equals(schemaName)) continue;
                    fnd = true;
                    break;
                }
            }
            if (!fnd) continue;
            retDatabase = db;
            break;
        }
        return retDatabase;
    }
}

