/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmCollector;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDataSource;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmEMDObjectNaming;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.genmodel.DataSourceType;
import com.ibm.cognos.fmeng.genmodel.DataSourcesType;
import com.ibm.cognos.fmeng.genmodel.ModelObjectType;
import com.ibm.cognos.fmeng.metadata.MdBase;
import com.ibm.cognos.fmeng.metadata.MdCatalog;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.metadata.MdTable;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmDataSources
extends FmCollector {
    public static final short kSourceExistsNo = 0;
    public static final short kSourceExistsNameOnly = 1;
    public static final short kSourceExistsCompleteMatch = 2;

    public FmDataSource findOrCreateDataSource(String modelDSName, String cmDataSourceName, String catalogName, String schemaName, String cubeName, String dsQueryType, String dsInterfaceType) {
        FmDataSource ds = null;
        ds = "".equals(modelDSName) ? this.findDataSource(cmDataSourceName, catalogName, schemaName, cubeName) : this.findDataSource(modelDSName);
        if (ds == null) {
            ds = this.createDataSource(cmDataSourceName, catalogName, schemaName, cubeName, dsQueryType, dsInterfaceType);
        }
        return ds;
    }

    public FmDataSource findDataSource(String modelDSName) {
        for (FmDataSource dataSource : this.getDataSourceCollection()) {
            if (!dataSource.getName().equals(modelDSName)) continue;
            return dataSource;
        }
        return null;
    }

    public FmDataSource findDataSource(String cmDataSourceName, String catalogName, String schemaName, String cubeName) {
        for (FmDataSource dataSource : this.getDataSourceCollection()) {
            if (!dataSource.doesMatch(cmDataSourceName, catalogName, schemaName, cubeName)) continue;
            return dataSource;
        }
        return null;
    }

    public short exists(FmDataSource ds) {
        int sourceExists = 0;
        String sourceName = ((ModelObjectType)ds.getInternal()).getName();
        List<FmDataSource> currentSources = this.getDataSourceCollection();
        for (FmDataSource source : currentSources) {
            String currentSourceName = ((ModelObjectType)source.getInternal()).getName();
            if (!sourceName.equals(currentSourceName)) continue;
            sourceExists = 1;
            if (!source.doesMatch(source)) continue;
            sourceExists = 2;
        }
        return (short)sourceExists;
    }

    public static FmDataSources get(FMMDSession session, Object emfobj) {
        FmDataSources.validateEMFBaseObject(emfobj, DataSourcesType.class);
        return new FmDataSources(session, emfobj);
    }

    private FmDataSources(FMMDSession session, Object emfObject) {
        super(session, emfObject);
    }

    private DataSourcesType getDataSourcesType() {
        return (DataSourcesType)this.m_emfObject;
    }

    public List<FmDataSource> getDataSourceCollection() {
        ArrayList<FmDataSource> datasources = new ArrayList<FmDataSource>();
        for (DataSourceType dataSource : this.getDataSourcesType().getDataSource()) {
            FmDataSource ds = FmDataSource.get(this.m_session, dataSource);
            datasources.add(ds);
        }
        return datasources;
    }

    public FmDataSource createDataSource(String cmDataSourceName, String catalogName, String schemaName, String cubeName, String queryType, String interfaceType) {
        FmDataSource ds = FmDataSource.createDataSource(this.m_session, cmDataSourceName, FmEMDObjectNaming.kMakeUnique);
        ds.setCmDataSourceName(cmDataSourceName);
        ds.setCatalogName(catalogName);
        ds.setSchemaName(schemaName);
        ds.setCube(cubeName);
        ds.setQueryType(queryType);
        ds.setInterface(interfaceType);
        return ds;
    }

    public FmDataSource createDataSource(DataSource srcDS, String name) {
        FmDataSource ds = FmDataSource.createDataSource(this.m_session, name, FmEMDObjectNaming.kMakeUnique);
        ds.setQueryProcessing(srcDS.getQueryProcessing());
        ds.setCatalogName(srcDS.getCatalogName());
        ds.setSchemaName(srcDS.getSchemaName());
        ds.setCube(srcDS.getCube());
        ds.setCmDataSourceName(srcDS.getCmDataSourceName());
        ds.setQueryType(srcDS.getQueryType());
        ds.setInterface(srcDS.getInterface());
        return ds;
    }

    public DataSource findOrCreateDataSource(MdBase mdTableOrColumn) {
        MdTable table = null;
        if (mdTableOrColumn instanceof MdTable) {
            table = (MdTable)mdTableOrColumn;
        } else if (mdTableOrColumn instanceof MdColumn) {
            table = ((MdColumn)mdTableOrColumn).getTable();
        } else {
            return null;
        }
        String dataSource = table.getDatabase().getName();
        MdCatalog cat = table.getSchema().getCatalog();
        String catalog = cat == null ? null : cat.getName();
        String schema = table.getSchema().getName();
        FmDataSource ds = this.findDataSource(dataSource, catalog, schema, null);
        if (ds == null) {
            String sInterface = mdTableOrColumn.getDatabase().getUDAVendorCode();
            ds = this.createDataSource(dataSource, catalog, schema, null, "relational", sInterface);
        }
        return ds;
    }

    private void addDataSource(DataSourceType dataSource) {
        this.getDataSourcesType().getDataSource().add((Object)dataSource);
    }

    @Override
    public FmObjectType getFmObjectType() {
        return FmObjectType.dataSources;
    }

    @Override
    void addChild(Object emfObject) {
        switch (this.m_session.getGateway().getClassifierType(emfObject)) {
            case 34: {
                this.addDataSource((DataSourceType)emfObject);
                return;
            }
        }
        super.addChild(emfObject);
    }
}

