/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FilterDefinitionParentInternal;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDataSource;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDefinitionBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFilterDefinition;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.DbQuery;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.FilterDefinition;
import com.ibm.cognos.fmeng.fmmd.model.GenerateSQL;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.genmodel.DataSourceRefsType;
import com.ibm.cognos.fmeng.genmodel.DbQueryType;
import com.ibm.cognos.fmeng.genmodel.FilterDefinitionType;
import com.ibm.cognos.fmeng.genmodel.FiltersType;
import com.ibm.cognos.fmeng.genmodel.GenerateSQLType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.IndexType;
import com.ibm.cognos.fmeng.genmodel.KeyBaseType;
import com.ibm.cognos.fmeng.genmodel.RefCollectionType;
import com.ibm.cognos.fmeng.genmodel.SqlType;
import com.ibm.cognos.fmeng.genmodel.TableTypeType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.impl.gateway.EMFModelGateway;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmDbQuery
extends FmDefinitionBase
implements DbQuery,
FilterDefinitionParentInternal {
    public static FmDbQuery get(FMMDSession session, DbQueryType dbQuery) {
        if (dbQuery != null) {
            return new FmDbQuery(session, dbQuery);
        }
        return null;
    }

    FmDbQuery(FMMDSession session, DbQueryType emfObject) {
        super(session, emfObject);
    }

    private DbQueryType getDbQueryType() {
        return (DbQueryType)this.m_emfObject;
    }

    protected void init(FmDataSource dataSource) {
        DataSourceRefsType dsRefs = GenmodelFactory.eINSTANCE.createDataSourceRefsType();
        EList<EObject> dsList = dsRefs.getDataSourceRef();
        dsList.add(dataSource.getAsDataSourceType());
        this.getDbQueryType().setSources(dsRefs);
    }

    public void clearBalticKeyAndIndexReferencesTo(FmBaseObject obj) {
        EList<IndexType> indexes;
        EList<KeyBaseType> baseTypes = this.getDbQueryType().getKey();
        if (baseTypes != null) {
            for (KeyBaseType key : baseTypes) {
                RefCollectionType rct = key.getQueryItemsCollection();
                rct.getRefobj().remove(obj.getInternal());
            }
        }
        if ((indexes = this.getDbQueryType().getIndex()) != null) {
            for (IndexType index : indexes) {
                RefCollectionType rct = index.getQueryItemsCollection();
                rct.getRefobj().remove(obj.getInternal());
            }
        }
    }

    public void getBalticReferences(Set<BaseObject> objects) {
        EList<IndexType> indexes;
        EList<KeyBaseType> baseTypes = this.getDbQueryType().getKey();
        if (baseTypes != null) {
            for (KeyBaseType key : baseTypes) {
                RefCollectionType rct = key.getQueryItemsCollection();
                for (Object ref : rct.getRefobj()) {
                    TopLevelObject bo = FmModelFactory.getInstance().get(this.m_session, ref);
                    if (bo == null) continue;
                    objects.add(bo);
                }
            }
        }
        if ((indexes = this.getDbQueryType().getIndex()) != null) {
            for (IndexType index : indexes) {
                RefCollectionType rct = index.getQueryItemsCollection();
                for (Object ref : rct.getRefobj()) {
                    TopLevelObject bo = FmModelFactory.getInstance().get(this.m_session, ref);
                    if (bo == null) continue;
                    objects.add(bo);
                }
            }
        }
    }

    @Override
    public TableType getTableType() {
        TableTypeType ttt = this.getDbQueryType().getTableType();
        switch (ttt) {
            case TABLE: {
                return TableType.table;
            }
            case VIEW: {
                return TableType.view;
            }
            case NON_TRANSPARENT_TABLE: {
                return TableType.nonTransparentTable;
            }
        }
        return TableType.unknown;
    }

    @Override
    public void setTableType(TableType tableType) {
        switch (tableType) {
            case table: {
                this.getDbQueryType().setTableType(TableTypeType.TABLE);
                break;
            }
            case view: {
                this.getDbQueryType().setTableType(TableTypeType.VIEW);
                break;
            }
            case nonTransparentTable: {
                this.getDbQueryType().setTableType(TableTypeType.NON_TRANSPARENT_TABLE);
                break;
            }
            case unknown: {
                this.getDbQueryType().setTableType(TableTypeType.UNKNOWN);
            }
        }
    }

    @Override
    public void setSql(String sqlStr, QuerySubjectBase.TypeOfSql sqlType) {
        SqlType sql = this.setSql(sqlStr);
        this.setSqlType(sql, sqlType);
    }

    public void setSql(String dsName, String tableName, QuerySubjectBase.TypeOfSql sqlType) {
        FmMDException.ASSERT(!tableName.contains("\""), "Table names may not contain double-quote characters.");
        SqlType sql = this.getDbQueryType().getSql();
        if (sql == null) {
            sql = GenmodelFactory.eINSTANCE.createSqlType();
            this.getDbQueryType().setSql(sql);
        }
        EMFModelGateway.addTextValueToSQL(sql, "Select ");
        sql.getColumn().add((Object)EMFModelGateway.createMacroType("*"));
        EMFModelGateway.addTextValueToSQL(sql, " from ");
        sql.getTable().add((Object)EMFModelGateway.createMacroType("[" + dsName + "].\"" + tableName + "\""));
        this.setSqlType(sql, sqlType);
    }

    @Override
    public String getSQL() {
        SqlType st = this.getDbQueryType().getSql();
        return StringEscapeUtils.unescapeXml((String)this.m_session.getGateway().asXML(st, false));
    }

    @Override
    protected SqlType setSql(String sqlStr) {
        SqlType sql = this.getDbQueryType().getSql();
        if (sql == null) {
            sql = GenmodelFactory.eINSTANCE.createSqlType();
            this.getDbQueryType().setSql(sql);
        }
        EMFModelGateway.setSqlTypeValue(sql, StringEscapeUtils.escapeXml((String)sqlStr));
        return sql;
    }

    public List<TopLevelObject> getDataSourcesInternal() {
        DataSourceRefsType dsRefs = this.getDbQueryType().getSources();
        if (dsRefs == null) {
            dsRefs = GenmodelFactory.eINSTANCE.createDataSourceRefsType();
            this.getDbQueryType().setSources(dsRefs);
        }
        ArrayList<TopLevelObject> dss = new ArrayList<TopLevelObject>(dsRefs.getDataSourceRef().size());
        for (Object eObj : dsRefs.getDataSourceRef()) {
            dss.add(FmModelFactory.getInstance().get(this.m_session, eObj));
        }
        return dss;
    }

    @Override
    public List<DataSource> getDataSources() {
        DataSourceRefsType dsRefs = this.getDbQueryType().getSources();
        if (dsRefs == null) {
            dsRefs = GenmodelFactory.eINSTANCE.createDataSourceRefsType();
            this.getDbQueryType().setSources(dsRefs);
        }
        EList<EObject> eObjs = dsRefs.getDataSourceRef();
        ArrayList<DataSource> dss = new ArrayList<DataSource>(eObjs.size());
        for (Object eObj : eObjs) {
            FmDataSource ds = (FmDataSource)FmModelFactory.getInstance().get(this.m_session, eObj);
            dss.add(ds);
        }
        return dss;
    }

    @Override
    public void syncItemsToDefinition(boolean updateTableType) {
        ((FmQuerySubjectBase)this.getParent()).syncItemsToDefinition(updateTableType);
    }

    @Override
    public FilterDefinition createFilterDefinition(String name, ExpressionBuilder expression) {
        return FmFilterDefinition.create(this.m_session, this, name, expression);
    }

    @Override
    public List<FilterDefinition> getFilterDefinitions() {
        ArrayList<FilterDefinition> filters = new ArrayList<FilterDefinition>();
        FiltersType filtersType = this.getFilters();
        for (FilterDefinitionType filterType : filtersType.getFilterDefinition()) {
            filters.add(FmFilterDefinition.get(this.m_session, filterType));
        }
        return filters;
    }

    @Override
    public void removeFilterDefinition(String displayName) {
        for (FilterDefinitionType filter : this.getFilters().getFilterDefinition()) {
            if (!filter.getDisplayName().equals(displayName)) continue;
            this.m_session.getGateway().delete(filter);
            break;
        }
    }

    private FiltersType getFilters() {
        FiltersType filtersType = this.getDbQueryType().getFilters();
        if (filtersType == null) {
            filtersType = GenmodelFactory.eINSTANCE.createFiltersType();
            this.getDbQueryType().setFilters(filtersType);
        }
        return filtersType;
    }

    @Override
    public void addFilterDefinition(FmFilterDefinition filter) {
        this.getFilters().getFilterDefinition().add((Object)filter.getFilterDefinitionType());
    }

    @Override
    public String getName() {
        return this.getParent().getName();
    }

    @Override
    public String makeObjectNameUnique(String name, int type) {
        FmMDException.ASSERT(type == 46, "Bad type for child object.");
        boolean bUnique = false;
        String tempName = name;
        int i = 0;
        int size = this.getFilters().getFilterDefinition().size();
        while (!bUnique) {
            bUnique = true;
            String objName = null;
            int j = 0;
            while (j < size) {
                objName = ((FilterDefinitionType)this.getFilters().getFilterDefinition().get(j)).getDisplayName();
                if (objName.equals(tempName)) {
                    bUnique = false;
                    break;
                }
                ++j;
            }
            if (bUnique) continue;
            tempName = String.valueOf(name) + Integer.toString(++i);
        }
        return tempName;
    }

    @Override
    public boolean isQueryItemInFilterScope(FmQueryItemBase qi) {
        return true;
    }

    @Override
    public GenerateSQL getGenerateSQL() {
        switch (this.getDbQueryType().getGenerateSQL()) {
            case AS_VIEW: {
                return GenerateSQL.asView;
            }
            case MINIMIZED: {
                return GenerateSQL.minimized;
            }
        }
        return GenerateSQL.minimized;
    }

    @Override
    public void setGenerateSQL(GenerateSQL generateSQL) {
        switch (generateSQL) {
            case asView: {
                this.getDbQueryType().setGenerateSQL(GenerateSQLType.AS_VIEW);
                break;
            }
            case minimized: {
                this.getDbQueryType().setGenerateSQL(GenerateSQLType.MINIMIZED);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TableType {
        table,
        view,
        nonTransparentTable,
        unknown;

    }
}

