/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCalculation;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmColumnReference;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmComplexProperty;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFilter;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasure;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmUnresolvedReference;
import com.ibm.cognos.fmeng.fmmd.model.BuilderFactory;
import com.ibm.cognos.fmeng.fmmd.model.Calculation;
import com.ibm.cognos.fmeng.fmmd.model.ColumnReference;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionParent;
import com.ibm.cognos.fmeng.fmmd.model.Filter;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.util.FmExpressionBuilder;
import com.ibm.cognos.fmeng.logging.FmEngApplicationLog;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FmExpressionCopier {
    public void resolveDeferredExpressions(HashMap<ExpressionParent, ExpressionParent> m_deferredExpressions) {
        if (m_deferredExpressions != null) {
            int oldSize = m_deferredExpressions.size();
            while (m_deferredExpressions.size() > 0) {
                Set<ExpressionParent> keys = m_deferredExpressions.keySet();
                Iterator<ExpressionParent> itKey = keys.iterator();
                while (itKey.hasNext()) {
                    ExpressionParent newObj = itKey.next();
                    ExpressionParent srcObj = m_deferredExpressions.get(newObj);
                    FmExpressionBuilder newExprBuilder = this.copyExpression(srcObj);
                    if (newExprBuilder == null) continue;
                    newObj.setExpression(newExprBuilder);
                    itKey.remove();
                    if (!(srcObj instanceof FmMeasure) || !(newObj instanceof FmQueryItemBase)) continue;
                    ((FmQueryItemBase)newObj).setRegularAggregate(((FmMeasure)srcObj).getRegularAggregate());
                }
                if (oldSize == m_deferredExpressions.size() && m_deferredExpressions.size() != 0) {
                    for (ExpressionParent key : m_deferredExpressions.keySet()) {
                        Object obj;
                        ExpressionParent value = m_deferredExpressions.get(key);
                        if (value instanceof FmBaseObject) {
                            obj = (FmBaseObject)((Object)value);
                            FmEngApplicationLog.getApplicationLog().logError(FmEngApplicationLog.LOGGERS.PUBLISH, ((FmBaseObject)obj).getSession(), "Deferring for late resolution the expression in: " + ((FmBaseObject)obj).getID());
                            continue;
                        }
                        if (!(value instanceof FmComplexProperty)) continue;
                        obj = (FmComplexProperty)((Object)value);
                        FmEngApplicationLog.getApplicationLog().logError(FmEngApplicationLog.LOGGERS.PUBLISH, ((FmComplexProperty)obj).getSession(), "Deferring for late resolution the expression in: " + ((FmComplexProperty)obj).getPropertyName());
                    }
                    FmMDException.ASSERT(false, "Unable to resolve deferred expressions.");
                }
                oldSize = m_deferredExpressions.size();
            }
        }
    }

    public FmExpressionBuilder copyExpression(ExpressionParent srcExpressionParent) {
        Expression srcExpr = srcExpressionParent.getExpression();
        FmExpressionBuilder destBuilder = (FmExpressionBuilder)BuilderFactory.createExpressionBuilder();
        for (Object part : srcExpr.getComponents()) {
            if (part instanceof QueryItemBase) {
                FmQueryItemBase qiPart = (FmQueryItemBase)part;
                if (this.handleQueryItemBase(srcExpressionParent, destBuilder, qiPart)) continue;
                return null;
            }
            if (part instanceof String) {
                destBuilder.addExpressionPart((String)part, null);
                continue;
            }
            if (part instanceof FmColumnReference) {
                ColumnReference cRef = (ColumnReference)part;
                if (this.handleColumnReference(srcExpressionParent, destBuilder, cRef)) continue;
                return null;
            }
            if (part instanceof Filter) {
                FmFilter filter = (FmFilter)part;
                if (this.handleFilter(srcExpressionParent, destBuilder, filter)) continue;
                return null;
            }
            if (part instanceof Calculation) {
                FmCalculation calculation = (FmCalculation)part;
                if (this.handleCalculation(srcExpressionParent, destBuilder, calculation)) continue;
                return null;
            }
            if (part instanceof FmUnresolvedReference) {
                FmUnresolvedReference ref = (FmUnresolvedReference)part;
                throw new FmMDException("BMT_MD_ERROR_INVALID_REFERENCE", ref.getReference());
            }
            FmMDException.ASSERT(false, "Unexpected expression part: " + part.getClass().toString() + " from " + srcExpr.getExpressionText());
        }
        return destBuilder;
    }

    protected abstract boolean handleCalculation(ExpressionParent var1, FmExpressionBuilder var2, FmCalculation var3);

    protected abstract boolean handleFilter(ExpressionParent var1, FmExpressionBuilder var2, FmFilter var3);

    protected abstract boolean handleColumnReference(ExpressionParent var1, FmExpressionBuilder var2, ColumnReference var3);

    protected abstract boolean handleQueryItemBase(ExpressionParent var1, FmExpressionBuilder var2, FmQueryItemBase var3);
}

