/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.EmbeddedFilter;
import com.ibm.cognos.fmeng.fmmd.impl.model.FilterDefinitionParentInternal;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmComplexProperty;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmExpression;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.FilterApplication;
import com.ibm.cognos.fmeng.fmmd.model.FilterDefinition;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.fmmd.util.FmExpressionBuilder;
import com.ibm.cognos.fmeng.genmodel.ApplyType;
import com.ibm.cognos.fmeng.genmodel.ExpressionType;
import com.ibm.cognos.fmeng.genmodel.FilterDefinitionType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmFilterDefinition
extends FmComplexProperty
implements EmbeddedFilter,
FilterDefinition {
    private FilterDefinitionType m_emfObj;

    private FmFilterDefinition(FMMDSession session, Object emfObj) {
        super(session, emfObj);
        if (emfObj != null) {
            FmMDException.ASSERT(emfObj instanceof FilterDefinitionType, null);
            this.m_emfObj = (FilterDefinitionType)emfObj;
        }
    }

    public static FmFilterDefinition get(FMMDSession session, Object object) {
        FmFilterDefinition fmFilterDefinitionObj = null;
        if (object != null) {
            FmMDException.ASSERT(object instanceof FilterDefinitionType, null);
            fmFilterDefinitionObj = new FmFilterDefinition(session, object);
        }
        return fmFilterDefinitionObj;
    }

    FilterDefinitionType getFilterDefinitionType() {
        return this.m_emfObj;
    }

    @Override
    public Object getInternal() {
        return this.m_emfObj;
    }

    @Deprecated
    public static FmFilterDefinition create(FMMDSession session) {
        FilterDefinitionType emfObj = GenmodelFactory.eINSTANCE.createFilterDefinitionType();
        ExpressionType expressionType = GenmodelFactory.eINSTANCE.createExpressionType();
        emfObj.setExpression(expressionType);
        return new FmFilterDefinition(session, emfObj);
    }

    public static FilterDefinition create(EMFSession session, FilterDefinitionParentInternal parent, String name, ExpressionBuilder expression) {
        String objectName = parent.makeObjectNameUnique(name, 46);
        FmFilterDefinition.checkExpressionScope(parent, (FmExpressionBuilder)expression);
        FilterDefinitionType emfObj = GenmodelFactory.eINSTANCE.createFilterDefinitionType();
        emfObj.setDisplayName(objectName);
        emfObj.setApply(ApplyType.ALWAYS);
        FmExpression exp = FmExpression.create((FMMDSession)session, expression);
        emfObj.setExpression(exp.getExpressionType());
        FmFilterDefinition newFilter = new FmFilterDefinition(session, emfObj);
        parent.addFilterDefinition(newFilter);
        return newFilter;
    }

    private static void checkExpressionScope(FilterDefinitionParentInternal parent, FmExpressionBuilder expression) {
        if (expression != null) {
            for (Object part : expression.getExpressionParts()) {
                FmQueryItemBase qi;
                if (!(part instanceof FmQueryItemBase) || parent.isQueryItemInFilterScope(qi = (FmQueryItemBase)part)) continue;
                throw new FmMDException("BMT_MD_EXPRESSION_ITEM_NOT_IN_FILTER_SCOPE", qi.getName(), parent.getName());
            }
        }
    }

    public BaseObject getRefobj() {
        EObject ref = this.getFilterDefinitionType().getRefobj();
        return FmModelFactory.getInstance().get(this.m_session, ref);
    }

    @Override
    public void setRefobj(FmBaseObject refObj) {
        Object ref;
        if (refObj != null && (ref = refObj.getInternal()) != null) {
            this.getFilterDefinitionType().setRefobj((EObject)ref);
        }
    }

    public void unSetRefobj() {
        this.m_session.getGateway().clearProperty(this.getFilterDefinitionType(), 0);
    }

    @Override
    public String getDisplayName() {
        return this.getFilterDefinitionType().getDisplayName();
    }

    public void setDisplayName(String nameValue) {
        if (nameValue != null) {
            this.getFilterDefinitionType().setDisplayName(nameValue);
        }
    }

    @Override
    public void unSetDisplayName() {
        this.m_session.getGateway().clearProperty(this.getFilterDefinitionType(), 1);
    }

    @Override
    public FmExpression getExpression() {
        FmExpression exp = FmExpression.get((FMMDSession)this.m_session, this.getFilterDefinitionType().getExpression());
        return exp;
    }

    @Override
    public Expression setExpression(ExpressionBuilder expression) {
        FmExpression exp = FmExpression.create((FMMDSession)this.m_session, expression);
        this.getFilterDefinitionType().setExpression(exp.getExpressionType());
        return exp;
    }

    @Override
    public void unSetExpression() {
        this.m_session.getGateway().clearProperty(this.getFilterDefinitionType(), 2);
    }

    public String getApply() {
        ApplyType apply = this.getFilterDefinitionType().getApply();
        if (apply != null) {
            return apply.getLiteral();
        }
        return null;
    }

    public void setApply(String literal) {
        ApplyType apply = ApplyType.get(literal);
        if (apply != null) {
            this.getFilterDefinitionType().setApply(apply);
        }
    }

    public void unsetApply() {
        this.getFilterDefinitionType().unsetApply();
    }

    public boolean isSetApply() {
        return this.getFilterDefinitionType().isSetApply();
    }

    @Override
    public String getPropertyName() {
        return this.getFilterDefinitionType().getDisplayName();
    }

    public void getReferencedObjects(Collection<BaseObject> objects) {
        TopLevelObject bo;
        EObject obj = this.getFilterDefinitionType().getRefobj();
        if (obj != null && (bo = FmModelFactory.getInstance().get(this.m_session, obj)) != null) {
            objects.add(bo);
        }
        FmExpression exp = this.getExpression();
        exp.getReferencedObjects(objects, true);
    }

    public boolean breakReferencesTo(FmBaseObject object) {
        FmExpression exp;
        boolean ret = false;
        if (object.equals(this.getRefobj())) {
            this.getFilterDefinitionType().setRefobj(this.m_session.createBrokenReference(object));
            ret = true;
        }
        if ((exp = this.getExpression()).breakReferencesTo(object)) {
            ret = true;
        }
        return ret;
    }

    @Override
    public FilterApplication.EFilterApplication getFilterApplication() {
        switch (this.getFilterDefinitionType().getApply()) {
            case ALWAYS: {
                return FilterApplication.EFilterApplication.always;
            }
            case AS_NEEDED: {
                return FilterApplication.EFilterApplication.optional;
            }
            case DESIGN_ONLY: {
                return FilterApplication.EFilterApplication.designOnly;
            }
        }
        FmMDException.ASSERT(false, "Bad filter definition apply value: " + this.getFilterDefinitionType().getApply().toString());
        return null;
    }

    @Override
    public void setFilterApplication(FilterApplication.EFilterApplication apply) {
        switch (apply) {
            case always: {
                this.getFilterDefinitionType().setApply(ApplyType.ALWAYS);
                break;
            }
            case optional: {
                this.getFilterDefinitionType().setApply(ApplyType.AS_NEEDED);
                break;
            }
            case designOnly: {
                this.getFilterDefinitionType().setApply(ApplyType.DESIGN_ONLY);
                break;
            }
            default: {
                FmMDException.ASSERT(false, "Bad filter definition apply value: " + apply.toString());
            }
        }
    }
}

