/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmNamespace;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSection;
import com.ibm.cognos.fmeng.fmmd.impl.model.NamingListener;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.Folder;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.NameType;
import com.ibm.cognos.fmeng.genmodel.NamespaceType;
import com.ibm.cognos.fmeng.genmodel.SectionType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.List;
import java.util.Locale;
import org.eclipse.emf.common.util.EList;

public class FmFolder
extends FmSection
implements Folder {
    protected static FmFolder createFolder(FMMDSession session, FmSection parent, String objectName) {
        if (objectName == null || objectName.length() == 0) {
            objectName = FmFolder.getDefaultName(session.getActiveLocale());
        }
        SectionType emfObj = GenmodelFactory.eINSTANCE.createSectionType();
        FmFolder folder = new FmFolder(session, emfObj);
        parent.addFolder(folder);
        String uniqueName = folder.makeUniqueName(objectName);
        String localeKey = FmModelFactory.getInstance().getProject(session).getDefaultLocale();
        folder.setName(localeKey, uniqueName);
        return folder;
    }

    public static FmFolder get(FMMDSession session, Object emfobj) {
        return new FmFolder(session, (SectionType)emfobj);
    }

    private FmFolder(FMMDSession session, SectionType emfObject) {
        super(session, emfObject);
    }

    public FmObjectType getFmObjectType() {
        return FmObjectType.folder;
    }

    public static String getDefaultName(Locale locale) {
        return FmMessage.render("BMT_MDN_OBJECT_NAME_FOLDER", locale);
    }

    SectionType getSectionType() {
        return (SectionType)this.m_emfObject;
    }

    public FmNamespace getParentNamespace() {
        Object parent = this.m_session.getGateway().getParent(this.m_emfObject);
        while (parent != null && !(parent instanceof NamespaceType)) {
            parent = this.m_session.getGateway().getParent(parent);
        }
        return FmNamespace.get(this.m_session, parent);
    }

    protected void makeAllNamesUnique(BaseObject.PrefixName namingStrategy, FmBaseObject parentObject, NamingListener listener) {
        EList<NameType> names = this.getReportObjectType().getName();
        for (NameType name : names) {
            String uniqueName = parentObject.makeChildUniqueName(name.getValue(), this.getFmObjectType(), namingStrategy, this);
            if (uniqueName.equals(name.getValue())) continue;
            if (listener != null) {
                listener.objectRenamed(this, name.getValue(), uniqueName, name.getLocale());
            }
            name.setValue(uniqueName);
        }
        List<BaseObject> children = this.getChildObjects();
        for (BaseObject child : children) {
            if (!(child instanceof FmReportObject)) continue;
            FmReportObject ro = (FmReportObject)child;
            ro.makeAllNamesUnique(namingStrategy, parentObject, listener);
        }
    }
}

