/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmGovernorBase;
import com.ibm.cognos.fmeng.fmmd.model.GovernorBase;
import com.ibm.cognos.fmeng.fmmd.model.GovernorWithListValue;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmGovernorWithListValue
extends FmGovernorBase
implements GovernorWithListValue {
    private int m_defaultValueIndex;
    private String m_defaultValue;
    private String m_defaultValueKey;
    private Map<String, String> m_valuesMap;
    private List<String> m_keys;
    private List<String> m_values;

    public FmGovernorWithListValue(String id, String label, String defaultValueKey, Map<String, String> valuesMap, List<String> keys) {
        if (keys.size() != valuesMap.size()) {
            throw new FmMDException("Number of keys don't match the number or values", id);
        }
        this.m_id = id;
        this.m_label = label;
        this.m_defaultValueKey = defaultValueKey;
        this.m_valuesMap = valuesMap;
        this.m_defaultValue = this.m_valuesMap.get(this.m_defaultValueKey);
        this.m_keys = keys;
        this.m_values = new ArrayList<String>();
        for (String key : this.m_keys) {
            this.m_values.add(this.m_valuesMap.get(key));
        }
    }

    @Override
    public GovernorBase.GovernorType getType() {
        return GovernorBase.GovernorType.list;
    }

    @Override
    public boolean isTypeBoolean() {
        return false;
    }

    @Override
    public boolean isTypeInt() {
        return false;
    }

    @Override
    public boolean isTypeList() {
        return true;
    }

    @Override
    public int getDefaultValueIndex() {
        return this.m_defaultValueIndex;
    }

    @Override
    public String getDefaultValue() {
        return this.m_defaultValue;
    }

    @Override
    public Map<String, String> getMapOfApplicableValues() {
        return this.m_valuesMap;
    }

    @Override
    public List<String> getListOfApplicableValues() {
        return this.m_values;
    }

    @Override
    public List<String> getIdsOfApplicableValues() {
        return this.m_keys;
    }

    @Override
    public String getDefaultValueAsString() {
        return this.m_defaultValue;
    }

    @Override
    public String toString() {
        String temp = "Id: " + this.m_id + "\n" + "Label: " + this.m_label + "\n" + "Type: " + (Object)((Object)this.getType()) + "\n" + "Default value: " + this.m_defaultValue + "\n" + "Default value key: " + this.m_defaultValueKey + "\n" + "Applicable Values:-" + "\n";
        for (String key : this.m_keys) {
            temp = String.valueOf(temp) + "Key: " + key + "|| Value: " + this.m_valuesMap.get(key) + "\n";
        }
        temp = String.valueOf(temp) + "=================================================================" + "\n";
        return temp;
    }
}

