/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmEMDObjectNaming;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmHierarchyFolder;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.LevelParentInternal;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.Hierarchy;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.util.EmfRecurseHelper;
import com.ibm.cognos.fmeng.fmmd.util.ObjectHelper;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.HierarchyType;
import com.ibm.cognos.fmeng.genmodel.LevelType;
import com.ibm.cognos.fmeng.genmodel.NameType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmHierarchy
extends FmReportObject
implements Hierarchy,
LevelParentInternal {
    static final String BMTCR1_OBJECT_RELATIONSHIP = "relationship";

    public static FmHierarchy get(FMMDSession session, Object emfobj) {
        return new FmHierarchy(session, (HierarchyType)emfobj);
    }

    public static FmHierarchy createHierarchy(FMMDSession session, FmDimension parent, String objectName, FmEMDObjectNaming fmEMDObjectNaming, boolean createAllLevel) {
        if (objectName == null || objectName.length() == 0) {
            objectName = FmHierarchy.getDefaultName(session.getActiveLocale());
        }
        HierarchyType emfObj = GenmodelFactory.eINSTANCE.createHierarchyType();
        FmHierarchy hierarchy = new FmHierarchy(session, emfObj);
        parent.addHierarchy(hierarchy);
        String uniqueName = hierarchy.makeUniqueName(objectName);
        String localeKey = FmModelFactory.getInstance().getProject(session).getDefaultLocale();
        hierarchy.setName(localeKey, uniqueName);
        if (createAllLevel) {
            hierarchy.createAllLevel();
        } else {
            String localeBasedHierarchyName = hierarchy.getName();
            localeBasedHierarchyName = String.valueOf(localeBasedHierarchyName) + FmMessage.render("BMT_MDS_OLAP_ALL", hierarchy.getProject().getDefaultLocale());
            hierarchy.setRootCaption(localeBasedHierarchyName);
            hierarchy.setRootMun("[all]");
        }
        return hierarchy;
    }

    public static FmHierarchy createHierarchy(FMMDSession session, FmHierarchyFolder parent, String objectName, FmEMDObjectNaming fmEMDObjectNaming, boolean createAllLevel) {
        if (objectName == null || objectName.length() == 0) {
            objectName = FmHierarchy.getDefaultName(session.getActiveLocale());
        }
        HierarchyType emfObj = GenmodelFactory.eINSTANCE.createHierarchyType();
        FmHierarchy hierarchy = new FmHierarchy(session, emfObj);
        parent.addHierarchy(hierarchy);
        String uniqueName = hierarchy.makeUniqueName(objectName);
        String localeKey = FmModelFactory.getInstance().getProject(session).getDefaultLocale();
        hierarchy.setName(localeKey, uniqueName);
        if (createAllLevel) {
            hierarchy.createAllLevel();
        }
        return hierarchy;
    }

    @Override
    void verifyReorderBefore(List<? extends BaseObject> reorderObjHandles, BaseObject referenceObjHandle) {
        FmLevel fmLevel;
        FmQuerySubjectBase objQueryBase = this.getQueryParent();
        QuerySubjectBase.EDefinitionType eOwnerType = objQueryBase.getDefinitionType();
        if (eOwnerType == QuerySubjectBase.EDefinitionType.kTypeMultiDimensionalQuery) {
            Object[] objectArray = new Object[]{ObjectHelper.renderObjects(this.m_session, reorderObjHandles, 1, true), objQueryBase.getName(), objQueryBase.getLocalizedDefinitionType()};
            FmMDException mdException = new FmMDException("BMT_MD_UNSUPPORTED_QUERYITEM_OPERATION_TYPE", objectArray);
            throw mdException;
        }
        if (referenceObjHandle != null && (fmLevel = (FmLevel)referenceObjHandle).isAllLevel()) {
            FmMDException mdException = new FmMDException("BMT_MD_ERROR_ALL_LEVEL_FIRST_LEVEL");
            throw mdException;
        }
        for (BaseObject baseObject : reorderObjHandles) {
            FmLevel objLevel = (FmLevel)baseObject;
            if (!objLevel.isAllLevel()) continue;
            FmMDException mdException = new FmMDException("BMT_MD_ERROR_ALL_LEVEL_FIRST_LEVEL");
            throw mdException;
        }
    }

    public static String getDefaultName(Locale locale) {
        return FmMessage.render("BMT_MDN_OBJECT_NAME_HIERARCHY", locale);
    }

    private FmHierarchy(FMMDSession session, HierarchyType emfObject) {
        super(session, emfObject);
    }

    @Override
    public FmObjectType getFmObjectType() {
        return FmObjectType.hierarchy;
    }

    @Override
    public List<Level> getLevels() {
        EList<LevelType> levels = this.getHierarchyType().getLevel();
        ArrayList<Level> res = new ArrayList<Level>(levels.size());
        for (LevelType level : levels) {
            res.add(FmLevel.get(this.m_session, level));
        }
        return res;
    }

    public FmLevel getLeafLevel() {
        EList<LevelType> levels = ((HierarchyType)this.m_emfObject).getLevel();
        LevelType leaf = (LevelType)levels.get(levels.size() - 1);
        FmLevel leafLevel = (FmLevel)FmModelFactory.getInstance().get(this.m_session, leaf);
        return leafLevel;
    }

    HierarchyType getHierarchyType() {
        return (HierarchyType)this.m_emfObject;
    }

    @Override
    void addChild(Object eObj) {
        switch (this.m_session.getGateway().getClassifierType(eObj)) {
            case 66: {
                this.addLevel((LevelType)eObj);
                return;
            }
        }
        super.addChild(eObj);
    }

    private void addLevel(LevelType lt) {
        this.getHierarchyType().getLevel().add((Object)lt);
    }

    @Override
    public void addLevel(Level level) {
        this.addLevel(((FmLevel)level).getLevelType());
    }

    @Override
    public Level createLevel(String name) {
        return FmLevel.createLevel(this.m_session, this, name);
    }

    public List<FmQueryItem> getAllQueryItems() {
        EmfRecurseHelper allStuff = new EmfRecurseHelper(this.m_session, this.m_emfObject);
        allStuff.addRecurseInto(115);
        allStuff.addRecurseInto(66);
        return allStuff.collect(119);
    }

    @Override
    public FmQuerySubjectBase getQueryParent() {
        return FmQuerySubjectBase.getQueryParent(this);
    }

    @Override
    public FmDimension getDimension() {
        return (FmDimension)this.getQueryParent();
    }

    @Override
    public String getExternalName() {
        return this.getHierarchyType().getExternalName();
    }

    private FmLevel createAllLevel() {
        FmDimension dim = this.getDimension();
        if (dim.getDefaultHierarchy() == null) {
            dim.setDefaultHierarchy(this);
        }
        String localeBasedHierarchyName = this.getName();
        localeBasedHierarchyName = String.valueOf(localeBasedHierarchyName) + FmMessage.render("BMT_MDS_OLAP_ALL", this.getProject().getDefaultLocale());
        FmLevel allLevel = (FmLevel)this.createLevel(localeBasedHierarchyName);
        allLevel.setIsManual(true);
        this.setRootCaption(localeBasedHierarchyName);
        this.setRootMun(allLevel.getMUNName());
        return allLevel;
    }

    private void setRootCaption(String value) {
        this.setRootCaption(this.getProject().getDefaultLocale(), value);
    }

    @Override
    public void setRootCaption(String locale, String value) {
        EList<NameType> names = this.getHierarchyType().getRootCaption();
        boolean set = false;
        for (NameType name : names) {
            if (!name.getLocale().equals(locale)) continue;
            name.setValue(value);
            set = true;
            break;
        }
        if (!set) {
            NameType name;
            name = GenmodelFactory.eINSTANCE.createNameType();
            name.setValue(value);
            name.setLocale(locale);
            names.add(name);
        }
    }

    @Override
    public String getRootCaption(String locale) {
        for (NameType name : this.getHierarchyType().getRootCaption()) {
            if (!name.getLocale().equals(locale)) continue;
            return name.getValue();
        }
        return null;
    }

    @Override
    public String getRootMember() {
        return this.getHierarchyType().getRootMember();
    }

    @Override
    public void setRootMember(String name) {
        this.getHierarchyType().setRootMember(name);
        String locale = this.getProject().getDefaultLocale();
        String caption = this.getRootCaption(locale);
        if (caption == null) {
            this.setRootCaption(locale, name);
        }
    }

    private void setRootMun(String mun) {
        this.getHierarchyType().setRootMUN(mun);
    }

    @Override
    public boolean getBalanced() {
        return this.getHierarchyType().isBalanced();
    }

    @Override
    public void setBalanced(boolean balanced) {
        this.getHierarchyType().setBalanced(balanced);
    }

    @Override
    public boolean getRagged() {
        return this.getHierarchyType().isRagged();
    }

    @Override
    public void setRagged(boolean ragged) {
        this.getHierarchyType().setRagged(ragged);
    }

    @Override
    public String getRootMUN() {
        return this.getHierarchyType().getRootMUN();
    }

    @Override
    public void setRootMUN(String rootMUN) {
        this.getHierarchyType().setRootMUN(rootMUN);
    }

    @Override
    public boolean getParentChild() {
        return this.getHierarchyType().isParentChild();
    }

    public void setParentChild(boolean parentChild) {
        this.getHierarchyType().setParentChild(parentChild);
    }

    @Override
    public boolean getIsWideFan() {
        return this.getHierarchyType().isIsWideFan();
    }

    @Override
    public void setIsWideFan(boolean isWideFan) {
        this.getHierarchyType().setIsWideFan(isWideFan);
    }

    public void copyNames(FmHierarchy nameSource, BaseObject.PrefixName namingStrategy, FmBaseObject parentObject) {
        super.copyNames(nameSource, namingStrategy, parentObject);
        EList<NameType> names = nameSource.getHierarchyType().getRootCaption();
        for (NameType name : names) {
            this.setRootCaption(name.getLocale(), name.getValue());
        }
    }

    @Override
    public List<Level> getAllLevels() {
        ArrayList<Level> levels = new ArrayList<Level>();
        for (LevelType level : this.getHierarchyType().getLevel()) {
            levels.add(FmLevel.get(this.m_session, level));
        }
        return levels;
    }

    @Override
    public void removeRootCaptionLocale(String localeKey) {
        this.removeLocale((List<NameType>)this.getHierarchyType().getRootCaption(), localeKey);
    }
}

