/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmAssociation;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPhysicalDefinition;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPseudoModelObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTable;
import com.ibm.cognos.fmeng.fmmd.model.Association;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.Cardinality;
import com.ibm.cognos.fmeng.fmmd.model.Join;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import com.ibm.cognos.fmeng.fmmd.util.FmJoinHelper;
import com.ibm.cognos.fmeng.fmmd.util.JoinBase;
import com.ibm.cognos.fmeng.genmodel.AssociationType;
import com.ibm.cognos.fmeng.genmodel.CardinalityEnum;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.JoinType;
import com.ibm.cognos.fmeng.genmodel.PhysicalDefinitionType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmJoin
extends FmPseudoModelObject
implements Join,
JoinBase<FmTable, FmJoin>,
Comparable<FmJoin> {
    FmJoin(FMMDSession session, Object object) {
        super(session, object);
    }

    public static FmJoin createJoin(FMMDSession session, FmPhysicalDefinition fmPhysicalDefinition, String name, FmTable left, FmTable right) {
        String objectName = fmPhysicalDefinition.makeObjectNameUnique(name, 59);
        JoinType joinType = GenmodelFactory.eINSTANCE.createJoinType();
        joinType.setLeftPhysicalObjectRef(left.getName());
        joinType.setRightPhysicalObjectRef(right.getName());
        FmJoin join = new FmJoin(session, joinType);
        fmPhysicalDefinition.addJoin(join);
        join.setName(objectName);
        join.setLeftMincard(Cardinality.ECardinality.one);
        join.setLeftMaxcard(Cardinality.ECardinality.one);
        join.setRightMincard(Cardinality.ECardinality.one);
        join.setRightMaxcard(Cardinality.ECardinality.many);
        return join;
    }

    public static FmJoin get(FMMDSession session, Object object) {
        return new FmJoin(session, object);
    }

    protected JoinType getJoinType() {
        return (JoinType)this.m_emfObject;
    }

    @Override
    public FmAssociation createAssociation(String leftColumn, String rightColumn, Association.EOperator operator) {
        FmAssociation association = FmAssociation.createAssociation(this.m_session, this, leftColumn, rightColumn, operator);
        return association;
    }

    public void addAssociation(FmAssociation association) {
        this.getJoinType().getAssociation().add((Object)association.getAssociationType());
    }

    @Override
    public List<Association> getAssociations() {
        ArrayList<Association> associations = new ArrayList<Association>();
        for (AssociationType association : this.getJoinType().getAssociation()) {
            associations.add(FmAssociation.get(this.m_session, association));
        }
        return associations;
    }

    @Override
    public Table getLeftTable() {
        PhysicalDefinitionType parentObject = (PhysicalDefinitionType)this.getJoinType().eContainer();
        return FmPhysicalDefinition.getTable(this.m_session, parentObject, this.getJoinType().getLeftPhysicalObjectRef());
    }

    @Override
    public Table getRightTable() {
        PhysicalDefinitionType parentObject = (PhysicalDefinitionType)this.getJoinType().eContainer();
        return FmPhysicalDefinition.getTable(this.m_session, parentObject, this.getJoinType().getRightPhysicalObjectRef());
    }

    @Override
    public FmTable getLeft() {
        return (FmTable)this.getLeftTable();
    }

    @Override
    public FmTable getRight() {
        return (FmTable)this.getRightTable();
    }

    @Override
    public Cardinality.ECardinality getLeftMincard() {
        return this.getCardinalityType(this.getJoinType().getLeftMinCard());
    }

    @Override
    public void setLeftMincard(Cardinality.ECardinality card) {
        this.getJoinType().setLeftMinCard(this.getCardinality(card));
    }

    @Override
    public Cardinality.ECardinality getRightMincard() {
        return this.getCardinalityType(this.getJoinType().getRightMinCard());
    }

    @Override
    public void setRightMincard(Cardinality.ECardinality card) {
        this.getJoinType().setRightMinCard(this.getCardinality(card));
    }

    @Override
    public Cardinality.ECardinality getLeftMaxcard() {
        return this.getCardinalityType(this.getJoinType().getLeftMaxCard());
    }

    @Override
    public void setLeftMaxcard(Cardinality.ECardinality card) {
        this.getJoinType().setLeftMaxCard(this.getCardinality(card));
    }

    @Override
    public Cardinality.ECardinality getRightMaxcard() {
        return this.getCardinalityType(this.getJoinType().getRightMaxCard());
    }

    @Override
    public void setRightMaxcard(Cardinality.ECardinality card) {
        this.getJoinType().setRightMaxCard(this.getCardinality(card));
    }

    protected Cardinality.ECardinality getCardinalityType(CardinalityEnum enumValue) {
        switch (enumValue) {
            case UNKNOWN: {
                return Cardinality.ECardinality.unknown;
            }
            case UNSUPPORTED: {
                return Cardinality.ECardinality.unsupported;
            }
            case ZERO: {
                return Cardinality.ECardinality.zero;
            }
            case ONE: {
                return Cardinality.ECardinality.one;
            }
            case MANY: {
                return Cardinality.ECardinality.many;
            }
        }
        return Cardinality.ECardinality.unknown;
    }

    protected CardinalityEnum getCardinality(Cardinality.ECardinality card) {
        switch (card) {
            case unknown: {
                return CardinalityEnum.UNKNOWN;
            }
            case unsupported: {
                return CardinalityEnum.UNSUPPORTED;
            }
            case zero: {
                return CardinalityEnum.ZERO;
            }
            default: {
                return CardinalityEnum.ONE;
            }
            case many: 
        }
        return CardinalityEnum.MANY;
    }

    private String getStartPrivate() {
        if (FmJoinHelper.isStart(this.getLeftMaxcard(), this.getRightMaxcard())) {
            return this.getJoinType().getLeftPhysicalObjectRef();
        }
        if (FmJoinHelper.isStart(this.getRightMaxcard(), this.getLeftMaxcard())) {
            return this.getJoinType().getRightPhysicalObjectRef();
        }
        return this.getJoinType().getLeftPhysicalObjectRef();
    }

    @Override
    public FmTable getEnd() {
        PhysicalDefinitionType parentObject = (PhysicalDefinitionType)this.getJoinType().eContainer();
        if (this.getStartPrivate().equals(this.getJoinType().getLeftPhysicalObjectRef())) {
            return FmPhysicalDefinition.getTable(this.m_session, parentObject, this.getJoinType().getRightPhysicalObjectRef());
        }
        return FmPhysicalDefinition.getTable(this.m_session, parentObject, this.getJoinType().getLeftPhysicalObjectRef());
    }

    @Override
    public FmTable getStart() {
        PhysicalDefinitionType parentObject = (PhysicalDefinitionType)this.getJoinType().eContainer();
        return FmPhysicalDefinition.getTable(this.m_session, parentObject, this.getJoinType().getLeftPhysicalObjectRef());
    }

    @Override
    public void remove() {
        this.m_session.getGateway().delete(this.getJoinType());
    }

    @Override
    public int compareTo(FmJoin right) {
        return this.getName().compareTo(right.getName());
    }

    @Override
    public boolean equals(FmJoin right) {
        return this.getName().equals(right.getName());
    }

    @Override
    public RelationalObject getRelationalParent() {
        BaseObject parent = this.getParent();
        while (parent != null && !(parent instanceof RelationalObject)) {
            parent = parent.getParent();
        }
        return (RelationalObject)parent;
    }

    boolean tableRemoved(Table table) {
        if (this.getLeft().equals(table) || this.getRight().equals(table)) {
            this.remove();
            return true;
        }
        return false;
    }

    @Override
    public FmTable getOtherSide(FmTable table) {
        return new FmJoinHelper<FmTable, FmJoin>().getOtherSide(this, table);
    }

    @Override
    public void copyCardinality(Cardinality right) {
        FmJoinHelper.copyCardinality(this, right);
    }

    public String toString() {
        String foo = this.getName();
        foo = String.valueOf(foo) + "(" + this.getLeftMincard().toString() + "-" + this.getLeftMaxcard().toString() + " : " + this.getRightMincard().toString() + "-" + this.getRightMaxcard().toString() + ")\n\t";
        foo = String.valueOf(foo) + this.getLeft().getName();
        foo = String.valueOf(foo) + " <---> ";
        foo = String.valueOf(foo) + this.getRight().getName();
        return foo;
    }

    @Override
    public boolean equals(Cardinality.ECardinality leftMinCard, Cardinality.ECardinality leftMaxCard, Cardinality.ECardinality rightMinCard, Cardinality.ECardinality rightMaxCard) {
        return leftMinCard.equals((Object)this.getLeftMincard()) && leftMaxCard.equals((Object)this.getLeftMaxcard()) && rightMinCard.equals((Object)this.getRightMincard()) && rightMaxCard.equals((Object)this.getRightMaxcard());
    }
}

