/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.helpers.XExecuteCommandHelper;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmEMDObjectNaming;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmExpression;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMultilingualAttributeMap;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemFolder;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmShortcut;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSortItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSortItems;
import com.ibm.cognos.fmeng.fmmd.impl.model.LevelParentInternal;
import com.ibm.cognos.fmeng.fmmd.impl.model.QueryItemParentInternal;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveListener;
import com.ibm.cognos.fmeng.fmmd.impl.task.planner.XAdaptor;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.BasedOn;
import com.ibm.cognos.fmeng.fmmd.model.DimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.LevelStyle;
import com.ibm.cognos.fmeng.fmmd.model.Levels;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.Role;
import com.ibm.cognos.fmeng.fmmd.model.SortItem;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.LevelKeysType;
import com.ibm.cognos.fmeng.genmodel.LevelStyleType;
import com.ibm.cognos.fmeng.genmodel.LevelType;
import com.ibm.cognos.fmeng.genmodel.MultilingualAttributeMapType;
import com.ibm.cognos.fmeng.genmodel.OrderByType;
import com.ibm.cognos.fmeng.genmodel.RelationalDimensionType;
import com.ibm.cognos.fmeng.genmodel.SortItemType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import com.ibm.cognos.fmeng.utility.queryTemplates.LevelMemberCount;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmLevel
extends FmQueryItemFolder
implements Level,
BasedOn,
QueryItemParentInternal {
    public static FmLevel get(FMMDSession session, Object emfobj) {
        return new FmLevel(session, (LevelType)emfobj);
    }

    public static String getDefaultName(Locale locale) {
        return FmMessage.render("BMT_MDN_OBJECT_NAME_LEVEL", locale);
    }

    public static Level createLevelFromLevel(FMMDSession session, FmRelationalDimension parent, Level srcLevel) {
        LevelType emfObj = GenmodelFactory.eINSTANCE.createLevelType();
        FmLevel level = new FmLevel(session, emfObj);
        parent.addLevel(level);
        String uniqueName = level.makeUniqueName(srcLevel.getName());
        String localeKey = FmModelFactory.getInstance().getProject(session).getDefaultLocale();
        level.setName(localeKey, uniqueName);
        level.copyCommonProperties(srcLevel, parent);
        level.setIsAllLevel(srcLevel.isAllLevel());
        level.setIsUnique(srcLevel.getIsUnique());
        return level;
    }

    public static FmLevel createLevel(FMMDSession session, LevelParentInternal parent, String objectName) {
        if (objectName == null || objectName.length() == 0) {
            objectName = FmLevel.getDefaultName(session.getActiveLocale());
        }
        LevelType emfObj = GenmodelFactory.eINSTANCE.createLevelType();
        FmLevel level = new FmLevel(session, emfObj);
        parent.addLevel(level);
        String uniqueName = level.makeUniqueName(objectName);
        String localeKey = FmModelFactory.getInstance().getProject(session).getDefaultLocale();
        level.setName(localeKey, uniqueName);
        return level;
    }

    public static FmLevel createLevel(FMMDSession session, LevelParentInternal parent, String objectName, short eMDObjectNaming, List<FmQueryItemBase> fmQueryItems) {
        FmLevel level = FmLevel.createLevel(session, parent, objectName);
        if (fmQueryItems != null) {
            level.createItemsBasedOnQueryItems(fmQueryItems, null);
        }
        return level;
    }

    public List<FmQueryItem> createItemsBasedOnQueryItems(List<FmQueryItemBase> items, FmShortcut sc) {
        ArrayList<FmQueryItem> res = new ArrayList<FmQueryItem>(items.size());
        for (FmQueryItemBase sourceItem : items) {
            res.add(this.createQueryItem(sourceItem.getName(), sourceItem, sc));
        }
        return res;
    }

    private FmLevel(FMMDSession session, LevelType emfObject) {
        super(session, emfObject);
    }

    @Override
    public FmObjectType getFmObjectType() {
        return FmObjectType.level;
    }

    @Override
    public FmQueryItemFolder createQueryItemFolder(String objectName) {
        FmQueryItemFolder qi = FmQueryItemFolder.createQueryItemFolder(this.m_session, this, objectName, FmEMDObjectNaming.kMakeUnique);
        return qi;
    }

    public FmQueryItem createQueryItem(String objectName, FmQueryItemBase basedOnItem, FmShortcut sc) {
        FmQueryItem qi = FmQueryItem.createQueryItemFromQueryItem(this.m_session, basedOnItem, this, objectName, FmEMDObjectNaming.kMakeUnique, sc);
        return qi;
    }

    LevelType getLevelType() {
        return (LevelType)this.m_emfObject;
    }

    void setIsManual(boolean isManual) {
        this.getLevelType().setIsManual(isManual);
    }

    public boolean getIsManual() {
        return this.getLevelType().isIsManual();
    }

    @Override
    public void setIsAllLevel(boolean isAllLevel) {
        this.getLevelType().setIsManual(isAllLevel);
    }

    @Override
    public boolean isAllLevel() {
        return ((LevelType)this.m_emfObject).isIsManual();
    }

    public FmHierarchy getParentHierarchy() {
        BaseObject parent = this.getParent();
        while (parent != null && !(parent instanceof FmHierarchy)) {
            parent = parent.getParent();
        }
        return (FmHierarchy)parent;
    }

    @Override
    public DimensionBase getDimension() {
        BaseObject parent = this.getParent();
        while (parent != null && !(parent instanceof DimensionBase)) {
            parent = parent.getParent();
        }
        return (DimensionBase)parent;
    }

    public String getMUNName() {
        return "[all]";
    }

    @Override
    public String getExternalName() {
        return this.getLevelType().getExternalName();
    }

    @Override
    public void remove(RemoveInfo info, RemoveListener listener) {
        FmHierarchy hier = this.getParentHierarchy();
        if (hier != null && !info.isRemoved(hier) && this.isAllLevel()) {
            FmMDException invalidDeleteObjectException = new FmMDException();
            invalidDeleteObjectException.addMessage(new FmMessage("BMT_MD_ERROR_CANNOT_DELETE_ALL_LEVEL"));
            listener.reportError(invalidDeleteObjectException);
        }
        super.remove(info, listener);
    }

    @Override
    public void prepareForObjectDeletion(RemoveInfo info, FmBaseObject object, RemoveListener listener) {
        super.prepareForObjectDeletion(info, object, listener);
        if (object instanceof FmQueryItem) {
            RelationalDimension relDim;
            FmQueryItem qi = (FmQueryItem)object;
            RelationalObject ro = qi.getRelationalParent();
            if (ro != null && ro instanceof RelationalDimension && (relDim = (RelationalDimension)ro).isRollupDimension() && this.getLevelKeys().indexOf(qi) != -1) {
                listener.reportError(new FmMDException("BMT_MD_QUERY_ITEM_DEFINED_IN_ROLLUP_SOURCE", qi.getName()));
            }
            this.removeFromMemberSort(qi);
            this.removeLevelKey((QueryItem)((Object)object));
        }
    }

    @Override
    public void removeFromMemberSort(QueryItem item) {
        OrderByType obt = this.getLevelType().getMemberSort();
        if (obt != null) {
            EList<SortItemType> sorts = obt.getSortItem();
            Iterator it = sorts.iterator();
            while (it.hasNext()) {
                SortItemType st = (SortItemType)it.next();
                if (st.getRefobj() != item.getInternal()) continue;
                it.remove();
            }
        }
    }

    private FmSortItems getSortItemParent() {
        OrderByType obt = this.getLevelType().getMemberSort();
        if (obt == null) {
            obt = GenmodelFactory.eINSTANCE.createOrderByType();
            this.getLevelType().setMemberSort(obt);
        }
        return FmSortItems.get(this.m_session, obt);
    }

    @Override
    public List<SortItem> getMemberSortItems() {
        return this.getSortItemParent().getMemberSortItems();
    }

    @Override
    public SortItem findMemberSortItem(QueryItem itemToFind) {
        return this.getSortItemParent().findMemberSortItem(itemToFind);
    }

    public FmSortItem addDefaultMemberSortItem() {
        return this.getSortItemParent().addDefaultMemberSortItem();
    }

    @Override
    public SortItem addMemberSortItem(QueryItem qi, SortItem.ESortItem value, SortItem.ENullPlacement nullPlacement) {
        return this.getSortItemParent().addMemberSortItem(this, qi, value, nullPlacement);
    }

    @Override
    public SortItem addMemberSortItem(QueryItem qi, SortItem.ESortItem value) {
        return this.getSortItemParent().addMemberSortItem(this, qi, value);
    }

    @Override
    public void removeFromMemberSort(SortItem item) {
        this.getSortItemParent().removeFromMemberSort((FmQueryItem)item.getQueryItem());
    }

    @Override
    public void reorderMemberSortBefore(SortItem itemToReorder, SortItem before) {
        this.getSortItemParent().reorderBefore(itemToReorder, before);
    }

    @Override
    public void reorderMemberSortBefore(QueryItem itemToReorder, QueryItem before) {
        this.getSortItemParent().reorderBefore(itemToReorder, before);
    }

    @Override
    public boolean getIsUnique() {
        return this.getLevelType().isIsUnique();
    }

    @Override
    public void setIsUnique(boolean isUnique) {
        this.getLevelType().setIsUnique(isUnique);
    }

    public QueryItemBase getItemWithRole(String string) {
        return this.getItemWithRole(string, this.getSession().getProject().getDefaultLocale(), this.getAllQueryItems());
    }

    @Override
    public QueryItemBase getItemWithRole(String customRoleName, String locale) {
        return this.getItemWithRole(customRoleName, locale, this.getAllQueryItems());
    }

    @Override
    public QueryItemBase getItemWithRole(Role.EDefaultRoles role) {
        return this.getItemWithRole(role, this.getAllQueryItems());
    }

    @Override
    public QueryItemBase getQueryItemByName(String name) {
        List<QueryItem> items = this.getAllQueryItems();
        for (QueryItem item : items) {
            if (!item.getName().equals(name)) continue;
            return item;
        }
        return null;
    }

    @Override
    public LevelStyle getLevelStyle() {
        return LevelStyle.valueOf(this.getLevelType().getLevelStyle().toString());
    }

    @Override
    public void setLevelStyle(LevelStyle style) {
        this.getLevelType().setLevelStyle(LevelStyleType.valueOf(style.toString().toUpperCase()));
    }

    @Override
    public List<QueryItem> getLevelKeys() {
        ArrayList<QueryItem> outKeys = new ArrayList<QueryItem>();
        if (this.getLevelType().getLevelKeys() != null) {
            for (EObject refObj : this.getLevelType().getLevelKeys().getRefObj()) {
                outKeys.add(FmQueryItem.get(this.getSession(), refObj));
            }
        }
        return outKeys;
    }

    @Override
    public void addLevelKey(QueryItem key) {
        FmMDException.ASSERT(this.getParent() instanceof Levels, "Bad level type");
        FmMDException.ASSERT(key != null, "Null key specified.");
        if (!key.getRelationalParent().equals(this.getParent().getParent())) {
            throw new FmMDException("BMT_MD_MODEL_INTEGRITY_LEVEL_KEY_NOT_FROM_DIMENSION", key.getName(), this.getName());
        }
        LevelKeysType keysType = this.getLevelType().getLevelKeys();
        if (keysType == null) {
            keysType = GenmodelFactory.eINSTANCE.createLevelKeysType();
            this.getLevelType().setLevelKeys(keysType);
        }
        for (Object obj : keysType.getRefObj()) {
            if (!obj.equals(key.getInternal())) continue;
            return;
        }
        keysType.getRefObj().add((Object)((EObject)key.getInternal()));
    }

    @Override
    public void removeLevelKey(QueryItem key) {
        LevelKeysType keysType = this.getLevelType().getLevelKeys();
        if (keysType == null) {
            return;
        }
        keysType.getRefObj().remove(key.getInternal());
    }

    @Override
    public boolean isLevelKey(QueryItem item) {
        LevelKeysType keysType = this.getLevelType().getLevelKeys();
        if (keysType != null) {
            for (Object key : keysType.getRefObj()) {
                if (!key.equals(item.getInternal())) continue;
                return true;
            }
        }
        return false;
    }

    public FmMultilingualAttributeMap getMultilingualAttributeMap() {
        if (this.getLevelType().getMultilingualAttributeMap() == null) {
            return FmMultilingualAttributeMap.createMultilingualAttributeMap((FMMDSession)this.m_session, this);
        }
        return FmMultilingualAttributeMap.get(this.m_session, this.getLevelType().getMultilingualAttributeMap());
    }

    public void setMultilingualAttributeMap(FmMultilingualAttributeMap map) {
        this.getLevelType().setMultilingualAttributeMap((MultilingualAttributeMapType)map.getInternal());
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public boolean getGenerateRelativeTimeMembers() {
        if (this.isTimeLevel()) {
            return this.getLevelType().isSetIncludeRelativeTimeMembers();
        }
        return false;
    }

    @Override
    public void setGenerateRelativeTimeMembers(boolean generateRelativeTimeMembers) {
        if (!this.isTimeLevel()) {
            throw new FmMDException("BMT_MD_INVALID_GENERATE_RELATIVE_TIME_MEMBERS");
        }
        this.getLevelType().setIncludeRelativeTimeMembers(generateRelativeTimeMembers);
    }

    @Override
    public boolean isTimeLevel() {
        return this.getLevelStyle().isTimeLevel();
    }

    @Override
    public Expression getCurrentPeriodExpression() {
        if (this.getLevelType().getCurrentPeriodExpression() != null) {
            return FmExpression.get((FMMDSession)this.m_session, this.getLevelType().getCurrentPeriodExpression());
        }
        return null;
    }

    @Override
    public Expression setCurrentPeriodExpression(ExpressionBuilder exprBuilder) {
        if (exprBuilder == null) {
            this.getLevelType().setCurrentPeriodExpression(null);
            return null;
        }
        FmExpression exp = FmExpression.create((FMMDSession)this.m_session, exprBuilder);
        this.getLevelType().setCurrentPeriodExpression(exp.getExpressionType());
        return exp;
    }

    @Override
    public List<QueryItem> getSecurableAttributes() {
        RelationalDimension dim = null;
        EObject parent = (EObject)this.m_emfObject;
        while (parent != null) {
            if (parent instanceof RelationalDimensionType) {
                dim = FmRelationalDimension.get(this.m_session, parent);
                break;
            }
            parent = parent.eContainer();
        }
        if (dim == null) {
            return new ArrayList<QueryItem>(0);
        }
        List<QueryItem> securableAttributes = dim.getSecurableAttributes();
        Iterator<QueryItem> it = securableAttributes.iterator();
        while (it.hasNext()) {
            QueryItem qi = it.next();
            if (qi.getParent().equals(this)) continue;
            it.remove();
        }
        return securableAttributes;
    }

    @Override
    public int getLevelMemberCount() {
        HashMap<Object, String> idMap;
        Element results = null;
        int memberCount = 0;
        FmRelationalDimension parentDim = (FmRelationalDimension)this.getDimension();
        QuerySubjectBase generatedQuerySubject = parentDim.generateFmQuerySubjectTempSession(idMap = new HashMap<Object, String>(), false);
        if (generatedQuerySubject == null) {
            return 0;
        }
        ArrayList<String> keyIds = new ArrayList<String>();
        List<QueryItem> levelKeys = this.getLevelKeys();
        for (QueryItem lk : levelKeys) {
            String qiId = idMap.get(lk.getInternal());
            keyIds.add(qiId);
        }
        if (levelKeys.size() > 0) {
            LevelMemberCount levelMemberCountRequest = new LevelMemberCount(keyIds);
            XExecuteCommandHelper hlprExecuteCmd = new XExecuteCommandHelper(generatedQuerySubject.getSession());
            Document document = DocumentHelper.createDocument();
            Element commandElement = document.addElement("command");
            hlprExecuteCmd.insertQuerySet(commandElement, levelMemberCountRequest.getQuerySetElement());
            try {
                XAdaptor myAdaptor = XAdaptor.create(generatedQuerySubject.getSession(), false, false);
                results = myAdaptor.doQsApiRequest(commandElement, 500);
            }
            catch (Exception e) {
                generatedQuerySubject.getSession().destroy();
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e.getMessage(), e);
            }
            generatedQuerySubject.getSession().destroy();
            memberCount = levelMemberCountRequest.getMemberCountFromResult(results);
        } else if (this.getIsManual()) {
            memberCount = 1;
        }
        return memberCount;
    }

    public static /* bridge */ /* synthetic */ FmQueryItemFolder get(FMMDSession fMMDSession, Object object) {
        return FmLevel.get(fMMDSession, object);
    }
}

