/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmAttributeReference;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveListener;
import com.ibm.cognos.fmeng.fmmd.model.AttributeReference;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.LevelReference;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.genmodel.AttributeReferenceType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.LevelReferenceType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmLevelReference
extends FmBaseObject
implements LevelReference {
    FmLevelReference(FMMDSession session, Object emfObject) {
        super(session, emfObject);
    }

    public static FmLevelReference get(FMMDSession session, Object emfObject) {
        return new FmLevelReference(session, emfObject);
    }

    public static FmLevelReference createLevelReference(FMMDSession session, FmRelationalHierarchy hierarchy, Level level) {
        LevelReferenceType levelRefType = GenmodelFactory.eINSTANCE.createLevelReferenceType();
        FmLevelReference levelRef = new FmLevelReference(session, levelRefType);
        levelRefType.setRefObj(((FmLevel)level).getLevelType());
        hierarchy.addLevelReference(levelRef);
        List<QueryItem> queryItems = level.getAllQueryItems();
        for (QueryItem q : queryItems) {
            FmAttributeReference.createAttributeReference(session, levelRef, q);
        }
        return levelRef;
    }

    @Override
    public Level getLevel() {
        return FmLevel.get(this.m_session, this.getLevelReferenceType().getRefObj());
    }

    LevelReferenceType getLevelReferenceType() {
        return (LevelReferenceType)this.m_emfObject;
    }

    public EObject getLevelReference() {
        return this.getLevelReferenceType().getRefObj();
    }

    @Override
    public FmObjectType getFmObjectType() {
        return FmObjectType.levelReference;
    }

    @Override
    public RelationalHierarchy getHierarchy() {
        return FmRelationalHierarchy.get(this.m_session, this.getLevelReferenceType().eContainer());
    }

    @Override
    public void remove(RemoveInfo info, RemoveListener listener) {
        RelationalDimension rdim = this.getHierarchy().getDimension();
        Level lvl = this.getLevel();
        if (rdim.isRollupDimension() && lvl.canDelete()) {
            List listDimHier = rdim.getAllHierarchies();
            int lvlRefCount = 0;
            block0: for (RelationalHierarchy h : listDimHier) {
                List<LevelReference> refs = h.getLevelReferences();
                for (LevelReference lref : refs) {
                    if (lref.getLevel().equals(lvl)) {
                        ++lvlRefCount;
                    }
                    if (lvlRefCount > 1) continue block0;
                }
            }
            boolean bDelete = false;
            if (lvlRefCount == 1 && !this.isLevelWithQueryItemReuse(lvl)) {
                bDelete = true;
            }
            super.remove(info, listener);
            if (bDelete) {
                this.m_session.delete(listener, lvl);
            }
        } else {
            super.remove(info, listener);
        }
    }

    private boolean isLevelWithQueryItemReuse(Level lvl) {
        RelationalDimension rdim = this.getHierarchy().getDimension();
        List<QueryItem> listLevelQI = lvl.getAllQueryItems();
        List<Level> dimLevels = rdim.getAllLevels();
        dimLevels.remove(lvl);
        for (Level dimLvl : dimLevels) {
            for (QueryItem dimLevelKey : dimLvl.getLevelKeys()) {
                if (!listLevelQI.contains(dimLevelKey)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void getReferencedObjects(Set<BaseObject> objects) {
        if (this.getLevelReferenceType().getRefObj() != null) {
            objects.add(FmModelFactory.getInstance().get(this.m_session, this.getLevelReferenceType().getRefObj()));
        }
    }

    @Override
    public String toString() {
        TopLevelObject refdLevel = FmModelFactory.getInstance().get(this.m_session, this.getLevelReferenceType().getRefObj());
        return "Level Reference -> " + refdLevel.getID();
    }

    @Override
    public List<AttributeReference> getAttributeReferences() {
        ArrayList<AttributeReference> attributeRefs = new ArrayList<AttributeReference>();
        for (AttributeReferenceType attributeRef : this.getLevelReferenceType().getAttributeReference()) {
            attributeRefs.add(FmAttributeReference.get(this.m_session, attributeRef));
        }
        return attributeRefs;
    }

    public void addAttributeReference(FmAttributeReference attributeRef) {
        this.addAttributeReference(attributeRef.getAttributeReferenceType());
    }

    private void addAttributeReference(AttributeReferenceType lrt) {
        this.getLevelReferenceType().getAttributeReference().add((Object)lrt);
    }

    @Override
    public String getName() {
        return this.getLevel().getName();
    }

    @Override
    void addChild(Object eObj) {
        switch (this.m_session.getGateway().getClassifierType(eObj)) {
            case 18: {
                this.addAttributeReference((AttributeReferenceType)eObj);
                return;
            }
        }
        super.addChild(eObj);
    }
}

