/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmNamespace;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.model.LinkedObject;
import com.ibm.cognos.fmeng.fmmd.model.Namespace;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.genmodel.ConnectionType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.LinkedNodeType;
import com.ibm.cognos.fmeng.genmodel.QueryPathType;
import com.ibm.cognos.fmeng.genmodel.SourceType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.ProjectAccess;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.Locale;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.emf.common.util.EList;

public class FmLinkedObject
extends FmBaseObject
implements LinkedObject,
TopLevelObject {
    protected static FmLinkedObject createLinkedObject(FMMDSession session, FmNamespace parent) {
        LinkedNodeType emfObj = GenmodelFactory.eINSTANCE.createLinkedNodeType();
        FmLinkedObject lo = new FmLinkedObject(session, emfObj);
        parent.addLinkedObject(lo);
        return lo;
    }

    public static FmLinkedObject get(FMMDSession session, Object emfobj) {
        return new FmLinkedObject(session, (LinkedNodeType)emfobj);
    }

    private FmLinkedObject(FMMDSession session, LinkedNodeType nt) {
        super(session, nt);
    }

    protected void setLinkedObject(Namespace ns) {
        this.setLinkType("namespace");
        this.setSourceType(LinkedObject.SourceType.modelFM);
        EMFSession linkedObjectSession = (EMFSession)ns.getSession();
        this.m_session.registerLinkedObject(this.getInternal(), ns.getInternal());
        this.addConnectionItem(LinkedObject.ConnectionItem.cmSearchPath, linkedObjectSession.getProjectManager().getAccess().getFileName(ProjectAccess.ProjectFile.MODEL_XML));
        String identificationString = "//*[ID='";
        String encoded = StringEscapeUtils.escapeXml((String)ns.getID());
        String id = encoded.replaceAll("'", "&apos;");
        identificationString = String.valueOf(identificationString) + id;
        identificationString = String.valueOf(identificationString) + "']";
        this.setQueryString(identificationString);
    }

    public static String getDefaultName(Locale locale) {
        return FmMessage.render("BMT_MDN_OBJECT_NAME_LEVEL", locale);
    }

    public FmObjectType getFmObjectType() {
        return FmObjectType.linkedNode;
    }

    LinkedNodeType getAsLinkedNodeType() {
        return (LinkedNodeType)this.m_emfObject;
    }

    private void setLinkType(String type) {
        this.getAsLinkedNodeType().setType(type);
    }

    private void setQueryString(String path) {
        QueryPathType qpt = this.getAsLinkedNodeType().getQueryPath();
        if (qpt == null) {
            qpt = GenmodelFactory.eINSTANCE.createQueryPathType();
            this.getAsLinkedNodeType().setQueryPath(qpt);
        }
        qpt.setValue(path);
    }

    public TopLevelObject getLinkedObject() {
        String queryPath = this.getAsLinkedNodeType().getQueryPath().getValue();
        String id = queryPath.substring(8, queryPath.length() - 2);
        Object obj = this.m_session.getObjectById(id);
        return FmModelFactory.getInstance().get(this.m_session, obj);
    }

    protected void setSourceType(LinkedObject.SourceType st) {
        LinkedNodeType lt = this.getAsLinkedNodeType();
        SourceType sourceType = lt.getSource();
        if (sourceType == null) {
            sourceType = GenmodelFactory.eINSTANCE.createSourceType();
            lt.setSource(sourceType);
        }
        sourceType.setType(st.toString());
    }

    private void addConnectionItem(LinkedObject.ConnectionItem ci, String value) {
        LinkedNodeType lt = this.getAsLinkedNodeType();
        SourceType sourceType = lt.getSource();
        EList<ConnectionType> connectionItems = sourceType.getConnection();
        ConnectionType ct = GenmodelFactory.eINSTANCE.createConnectionType();
        ct.setName(ci.toString());
        ct.setValue(value);
        connectionItems.add(ct);
    }

    private LinkedObject.SourceType getSourceType() {
        LinkedNodeType lt = this.getAsLinkedNodeType();
        SourceType sourceType = lt.getSource();
        String type = sourceType.getType();
        return LinkedObject.SourceType.valueOf(type);
    }

    private String getConnectionItem(LinkedObject.ConnectionItem item) {
        LinkedNodeType lt = this.getAsLinkedNodeType();
        SourceType sourceType = lt.getSource();
        EList<ConnectionType> connectionItems = sourceType.getConnection();
        for (ConnectionType ct : connectionItems) {
            if (!ct.getName().equals(item.toString())) continue;
            return ct.getValue();
        }
        return null;
    }

    public String getName() {
        return this.getLinkedObject().getName();
    }
}

