/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.AggregateRuleParentInternal;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmAggregateRule;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCalculation;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmEMDObjectNaming;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasureDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasureFolder;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationship;
import com.ibm.cognos.fmeng.fmmd.impl.model.MeasureParentInternal;
import com.ibm.cognos.fmeng.fmmd.impl.model.MoveListener;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveListener;
import com.ibm.cognos.fmeng.fmmd.model.AggregateRule;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.BuilderFactory;
import com.ibm.cognos.fmeng.fmmd.model.Cube;
import com.ibm.cognos.fmeng.fmmd.model.Dimension;
import com.ibm.cognos.fmeng.fmmd.model.DimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.fmmd.model.FmRegularAggregate;
import com.ibm.cognos.fmeng.fmmd.model.FmUsage;
import com.ibm.cognos.fmeng.fmmd.model.Format;
import com.ibm.cognos.fmeng.fmmd.model.Measure;
import com.ibm.cognos.fmeng.fmmd.model.MeasureDimension;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemMapping;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipEnd;
import com.ibm.cognos.fmeng.fmmd.model.SemiAggregate;
import com.ibm.cognos.fmeng.fmmd.model.Shortcut;
import com.ibm.cognos.fmeng.fmmd.util.FmFormatGroup;
import com.ibm.cognos.fmeng.genmodel.AggregateRuleType;
import com.ibm.cognos.fmeng.genmodel.AggregateRulesType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.MeasureDimensionType;
import com.ibm.cognos.fmeng.genmodel.MeasureType;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmMeasure
extends FmQueryItemBase
implements Measure,
AggregateRuleParentInternal {
    public static FmMeasure get(FMMDSession session, Object emfobj) {
        return new FmMeasure(session, (MeasureType)emfobj);
    }

    public static FmMeasure createMeasure(FMMDSession session, MeasureParentInternal parent, String objectName, FmEMDObjectNaming eMDObjectNaming) {
        FmMeasure measure = FmMeasure.createObject(session, parent, objectName, eMDObjectNaming);
        ExpressionBuilder builder = BuilderFactory.createExpressionBuilder();
        builder.addExpressionPart("", null);
        measure.setExpression(builder);
        measure.setUsage(FmUsage.fact);
        measure.setRegularAggregate(FmRegularAggregate.sum);
        return measure;
    }

    public static FmMeasure createMeasureBasedOnCalculation(FMMDSession session, MeasureParentInternal parent, String objectName, FmEMDObjectNaming eMDObjectNaming, FmCalculation calc) {
        FmMeasure measure = FmMeasure.createObject(session, parent, objectName, eMDObjectNaming);
        measure.copyReplicableProperties(calc);
        measure.setExpression(calc);
        measure.setUsage(FmUsage.fact);
        return measure;
    }

    public static FmMeasure createMeasureBasedOnQueryItem(FMMDSession session, FmQueryItemBase item, MeasureParentInternal parent, String objectName, FmEMDObjectNaming eMDObjectNaming, Shortcut shortcut) {
        FmMeasure measure = FmMeasure.createObject(session, parent, objectName, eMDObjectNaming);
        measure.copyReplicableProperties(item);
        measure.setExpression(item, shortcut);
        measure.setUsage(FmUsage.fact);
        return measure;
    }

    public static FmMeasure createMeasureFromColumn(FMMDSession session, MeasureParentInternal parent, String name, MdColumn column) {
        FmMeasure qi = FmMeasure.createMeasure(session, parent, name, FmEMDObjectNaming.kMakeUnique);
        qi.copyColumnProperties(column);
        return qi;
    }

    private static FmMeasure createObject(FMMDSession session, MeasureParentInternal parent, String objectName, FmEMDObjectNaming eMDObjectNaming) {
        if (objectName == null || objectName.length() == 0) {
            objectName = FmMeasure.getDefaultName(session.getActiveLocale());
        }
        MeasureType emfObj = GenmodelFactory.eINSTANCE.createMeasureType();
        FmMeasure measure = new FmMeasure(session, emfObj);
        parent.addMeasure(measure);
        String uniqueName = measure.makeUniqueName(objectName);
        String localeKey = FmModelFactory.getInstance().getProject(session).getDefaultLocale();
        measure.setName(localeKey, uniqueName);
        measure.setUsage(FmUsage.fact);
        return measure;
    }

    @Override
    public void addAggregateRule(FmAggregateRule rule) {
        AggregateRulesType aggrRuleParent = this.getMeasureType().getAggregateRules();
        if (aggrRuleParent == null) {
            aggrRuleParent = GenmodelFactory.eINSTANCE.createAggregateRulesType();
            this.getMeasureType().setAggregateRules(aggrRuleParent);
        }
        EList<AggregateRuleType> rules = aggrRuleParent.getAggregateRule();
        int i = 0;
        while (i < rules.size()) {
            AggregateRuleType someRule = (AggregateRuleType)rules.get(i);
            if (someRule.getDimensionRef().equals(rule.getAggregateRuleType().getDimensionRef())) {
                rules.set(i, rule.getAggregateRuleType());
                return;
            }
            ++i;
        }
        aggrRuleParent.getAggregateRule().add((Object)rule.getAggregateRuleType());
    }

    @Override
    public AggregateRule createAggregateRule(SemiAggregate aggregation) {
        return FmAggregateRule.create(this.m_session, this, aggregation);
    }

    @Override
    public AggregateRule createAggregateRule(Dimension dim, SemiAggregate aggregation) {
        return FmAggregateRule.create(this.m_session, (AggregateRuleParentInternal)this, dim, aggregation);
    }

    @Override
    public AggregateRule createAggregateRule(RelationalDimension dim, SemiAggregate aggregation) {
        return FmAggregateRule.create(this.m_session, (AggregateRuleParentInternal)this, dim, aggregation);
    }

    private FmMeasure(FMMDSession session, MeasureType emfObject) {
        super(session, emfObject);
    }

    @Override
    protected FmQueryItemBase.EItemType getReportItemType() {
        return FmQueryItemBase.EItemType.kItemMeasure;
    }

    @Override
    public FmObjectType getFmObjectType() {
        return FmObjectType.measure;
    }

    public static String getDefaultName(Locale locale) {
        return FmMessage.render("BMT_MDN_OBJECT_NAME_MEASURE", locale);
    }

    protected MeasureType getMeasureType() {
        return (MeasureType)this.m_emfObject;
    }

    @Override
    public List<AggregateRule> getAggregateRules() {
        AggregateRulesType art = this.getMeasureType().getAggregateRules();
        if (art != null) {
            EList<AggregateRuleType> arl = art.getAggregateRule();
            ArrayList<AggregateRule> res = new ArrayList<AggregateRule>(arl.size());
            for (AggregateRuleType ar : arl) {
                res.add(FmAggregateRule.get(this.m_session, ar));
            }
            return res;
        }
        return new ArrayList<AggregateRule>(0);
    }

    @Override
    public void removeAggregateRule(AggregateRule rule) {
        AggregateRulesType art = this.getMeasureType().getAggregateRules();
        EList<AggregateRuleType> arl = art.getAggregateRule();
        arl.remove(((FmAggregateRule)rule).getInternal());
    }

    @Override
    public void insertAggregateRule(AggregateRule prop, AggregateRule beforeProp) {
        AggregateRulesType art = this.getMeasureType().getAggregateRules();
        EList<AggregateRuleType> arl = art.getAggregateRule();
        FmAggregateRule fmProp = (FmAggregateRule)prop;
        arl.remove(fmProp.getInternal());
        int index = -1;
        if (beforeProp != null) {
            index = arl.indexOf(((FmAggregateRule)beforeProp).getInternal());
        }
        if (index != -1) {
            arl.add(index, fmProp.getAggregateRuleType());
        } else {
            arl.add(fmProp.getAggregateRuleType());
        }
    }

    @Override
    public void prepareForObjectDeletion(RemoveInfo info, FmBaseObject object, RemoveListener listener) {
        super.prepareForObjectDeletion(info, object, listener);
        List<AggregateRule> aggRules = this.getAggregateRules();
        if (object instanceof FmRelationalDimension || object instanceof FmDimension) {
            for (AggregateRule rule : aggRules) {
                if (!rule.getDimensionBaseRef().equals(object)) continue;
                this.removeAggregateRule(rule);
            }
        }
        if (object instanceof FmRelationship) {
            Cube c;
            FmRelationship rel = (FmRelationship)object;
            BaseObject bObj = rel.getParent();
            if (bObj instanceof Cube && (c = (Cube)bObj).isAggregateCube()) {
                return;
            }
            RelationshipEnd leftSide = rel.getLeftEnd();
            RelationshipEnd rightSide = rel.getRightEnd();
            for (AggregateRule rule : aggRules) {
                if (rule.getDimensionBaseRef().equals(leftSide) && rightSide.equals(this.getParentMeasureDimension())) {
                    this.removeAggregateRule(rule);
                }
                if (!rule.getDimensionBaseRef().equals(rightSide) || !leftSide.equals(this.getParentMeasureDimension())) continue;
                this.removeAggregateRule(rule);
            }
        }
    }

    @Override
    public void getReferencedObjects(Set<BaseObject> objects) {
        super.getReferencedObjects(objects);
        List<AggregateRule> aggRules = this.getAggregateRules();
        for (AggregateRule rule : aggRules) {
            objects.add(rule.getDimensionBaseRef());
        }
    }

    @Override
    public AggregateRule findAggregateRule(DimensionBase dim) {
        AggregateRulesType art = this.getMeasureType().getAggregateRules();
        if (art != null) {
            EList<AggregateRuleType> arl = art.getAggregateRule();
            for (AggregateRuleType ar : arl) {
                for (EObject obj : ar.getDimensionRef()) {
                    if (!obj.equals(dim.getInternal())) continue;
                    return FmAggregateRule.get(this.m_session, ar);
                }
            }
        }
        return null;
    }

    @Override
    public boolean getHidden() {
        return this.getMeasureType().isHidden();
    }

    @Override
    public Format getFormatAsFormat() {
        return FmFormatGroup.get(this.getMeasureType().getFormat()).getFormat();
    }

    @Override
    public void setFormat(Format format) {
        if (format == null) {
            this.getMeasureType().setFormat(null);
        } else {
            this.getMeasureType().setFormat(format.getFormatString());
        }
    }

    @Override
    public void setFormat(String format) {
        if (format == null) {
            this.getMeasureType().setFormat(null);
        } else {
            this.getMeasureType().setFormat(format);
        }
    }

    public boolean isNonDistributive() {
        FmRegularAggregate agg = this.getRegularAggregate();
        switch (agg) {
            case automatic: 
            case average: 
            case calculated: 
            case countDistinct: 
            case median: 
            case standardDeviation: 
            case unknown: 
            case unsupported: 
            case variance: {
                return true;
            }
        }
        return false;
    }

    @Override
    public RelationalHierarchy getHierarchy() {
        return null;
    }

    @Override
    public boolean isCountOnly() {
        if (this.getDatatype().equals((Object)FmDatatype.UNKNOWN)) {
            return false;
        }
        RelationalObject ro = this.getRelationalParent();
        if (ro == null) {
            return false;
        }
        if (FmDatatype.isNumeric(this.getDatatype()).booleanValue()) {
            MdColumn column;
            QueryItemMapping mapping = ro.findMapping(this);
            return mapping != null && (column = mapping.getPhysicalColumn()) != null && column.isKey();
        }
        return true;
    }

    @Override
    public void copyColumnProperties(MdColumn column) {
        this.setDatatype(column.getDatatype());
        this.setUsage(FmUsage.fact);
        if (!FmDatatype.isNumeric(column.getDatatype()).booleanValue() || column.isKey()) {
            if (!this.getRegularAggregate().equals((Object)FmRegularAggregate.count) && !this.getRegularAggregate().equals((Object)FmRegularAggregate.countDistinct)) {
                this.setRegularAggregate(FmRegularAggregate.countDistinct);
            }
        } else if (this.getRegularAggregate().equals((Object)FmRegularAggregate.unknown)) {
            this.setRegularAggregate(FmRegularAggregate.sum);
        }
        if (column.getScale() != null) {
            this.setScale(column.getScale());
        }
        if (column.getPrecision() != null) {
            this.setPrecision(column.getPrecision());
        }
        if (column.getSize() != null) {
            this.setSize(column.getSize().intValue());
        }
        if (column.isNullable() != null) {
            this.setNullable(column.isNullable());
        }
        if (column.getCollationSequence() != null) {
            this.setOriginalCollationSequenceName(column.getCollationSequence());
        }
        if (column.getDescription() != null) {
            this.setDescription(this.getProject().getDefaultLocale(), column.getDescription());
        }
        this.getQueryItemBaseType().setExpression(null);
    }

    @Override
    public MeasureDimension getParentMeasureDimension() {
        EObject obj = (EObject)this.m_emfObject;
        while (obj != null) {
            if (obj instanceof MeasureDimensionType) {
                return FmMeasureDimension.get(this.m_session, obj);
            }
            obj = obj.eContainer();
        }
        return null;
    }

    @Override
    public boolean hasAggregateRules() {
        return this.getAggregateRules().size() > 0;
    }

    @Override
    public void moveObject(FmBaseObject targetParent, MoveListener listener) {
        EList<MeasureType> targetMeasures;
        if (targetParent instanceof FmMeasureFolder && (targetMeasures = ((FmMeasureFolder)targetParent).getMeasureFolderType().getMeasure()).isEmpty()) {
            MeasureType tmp = GenmodelFactory.eINSTANCE.createMeasureType();
            targetMeasures.add((Object)tmp);
            targetMeasures.add((Object)((MeasureType)this.m_emfObject));
            targetMeasures.remove((Object)tmp);
            this.makeAllNamesUnique(BaseObject.PrefixName.kStandard, targetParent, listener);
            return;
        }
        super.moveObject(targetParent, listener);
    }
}

