/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmStructuredText;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.Cube;
import com.ibm.cognos.fmeng.fmmd.model.CubeBase;
import com.ibm.cognos.fmeng.fmmd.model.HierarchyBase;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.LevelReference;
import com.ibm.cognos.fmeng.fmmd.model.MemberUniqueName;
import com.ibm.cognos.fmeng.fmmd.model.MemberUniqueNameBuilder;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.model.VirtualHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.VirtualLevel;
import com.ibm.cognos.fmeng.fmmd.model.VirtualObject;
import com.ibm.cognos.fmeng.fmmd.util.FmMemberUniqueNameBuilder;
import com.ibm.cognos.fmeng.fmmd.util.ROLAPIDBuilder;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.MunType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmMemberUniqueName
extends FmStructuredText
implements MemberUniqueName {
    public static String MUN = String.valueOf(Pattern.quote("[")) + "[a-zA-Z0-9 \u0080-\uffff" + Pattern.quote("()-") + "]+" + Pattern.quote("]") + "(" + Pattern.quote(".[") + "[a-zA-Z0-9 \u0080-\uffff" + Pattern.quote("()-") + "]+" + Pattern.quote("]") + ")*";
    private static String m_MUNSplit = "->:\\[RO\\]\\.";

    public static FmMemberUniqueName get(FMMDSession session, Object mun) {
        return new FmMemberUniqueName(session, mun);
    }

    public static FmMemberUniqueName create(FMMDSession session, MemberUniqueNameBuilder munBuilder) {
        MunType munType = null;
        munType = munBuilder != null ? ((FmMemberUniqueNameBuilder)munBuilder).buildMemberUniqueName(session) : GenmodelFactory.eINSTANCE.createMunType();
        return FmMemberUniqueName.get(session, munType);
    }

    private FmMemberUniqueName(FMMDSession session, Object mun) {
        super(session, mun);
    }

    @Override
    public List<Object> getComponents() {
        return this.getComponents(this.getMemberUniqueNameType().getMixed(), true);
    }

    @Override
    public String getText() {
        return this.m_session.getGateway().asXML(this.m_emfObject, false);
    }

    @Override
    public List<BaseObject> getRawRefObjs() {
        ArrayList<BaseObject> res = new ArrayList<BaseObject>();
        MunType et = this.getMemberUniqueNameType();
        if (et != null) {
            EList<EObject> refObjs = et.getRefobj();
            this.getRawReferencedObjects(refObjs, null, res, false);
        }
        return res;
    }

    @Override
    public List<ReportObject> getRefObjs() {
        ArrayList<ReportObject> res = new ArrayList<ReportObject>();
        MunType et = this.getMemberUniqueNameType();
        if (et != null) {
            EList<EObject> refObjs = et.getRefobj();
            this.getReferencedObjects(refObjs, null, res, false);
        }
        return res;
    }

    public MunType getMemberUniqueNameType() {
        return (MunType)this.m_emfObject;
    }

    @Override
    public String getPath() {
        if (this.getMemberUniqueNameType().getPath() == null) {
            return null;
        }
        return this.getMemberUniqueNameType().getPath().getValue();
    }

    @Override
    public String getV5MemberUniqueName(CubeBase cube, boolean longForm) {
        String v5mun = "";
        List<BaseObject> objs = this.getRawRefObjs();
        if (objs.size() == 0) {
            String[] foo;
            for (Object part : this.getComponents()) {
                if (part == this.getMemberUniqueNameType().getMemberCaption()) continue;
                v5mun = String.valueOf(v5mun) + part.toString();
            }
            if (!longForm && (foo = v5mun.split(m_MUNSplit)).length == 2) {
                v5mun = foo[1];
            }
        } else if (objs.size() == 1) {
            FmMDException.ASSERT(objs.get(0) instanceof RelationalHierarchy, "Bad object type for single-sided MUN.");
            RelationalHierarchy hier = (RelationalHierarchy)objs.get(0);
            v5mun = String.valueOf(ROLAPIDBuilder.build(null, hier)) + "." + this.getPath();
        } else if (objs.size() == 2) {
            if (longForm) {
                String leftSide = "";
                if (objs.get(0) instanceof LevelReference) {
                    leftSide = ROLAPIDBuilder.build((CubeBase)((Cube)cube), (LevelReference)objs.get(0));
                } else if (objs.get(0) instanceof Level) {
                    leftSide = ROLAPIDBuilder.build((CubeBase)((Cube)cube), (Level)objs.get(0));
                } else if (objs.get(0) instanceof RelationalHierarchy) {
                    leftSide = ROLAPIDBuilder.build((CubeBase)((Cube)cube), (RelationalHierarchy)objs.get(0));
                } else if (objs.get(0) instanceof VirtualLevel) {
                    leftSide = ROLAPIDBuilder.build((VirtualObject)objs.get(0));
                } else if (objs.get(0) instanceof VirtualHierarchy) {
                    leftSide = ROLAPIDBuilder.build((VirtualObject)objs.get(0));
                } else {
                    FmMDException.ASSERT(false, "Bad object type for left side of MUN.");
                }
                v5mun = String.valueOf(v5mun) + leftSide;
                v5mun = String.valueOf(v5mun) + "->:[RO].";
            }
            HierarchyBase hier = (HierarchyBase)objs.get(1);
            boolean cubingServicesCompatibility = false;
            if (cube != null && cube instanceof FmCube) {
                cubingServicesCompatibility = ((FmCube)cube).getCubingServicesCompatibility();
            }
            v5mun = !longForm && cube != null && cubingServicesCompatibility ? String.valueOf(v5mun) + "[" + hier.getName() + "]" : (hier instanceof RelationalHierarchy ? String.valueOf(v5mun) + ROLAPIDBuilder.build(null, (RelationalHierarchy)hier) : String.valueOf(v5mun) + ROLAPIDBuilder.buildShortId((VirtualHierarchy)hier));
            v5mun = String.valueOf(v5mun) + ".";
            v5mun = String.valueOf(v5mun) + this.getPath();
        } else {
            FmMDException.ASSERT(true, "Bad MUN. Why does the MUN have more than two object references in it?");
        }
        return v5mun;
    }

    public String toString() {
        return this.getText();
    }

    public boolean isValid() {
        List<BaseObject> objs = this.getRawRefObjs();
        if (objs.size() != 2) {
            return false;
        }
        String path = this.getPath();
        if (path == null) {
            return false;
        }
        Pattern MUNPattern = Pattern.compile(MUN);
        Matcher matcher = MUNPattern.matcher(path);
        return matcher.find();
    }

    @Override
    public String getMemberCaption() {
        return this.getMemberUniqueNameType().getMemberCaption();
    }

    @Override
    public void setMemberCaption(String caption) {
        this.getMemberUniqueNameType().setMemberCaption(caption);
    }
}

