/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCalculation;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmComplexProperty;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDbQuery;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmExpressionCopier;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFilter;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLocaleMapping;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasure;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasureDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMultilingualAttribute;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmNamespace;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPackage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPhysicalDefinition;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmProject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemFolder;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemLike;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimensionBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalQuerySubject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationship;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSecurityFilterDefinition;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSecurityObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSecurityView;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmShortcut;
import com.ibm.cognos.fmeng.fmmd.model.AccessRule;
import com.ibm.cognos.fmeng.fmmd.model.AggregateRule;
import com.ibm.cognos.fmeng.fmmd.model.Association;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.BuilderFactory;
import com.ibm.cognos.fmeng.fmmd.model.Calculation;
import com.ibm.cognos.fmeng.fmmd.model.Cardinality;
import com.ibm.cognos.fmeng.fmmd.model.ColumnReference;
import com.ibm.cognos.fmeng.fmmd.model.Copyable;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.Determinant;
import com.ibm.cognos.fmeng.fmmd.model.Dimension;
import com.ibm.cognos.fmeng.fmmd.model.DimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionParent;
import com.ibm.cognos.fmeng.fmmd.model.Filter;
import com.ibm.cognos.fmeng.fmmd.model.FilterApplication;
import com.ibm.cognos.fmeng.fmmd.model.FilterDefinition;
import com.ibm.cognos.fmeng.fmmd.model.FmRegularAggregate;
import com.ibm.cognos.fmeng.fmmd.model.FmUsage;
import com.ibm.cognos.fmeng.fmmd.model.Join;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.LevelReference;
import com.ibm.cognos.fmeng.fmmd.model.Measure;
import com.ibm.cognos.fmeng.fmmd.model.MeasureDimension;
import com.ibm.cognos.fmeng.fmmd.model.MeasureFolder;
import com.ibm.cognos.fmeng.fmmd.model.MeasureScope;
import com.ibm.cognos.fmeng.fmmd.model.ModelQuery;
import com.ibm.cognos.fmeng.fmmd.model.Namespace;
import com.ibm.cognos.fmeng.fmmd.model.Package;
import com.ibm.cognos.fmeng.fmmd.model.PackageBase;
import com.ibm.cognos.fmeng.fmmd.model.ParameterMap;
import com.ibm.cognos.fmeng.fmmd.model.ParameterMapBase;
import com.ibm.cognos.fmeng.fmmd.model.Permission;
import com.ibm.cognos.fmeng.fmmd.model.Project;
import com.ibm.cognos.fmeng.fmmd.model.PseudoPackage;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemFolder;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemFolderParent;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemMapping;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemParent;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubject;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationalFilter;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.RelationalParameterMap;
import com.ibm.cognos.fmeng.fmmd.model.Relationship;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipEnd;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.model.SQLObject;
import com.ibm.cognos.fmeng.fmmd.model.Scope;
import com.ibm.cognos.fmeng.fmmd.model.ScopeRelationship;
import com.ibm.cognos.fmeng.fmmd.model.Section;
import com.ibm.cognos.fmeng.fmmd.model.SecurityViewDefinition;
import com.ibm.cognos.fmeng.fmmd.model.Shortcut;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import com.ibm.cognos.fmeng.fmmd.model.TableDeterminant;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.fmmd.util.CrnIDHelper;
import com.ibm.cognos.fmeng.fmmd.util.FmExpressionBuilder;
import com.ibm.cognos.fmeng.genmodel.MeasureDimensionType;
import com.ibm.cognos.fmeng.genmodel.MeasureType;
import com.ibm.cognos.fmeng.genmodel.RelationalDimensionType;
import com.ibm.cognos.fmeng.genmodel.RelationalQuerySubjectType;
import com.ibm.cognos.fmeng.logging.FmEngApplicationLog;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.metadata.MdPrimaryKey;
import com.ibm.cognos.fmeng.metadata.MdTable;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FmModelBuilderBase {
    private List<PhysicalTableInfo> m_PhysicalTableInfo;
    private FMMDSession m_oldSession = null;
    private FMMDSession m_newSession = null;
    private Namespace m_PhysicalView = null;
    private Namespace m_BusinessView = null;
    private FmNamespace m_PresentationView = null;
    private HashMap<ExpressionParent, ExpressionParent> m_deferredExpressions = null;
    protected Project m_newProject = null;
    protected HashMap<Object, String> m_idMap = null;
    protected HashMap<Object, BaseObject> m_presentationLayerObjectMap = new HashMap();
    protected PackageBase m_package = null;
    protected List<ReportObject> m_packageIncludeObjects = null;
    private HashMap<Object, DataSource> m_dsMap = null;
    private List<Relationship> m_srcRelationships = null;
    protected HashMap<Object, BaseObject> m_businessLayerItemMap = null;
    private HashMap<Object, QuerySubjectBase> m_businessQuerySubjects = null;
    private HashMap<Object, PhysicalItem> m_physicalMap = new HashMap();
    private static final boolean m_EliminateDuplicateRelationships = false;
    private HashSet<String> m_RelationshipExpressions = null;
    private MeasureDimension m_srcMeasureDimension;
    private List<RelationalObject> m_srcRelationalObjects;
    private static final boolean m_dumpMaps = false;
    private static final boolean m_dumpMapsDetails = false;

    protected FMMDSession getSourceSession() {
        return this.m_oldSession;
    }

    protected FMMDSession getDestinationSession() {
        return this.m_newSession;
    }

    protected Section getBusinessNamespace() {
        return this.m_BusinessView;
    }

    private List<Relationship> collectRelationships(List<RelationalObject> relationalObjects) {
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        if (relationalObjects.size() == 0) {
            return relationships;
        }
        for (Relationship rel : relationalObjects.get(0).getProject().getRootNamespace().getAllRelationships()) {
            boolean leftUsed = false;
            boolean rightUsed = false;
            for (RelationalObject obj : relationalObjects) {
                if (rel.getLeftEnd().equals(obj)) {
                    leftUsed = true;
                }
                if (!rel.getRightEnd().equals(obj)) continue;
                rightUsed = true;
            }
            if (!leftUsed || !rightUsed) continue;
            boolean add = true;
            for (Relationship existingRel : relationships) {
                if (!rel.equals(existingRel)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            relationships.add(rel);
        }
        return relationships;
    }

    private void collectRelatedQuerySubjects(List<RelationalObject> objects) {
        HashSet<RelationalQuerySubjectType> related = new HashSet<RelationalQuerySubjectType>();
        for (RelationalObject object : objects) {
            if (!(object instanceof RelationalDimension)) continue;
            RelationalDimension dim = (RelationalDimension)object;
            for (RelationalHierarchy hier : dim.getAllHierarchies()) {
                for (AccessRule rule : hier.getAccessRules()) {
                    if (rule.getRuleStyle() != AccessRule.RuleStyle.lookupTableBased || rule.isEmpty()) continue;
                    related.add((RelationalQuerySubjectType)rule.getFilterQuerySubject().getInternal());
                }
            }
        }
        for (RelationalQuerySubjectType qs : related) {
            objects.add(FmRelationalQuerySubject.get(this.m_oldSession, qs));
        }
        for (ParameterMapBase pm : this.m_oldSession.getProject().getParameterMaps()) {
            if (!(pm instanceof RelationalParameterMap)) continue;
            objects.add((RelationalParameterMap)pm);
        }
    }

    public void convertFromPackage(PackageBase kPackage, FMMDSession newSession) {
        FmEngApplicationLog.getApplicationLog().logDebug(FmEngApplicationLog.LOGGERS.PUBLISH, kPackage.getSession(), "Start create package model for package: " + kPackage.getName());
        this.m_oldSession = kPackage.getSession();
        this.m_newSession = newSession;
        this.m_newProject = newSession.getProject();
        this.m_PresentationView = (FmNamespace)this.m_newProject.getRootNamespace();
        this.m_package = kPackage;
        this.m_packageIncludeObjects = new ArrayList<ReportObject>();
        String defaultLocale = this.m_oldSession.getProject().getDefaultLocale();
        this.m_newProject.setDefaultLocale(defaultLocale);
        this.m_newSession.setProjectLocales(this.m_oldSession.getProject());
        if (kPackage.isStupidSpecialCaseCubeHandling()) {
            this.m_PresentationView.copyNames(kPackage.getNames(), BaseObject.PrefixName.kStandard, (FmBaseObject)this.m_PresentationView.getFmProject());
            this.m_PresentationView.copyDescriptionAndScreentip((FmReportObject)((Object)kPackage.getAllCubes().get(0)));
        } else {
            this.m_PresentationView.copyNames(this.m_oldSession.getProject().getRootNamespace().getNames(), BaseObject.PrefixName.kStandard, (FmBaseObject)this.m_PresentationView.getFmProject());
            this.m_PresentationView.copyDescriptionAndScreentip((FmReportObject)((Object)this.m_oldSession.getProject().getRootNamespace()));
        }
        this.populateNamesAndDescriptions(this.m_PresentationView, this.m_PresentationView.getName(), null);
        this.m_newProject.setDynamicQueryMode(true);
        this.m_newProject.setUseMFW(Project.UseMFW.eTrue);
        this.m_packageIncludeObjects.add(this.m_PresentationView);
        List<TopLevelObject> contents = kPackage.getPackageContents();
        ArrayList<RelationalObject> relationalObjects = new ArrayList<RelationalObject>();
        this.collectRelationalObjects(contents, relationalObjects);
        List<Relationship> relationships = this.collectRelationships(relationalObjects);
        if (relationalObjects.size() > 0) {
            this.convertFromCubeInternal(this.m_newProject.getRootNamespace(), relationalObjects, relationships);
        }
        for (TopLevelObject obj : contents) {
            this.createDimensionalObject(obj, this.m_PresentationView, this.m_businessLayerItemMap);
        }
        this.copyGovernors();
        if (this.m_packageIncludeObjects.size() > 0) {
            List<String> locales = this.m_oldSession.getProject().getSupportedLocales();
            FmPackage kNewPackage = (FmPackage)this.m_newProject.createPackage(kPackage.getName(), null, null, locales, this.m_packageIncludeObjects, null, null, null);
            kNewPackage.copyNames(kPackage.getNames(), BaseObject.PrefixName.kStandard, (FmBaseObject)((FmProject)this.m_newProject));
            FmSecurityView sv = kNewPackage.getSecurityView();
            for (DataSource ds : this.m_newProject.getDataSources()) {
                if (ds.getFunctionSetID() == null) continue;
                sv.addFunctionSet(ds.getFunctionSetID());
            }
            kNewPackage.setUseV5DataServer(true);
            kNewPackage.setSecurity(new ArrayList<FmSecurityObject>());
            if (kPackage instanceof FmPackage) {
                FmPackage kOldPackage = (FmPackage)kPackage;
                kPackage.getPackageContents();
                kNewPackage.copyDescriptionAndScreentip(kOldPackage);
                this.populateNamesAndDescriptions(kOldPackage, kOldPackage.getName(), kOldPackage.getDescription(this.m_newSession.getDefaultLocale()));
                List<SecurityViewDefinition> securityViewDefs = kOldPackage.getSecurityViewDefinitions();
                for (SecurityViewDefinition svd : securityViewDefs) {
                    ArrayList<ReportObject> includeObjects = new ArrayList<ReportObject>();
                    ArrayList<ReportObject> excludeObjects = new ArrayList<ReportObject>();
                    for (SecurityViewDefinition.SecuredObject securedObject : svd.getSecuredObjects()) {
                        if (securedObject.m_permission.equals((Object)Permission.deny)) {
                            this.addSecurityObject(excludeObjects, securedObject.m_object);
                            for (BaseObject descendant : securedObject.m_object.getDescendantObjects()) {
                                this.addSecurityObject(excludeObjects, descendant);
                            }
                        }
                        if (!securedObject.m_permission.equals((Object)Permission.grant)) continue;
                        this.addSecurityObject(includeObjects, securedObject.m_object);
                        for (BaseObject descendant : securedObject.m_object.getDescendantObjects()) {
                            this.addSecurityObject(includeObjects, descendant);
                        }
                    }
                    FmPackage securePackage = (FmPackage)this.m_newProject.createPackage(svd.getName(), null, null, locales, includeObjects, excludeObjects, null, null);
                    sv = securePackage.getSecurityView();
                    for (DataSource ds : this.m_newProject.getDataSources()) {
                        sv.addFunctionSet(ds.getFunctionSetID());
                    }
                    securePackage.setSecurityImplementation(Package.SecurityImplementation.viewBased);
                    securePackage.setUseV5DataServer(true);
                    securePackage.setSecurity(new ArrayList<FmSecurityObject>());
                    for (RelationalFilter filter : svd.getSecurityFilters()) {
                        RelationalObject ro = filter.getRelationalParent();
                        FmQuerySubjectBase mqs = (FmQuerySubjectBase)this.m_businessQuerySubjects.get(ro.getInternal());
                        FmMDException.ASSERT(mqs != null, "Didn't find a model query subject in the business layer for: " + ro.getID());
                        FmSecurityFilterDefinition securityFilterDefinition = mqs.createSecurityFilterDefinition(filter.getName(), sv);
                        this.deferExpression(securityFilterDefinition, filter);
                    }
                }
                if (securityViewDefs.size() > 0) {
                    FmPackage securePackage = (FmPackage)this.m_newProject.createPackage("_Everyone", null, null, locales, null, null, null, null);
                    sv = securePackage.getSecurityView();
                    for (DataSource ds : this.m_newProject.getDataSources()) {
                        sv.addFunctionSet(ds.getFunctionSetID());
                    }
                    securePackage.setSecurityImplementation(Package.SecurityImplementation.viewBased);
                    securePackage.setUseV5DataServer(true);
                    securePackage.setSecurity(new ArrayList<FmSecurityObject>());
                }
            }
        }
        DimensionalExpressionCopier expressionCopier = new DimensionalExpressionCopier(this.m_businessLayerItemMap);
        expressionCopier.resolveDeferredExpressions(this.m_deferredExpressions);
        this.resolveAggregateRules();
        this.m_presentationLayerObjectMap.put(this.m_oldSession.getProject().getRootNamespace().getInternal(), this.m_PresentationView);
        List<Relationship> scopeRelationships = this.collectAllRelationshipsWithScope(relationships);
        this.putInScopeRelationships(scopeRelationships);
        this.debugDumpMaps();
        FmEngApplicationLog.getApplicationLog().logDebug(FmEngApplicationLog.LOGGERS.PUBLISH, kPackage.getSession(), "End create package model for package: " + kPackage.getName());
    }

    public void convertFromDimensionForROLAP(FMMDSession destSession, RelationalObject dim, HashMap<Object, String> idMap) {
        this.m_idMap = idMap;
        PseudoPackage kPackage = new PseudoPackage(dim, dim.getName(), "~~");
        this.convertFromPackage(kPackage, destSession);
        Namespace parent = dim.getParentNamespace();
        String name = parent == null ? dim.getName() : parent.getName();
        destSession.getProject().getRootNamespace().setName(destSession.getDefaultLocale(), name);
        if (idMap != null && this.m_businessQuerySubjects.containsKey(dim.getInternal())) {
            idMap.put(dim.getInternal(), this.m_businessQuerySubjects.get(dim.getInternal()).getID());
        }
    }

    private void addSecurityObject(List<ReportObject> securityObjectList, BaseObject securedSourceObject) {
        BaseObject destObject = this.m_presentationLayerObjectMap.get(securedSourceObject.getInternal());
        if (destObject != null && destObject instanceof ReportObject) {
            securityObjectList.add((ReportObject)destObject);
        }
    }

    private void copyGovernors() {
        ParameterMap governors = this.m_newProject.getGovernorParameterMap();
        for (String key : this.m_package.getGovernorKeys()) {
            String value = this.m_package.getGovernorValue(key);
            governors.addEntry(key, value);
        }
    }

    private void debugDumpMaps() {
    }

    private void debugDumpMap(String name, HashMap<?, ?> map) {
        if (map != null) {
            System.out.println(String.valueOf(name) + ": " + Integer.toString(map.size()) + " entries.");
        } else {
            System.out.println(String.valueOf(name) + ": empty");
        }
    }

    private void resolveAggregateRules() {
        for (Object key : this.m_presentationLayerObjectMap.keySet()) {
            if (!(key instanceof MeasureType)) continue;
            BaseObject val = this.m_presentationLayerObjectMap.get(key);
            FmMDException.ASSERT(val instanceof Measure, "Unexpected mapping of measure to: " + val.toString());
            Measure destMeasure = (Measure)val;
            FmMeasure measure = FmMeasure.get(this.m_oldSession, key);
            for (AggregateRule srcRule : measure.getAggregateRules()) {
                AggregateRule destRule = destMeasure.createAggregateRule(srcRule.getApplyAggregate());
                for (DimensionBase srcDim : srcRule.getDimensionRefs()) {
                    BaseObject destDim = this.m_presentationLayerObjectMap.get(srcDim.getInternal());
                    FmMDException.ASSERT(destDim != null, "No dimension is mapped for: " + srcDim.toString());
                    FmMDException.ASSERT(destDim instanceof Dimension, "Unexpected mapping of dimension to: " + destDim.toString());
                    destRule.addDimensionRef((DimensionBase)destDim);
                }
            }
        }
    }

    private List<Relationship> collectAllRelationshipsWithScope(List<Relationship> srcRelationships) {
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        if (srcRelationships.size() == 0) {
            return relationships;
        }
        for (Relationship rel : srcRelationships) {
            if ((!(rel.getLeftEnd() instanceof RelationalDimension) || !(rel.getRightEnd() instanceof MeasureDimension)) && (!(rel.getLeftEnd() instanceof MeasureDimension) || !(rel.getRightEnd() instanceof RelationalDimension)) || !(rel.getParent() instanceof Section)) continue;
            boolean add = true;
            for (Relationship existingRel : relationships) {
                if (!rel.equals(existingRel)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            relationships.add(rel);
        }
        return relationships;
    }

    private void putInScopeRelationships(List<Relationship> srcRelationships) {
        for (Relationship rel : srcRelationships) {
            RelationshipEnd left = (RelationshipEnd)this.getRelationalObjectId(rel.getLeftEnd().getInternal());
            RelationshipEnd right = (RelationshipEnd)this.getRelationalObjectId(rel.getRightEnd().getInternal());
            FmMDException.ASSERT(left != null && right != null, "Left or right end of the scope relationship can not be null");
            BaseObject parent = rel.getParent();
            FmMDException.ASSERT(parent instanceof Section, "Relationships can only have namespaces as their parents");
            Section destNamespace = (Section)this.getRelationalObjectId(parent.getInternal());
            if (destNamespace == null) {
                destNamespace = this.m_PresentationView;
            }
            ScopeRelationship scopeRel = destNamespace.createScopeRelationship(left, right);
            for (Scope s : rel.getScopes()) {
                BaseObject oldBo = s.getLevelOrHierarchy();
                BaseObject newBo = oldBo instanceof LevelReference ? this.getRelationalObjectId(((LevelReference)oldBo).getLevel().getInternal()) : this.getRelationalObjectId(oldBo.getInternal());
                List<MeasureScope> oldMeasureScopes = s.getMeasureScope();
                ArrayList<Measure> newMeasures = new ArrayList<Measure>();
                ArrayList<Boolean> excludeList = new ArrayList<Boolean>();
                for (MeasureScope oldMs : oldMeasureScopes) {
                    BaseObject newMeasure = this.getRelationalObjectId(oldMs.getMeasure().getInternal());
                    newMeasures.add((Measure)newMeasure);
                    excludeList.add(oldMs.isExcluded());
                }
                Scope newScope = scopeRel.createScopeForRelationship(newBo);
                FmMDException.ASSERT(newMeasures.size() == excludeList.size(), "number of measures does not match the exclude list");
                int i = 0;
                while (i < newMeasures.size()) {
                    newScope.createMeasureScope((Measure)newMeasures.get(i), (Boolean)excludeList.get(i));
                    ++i;
                }
            }
        }
    }

    private void collectRelationalObjects(List<? extends BaseObject> contents, List<RelationalObject> relationalObjects) {
        block5: for (BaseObject baseObject : contents) {
            switch (baseObject.getFmObjectType()) {
                case measureDimension: 
                case relationalDimension: 
                case relationalParameterMap: 
                case relationalQuerySubject: {
                    this.collectRelationalObject(relationalObjects, baseObject);
                    break;
                }
                case folder: 
                case namespace: {
                    this.collectRelationalObjects(baseObject.getChildObjects(), relationalObjects);
                    break;
                }
                case querySubject: {
                    HashSet<RelationalObject> relObjs = new HashSet<RelationalObject>();
                    this.collectRelationalParents((QuerySubject)baseObject, relObjs);
                    for (RelationalObject relObj : relObjs) {
                        this.collectRelationalObject(relationalObjects, relObj);
                    }
                    continue block5;
                }
            }
        }
    }

    private void collectRelationalObject(List<RelationalObject> relationalObjects, BaseObject obj) {
        boolean bFound = false;
        for (RelationalObject existing : relationalObjects) {
            if (!existing.equals(obj)) continue;
            bFound = true;
            break;
        }
        if (!bFound) {
            relationalObjects.add((RelationalObject)obj);
        }
    }

    private void collectRelationalParents(QuerySubject qs, HashSet<RelationalObject> relObjs) {
        for (QueryItemBase queryItemBase : qs.getAllQueryItems()) {
            for (Object part : queryItemBase.getExpression().getComponents()) {
                if (!(part instanceof QueryItemBase)) continue;
                QueryItemBase qiPart = (QueryItemBase)part;
                RelationalObject parent = qiPart.getRelationalParent();
                if (parent == null) {
                    QuerySubjectBase qs2 = qiPart.getQueryParent();
                    FmMDException.ASSERT(qs2 != null, "Found a query item with no good parents: " + qiPart.getID());
                    if (qs2.equals(qs)) continue;
                    this.collectRelationalParents((QuerySubject)qs2, relObjs);
                    continue;
                }
                relObjs.add(parent);
            }
        }
    }

    protected void convertFromCubeInternal(Section parentNamespace, List<RelationalObject> relationalObjects, List<Relationship> relationships) {
        this.m_newSession = parentNamespace.getSession();
        this.m_newProject = this.m_newSession.getProject();
        this.m_oldSession = relationalObjects.get(0).getSession();
        this.m_businessQuerySubjects = new HashMap();
        this.m_deferredExpressions = new HashMap();
        this.m_PhysicalTableInfo = new ArrayList<PhysicalTableInfo>();
        this.m_dsMap = new HashMap();
        this.m_srcRelationships = relationships;
        this.m_srcMeasureDimension = null;
        this.m_srcRelationalObjects = relationalObjects;
        this.collectRelatedQuerySubjects(relationalObjects);
        for (DataSource ds : this.m_oldSession.getProject().getDataSources()) {
            DataSource newDS = this.m_newProject.findDataSource(ds.getCmDataSourceName(), ds.getCatalogName(), ds.getSchemaName(), ds.getCube());
            if (newDS == null) {
                newDS = this.m_newProject.createDataSource(ds.getCmDataSourceName(), ds.getCatalogName(), ds.getSchemaName(), ds.getCube(), ds.getQueryType().toString(), ds.getInterface());
            }
            this.m_dsMap.put(ds.getInternal(), newDS);
        }
        this.m_PhysicalView = this.findOrCreateNamespace(parentNamespace, FmMessage.render("BMT_MDN_PHYSICAL_VIEW", this.m_newSession.getDefaultLocale()));
        this.m_BusinessView = this.findOrCreateNamespace(parentNamespace, FmMessage.render("BMT_MDN_BUSINESS_VIEW", this.m_newSession.getDefaultLocale()));
        Collections.sort(relationalObjects, new Comparator<RelationalObject>(){

            @Override
            public int compare(RelationalObject arg0, RelationalObject arg1) {
                int val0 = this.getValue(arg0);
                int val1 = this.getValue(arg1);
                if (val1 == val0) {
                    return arg0.compareTo(arg1);
                }
                return val0 - val1;
            }

            private int getValue(RelationalObject obj) {
                if (obj instanceof MeasureDimension) {
                    return 0;
                }
                if (obj instanceof RelationalDimension) {
                    return 1;
                }
                return 2;
            }
        });
        for (RelationalObject relationalObject : relationalObjects) {
            if (relationalObject instanceof MeasureDimension) {
                this.m_srcMeasureDimension = (MeasureDimension)relationalObject;
            }
            this.buildPhysicalView(relationalObject, this.m_physicalMap);
        }
        this.buildRelationshipsInPhysicalLayer(relationships, this.m_physicalMap);
        this.fixShortCutsInPhysicalLayer();
        this.m_businessLayerItemMap = new HashMap();
        for (RelationalObject relationalObject : relationalObjects) {
            this.buildBusinessView(relationalObject, this.m_physicalMap, this.m_businessLayerItemMap);
        }
        boolean skipParameterMaps = true;
        for (RelationalObject ro : relationalObjects) {
            if (ro instanceof RelationalParameterMap) continue;
            skipParameterMaps = false;
            break;
        }
        if (!skipParameterMaps) {
            this.exportParameterMaps(this.m_businessLayerItemMap);
        }
        BusinessExpressionCopier expressionCopier = new BusinessExpressionCopier(this.m_businessLayerItemMap, this.m_physicalMap);
        expressionCopier.resolveDeferredExpressions(this.m_deferredExpressions);
    }

    private void exportParameterMaps(HashMap<Object, BaseObject> businessMap) {
        FmProject oldProject = (FmProject)this.m_oldSession.getProject();
        for (ParameterMapBase pmapbase : oldProject.getParameterMaps()) {
            Object[] msgParams;
            Copyable pm;
            if (pmapbase instanceof ParameterMap) {
                pm = (ParameterMap)pmapbase;
                FmMDException.ASSERT(pm.isManual(), "How did a query-item-base parameter map end up in the model?");
                if (pm.isHidden()) {
                    ParameterMap hidden = (ParameterMap)this.m_newProject.findParameterMap(pm.getName());
                    hidden.copyParameterMapEntries((ParameterMap)pm);
                } else {
                    this.m_newProject.copyParameterMap((ParameterMap)pm);
                }
            }
            if (!(pmapbase instanceof RelationalParameterMap)) continue;
            pm = (RelationalParameterMap)pmapbase;
            ParameterMap newPm = this.m_newProject.createParameterMap(pm.getName(), false);
            newPm.setDefaultValue(pm.getDefaultValue());
            if (pm.getKey() == null) {
                msgParams = new Object[]{pm.getName()};
                throw new FmMDException("BMT_FBM_NO_KEY_FOR_PARAMETER_MAP", msgParams);
            }
            if (pm.getValue() == null) {
                msgParams = new Object[]{pm.getName()};
                throw new FmMDException("BMT_FBM_NO_VALUE_FOR_PARAMETER_MAP", msgParams);
            }
            QueryItem keyQI = (QueryItem)businessMap.get(pm.getKey().getInternal());
            QueryItem valueQI = (QueryItem)businessMap.get(pm.getValue().getInternal());
            newPm.addEntryBasedOn(keyQI, valueQI);
        }
    }

    private void fixShortCutsInPhysicalLayer() {
        List<Relationship> rels = this.m_PhysicalView.getAllRelationships();
        for (Shortcut shortcut : this.m_PhysicalView.getAllShortcuts()) {
            boolean hasRelationship = false;
            for (Relationship rel : rels) {
                if (!rel.getLeftEnd().equals(shortcut) && !rel.getRightEnd().equals(shortcut)) continue;
                hasRelationship = true;
                break;
            }
            if (hasRelationship) continue;
            shortcut.setTreatAs(Shortcut.TreatAs.reference);
        }
    }

    private void buildRelationshipsInPhysicalLayer(Collection<Relationship> relationships, HashMap<Object, PhysicalItem> physicalMap) {
        boolean determinantsAreRequired = false;
        for (Relationship relCandidate : relationships) {
            if (relCandidate.getDimensionJoinsOnLowestLevel()) continue;
            determinantsAreRequired = true;
            break;
        }
        for (Relationship rel : relationships) {
            FmRelationship relationship = (FmRelationship)rel;
            if (rel.isSelfJoin(true)) continue;
            HashMap<Object, List<PhysicalItem>> roItems = new HashMap<Object, List<PhysicalItem>>();
            ArrayList<RelationalObject> orderedROs = new ArrayList<RelationalObject>(2);
            RelationshipExpressionCopier expressionCopier = new RelationshipExpressionCopier(roItems, orderedROs);
            FmExpressionBuilder builder = expressionCopier.copyExpression(relationship);
            FmMDException.ASSERT(roItems.size() == 2, "Invalid relationship expression; not two sides to the relationship");
            FmMDException.ASSERT(orderedROs.size() == 2, "Invalid relationship expression; not two sides to the relationship");
            FmMDException.ASSERT(!((RelationalObject)orderedROs.get(0)).equals(orderedROs.get(1)), "Invalid relationship expression; undetected degenerate relationship");
            for (RelationalObject ro : orderedROs) {
                List<PhysicalItem> items = roItems.get(ro.getInternal());
                FmMDException.ASSERT(items.size() > 0, "Couldn't find a side of relationship: " + rel.getName());
            }
            RelationshipEnd leftDBQuerySubject = roItems.get((Object)((RelationalObject)orderedROs.get((int)0)).getInternal()).get((int)0).m_Parent;
            FmMDException.ASSERT(leftDBQuerySubject != null, "Expecting a valid left query subject when mapping relationship:" + relationship.getID());
            RelationshipEnd rightDBQuerySubject = roItems.get((Object)((RelationalObject)orderedROs.get((int)1)).getInternal()).get((int)0).m_Parent;
            FmMDException.ASSERT(rightDBQuerySubject != null, "Expecting a valid right query subject when mapping relationship:" + relationship.getID());
            FmMDException.ASSERT(!leftDBQuerySubject.equals(rightDBQuerySubject), "Missed a degenerate relationship");
            TempCardinality cardinality = new TempCardinality();
            if (relationship.getLeftEnd().equals(orderedROs.get(0))) {
                cardinality.setLeftMincard(relationship.getLeftMincard());
                cardinality.setLeftMaxcard(relationship.getLeftMaxcard());
                cardinality.setRightMincard(relationship.getRightMincard());
                cardinality.setRightMaxcard(relationship.getRightMaxcard());
            } else {
                cardinality.setLeftMincard(relationship.getRightMincard());
                cardinality.setLeftMaxcard(relationship.getRightMaxcard());
                cardinality.setRightMincard(relationship.getLeftMincard());
                cardinality.setRightMaxcard(relationship.getLeftMaxcard());
            }
            List<Relationship> priorRelationships = leftDBQuerySubject.getRelationships(rightDBQuerySubject);
            if (priorRelationships.isEmpty()) {
                this.createPhysicalRelationship(this.m_PhysicalView, cardinality, leftDBQuerySubject, rightDBQuerySubject, builder, relationship.getJoinOptimization());
            }
            RelationalObject determinantDimension = null;
            RelationshipEnd measureDimension = null;
            List<PhysicalItem> joinQueryItems = null;
            RelationshipEnd dimEnd = null;
            if (!determinantsAreRequired) continue;
            for (RelationalObject ro : orderedROs) {
                if (!(ro instanceof RelationalDimension)) continue;
                determinantDimension = ro;
                measureDimension = rel.getOtherEnd(determinantDimension);
                joinQueryItems = roItems.get(ro.getInternal());
                dimEnd = roItems.get((Object)ro.getInternal()).get((int)0).m_Parent;
            }
            QuerySubject dimDbQs = null;
            dimDbQs = dimEnd instanceof Shortcut ? (QuerySubject)((Shortcut)dimEnd).getRefobj() : (QuerySubject)dimEnd;
            if (!(determinantDimension instanceof RelationalDimension)) continue;
            this.addDeterminant(dimDbQs, joinQueryItems, (RelationalDimension)determinantDimension, measureDimension, rel.getDimensionJoinsOnLowestLevel());
        }
        if (determinantsAreRequired) {
            this.cleanupUniqueDeterminants(this.m_PhysicalView);
        }
    }

    private void associateItemWithRelationalObject(HashMap<Object, List<PhysicalItem>> roItems, List<RelationalObject> orderedROs, PhysicalItem item, RelationalObject roObj) {
        if (!roItems.containsKey(roObj.getInternal())) {
            roItems.put(roObj.getInternal(), new ArrayList());
        }
        roItems.get(roObj.getInternal()).add(item);
        if (orderedROs.size() < 2) {
            if (orderedROs.size() == 1) {
                if (!orderedROs.get(0).equals(roObj)) {
                    orderedROs.add(roObj);
                }
            } else {
                orderedROs.add(roObj);
            }
        }
    }

    private PhysicalItem createDBQueryItem(ColumnReference cRef) {
        RelationshipEnd db = this.lookupDBQuerySubject(cRef);
        QueryItem qi = null;
        QuerySubject qs = null;
        if (db == null) {
            this.createDBQuerySubject(cRef.getRelationalObject(), cRef.getDataSource(), cRef.getTableName());
            db = this.lookupDBQuerySubject(cRef);
        }
        if (db instanceof QuerySubject) {
            qs = (QuerySubject)db;
        } else if (db instanceof Shortcut) {
            qs = (QuerySubject)((Shortcut)db).getRefobj();
        } else {
            FmMDException.ASSERT(false, "Didn't find a relationshipend for " + cRef.toString());
        }
        MdColumn col = this.m_oldSession.findPhysicalColumn(cRef, true);
        if (col == null) {
            throw new FmMDException("BMT_MD_COLUMN_NOT_FOUND", cRef.getColumnName(), cRef.getTableName(), cRef.getDataSource().getName());
        }
        qi = qs.createQueryItemFromColumn(col.getName(), col);
        this.populateNamesAndDescriptions(qi, col.getName(), "");
        qi.setExternalName(cRef.getColumnName());
        PhysicalItem item = new PhysicalItem(db, (FmQueryItemLike)((Object)qi));
        return item;
    }

    private void cleanupUniqueDeterminants(Namespace ns) {
        List<QuerySubject> qList = ns.getQuerySubjects();
        for (QuerySubject qs : qList) {
            List<Determinant> detList = qs.getDeterminants();
            boolean hasGroupby = false;
            boolean hasUnique = false;
            for (Determinant det : detList) {
                if (det.isCanGroup()) {
                    hasGroupby = true;
                }
                if (!det.isIdentifiesRow()) continue;
                hasUnique = true;
            }
            if (hasUnique && !hasGroupby) {
                qs.clearDeterminants();
                continue;
            }
            if (hasUnique && hasGroupby) {
                qs.pushUniqueDeterminantsToBottom();
                continue;
            }
            if (!hasGroupby || hasUnique) continue;
            this.generateUniqueDeterminant(qs);
        }
        List<Namespace> nsList = ns.getAllNamespaces();
        for (Namespace n : nsList) {
            this.cleanupUniqueDeterminants(n);
        }
    }

    private void generateUniqueDeterminant(QuerySubject qs) {
        List<Determinant> detList;
        MdTable table = this.lookupTableFromQuerySubject(qs);
        Determinant det = null;
        MdPrimaryKey pKey = table.getPrimaryKey();
        if (pKey != null) {
            List<MdColumn> keyColumns = pKey.getColumns();
            List<QueryItem> qiList = qs.getAllQueryItems();
            boolean keyItemsExist = true;
            for (MdColumn kc : keyColumns) {
                if (qs.findQueryItemByExternalName(kc.getName()) != null) continue;
                keyItemsExist = false;
                break;
            }
            if (keyItemsExist) {
                det = qs.addDeterminant(String.valueOf(qs.getName()) + "_key");
                det.setIdentifiesRow(true);
                det.setCanGroup(false);
                for (QueryItem qi : qiList) {
                    boolean isKey = false;
                    for (MdColumn keyCol : keyColumns) {
                        if (!keyCol.getName().equals(qi.getExternalName())) continue;
                        isKey = true;
                        det.addKey(qi);
                        break;
                    }
                    if (isKey) continue;
                    det.addAttribute(qi);
                }
            }
        }
        if (det == null && (detList = qs.getDeterminants()).size() > 0) {
            det = detList.get(detList.size() - 1);
            List<QueryItem> detKeyList = det.getKeys();
            List<QueryItem> detAttrList = det.getAttributes();
            List<QueryItem> qiList = qs.getAllQueryItems();
            for (QueryItem qi : qiList) {
                if (detKeyList.contains(qi) || detAttrList.contains(qi)) continue;
                det.addAttribute(qi);
            }
        }
    }

    private void addDeterminant(QuerySubject dimDbQs, List<PhysicalItem> joinQueryItems, RelationalDimension determinantDimension, RelationshipEnd measureDimension, boolean dimensionJoinsOnLowestLevel) {
        block21: {
            boolean needsDeterminant;
            HashSet<String> keys = new HashSet<String>();
            ArrayList<QueryItem> keyList = new ArrayList<QueryItem>();
            for (PhysicalItem pi : joinQueryItems) {
                QueryItem qi = (QueryItem)((Object)pi.m_Item);
                keys.add(qi.getID());
                keyList.add(qi);
            }
            boolean bl = needsDeterminant = !dimDbQs.verifyDuplicateDeterminants(keyList, new StringBuffer());
            if (!needsDeterminant) break block21;
            int dcnt = dimDbQs.getDeterminants().size();
            Determinant determinant = dimDbQs.addDeterminant("D" + Integer.toString(dcnt));
            for (PhysicalItem pi : joinQueryItems) {
                QueryItem qi = (QueryItem)((Object)pi.m_Item);
                if (determinant.isKey(qi) || determinant.isAttribute(qi)) continue;
                determinant.addKey(qi);
            }
            if (dimensionJoinsOnLowestLevel) {
                determinant.setCanGroup(false);
                determinant.setIdentifiesRow(true);
                for (QueryItem attrItem : dimDbQs.getAllQueryItems()) {
                    if (keys.contains(attrItem.getID()) || determinant.isKey(attrItem) || determinant.isAttribute(attrItem)) continue;
                    determinant.addAttribute(attrItem);
                }
            } else {
                determinant.setCanGroup(true);
                determinant.setIdentifiesRow(false);
                List<Level> levels = determinantDimension.getAllLevels();
                ArrayList<Level> joinLevels = new ArrayList<Level>();
                for (Level level : levels) {
                    List<QueryItem> queryItems = level.getAllQueryItems();
                    Iterator<QueryItem> iterator = queryItems.iterator();
                    while (iterator.hasNext()) {
                        QueryItem qi = iterator.next();
                        if (determinantDimension.findMapping(qi) == null) continue;
                        for (PhysicalItem pi : this.lookupDBQueryItem(qi)) {
                            for (PhysicalItem joinPi : joinQueryItems) {
                                if (!joinPi.m_Item.getID().equals(pi.m_Item.getID())) continue;
                                joinLevels.add(level);
                            }
                        }
                    }
                }
                if (joinLevels.isEmpty()) {
                    StringBuilder missingItems = new StringBuilder();
                    for (PhysicalItem joinPi : joinQueryItems) {
                        missingItems.append(joinPi.m_Item.getName());
                        missingItems.append(" ");
                    }
                    throw new FmMDException("BMT_MD_JOINKEY_NOT_REFERENCED_IN_LEVEL", determinantDimension.getID(), measureDimension.getID(), missingItems.toString());
                }
                HashSet<String> keyQueryItemIds = new HashSet<String>();
                List hierarchies = determinantDimension.getAllHierarchies();
                for (RelationalHierarchy hierarchy : hierarchies) {
                    ArrayList<Level> possibleLevels = new ArrayList<Level>();
                    boolean fnd = false;
                    List<LevelReference> levelRefs = hierarchy.getLevelReferences();
                    for (LevelReference levRef : levelRefs) {
                        for (Level jLev : joinLevels) {
                            if (jLev.getID().equals(levRef.getLevel().getID())) {
                                fnd = true;
                                break;
                            }
                            possibleLevels.add(levRef.getLevel());
                        }
                        if (fnd) break;
                    }
                    if (fnd) {
                        for (Level posLev : possibleLevels) {
                            List<QueryItem> levKeyItems = posLev.getLevelKeys();
                            for (QueryItem levKey : levKeyItems) {
                                keyQueryItemIds.add(levKey.getID());
                            }
                        }
                    }
                    possibleLevels.clear();
                }
                for (String keyId : keyQueryItemIds) {
                    for (PhysicalItem phyAttrItem : this.lookupDBQueryItem((QueryItem)determinantDimension.getSession().findById(keyId))) {
                        boolean isNotKey = true;
                        for (PhysicalItem pi : joinQueryItems) {
                            if (!pi.m_Item.getID().equals(keyId)) continue;
                            isNotKey = false;
                            break;
                        }
                        if (!isNotKey || determinant.isKey((QueryItem)((Object)phyAttrItem.m_Item)) || determinant.isAttribute((QueryItem)((Object)phyAttrItem.m_Item))) continue;
                        determinant.addAttribute((QueryItem)((Object)phyAttrItem.m_Item));
                    }
                }
            }
        }
    }

    private void addComponent(ExpressionBuilder builder, PhysicalItem item) {
        if (item.m_Parent.equals(item.m_Item.getParent())) {
            builder.addExpressionPart((QueryItemBase)((Object)item.m_Item), null, null);
        } else {
            builder.addExpressionPart((QueryItemBase)((Object)item.m_Item), (Shortcut)item.m_Parent, null);
        }
    }

    private Relationship createPhysicalRelationship(Namespace parent, Cardinality relationship, RelationshipEnd leftDBQuerySubject, RelationshipEnd rightDBQuerySubject, ExpressionBuilder builder, Relationship.JoinOptimization joinOptimization) {
        Relationship newRel = parent.createRelationship(builder, leftDBQuerySubject, rightDBQuerySubject);
        newRel.copyCardinality(relationship);
        newRel.setJoinOptimization(joinOptimization);
        return newRel;
    }

    private PhysicalItem lookupDBQueryItem(ColumnReference cRef) {
        FmQueryItemLike item = null;
        RelationshipEnd parent = null;
        PhysicalTableInfo physicalTableInfo = this.matchQuerySubject(cRef.getDataSource(), cRef.getTableName());
        if (physicalTableInfo == null) {
            return null;
        }
        parent = physicalTableInfo.lookupQuerySubject(cRef.getRelationalObject());
        QuerySubject qs = null;
        if (parent instanceof QuerySubject) {
            qs = (QuerySubject)parent;
        } else if (parent instanceof Shortcut) {
            qs = (QuerySubject)((Shortcut)parent).getRefobj();
        } else if (parent != null) {
            FmMDException.ASSERT(false, "How did we get a bad PhysicalTableInfo object? " + parent.getClass().toString());
        } else {
            FmMDException.ASSERT(false, "No parent: " + cRef.toString());
        }
        for (QueryItem qi : qs.getAllQueryItems()) {
            if (!cRef.getColumnName().equals(qi.getExternalName())) continue;
            item = (FmQueryItemLike)((Object)qi);
            break;
        }
        if (item == null) {
            return null;
        }
        return new PhysicalItem(parent, item);
    }

    private List<PhysicalItem> lookupDBQueryItem(QueryItem item) {
        ArrayList<PhysicalItem> physItems = new ArrayList<PhysicalItem>();
        this.lookupDBQueryItemRecursive(item, physItems);
        return physItems;
    }

    private void lookupDBQueryItemRecursive(QueryItem item, List<PhysicalItem> items) {
        RelationshipEnd parent = null;
        RelationalObject roObj = item.getRelationalParent();
        FmMDException.ASSERT(roObj != null, "No relational parent");
        QueryItemMapping mapping = roObj.findMapping(item);
        if (mapping == null) {
            for (Object obj : item.getExpression().getComponents()) {
                if (obj instanceof QueryItem) {
                    this.lookupDBQueryItemRecursive((QueryItem)obj, items);
                    continue;
                }
                if (obj instanceof String) continue;
                FmMDException.ASSERT(false, "Unexpected object in the db item: " + item.getID());
            }
        } else {
            String columnName = mapping.getColumnName();
            Table table = mapping.getTable();
            PhysicalTableInfo blah = this.matchQuerySubject(table.getDataSource(), table.getTableName());
            parent = blah.lookupQuerySubject(roObj);
            QueryItem qi = this.lookupDBQueryItem(roObj, table, columnName);
            FmMDException.ASSERT(qi != null, "No DB Query Item found for " + columnName);
            items.add(new PhysicalItem(parent, (FmQueryItemLike)((Object)qi)));
        }
    }

    private QueryItem lookupDBQueryItem(RelationalObject roObj, Table table, String columnName) {
        BaseObject baseObj = this.matchQuerySubject(roObj, table);
        if (baseObj != null) {
            QuerySubject qs = null;
            if (baseObj instanceof QuerySubject) {
                qs = (QuerySubject)baseObj;
            } else if (baseObj instanceof Shortcut) {
                Shortcut sc = (Shortcut)baseObj;
                qs = (QuerySubject)sc.getRefobj();
            }
            for (QueryItem qi : qs.getAllQueryItems()) {
                if (!columnName.equals(qi.getExternalName())) continue;
                return qi;
            }
        }
        return null;
    }

    private MdTable lookupTableFromQuerySubject(QuerySubject qs) {
        for (PhysicalTableInfo info : this.m_PhysicalTableInfo) {
            if (!info.m_QuerySubject.getID().equals(qs.getID())) continue;
            return this.m_oldSession.findPhysicalTable(info.m_srcDataSource, info.m_TableName, true);
        }
        return null;
    }

    private RelationshipEnd lookupDBQuerySubject(ColumnReference cRef) {
        DataSource destDS = this.m_dsMap.get(cRef.getDataSource().getInternal());
        for (PhysicalTableInfo info : this.m_PhysicalTableInfo) {
            if (!info.m_TableName.equals(cRef.getTableName()) || !info.m_destDataSource.equals(destDS)) continue;
            return info.lookupQuerySubject(cRef.getRelationalObject());
        }
        return null;
    }

    private PhysicalTableInfo matchQuerySubject(Table table) {
        DataSource destDS = this.m_dsMap.get(table.getDataSource().getInternal());
        for (PhysicalTableInfo info : this.m_PhysicalTableInfo) {
            if (!info.m_TableName.equals(table.getTableName()) || !info.m_destDataSource.equals(destDS)) continue;
            return info;
        }
        return null;
    }

    private PhysicalTableInfo matchQuerySubject(DataSource dataSource, String tableName) {
        DataSource destDS = this.m_dsMap.get(dataSource.getInternal());
        for (PhysicalTableInfo info : this.m_PhysicalTableInfo) {
            if (!info.m_TableName.equals(tableName) || !info.m_destDataSource.equals(destDS)) continue;
            return info;
        }
        return null;
    }

    private BaseObject matchQuerySubject(RelationalObject roObject, Table table) {
        PhysicalTableInfo info = this.matchQuerySubject(table);
        if (info != null) {
            return info.lookupQuerySubject(roObject);
        }
        return null;
    }

    private void buildPhysicalView(RelationalObject obj, HashMap<Object, PhysicalItem> physicalMap) {
        FmPhysicalDefinition physDef = ((FmRelationalObject)obj).getPhysicalDefinition();
        for (QueryItemMapping mapping : physDef.getQueryItemMappings()) {
            QueryItemBase item = mapping.getQueryItem();
            Table table = mapping.getTable();
            if (table != null) {
                this.populateDBQuerySubject(obj, table.getTableName(), table.getDataSource(), mapping.getColumnName(), item.getUsage().equals((Object)FmUsage.identifier), item, physicalMap);
                continue;
            }
            List<SQLObject> sqlObjs = obj.getSQLObjects();
            FmMDException.ASSERT(sqlObjs.size() == 1, "no sqlObjects");
            this.populateDBQuerySubject(obj, sqlObjs.get(0).getName(), sqlObjs.get(0).getDataSource(), mapping.getColumnName(), item.getUsage().equals((Object)FmUsage.identifier), item, physicalMap);
        }
        for (Join join : physDef.getJoins()) {
            Table leftTable = join.getLeftTable();
            Table rightTable = join.getRightTable();
            ExpressionBuilder exprBuilder = BuilderFactory.createExpressionBuilder();
            Namespace relationshipNamespace = null;
            RelationshipEnd leftQS = null;
            RelationshipEnd rightQS = null;
            int assocCount = 0;
            for (Association assoc : join.getAssociations()) {
                ++assocCount;
                PhysicalItem leftQI = this.populateDBQuerySubject(obj, leftTable.getTableName(), leftTable.getDataSource(), assoc.getLeftColumn(), true, null, physicalMap);
                PhysicalItem rightQI = this.populateDBQuerySubject(obj, rightTable.getTableName(), rightTable.getDataSource(), assoc.getRightColumn(), true, null, physicalMap);
                if (relationshipNamespace == null) {
                    Namespace leftNS = leftQI.m_Item.getParentNamespace();
                    Namespace rightNS = rightQI.m_Item.getParentNamespace();
                    leftQS = leftQI.m_Parent;
                    rightQS = rightQI.m_Parent;
                    relationshipNamespace = leftNS.equals(rightNS) ? leftNS : this.m_PhysicalView;
                }
                this.addComponent(exprBuilder, leftQI);
                exprBuilder.addExpressionPart(assoc.getOperatorAsString(), null);
                this.addComponent(exprBuilder, rightQI);
                if (assocCount >= join.getAssociations().size()) continue;
                exprBuilder.addExpressionPart("AND", null);
            }
            this.createPhysicalRelationship(relationshipNamespace, join, leftQS, rightQS, exprBuilder, Relationship.JoinOptimization.none);
        }
        for (Table table : obj.getTables()) {
            PhysicalTableInfo infoOfInterest = this.matchQuerySubject(table);
            QuerySubject db = infoOfInterest.getQuerySubject();
            for (TableDeterminant det : table.getTableDeterminants()) {
                PhysicalItem item;
                String detName = String.valueOf(det.getName()) + "-" + obj.getName();
                int i = 1;
                Determinant existingDet = db.getDeteriminant(detName);
                while (existingDet != null) {
                    detName = String.valueOf(det.getName()) + "-" + obj.getName() + Integer.toString(i++);
                    existingDet = db.getDeteriminant(detName);
                }
                Determinant dbDet = db.addDeterminant(detName);
                dbDet.setIdentifiesRow(det.isIdentifiesRow());
                dbDet.setCanGroup(det.isCanGroup());
                for (String key : det.getKeys()) {
                    item = this.populateDBQuerySubject(obj, table.getTableName(), table.getDataSource(), key, true, null, physicalMap);
                    dbDet.addKey((QueryItem)((Object)item.m_Item));
                }
                for (String attribute : det.getAttributes()) {
                    item = this.populateDBQuerySubject(obj, table.getTableName(), table.getDataSource(), attribute, false, null, physicalMap);
                    dbDet.addAttribute((QueryItem)((Object)item.m_Item));
                }
            }
        }
    }

    private PhysicalItem populateDBQuerySubject(RelationalObject srcRelationalObj, String tableName, DataSource ds, String columnName, boolean forceIndexUsage, QueryItemBase srcItem, HashMap<Object, PhysicalItem> physicalMap) {
        String schemaName = ds.getSchemaName();
        Namespace parent = this.findOrCreateNamespace(this.m_PhysicalView, schemaName);
        QuerySubject qsOfInterest = null;
        RelationshipEnd qiParent = null;
        PhysicalTableInfo infoOfInterest = this.matchQuerySubject(ds, tableName);
        if (infoOfInterest == null) {
            infoOfInterest = this.createDBQuerySubject(srcRelationalObj, ds, tableName);
        }
        qsOfInterest = infoOfInterest.getQuerySubject();
        if (!infoOfInterest.isMapped(srcRelationalObj)) {
            boolean reuseTable = false;
            if (srcRelationalObj instanceof RelationalDimension) {
                RelationalDimension dim = (RelationalDimension)srcRelationalObj;
                for (Relationship relationship : this.m_srcRelationships) {
                    if (!relationship.getLeftEnd().equals(dim) && !relationship.getRightEnd().equals(dim) || !relationship.isSelfJoin(true)) continue;
                    reuseTable = true;
                    break;
                }
            }
            if (reuseTable) {
                infoOfInterest.addRelMap(srcRelationalObj, qsOfInterest);
            } else {
                Shortcut newShortCut = parent.createShortcut(qsOfInterest, BaseObject.PrefixName.kStandard);
                newShortCut.setTreatAs(Shortcut.TreatAs.alias);
                infoOfInterest.addRelMap(srcRelationalObj, newShortCut);
            }
        }
        qiParent = infoOfInterest.lookupQuerySubject(srcRelationalObj);
        FmMDException.ASSERT(qsOfInterest != null, "We don't have a query subject");
        FmQueryItemBase qiOfInterest = null;
        for (QueryItem qi : qsOfInterest.getAllQueryItems()) {
            if (!qi.getExternalName().equals(columnName)) continue;
            qiOfInterest = (FmQueryItem)qi;
            break;
        }
        if (qiOfInterest == null) {
            if (srcItem == null) {
                MdColumn physColumn = null;
                MdTable mdTable = this.m_oldSession.findPhysicalTable(ds, tableName, true);
                if (mdTable != null) {
                    physColumn = mdTable.findColumn(columnName);
                }
                FmMDException.ASSERT(physColumn != null, "Can't find a column named " + columnName + " in the table " + tableName);
                qiOfInterest = (FmQueryItem)qsOfInterest.createQueryItemFromColumn(columnName, physColumn);
                this.populateNamesAndDescriptions(qiOfInterest, columnName, "");
            } else {
                qiOfInterest = (FmQueryItem)qsOfInterest.createQueryItemFromQueryItem(columnName, srcItem, null);
                this.populateNamesAndDescriptions(qiOfInterest, columnName, "");
                qiOfInterest.copyReplicableProperties((FmQueryItemBase)srcItem);
            }
            qiOfInterest.setExternalName(columnName);
            if (srcItem != null) {
                qiOfInterest.setUsage(srcItem.getUsage());
            }
        }
        if (srcItem != null) {
            physicalMap.put(srcItem.getInternal(), new PhysicalItem(qiParent, qiOfInterest));
        }
        if (forceIndexUsage) {
            qiOfInterest.setUsage(FmUsage.identifier);
        }
        PhysicalItem pi = srcItem != null ? physicalMap.get(srcItem.getInternal()) : new PhysicalItem(qiParent, qiOfInterest);
        return pi;
    }

    private PhysicalTableInfo createDBQuerySubject(RelationalObject srcRelationalObj, DataSource srcDs, String tableName) {
        String schemaName = srcDs.getSchemaName();
        Namespace parent = this.findOrCreateNamespace(this.m_PhysicalView, schemaName);
        DataSource newDs = this.m_dsMap.get(srcDs.getInternal());
        FmMDException.ASSERT(newDs != null, "Bad data source");
        QuerySubject newQS = parent.createDbQuerySubject(tableName, newDs);
        this.populateNamesAndDescriptions(newQS, tableName, null);
        FmDbQuery dbQuery = (FmDbQuery)newQS.getDBQuery();
        List<SQLObject> sqlObjects = srcRelationalObj.getSQLObjects();
        if (sqlObjects.size() == 0) {
            dbQuery.setSql(newDs.getName(), tableName, QuerySubjectBase.TypeOfSql.cognosSQL);
        } else {
            String sql = sqlObjects.get(0).getSQLStatement();
            dbQuery.setSql(sql, QuerySubjectBase.TypeOfSql.cognosSQL);
        }
        dbQuery.setTableType(FmDbQuery.TableType.table);
        PhysicalTableInfo infoOfInterest = new PhysicalTableInfo(srcDs, tableName, srcRelationalObj, newQS);
        this.m_PhysicalTableInfo.add(infoOfInterest);
        return infoOfInterest;
    }

    private QuerySubjectBase buildBusinessView(RelationalObject srcObj, HashMap<Object, PhysicalItem> physicalMap, HashMap<Object, BaseObject> businessMap) {
        FmQuerySubject qs = null;
        qs = (FmQuerySubject)this.m_BusinessView.createModelQuerySubject(srcObj.getName());
        this.m_businessQuerySubjects.put(srcObj.getInternal(), qs);
        qs.copyCommonProperties(srcObj, this.m_BusinessView);
        if (this.m_idMap != null) {
            this.m_idMap.put(srcObj.getInternal(), qs.getID());
        }
        for (BaseObject obj : srcObj.getChildObjects()) {
            this.createBusinessObject(srcObj, obj, qs, physicalMap, businessMap);
        }
        boolean keyFilter = false;
        for (RelationalFilter filter : srcObj.getAllFilters()) {
            if (!filter.isInScope(this.m_srcRelationalObjects) || !filter.getFilterApplication().equals((Object)FilterApplication.EFilterApplication.always)) continue;
            ModelQuery mq = qs.getModelQuery();
            FilterDefinition fd = mq.createFilterDefinition(filter.getName(), null);
            this.deferExpression(fd, filter);
            if (!filter.getGenerateKeyFilter() || keyFilter) continue;
            keyFilter = true;
            this.generateRelationshipFilter(srcObj);
        }
        return qs;
    }

    protected void deferExpression(ExpressionParent key, ExpressionParent value) {
        if (value instanceof BaseObject) {
            FmEngApplicationLog.getApplicationLog().logDebug(FmEngApplicationLog.LOGGERS.PUBLISH, this.m_oldSession, "Deferring for late resolution the expression in: " + ((BaseObject)((Object)value)).getID());
        } else if (value instanceof FmComplexProperty) {
            FmEngApplicationLog.getApplicationLog().logDebug(FmEngApplicationLog.LOGGERS.PUBLISH, this.m_oldSession, "Deferring for late resolution the expression in: " + ((FmComplexProperty)((Object)value)).getPropertyName());
        } else {
            FmEngApplicationLog.getApplicationLog().logDebug(FmEngApplicationLog.LOGGERS.PUBLISH, this.m_oldSession, "Deferring for late resolution the expression in: " + value.toString());
        }
        FmEngApplicationLog.getApplicationLog().logDebug(FmEngApplicationLog.LOGGERS.PUBLISH, this.m_oldSession, "Expression: " + (value.getExpression() == null ? "" : value.getExpression().getExpressionText()));
        this.m_deferredExpressions.put(key, value);
    }

    private void generateRelationshipFilter(RelationalObject srcObj) {
        if (!(srcObj instanceof RelationalDimension)) {
            return;
        }
        if (this.m_srcMeasureDimension == null) {
            return;
        }
        if (this.m_srcMeasureDimension.getParent() instanceof FmCube && ((FmCube)this.m_srcMeasureDimension.getParent()).isAggregateCube()) {
            FmEngApplicationLog.getApplicationLog().logInfo(FmEngApplicationLog.LOGGERS.PUBLISH, this.m_oldSession, "Skipping the creation of a data filter for " + this.m_srcMeasureDimension.getName() + " because the aggregate cube is built on a single table.");
            return;
        }
        RelationalDimension dim = (RelationalDimension)srcObj;
        Relationship relOfInterest = this.getRelationship(dim, this.m_srcMeasureDimension);
        if (relOfInterest == null) {
            FmEngApplicationLog.getApplicationLog().logWarn(FmEngApplicationLog.LOGGERS.PUBLISH, this.m_oldSession, "Skipping the creation of a data filter for " + this.m_srcMeasureDimension.getName() + " because there is no relationship between it and " + dim.getName() + ".");
            return;
        }
        QuerySubject measQS = (QuerySubject)this.m_businessQuerySubjects.get(this.m_srcMeasureDimension.getInternal());
        FmMDException.ASSERT(measQS != null, "Assumption violation: why haven't we converted the measure dimension yet?");
        ModelQuery mq = measQS.getModelQuery();
        FilterDefinition fd = mq.createFilterDefinition(relOfInterest.getName(), null);
        this.deferExpression(fd, relOfInterest);
    }

    private Relationship getRelationship(RelationalObject ro1, RelationalObject ro2) {
        for (Relationship rel : this.m_srcRelationships) {
            if (rel.getLeftEnd().equals(ro1) && rel.getRightEnd().equals(ro2)) {
                return rel;
            }
            if (!rel.getLeftEnd().equals(ro2) || !rel.getRightEnd().equals(ro1)) continue;
            return rel;
        }
        return null;
    }

    private BaseObject createBusinessObject(RelationalObject relationalParent, BaseObject srcObj, BaseObject destParent, HashMap<Object, PhysicalItem> physicalMap, HashMap<Object, BaseObject> businessMap) {
        BaseObject destObj = null;
        FmMultilingualAttribute multiAttr = null;
        switch (srcObj.getFmObjectType()) {
            case queryItem: {
                RelationalDimension regDim;
                if (relationalParent instanceof RelationalDimension && (regDim = (RelationalDimension)relationalParent).getMultilingualSupport() == RelationalDimension.MultilingualSupport.byColumn && ((FmQueryItem)srcObj).isMultilingual()) {
                    FmQueryItem objQItem = (FmQueryItem)srcObj;
                    if (regDim.getParentChild()) {
                        List hierarchies = regDim.getAllHierarchies();
                        FmMDException.ASSERT(hierarchies.size() == 1, "Can only be one hierarchy in a parent-child dimension");
                        FmRelationalHierarchy hierarchy = (FmRelationalHierarchy)hierarchies.get(0);
                        multiAttr = hierarchy.getMultilingualAttributeMap().findAttribute(objQItem);
                    } else {
                        FmLevel qiLevel = (FmLevel)objQItem.getLevel();
                        multiAttr = qiLevel.getMultilingualAttributeMap().findAttribute(objQItem);
                    }
                    List<QueryItem> localeItems = objQItem.getMultilingualAttributeQueryItems();
                    List<String> supportedLocales = srcObj.getSession().getProject().getSupportedLocales();
                    String defaultLocale = srcObj.getSession().getProject().getDefaultLocale();
                    for (QueryItem qi : localeItems) {
                        if (multiAttr == null) continue;
                        List<FmLocaleMapping> mappings = multiAttr.getLocaleMappingList();
                        for (FmLocaleMapping mapping : mappings) {
                            if (mapping.getQueryItem() == null || !mapping.getQueryItem().equals(qi) || mapping.getlocale().equals(defaultLocale)) continue;
                            for (String suppLocale : supportedLocales) {
                                if (!mapping.getlocale().equals(suppLocale)) continue;
                                this.createBusinessQueryItem((FmQueryItemBase)((Object)qi), destParent, physicalMap, businessMap);
                            }
                        }
                    }
                }
            }
            case measure: {
                destObj = this.createBusinessQueryItem((FmQueryItemBase)srcObj, destParent, physicalMap, businessMap);
                break;
            }
            case queryItemFolder: {
                destObj = this.createBusinessQueryItemFolder((QueryItemFolder)srcObj, destParent);
                break;
            }
            case measureFolder: {
                destObj = this.createBusinessQueryItemFolder((MeasureFolder)srcObj, destParent);
                break;
            }
        }
        if (destObj == null) {
            destObj = destParent;
        }
        if (srcObj.getFmObjectType() != FmObjectType.multilingualAttributeMap) {
            for (BaseObject child : srcObj.getChildObjects()) {
                this.createBusinessObject(relationalParent, child, destObj, physicalMap, businessMap);
            }
        }
        return destObj;
    }

    private BaseObject createBusinessQueryItemFolder(QueryItemFolder srcObj, BaseObject destParent) {
        FmQueryItemFolder newFolder = null;
        if (destParent instanceof QueryItemFolderParent) {
            QueryItemFolderParent mfp = (QueryItemFolderParent)destParent;
            newFolder = (FmQueryItemFolder)mfp.createQueryItemFolder(srcObj.getName());
            newFolder.copyCommonProperties(srcObj, destParent);
        }
        return newFolder;
    }

    private BaseObject createBusinessQueryItemFolder(MeasureFolder srcObj, BaseObject destParent) {
        FmQueryItemFolder newFolder = null;
        if (destParent instanceof QueryItemFolderParent) {
            QueryItemFolderParent mfp = (QueryItemFolderParent)destParent;
            newFolder = (FmQueryItemFolder)mfp.createQueryItemFolder(srcObj.getName());
            newFolder.copyCommonProperties(srcObj, destParent);
        }
        return newFolder;
    }

    private BaseObject createBusinessQueryItem(FmQueryItemBase srcObj, BaseObject destParent, HashMap<Object, PhysicalItem> physicalMap, HashMap<Object, BaseObject> businessMap) {
        FmQueryItemLike newItem = null;
        RelationalObject roParent = srcObj.getRelationalParent();
        FmEngApplicationLog.getApplicationLog().logDebug(FmEngApplicationLog.LOGGERS.PUBLISH, this.m_oldSession, "Creating business layer query item for: " + srcObj.getID());
        if (destParent instanceof QueryItemParent) {
            PhysicalItem physicalItem = physicalMap.get(srcObj.getInternal());
            if (physicalItem == null) {
                Expression srcExpr = srcObj.getExpression();
                RelationalObject relParent = srcObj.getRelationalParent();
                QueryItemMapping mapping = relParent.findMapping(srcObj);
                if (mapping != null) {
                    throw new FmMDException("BMT_MD_BAD_QUERY_ITEM_MAPPING", srcObj.getID(), mapping.getColumnName());
                }
                FmMDException.ASSERT(srcExpr != null, "We must have an expression here: " + srcObj.getID());
                if (srcObj.getRegularAggregate() == FmRegularAggregate.calculated) {
                    newItem = this.createBusinessCalculation(srcObj, destParent);
                } else if (srcObj.getRegularAggregate() == FmRegularAggregate.countNonZero) {
                    FmExpressionBuilder newExpr = (FmExpressionBuilder)BuilderFactory.createExpressionBuilder();
                    newExpr.addExpressionPart("IF ((", null);
                    newExpr.populateFrom(srcExpr);
                    newExpr.addExpressionPart(") = 0) THEN (0) ELSE (1)", null);
                    newItem = (FmQueryItem)((QueryItemParent)destParent).createQueryItem(srcObj.getName(), newExpr);
                    newItem.copyReplicableProperties(srcObj);
                    newItem.setRegularAggregate(FmRegularAggregate.sum);
                    this.deferExpression(newItem, newItem);
                } else {
                    newItem = (FmQueryItem)((QueryItemParent)destParent).createQueryItem(srcObj.getName(), null);
                    this.deferExpression(newItem, srcObj);
                }
            } else {
                FmExpressionBuilder expr = (FmExpressionBuilder)BuilderFactory.createExpressionBuilder();
                if (srcObj.getRegularAggregate() == FmRegularAggregate.countNonZero) {
                    expr.addExpressionPart("IF (", null);
                    expr.addExpressionPart(physicalItem.m_Item, null);
                    expr.addExpressionPart(" = 0) THEN (0) ELSE (1)", null);
                    newItem = (FmQueryItem)((QueryItemParent)destParent).createQueryItem(srcObj.getName(), expr);
                    if (physicalItem.m_Item instanceof FmQueryItemBase) {
                        newItem.copyReplicableProperties((FmQueryItemBase)physicalItem.m_Item);
                    }
                    newItem.setRegularAggregate(FmRegularAggregate.sum);
                } else {
                    this.addComponent(expr, physicalItem);
                    newItem = (FmQueryItem)((QueryItemParent)destParent).createQueryItem(srcObj.getName(), expr);
                }
            }
            if (newItem != null) {
                FmEngApplicationLog.getApplicationLog().logDebug(FmEngApplicationLog.LOGGERS.PUBLISH, this.m_oldSession, "Created business layer query item: " + newItem.getID());
                newItem.copyCommonProperties(srcObj, destParent);
                newItem.copyReplicableProperties(srcObj);
                if (this.m_idMap != null) {
                    this.m_idMap.put(srcObj.getInternal(), newItem.getID());
                }
                if (srcObj instanceof FmMeasure) {
                    newItem.setUsage(FmUsage.fact);
                } else if (roParent != null && roParent instanceof RelationalDimension) {
                    newItem.setUsage(FmUsage.attribute);
                    newItem.setRegularAggregate(FmRegularAggregate.unsupported);
                }
                businessMap.put(srcObj.getInternal(), newItem);
            } else {
                FmEngApplicationLog.getApplicationLog().logWarn(FmEngApplicationLog.LOGGERS.PUBLISH, this.m_oldSession, "Didn't create a business layer query item for: " + srcObj.getID());
            }
        }
        return newItem;
    }

    protected abstract FmQueryItemLike createBusinessCalculation(FmQueryItemBase var1, BaseObject var2);

    protected abstract BaseObject createDimensionalObject(BaseObject var1, BaseObject var2, HashMap<Object, BaseObject> var3);

    private Namespace findOrCreateNamespace(Section parentNamespace, String name) {
        String id = CrnIDHelper.addEntryToID(null, name);
        Namespace newNamespace = (Namespace)FmModelFactory.getInstance().getById(this.m_newSession, id);
        if (newNamespace == null) {
            newNamespace = parentNamespace.createNamespace(name);
            this.populateNamesAndDescriptions(newNamespace, name, null);
        }
        return newNamespace;
    }

    private void populateNamesAndDescriptions(ReportObject reportObject, String name, String description) {
        for (String locale : this.m_newSession.getProject().getSupportedLocales()) {
            if (!locale.equals(this.m_newSession.getDefaultLocale()) && reportObject.getName(locale) == null) {
                reportObject.setName(locale, name);
            }
            if (reportObject.getDescription(locale) != null || description == null) continue;
            reportObject.setDescription(locale, description);
        }
    }

    public BaseObject getRelationalObjectId(Object obj) {
        return this.m_presentationLayerObjectMap.get(obj);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BusinessExpressionCopier
    extends FmExpressionCopier {
        private HashMap<Object, BaseObject> itemMap;
        private HashMap<Object, PhysicalItem> physicalMap;

        public BusinessExpressionCopier(HashMap<Object, BaseObject> itemMap, HashMap<Object, PhysicalItem> physicalMap) {
            this.itemMap = itemMap;
            this.physicalMap = physicalMap;
        }

        @Override
        protected boolean handleQueryItemBase(ExpressionParent srcExpressionParent, FmExpressionBuilder destBuilder, FmQueryItemBase qiPart) {
            PhysicalItem physItem = null;
            BaseObject busItem = this.itemMap.get(qiPart.getInternal());
            if (busItem == null && this.physicalMap != null && (physItem = this.physicalMap.get(qiPart.getInternal())) != null) {
                busItem = physItem.m_Item;
            }
            if (busItem == null) {
                return false;
            }
            if (physItem != null && physItem.m_Parent instanceof Shortcut) {
                destBuilder.addExpressionPart((QueryItemBase)busItem, (Shortcut)physItem.m_Parent, null);
            } else if (busItem instanceof Calculation) {
                destBuilder.addExpressionPart((Calculation)busItem, null);
            } else {
                destBuilder.addExpressionPart((QueryItemBase)busItem, null, null);
            }
            return true;
        }

        @Override
        protected boolean handleColumnReference(ExpressionParent srcExpressionParent, FmExpressionBuilder destBuilder, ColumnReference cRef) {
            QuerySubjectBase mqs;
            PhysicalItem item = FmModelBuilderBase.this.lookupDBQueryItem(cRef);
            if (item == null) {
                item = FmModelBuilderBase.this.createDBQueryItem(cRef);
            }
            FmMDException.ASSERT((mqs = (QuerySubjectBase)FmModelBuilderBase.this.m_businessQuerySubjects.get(cRef.getRelationalObject().getInternal())) != null, "No model query subject for relational object" + cRef.getRelationalObject().getID());
            FmMDException.ASSERT(item.m_Item instanceof QueryItem, String.valueOf(item.m_Item.getName()) + " isn't a query item.");
            QueryItem mqi = mqs.findQueryItemReferencing((QueryItem)((Object)item.m_Item));
            if (mqi == null) {
                FmExpressionBuilder expr = (FmExpressionBuilder)BuilderFactory.createExpressionBuilder();
                FmModelBuilderBase.this.addComponent(expr, item);
                mqi = mqs.createQueryItem(item.m_Item.getName(), expr);
                FmModelBuilderBase.this.populateNamesAndDescriptions(mqi, item.m_Item.getName(), "");
                mqi.setComment("This was injected because an expression in the source model used a column reference: " + cRef.toString());
            }
            destBuilder.addExpressionPart(mqi, null, null);
            return true;
        }

        @Override
        protected boolean handleCalculation(ExpressionParent srcExpressionParent, FmExpressionBuilder destBuilder, FmCalculation calculation) {
            FmMDException.ASSERT(false, "Shouldn't encounter calculations while copying expressions in the business layer.");
            return false;
        }

        @Override
        protected boolean handleFilter(ExpressionParent srcExpressionParent, FmExpressionBuilder destBuilder, FmFilter filter) {
            FmMDException.ASSERT(false, "Shouldn't encounter filters while copying expressions in the business layer.");
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DimensionalExpressionCopier
    extends FmExpressionCopier {
        private HashMap<Object, BaseObject> m_itemMap;

        public DimensionalExpressionCopier(HashMap<Object, BaseObject> itemMap) {
            this.m_itemMap = itemMap;
        }

        @Override
        protected boolean handleQueryItemBase(ExpressionParent srcExpressionParent, FmExpressionBuilder destBuilder, FmQueryItemBase qiPart) {
            QuerySubjectBase qs = null;
            BaseObject destItem = null;
            if (srcExpressionParent instanceof QueryItem) {
                qs = ((QueryItem)srcExpressionParent).getQueryParent();
            }
            destItem = srcExpressionParent instanceof Filter || srcExpressionParent instanceof Calculation || srcExpressionParent instanceof RelationalFilter ? this.m_itemMap.get(qiPart.getInternal()) : (qs != null ? (qiPart.getRelationalParent() != null ? this.m_itemMap.get(qiPart.getInternal()) : FmModelBuilderBase.this.m_presentationLayerObjectMap.get(qiPart.getInternal())) : FmModelBuilderBase.this.m_presentationLayerObjectMap.get(qiPart.getInternal()));
            if (destItem == null) {
                return false;
            }
            destBuilder.addExpressionPart((QueryItemBase)destItem, null, null);
            return true;
        }

        @Override
        protected boolean handleColumnReference(ExpressionParent srcExpressionParent, FmExpressionBuilder destBuilder, ColumnReference cRef) {
            FmMDException.ASSERT(false, "Shouldn't encounter column references while copying expressions in the dimensional/presentation layer.");
            return true;
        }

        @Override
        protected boolean handleCalculation(ExpressionParent srcExpressionParent, FmExpressionBuilder destBuilder, FmCalculation calculation) {
            BaseObject busItem = FmModelBuilderBase.this.m_presentationLayerObjectMap.get(calculation.getInternal());
            if (busItem == null) {
                return false;
            }
            destBuilder.addExpressionPart((Calculation)busItem, null);
            return true;
        }

        @Override
        protected boolean handleFilter(ExpressionParent srcExpressionParent, FmExpressionBuilder destBuilder, FmFilter filter) {
            BaseObject busItem = FmModelBuilderBase.this.m_presentationLayerObjectMap.get(filter.getInternal());
            if (busItem == null) {
                return false;
            }
            destBuilder.addExpressionPart((Filter)busItem, null);
            return true;
        }
    }

    class PhysicalItem {
        public RelationshipEnd m_Parent;
        public FmQueryItemLike m_Item;

        public PhysicalItem(RelationshipEnd parent, FmQueryItemLike item) {
            this.m_Parent = parent;
            this.m_Item = item;
        }

        public String toString() {
            StringBuilder out = new StringBuilder("Physical Item: ");
            if (this.m_Parent instanceof QuerySubject) {
                out.append("Query Subject ");
                out.append(this.m_Parent.getID());
            } else if (this.m_Parent instanceof Shortcut) {
                out.append("Shortcut ");
                out.append(this.m_Parent.getID());
            }
            out.append(" --> ");
            out.append(this.m_Item.getID());
            return out.toString();
        }
    }

    class PhysicalTableInfo {
        private String m_TableName;
        private DataSource m_srcDataSource;
        private DataSource m_destDataSource;
        private QuerySubject m_QuerySubject;
        private HashMap<Object, RelationshipEnd> m_RelObjectMap;

        public PhysicalTableInfo(DataSource dataSource, String tableName, RelationalObject rel, QuerySubject qs) {
            this.m_TableName = tableName;
            this.m_srcDataSource = dataSource;
            this.m_destDataSource = (DataSource)FmModelBuilderBase.this.m_dsMap.get(dataSource.getInternal());
            this.m_QuerySubject = qs;
            this.m_RelObjectMap = new HashMap();
            this.m_RelObjectMap.put(rel.getInternal(), qs);
        }

        public boolean isMapped(RelationalObject srcRelationalObj) {
            return this.m_RelObjectMap.containsKey(srcRelationalObj.getInternal());
        }

        public void addRelMap(RelationalObject srcRelationalObj, Shortcut qiParent) {
            FmMDException.ASSERT(qiParent instanceof FmShortcut, "Trying to map a table to a non-shortcut");
            this.m_RelObjectMap.put(srcRelationalObj.getInternal(), qiParent);
        }

        public void addRelMap(RelationalObject srcRelationalObj, QuerySubject qiParent) {
            FmMDException.ASSERT(qiParent instanceof FmQuerySubject, "Trying to map a table to a non-query-subject");
            this.m_RelObjectMap.put(srcRelationalObj.getInternal(), qiParent);
        }

        public RelationshipEnd lookupQuerySubject(RelationalObject roObject) {
            return this.m_RelObjectMap.get(roObject.getInternal());
        }

        public QuerySubject getQuerySubject() {
            return this.m_QuerySubject;
        }

        public String toString() {
            String out = "Table Name: " + this.m_TableName + "\n";
            out = String.valueOf(out) + "QuerySubject: " + this.m_QuerySubject.getID() + "\n";
            for (Object obj : this.m_RelObjectMap.keySet()) {
                FmRelationalDimensionBase relObj = null;
                if (obj instanceof RelationalDimensionType) {
                    relObj = FmRelationalDimension.get(FmModelBuilderBase.this.m_oldSession, obj);
                }
                if (obj instanceof MeasureDimensionType) {
                    relObj = FmMeasureDimension.get(FmModelBuilderBase.this.m_oldSession, obj);
                }
                out = String.valueOf(out) + "\tRel Obj: " + relObj.getName() + " ---> ";
                RelationshipEnd end = this.m_RelObjectMap.get(obj);
                if (end instanceof QuerySubject) {
                    out = String.valueOf(out) + "Query Subject: " + ((QuerySubject)end).getID() + "\n";
                }
                if (!(end instanceof Shortcut)) continue;
                out = String.valueOf(out) + "Shortcut: " + ((Shortcut)end).getID() + "\n";
            }
            return out;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RelationshipExpressionCopier
    extends FmExpressionCopier {
        private HashMap<Object, List<PhysicalItem>> roItems;
        private List<RelationalObject> orderedROs;

        public RelationshipExpressionCopier(HashMap<Object, List<PhysicalItem>> roItems, List<RelationalObject> orderedROs) {
            this.orderedROs = orderedROs;
            this.roItems = roItems;
        }

        @Override
        protected boolean handleCalculation(ExpressionParent srcExpressionParent, FmExpressionBuilder destBuilder, FmCalculation calculation) {
            FmMDException.ASSERT(false, "There shouldn't be a calculation in a relationship expression.");
            return false;
        }

        @Override
        protected boolean handleFilter(ExpressionParent srcExpressionParent, FmExpressionBuilder destBuilder, FmFilter filter) {
            FmMDException.ASSERT(false, "There shouldn't be a filter in a relationship expression.");
            return false;
        }

        @Override
        protected boolean handleColumnReference(ExpressionParent srcExpressionParent, FmExpressionBuilder destBuilder, ColumnReference cRef) {
            PhysicalItem item = FmModelBuilderBase.this.lookupDBQueryItem(cRef);
            if (item == null) {
                item = FmModelBuilderBase.this.createDBQueryItem(cRef);
            }
            FmModelBuilderBase.this.addComponent(destBuilder, item);
            FmModelBuilderBase.this.associateItemWithRelationalObject(this.roItems, this.orderedROs, item, cRef.getRelationalObject());
            return true;
        }

        @Override
        protected boolean handleQueryItemBase(ExpressionParent srcExpressionParent, FmExpressionBuilder destBuilder, FmQueryItemBase qiPart) {
            List items = FmModelBuilderBase.this.lookupDBQueryItem((QueryItem)((Object)qiPart));
            FmMDException.ASSERT(items.size() == 1, "Bad expression component: " + srcExpressionParent.getExpression().getExpressionText());
            for (PhysicalItem item : items) {
                FmModelBuilderBase.this.addComponent(destBuilder, item);
                FmModelBuilderBase.this.associateItemWithRelationalObject(this.roItems, this.orderedROs, item, qiPart.getRelationalParent());
            }
            return true;
        }
    }

    class TempCardinality
    implements Cardinality {
        private Cardinality.ECardinality m_leftMin = Cardinality.ECardinality.one;
        private Cardinality.ECardinality m_leftMax = Cardinality.ECardinality.one;
        private Cardinality.ECardinality m_rightMin = Cardinality.ECardinality.one;
        private Cardinality.ECardinality m_rightMax = Cardinality.ECardinality.one;

        TempCardinality() {
        }

        public Cardinality.ECardinality getLeftMincard() {
            return this.m_leftMin;
        }

        public Cardinality.ECardinality getRightMincard() {
            return this.m_rightMin;
        }

        public Cardinality.ECardinality getLeftMaxcard() {
            return this.m_leftMax;
        }

        public Cardinality.ECardinality getRightMaxcard() {
            return this.m_rightMax;
        }

        public void setLeftMincard(Cardinality.ECardinality leftMincard) {
            this.m_leftMin = leftMincard;
        }

        public void setRightMincard(Cardinality.ECardinality rightMincard) {
            this.m_rightMin = rightMincard;
        }

        public void setLeftMaxcard(Cardinality.ECardinality leftMaxcard) {
            this.m_leftMax = leftMaxcard;
        }

        public void setRightMaxcard(Cardinality.ECardinality rightMaxcard) {
            this.m_rightMax = rightMaxcard;
        }

        public void copyCardinality(Cardinality right) {
            this.m_leftMin = right.getLeftMincard();
            this.m_leftMax = right.getLeftMaxcard();
            this.m_rightMin = right.getRightMincard();
            this.m_rightMax = right.getRightMaxcard();
        }

        public boolean equals(Cardinality.ECardinality leftMinCard, Cardinality.ECardinality leftMaxCard, Cardinality.ECardinality rightMinCard, Cardinality.ECardinality rightMaxCard) {
            return leftMinCard.equals((Object)this.m_leftMin) && leftMaxCard.equals((Object)this.m_leftMax) && rightMinCard.equals((Object)rightMinCard) && rightMaxCard.equals((Object)rightMaxCard);
        }

        public String toString() {
            return "leftMin: " + this.m_leftMin.toString() + ", leftMax: " + this.m_leftMax.toString() + ", rightMin: " + this.m_rightMin.toString() + ", rightMax: " + this.m_rightMax.toString();
        }
    }
}

