/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmEMDObjectNaming;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFolder;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasure;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasureFolder;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelBuilderBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmNamespace;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemFolder;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemLike;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSection;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.BuilderFactory;
import com.ibm.cognos.fmeng.fmmd.model.Calculation;
import com.ibm.cognos.fmeng.fmmd.model.CubeBase;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionParent;
import com.ibm.cognos.fmeng.fmmd.model.Filter;
import com.ibm.cognos.fmeng.fmmd.model.FmRegularAggregate;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.LevelParent;
import com.ibm.cognos.fmeng.fmmd.model.LevelReference;
import com.ibm.cognos.fmeng.fmmd.model.Measure;
import com.ibm.cognos.fmeng.fmmd.model.MeasureDimension;
import com.ibm.cognos.fmeng.fmmd.model.MeasureFolder;
import com.ibm.cognos.fmeng.fmmd.model.MeasureFolderParent;
import com.ibm.cognos.fmeng.fmmd.model.MeasureParent;
import com.ibm.cognos.fmeng.fmmd.model.PackageBase;
import com.ibm.cognos.fmeng.fmmd.model.ParameterMap;
import com.ibm.cognos.fmeng.fmmd.model.Property;
import com.ibm.cognos.fmeng.fmmd.model.PseudoPackage;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemFolder;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemFolderParent;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemMapping;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemParent;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubject;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.model.Role;
import com.ibm.cognos.fmeng.fmmd.model.Section;
import com.ibm.cognos.fmeng.fmmd.model.ShortcutTarget;
import com.ibm.cognos.fmeng.fmmd.model.SortItem;
import com.ibm.cognos.fmeng.fmmd.util.FmExpressionBuilder;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.ProjectFactory;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmModelBuilderDMR
extends FmModelBuilderBase {
    private static final String FMT_DYNAMIC_SOURCE_PROPERTY = "&lt;item Name=&quot;%s&quot; Type=&quot;database&quot; Value=&quot;true&quot; dbType=&quot;RO&quot; isSystem=&quot;false&quot;&gt;&lt;item Name=&quot;ROLAP Catalog&quot; Type=&quot;catalog&quot; Value=&quot;partial&quot; uniqueName=&quot;ROLAP Catalog&quot;&gt;&lt;item Name=&quot;%s&quot; Type=&quot;cube&quot; Value=&quot;true&quot; uniqueName=&quot;%s&quot;/&gt;&lt;/item&gt;&lt;/item&gt;";

    public FMMDSession convertFromPackage(PackageBase kPackage) {
        FMMDSession newSession = FMMDSession.createFMMDSession(kPackage.getSession());
        newSession.create(ProjectFactory.createInMemoryProject());
        this.convertFromPackage(kPackage, newSession);
        return newSession;
    }

    @Override
    protected BaseObject createDimensionalObject(BaseObject srcObj, BaseObject destParent, HashMap<Object, BaseObject> businessMap) {
        BaseObject destObj = null;
        switch (srcObj.getFmObjectType()) {
            case cube: 
            case virtualCube: {
                this.createPresentationCube((CubeBase)srcObj, destParent);
                break;
            }
            case queryItem: {
                destObj = this.createDimensionalQueryItem((QueryItem)srcObj, destParent, businessMap);
                break;
            }
            case measure: {
                destObj = this.createDimensionalMeasure((Measure)srcObj, destParent, businessMap);
                break;
            }
            case queryItemFolder: {
                destObj = this.createDimensionalQueryItemFolder((QueryItemFolder)srcObj, destParent);
                break;
            }
            case measureFolder: {
                destObj = this.createDimensionalMeasureFolder((MeasureFolder)srcObj, destParent);
                break;
            }
            case level: {
                destObj = this.createDimensionalLevel((Level)srcObj, destParent);
                break;
            }
            case levelReference: {
                srcObj = ((LevelReference)srcObj).getLevel();
                destObj = this.createDimensionalLevel((Level)srcObj, destParent);
                break;
            }
            case relationalDimension: {
                destObj = this.createDimensionalDimension((RelationalDimension)srcObj, businessMap, (Section)destParent);
                break;
            }
            case measureDimension: {
                destObj = this.createDimensionalMeasureDimension((MeasureDimension)srcObj, businessMap, (Section)destParent);
                break;
            }
            case querySubject: 
            case relationalQuerySubject: {
                destObj = this.createDimensionalQuerySubject(srcObj, businessMap, destParent);
                break;
            }
            case namespace: {
                destObj = this.createDimensionalNamespace(srcObj, businessMap, destParent);
                break;
            }
            case folder: {
                destObj = this.createDimensionalFolder(srcObj, businessMap, destParent);
                break;
            }
            case parameterMap: {
                this.m_newProject.copyParameterMap((ParameterMap)srcObj);
                break;
            }
            case calculation: 
            case filter: {
                destObj = this.createDimensionalFilterOrCalculation(srcObj, destParent);
                break;
            }
            case accessRules: 
            case calculatedMembers: 
            case filterFolder: 
            case multilingualAttributeMap: 
            case relationalParameterMap: 
            case relationship: 
            case relativeTimeMembers: {
                break;
            }
        }
        if (destObj != null) {
            if (this.m_presentationLayerObjectMap != null) {
                this.m_presentationLayerObjectMap.put(srcObj.getInternal(), destObj);
            }
            for (BaseObject child : srcObj.getChildObjects()) {
                this.createDimensionalObject(child, destObj, businessMap);
            }
        }
        return destObj;
    }

    private BaseObject createDimensionalFilterOrCalculation(BaseObject srcObj, BaseObject destParent) {
        ShortcutTarget newObj = null;
        if (destParent instanceof Section) {
            Section section = (Section)destParent;
            if (srcObj instanceof Filter) {
                newObj = section.createFilter(srcObj.getName());
            } else if (srcObj instanceof Calculation) {
                newObj = section.createCalculation(srcObj.getName());
                ((Calculation)newObj).setUsage(((Calculation)srcObj).getUsage());
                ((Calculation)newObj).setRegularAggregate(((Calculation)srcObj).getRegularAggregate());
            }
            FmMDException.ASSERT(newObj != null, "Bad source object: " + srcObj.getID());
            this.m_packageIncludeObjects.add(newObj);
            ((FmReportObject)((Object)newObj)).copyCommonProperties((ReportObject)srcObj, destParent);
            this.deferExpression((ExpressionParent)((Object)newObj), (ExpressionParent)((Object)srcObj));
        }
        return newObj;
    }

    private BaseObject createDimensionalNamespace(BaseObject srcObj, HashMap<Object, BaseObject> businessMap, BaseObject destParent) {
        FmNamespace newNS = null;
        if (destParent instanceof Section) {
            if (this.sectionIsEmpty(srcObj)) {
                return null;
            }
            Section section = (Section)destParent;
            newNS = (FmNamespace)section.createNamespace(srcObj.getName());
            this.m_packageIncludeObjects.add(newNS);
            newNS.copyCommonProperties((ReportObject)srcObj, destParent);
        }
        return newNS;
    }

    private BaseObject createDimensionalFolder(BaseObject srcObj, HashMap<Object, BaseObject> businessMap, BaseObject destParent) {
        FmFolder newNS = null;
        if (destParent instanceof Section) {
            if (this.sectionIsEmpty(srcObj)) {
                return null;
            }
            Section section = (Section)destParent;
            newNS = (FmFolder)section.createFolder(srcObj.getName());
            this.m_packageIncludeObjects.add(newNS);
            newNS.copyCommonProperties((ReportObject)srcObj, destParent);
        }
        return newNS;
    }

    private boolean sectionIsEmpty(BaseObject srcObj) {
        block3: for (BaseObject child : srcObj.getChildObjects()) {
            switch (child.getFmObjectType()) {
                case folder: 
                case namespace: {
                    if (this.sectionIsEmpty(child)) continue block3;
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private BaseObject createDimensionalQuerySubject(BaseObject srcObj, HashMap<Object, BaseObject> businessMap, BaseObject destParent) {
        FmQuerySubject newQS = null;
        if (destParent instanceof Section) {
            Section s = (Section)destParent;
            newQS = (FmQuerySubject)s.createModelQuerySubject(srcObj.getName());
            this.m_packageIncludeObjects.add(newQS);
            newQS.copyCommonProperties((ReportObject)srcObj, destParent);
        }
        return newQS;
    }

    private BaseObject createDimensionalLevel(Level srcObj, BaseObject destParent) {
        FmLevel newLevel = null;
        if (destParent instanceof LevelParent) {
            LevelParent lp = (LevelParent)destParent;
            newLevel = (FmLevel)lp.createLevel(srcObj.getName());
            this.m_packageIncludeObjects.add(newLevel);
            newLevel.copyCommonProperties(srcObj, destParent);
            newLevel.setIsManual(srcObj.isAllLevel());
            if (!srcObj.isAllLevel()) {
                List<QueryItem> levelKeys = srcObj.getLevelKeys();
                FmMDException.ASSERT(levelKeys.size() > 0, "Why does " + srcObj.getName() + " not have level keys?");
                boolean isUnique = true;
                for (QueryItem levelKey : levelKeys) {
                    if (srcObj.equals(levelKey.getLevel())) continue;
                    isUnique = false;
                    break;
                }
                newLevel.setIsUnique(isUnique);
            }
        }
        return newLevel;
    }

    private BaseObject createDimensionalMeasureFolder(MeasureFolder srcObj, BaseObject destParent) {
        FmMeasureFolder newFolder = null;
        if (destParent instanceof MeasureFolderParent) {
            MeasureFolderParent mfp = (MeasureFolderParent)destParent;
            newFolder = (FmMeasureFolder)mfp.createMeasureFolder(srcObj.getName());
            this.m_packageIncludeObjects.add(newFolder);
            newFolder.copyCommonProperties(srcObj, destParent);
        }
        return newFolder;
    }

    private BaseObject createDimensionalQueryItemFolder(QueryItemFolder srcObj, BaseObject destParent) {
        FmQueryItemFolder newFolder = null;
        if (destParent instanceof QueryItemFolderParent) {
            QueryItemFolder mfp = (QueryItemFolder)destParent;
            newFolder = (FmQueryItemFolder)mfp.createQueryItemFolder(srcObj.getName());
            this.m_packageIncludeObjects.add(newFolder);
            newFolder.copyCommonProperties(srcObj, destParent);
        }
        return newFolder;
    }

    private BaseObject createDimensionalMeasure(Measure srcObj, BaseObject destParent, HashMap<Object, BaseObject> businessMap) {
        FmMeasure newMeas = null;
        if (destParent instanceof MeasureParent) {
            MeasureParent mp = (MeasureParent)destParent;
            MeasureDimension measureDim = srcObj.getParentMeasureDimension();
            FmMDException.ASSERT(measureDim != null, "Bad kind of measure: " + srcObj.getID());
            QueryItemMapping mapping = measureDim.findMapping(srcObj);
            if (mapping == null) {
                newMeas = (FmMeasure)mp.createMeasureFromQueryItem(srcObj);
                this.m_packageIncludeObjects.add(newMeas);
                if (srcObj.getRegularAggregate() == FmRegularAggregate.countNonZero) {
                    FmExpressionBuilder newExpr = (FmExpressionBuilder)BuilderFactory.createExpressionBuilder();
                    newExpr.addExpressionPart("IF ((", null);
                    newExpr.populateFrom(srcObj.getExpression());
                    newExpr.addExpressionPart(") = 0) THEN (0) ELSE (1)", null);
                    newMeas.setExpression(newExpr);
                    newMeas.copyCommonProperties(srcObj, destParent);
                    newMeas.setHidden(srcObj.getHidden());
                    this.deferExpression(newMeas, newMeas);
                } else {
                    ExpressionBuilder expr = BuilderFactory.createExpressionBuilder(srcObj.getExpression());
                    newMeas.setExpression(expr);
                    newMeas.copyCommonProperties(srcObj, destParent);
                    newMeas.setHidden(srcObj.getHidden());
                    this.deferExpression(newMeas, srcObj);
                }
            } else {
                BaseObject physicalItem = businessMap.get(srcObj.getInternal());
                FmExpressionBuilder expr = (FmExpressionBuilder)BuilderFactory.createExpressionBuilder();
                expr.addExpressionPart((QueryItemBase)physicalItem, null, null);
                newMeas = (FmMeasure)mp.createMeasureFromQueryItem(srcObj);
                this.m_packageIncludeObjects.add(newMeas);
                newMeas.setExpression(expr);
                newMeas.copyCommonProperties(srcObj, destParent);
                newMeas.setHidden(srcObj.getHidden());
            }
        }
        return newMeas;
    }

    private BaseObject createDimensionalQueryItem(QueryItem srcObj, BaseObject destParent, HashMap<Object, BaseObject> businessMap) {
        FmQueryItemBase newItem = null;
        if (destParent instanceof QueryItemParent) {
            QueryItemParent qip = (QueryItemParent)destParent;
            BaseObject physicalItem = businessMap.get(srcObj.getInternal());
            FmExpressionBuilder expr = (FmExpressionBuilder)BuilderFactory.createExpressionBuilder();
            newItem = (FmQueryItemBase)((Object)qip.createQueryItemFromQueryItem(srcObj.getName(), srcObj, null));
            this.m_packageIncludeObjects.add(newItem);
            if (physicalItem == null) {
                FmMDException.ASSERT(qip instanceof QuerySubject, "Unexpected class for: " + qip.getID());
                this.deferExpression(newItem, srcObj);
            } else {
                expr.addExpressionPart((QueryItemBase)physicalItem, null, null);
                newItem.setExpression(expr);
            }
            newItem.copyCommonProperties(srcObj, destParent);
            newItem.setHidden(srcObj.getHidden());
            BaseObject srcParent = srcObj.getParent();
            String locale = srcParent.getProject().getDefaultLocale();
            if (srcParent instanceof Level && destParent instanceof Level) {
                QueryItemBase memberDesc;
                Level srclvl = (Level)srcParent;
                Level destLvl = (Level)destParent;
                QueryItemBase memberCaption = srclvl.getItemWithRole(Role.EDefaultRoles.kRoleMemberCaption);
                if (memberCaption != null && memberCaption.equals(srcObj)) {
                    newItem.addDefaultRole(Role.EDefaultRoles.kRoleMemberCaption, locale);
                }
                if ((memberDesc = srclvl.getItemWithRole(Role.EDefaultRoles.kRoleMemberDescription)) != null && memberDesc.equals(srcObj)) {
                    newItem.addDefaultRole(Role.EDefaultRoles.kRoleMemberDescription, locale);
                }
                List<QueryItem> levelKeys = srclvl.getLevelKeys();
                for (QueryItem levelKey : levelKeys) {
                    if (!levelKey.equals(srcObj)) continue;
                    newItem.addDefaultRole(Role.EDefaultRoles.kRoleBusinessKey, locale);
                    break;
                }
                FmMDException.ASSERT(levelKeys.size() > 0, "Why does " + srclvl.getName() + " not have level keys?");
                for (SortItem sortItem : srclvl.getMemberSortItems()) {
                    if (!sortItem.getQueryItem().equals(srcObj)) continue;
                    SortItem.ENullPlacement nullPlacement = SortItem.ENullPlacement.nullsUnspecified;
                    nullPlacement = sortItem.getSort().equals((Object)SortItem.ESortItem.ascending) ? SortItem.ENullPlacement.nullsLast : SortItem.ENullPlacement.nullsFirst;
                    destLvl.addMemberSortItem((QueryItem)((Object)newItem), sortItem.getSort(), nullPlacement);
                }
            }
        }
        return newItem;
    }

    private FmDimension createDimensionalMeasureDimension(MeasureDimension measDim, HashMap<Object, BaseObject> businessMap, Section s) {
        FmDimension newMeasDim = null;
        newMeasDim = (FmDimension)s.createMeasureDimension(measDim.getName());
        this.m_packageIncludeObjects.add(newMeasDim);
        newMeasDim.copyCommonProperties(measDim, s);
        return newMeasDim;
    }

    private FmDimension createDimensionalDimension(RelationalDimension srcObj, HashMap<Object, BaseObject> businessMap, Section section) {
        FmDimension dim = null;
        dim = (FmDimension)section.createRegularDimension(srcObj.getName());
        this.m_packageIncludeObjects.add(dim);
        dim.copyCommonProperties(srcObj, section);
        List hierarchies = srcObj.getAllHierarchies();
        if (hierarchies.size() == 0) {
            FmHierarchy hier = FmHierarchy.createHierarchy(dim.getSession(), dim, dim.getName(), FmEMDObjectNaming.kMakeUnique, false);
            hier.copyCommonProperties(dim, dim);
            this.m_packageIncludeObjects.add(hier);
            for (Level level : srcObj.getAllLevels()) {
                this.createDimensionalObject(level, hier, businessMap);
            }
        } else {
            RelationalHierarchy defaultHierarchy = srcObj.getDefaultHierarchy();
            for (RelationalHierarchy srcHierarchy : hierarchies) {
                FmHierarchy destHierarchy = FmHierarchy.createHierarchy(dim.getSession(), dim, srcHierarchy.getName(), FmEMDObjectNaming.kMakeUnique, false);
                destHierarchy.copyCommonProperties(srcHierarchy, dim);
                destHierarchy.copyDescriptionAndScreentip((FmRelationalHierarchy)srcHierarchy);
                destHierarchy.copyNames((FmRelationalHierarchy)srcHierarchy, BaseObject.PrefixName.kStandard, (FmBaseObject)dim);
                for (String locale : this.getDestinationSession().getProject().getSupportedLocales()) {
                    String rootCaption = srcHierarchy.getRootCaption(locale);
                    if (rootCaption != null && !"".equals(rootCaption)) {
                        destHierarchy.setRootCaption(locale, rootCaption);
                        continue;
                    }
                    destHierarchy.setRootCaption(locale, srcHierarchy.getRootCaption());
                }
                this.m_packageIncludeObjects.add(destHierarchy);
                if (this.m_presentationLayerObjectMap != null) {
                    this.m_presentationLayerObjectMap.put(srcHierarchy.getInternal(), destHierarchy);
                }
                for (BaseObject obj1 : srcHierarchy.getChildObjects()) {
                    this.createDimensionalObject(obj1, destHierarchy, businessMap);
                }
                if (!defaultHierarchy.equals(srcHierarchy)) continue;
                dim.setDefaultHierarchy(destHierarchy);
            }
            for (Level level : srcObj.getAllLevels()) {
                List<SortItem> sortItems = level.getMemberSortItems();
                if (sortItems.size() <= 0) continue;
                dim.setSortMembersMetadata(true);
                dim.setSortMembersData(true);
                dim.setSortMembersAndEnableMrf(true);
                break;
            }
        }
        if (this.m_presentationLayerObjectMap != null) {
            this.m_presentationLayerObjectMap.put(srcObj.getInternal(), dim);
        }
        return null;
    }

    private void createPresentationCube(BaseObject srcObj, BaseObject destParent) {
        FmMDException.ASSERT(destParent instanceof FmSection, "Bad parent for cube");
        FmMDException.ASSERT(srcObj instanceof CubeBase, "Bad object");
        FmNamespace n = null;
        if (this.m_package != null && this.m_package instanceof PseudoPackage) {
            n = (FmNamespace)destParent;
        } else {
            n = (FmNamespace)((FmSection)destParent).createNamespace(srcObj.getName());
            n.copyNames((FmReportObject)srcObj, BaseObject.PrefixName.kStandard, (FmBaseObject)destParent);
            this.m_packageIncludeObjects.add(n);
        }
        Property propertyDynamicContent = n.createCustomProperty("dynamicContent");
        propertyDynamicContent.setType(Property.PropType.HIDDEN_TYPE);
        propertyDynamicContent.setValue("true");
        Property propertyDynamicSource = n.createCustomProperty("dynamicSource");
        propertyDynamicSource.setType(Property.PropType.HIDDEN_TYPE);
        propertyDynamicSource.setValue(String.format(FMT_DYNAMIC_SOURCE_PROPERTY, srcObj.getName(), srcObj.getName(), srcObj.getName()));
    }

    @Override
    protected FmQueryItemLike createBusinessCalculation(FmQueryItemBase srcObj, BaseObject destParent) {
        return null;
    }
}

