/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLocaleMapping;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMultilingualAttributeMap;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.BuilderFactory;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemMapping;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.TaskDimensionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.LocaleMappingType;
import com.ibm.cognos.fmeng.genmodel.MultilingualAttributeType;
import com.ibm.cognos.fmeng.genmodel.RelationalDimensionType;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.metadata.MdTable;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmMultilingualAttribute
extends FmBaseObject
implements TopLevelObject {
    public static FmMultilingualAttribute createMultilingualAttribute(FMMDSession session, FmMultilingualAttributeMap parent, FmQueryItem item) {
        MultilingualAttributeType attrType = GenmodelFactory.eINSTANCE.createMultilingualAttributeType();
        FmMultilingualAttribute attr = new FmMultilingualAttribute(session, attrType);
        parent.addMultilingualAttribute(attr);
        attrType.setSourceQueryItemForMultilingualValues((EObject)item.getInternal());
        return attr;
    }

    public static FmMultilingualAttribute get(FMMDSession session, Object obj) {
        return new FmMultilingualAttribute(session, obj);
    }

    private FmMultilingualAttribute(FMMDSession session, Object emfObject) {
        super(session, emfObject);
    }

    private MultilingualAttributeType getMultilingualAttributeType() {
        return (MultilingualAttributeType)this.m_emfObject;
    }

    @Override
    public FmObjectType getFmObjectType() {
        return FmObjectType.multilingualAttribute;
    }

    public void changeDefaultLocale(String oldDefaultLocale, String newDefaultLocale) {
        if (oldDefaultLocale.equals(newDefaultLocale)) {
            return;
        }
        FmQueryItem item = FmQueryItem.get(this.m_session, this.getMultilingualAttributeType().getSourceQueryItemForMultilingualValues());
        QueryItemMapping qiMapping = this.getDimension().findMapping(item);
        if (qiMapping == null) {
            ExpressionBuilder builder = BuilderFactory.createExpressionBuilder(item.getExpression());
            this.setMultilingualAttribute(oldDefaultLocale, builder);
            Expression newExpression = this.getMultilingualAttributeAsExpression(newDefaultLocale);
            if (newExpression != null) {
                builder = BuilderFactory.createExpressionBuilder(newExpression);
                item.setExpression(builder);
            }
        } else {
            MdTable table = qiMapping.getTable().getPhysicalTable(true);
            if (table != null) {
                MdColumn col = table.findColumn(qiMapping.getColumnName());
                this.setMultilingualAttribute(oldDefaultLocale, col);
                MdColumn newCol = this.getMultilingualAttributeAsColumn(newDefaultLocale);
                if (newCol != null) {
                    this.getDimensionBuilder().addQueryItemMapping(item, newCol);
                }
            }
        }
    }

    public MdColumn getMultilingualAttributeAsColumn(String locale) {
        LocaleMappingType mappingType = this.getLocaleMapping(locale);
        if (mappingType != null) {
            MdTable table;
            FmQueryItem item;
            FmLocaleMapping localeMapping = FmLocaleMapping.get(this.m_session, mappingType);
            RelationalDimension dim = this.getDimension();
            QueryItemMapping mapping = dim.findMapping(item = (FmQueryItem)localeMapping.getQueryItem());
            if (mapping != null && (table = mapping.getTable().getPhysicalTable(true)) != null) {
                return table.findColumn(mapping.getColumnName());
            }
        }
        return null;
    }

    public Expression getMultilingualAttributeAsExpression(String locale) {
        LocaleMappingType mappingType = this.getLocaleMapping(locale);
        if (mappingType != null) {
            FmLocaleMapping localeMapping = FmLocaleMapping.get(this.m_session, mappingType);
            return localeMapping.getQueryItem().getExpression();
        }
        return null;
    }

    public void removeMultilingualAttribute(String locale) {
        this.removeMultilingualAttribute(this.getDimensionBuilder(), locale);
    }

    private void removeMultilingualAttribute(TaskDimensionBuilder dimBuilder, String locale) {
        LocaleMappingType mappingType = this.getLocaleMapping(locale);
        if (mappingType != null) {
            FmLocaleMapping mapping = FmLocaleMapping.get(this.m_session, mappingType);
            mapping.removeMapping(dimBuilder);
        }
    }

    public void setMultilingualAttribute(String locale, ExpressionBuilder expression) {
        LocaleMappingType mappingType = this.getLocaleMapping(locale);
        if (mappingType == null) {
            FmLocaleMapping.createLocaleMapping(this.getSession(), this, locale, expression);
        } else {
            FmLocaleMapping mapping = FmLocaleMapping.get(this.m_session, mappingType);
            this.getSession().delete(mapping.getQueryItem());
            mapping.createQueryItem(locale, expression);
        }
    }

    public void setMultilingualAttribute(String locale, MdColumn column) {
        TaskDimensionBuilder builder = this.getDimensionBuilder();
        LocaleMappingType mappingType = this.getLocaleMapping(locale);
        if (mappingType == null) {
            FmLocaleMapping.createLocaleMapping(this.getSession(), this, locale, builder, column);
        } else {
            FmLocaleMapping mapping = FmLocaleMapping.get(this.m_session, mappingType);
            builder.removeQueryItem(mapping.getQueryItem());
            builder.createQueryItemFromColumn(mapping, column);
        }
    }

    private RelationalDimension getDimension() {
        RelationalDimensionType dim = null;
        EObject parent = this.getMultilingualAttributeType().eContainer();
        while (parent != null) {
            if (parent instanceof RelationalDimensionType) {
                dim = (RelationalDimensionType)parent;
                break;
            }
            parent = parent.eContainer();
        }
        FmMDException.ASSERT(dim != null, "Didn't find my dimension");
        return FmRelationalDimension.get(this.getSession(), dim);
    }

    private TaskDimensionBuilder getDimensionBuilder() {
        return this.getSession().getTaskDimensionBuilder(this.getDimension());
    }

    private LocaleMappingType getLocaleMapping(String locale) {
        for (LocaleMappingType mapping : this.getMultilingualAttributeType().getLocaleMapping()) {
            if (!mapping.getLocale().equals(locale)) continue;
            return mapping;
        }
        return null;
    }

    public List<FmLocaleMapping> getLocaleMappingList() {
        ArrayList<FmLocaleMapping> retList = new ArrayList<FmLocaleMapping>();
        for (LocaleMappingType mappingType : this.getMultilingualAttributeType().getLocaleMapping()) {
            retList.add(FmLocaleMapping.get(this.m_session, mappingType));
        }
        return retList;
    }

    public void addLocaleMapping(FmLocaleMapping mapping) {
        this.addLocaleMapping((LocaleMappingType)mapping.getInternal());
    }

    private void addLocaleMapping(LocaleMappingType mapping) {
        this.getMultilingualAttributeType().getLocaleMapping().add((Object)mapping);
    }

    @Override
    public String getName() {
        return FmQueryItem.get(this.m_session, this.getMultilingualAttributeType().getSourceQueryItemForMultilingualValues()).getName();
    }
}

