/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCollector;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMultilingualAttribute;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveListener;
import com.ibm.cognos.fmeng.fmmd.model.Collector;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.MultilingualAttributeMapType;
import com.ibm.cognos.fmeng.genmodel.MultilingualAttributeType;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmMultilingualAttributeMap
extends FmCollector
implements TopLevelObject,
Collector {
    public static FmMultilingualAttributeMap createMultilingualAttributeMap(FMMDSession session, FmLevel parent) {
        MultilingualAttributeMapType type = GenmodelFactory.eINSTANCE.createMultilingualAttributeMapType();
        FmMultilingualAttributeMap map = new FmMultilingualAttributeMap(session, type);
        parent.setMultilingualAttributeMap(map);
        return map;
    }

    public static FmMultilingualAttributeMap createMultilingualAttributeMap(FMMDSession session, FmRelationalHierarchy parent) {
        MultilingualAttributeMapType type = GenmodelFactory.eINSTANCE.createMultilingualAttributeMapType();
        FmMultilingualAttributeMap map = new FmMultilingualAttributeMap(session, type);
        parent.setMultilingualAttributeMap(map);
        return map;
    }

    public static FmMultilingualAttributeMap get(FMMDSession session, Object map) {
        return new FmMultilingualAttributeMap(session, map);
    }

    private FmMultilingualAttributeMap(FMMDSession session, Object emfObject) {
        super(session, emfObject);
    }

    private MultilingualAttributeMapType getMap() {
        return (MultilingualAttributeMapType)this.m_emfObject;
    }

    @Override
    public FmObjectType getFmObjectType() {
        return FmObjectType.multilingualAttributeMap;
    }

    public MdColumn getMultilingualAttributeAsColumn(FmQueryItem fmQueryItem, String locale) {
        FmMultilingualAttribute attr = this.findOrCreateAttribute(fmQueryItem);
        return attr.getMultilingualAttributeAsColumn(locale);
    }

    public Expression getMultilingualAttributeAsExpression(FmQueryItem fmQueryItem, String locale) {
        FmMultilingualAttribute attr = this.findOrCreateAttribute(fmQueryItem);
        return attr.getMultilingualAttributeAsExpression(locale);
    }

    public boolean isMultilingual(FmQueryItem fmQueryItem) {
        return this.findAttribute(fmQueryItem) != null;
    }

    public void removeMultilingualAttribute(FmQueryItem fmQueryItem, String locale) {
        FmMultilingualAttribute attr = this.findOrCreateAttribute(fmQueryItem);
        attr.removeMultilingualAttribute(locale);
    }

    public void setMultilingual(FmQueryItem fmQueryItem, boolean multilingual) {
        MultilingualAttributeType attr = this.findAttributeInternal(fmQueryItem);
        if (multilingual && attr == null && multilingual) {
            FmMultilingualAttribute.createMultilingualAttribute(this.m_session, this, fmQueryItem);
        }
        if (!multilingual && attr != null) {
            FmMultilingualAttribute fmAttr = FmMultilingualAttribute.get(this.getSession(), attr);
            this.m_session.delete(fmAttr);
        }
    }

    public void setMultilingualAttribute(FmQueryItem fmQueryItem, String locale, MdColumn column) {
        this.cleanEmptyMultilingualAttributes();
        FmMultilingualAttribute attr = this.findOrCreateAttribute(fmQueryItem);
        attr.setMultilingualAttribute(locale, column);
    }

    public void setMultilingualAttribute(FmQueryItem fmQueryItem, String locale, ExpressionBuilder expression) {
        this.cleanEmptyMultilingualAttributes();
        FmMultilingualAttribute attr = this.findOrCreateAttribute(fmQueryItem);
        attr.setMultilingualAttribute(locale, expression);
    }

    private void cleanEmptyMultilingualAttributes() {
        Iterator it = this.getMap().getMultilingualAttribute().iterator();
        while (it.hasNext()) {
            MultilingualAttributeType attr = (MultilingualAttributeType)it.next();
            if (attr.getSourceQueryItemForMultilingualValues() != null) continue;
            it.remove();
            this.m_session.delete(FmMultilingualAttribute.get(this.m_session, attr));
        }
    }

    protected MultilingualAttributeType findAttributeInternal(FmQueryItem queryItem) {
        for (MultilingualAttributeType attr : this.getMap().getMultilingualAttribute()) {
            EObject source = attr.getSourceQueryItemForMultilingualValues();
            if (source == null || !source.equals(queryItem.getInternal())) continue;
            return attr;
        }
        return null;
    }

    protected FmMultilingualAttribute findAttribute(FmQueryItem queryItem) {
        MultilingualAttributeType attr = this.findAttributeInternal(queryItem);
        if (attr != null) {
            return FmMultilingualAttribute.get(this.m_session, attr);
        }
        return null;
    }

    protected FmMultilingualAttribute findOrCreateAttribute(FmQueryItem queryItem) {
        MultilingualAttributeType attrType = this.findAttributeInternal(queryItem);
        FmMultilingualAttribute attr = null;
        attr = attrType == null ? FmMultilingualAttribute.createMultilingualAttribute(this.m_session, this, queryItem) : FmMultilingualAttribute.get(this.m_session, attrType);
        FmMDException.ASSERT(attr != null, "Couldn't find multilingual attributes for " + queryItem.getID());
        return attr;
    }

    public void addMultilingualAttribute(FmMultilingualAttribute attr) {
        this.getMap().getMultilingualAttribute().add((Object)((MultilingualAttributeType)attr.getInternal()));
    }

    @Override
    public void prepareForObjectDeletion(RemoveInfo info, FmBaseObject object, RemoveListener listener) {
        super.prepareForObjectDeletion(info, object, listener);
        if (object instanceof FmQueryItem) {
            FmMultilingualAttribute fmAttr = null;
            for (MultilingualAttributeType attr : this.getMap().getMultilingualAttribute()) {
                EObject source = attr.getSourceQueryItemForMultilingualValues();
                if (source == null || !source.equals(object.getInternal())) continue;
                fmAttr = FmMultilingualAttribute.get(this.m_session, attr);
                break;
            }
            if (fmAttr != null) {
                this.getSession().delete(fmAttr);
            }
        }
    }

    public List<FmMultilingualAttribute> getMultilingualAttributes() {
        ArrayList<FmMultilingualAttribute> attrs = new ArrayList<FmMultilingualAttribute>();
        for (MultilingualAttributeType attr : this.getMap().getMultilingualAttribute()) {
            attrs.add(FmMultilingualAttribute.get(this.m_session, attr));
        }
        return attrs;
    }

    public QueryItem isMultilingual(List<Object> removed) {
        MultilingualAttributeType attr;
        EObject qi;
        if (removed != null && removed.size() > 0 && removed.get(0) instanceof MultilingualAttributeType && (qi = (attr = (MultilingualAttributeType)removed.get(0)).getSourceQueryItemForMultilingualValues()) != null) {
            return FmQueryItem.get(this.m_session, qi);
        }
        return null;
    }
}

